import 'dart:convert';

class TestData {
  static String setCurrency = "usd";

  static String json = JsonEncoder().convert(
      {
        "id": "bitcoin",
        "symbol": "btc",
        "name": "Bitcoin",
        "asset_platform_id": null,
        "platforms": {
          "": ""
        },
        "block_time_in_minutes": 10,
        "hashing_algorithm": "SHA-256",
        "categories": [
          "Cryptocurrency"
        ],
        "links": {
          "homepage": [
            "http://www.bitcoin.org",
            "",
            ""
          ],
          "blockchain_site": [
            "https://blockchair.com/bitcoin/",
            "https://btc.com/",
            "https://btc.tokenview.com/",
            "",
            ""
          ],
          "official_forum_url": [
            "https://bitcointalk.org/",
            "",
            ""
          ],
          "chat_url": [
            "",
            "",
            ""
          ],
          "announcement_url": [
            "",
            ""
          ],
          "twitter_screen_name": "btc",
          "facebook_username": "bitcoins",
          "bitcointalk_thread_identifier": null,
          "telegram_channel_identifier": "",
          "subreddit_url": "https://www.reddit.com/r/Bitcoin/",
          "repos_url": {
            "github": [
              "https://github.com/bitcoin/bitcoin",
              "https://github.com/bitcoin/bips"
            ],
            "bitbucket": []
          }
        },
        "image": {
          "thumb": "https://assets.coingecko.com/coins/images/1/thumb/bitcoin.png?1547033579",
          "small": "https://assets.coingecko.com/coins/images/1/small/bitcoin.png?1547033579",
          "large": "https://assets.coingecko.com/coins/images/1/large/bitcoin.png?1547033579"
        },
        "country_origin": "",
        "genesis_date": "2009-01-03",
        "market_data": {
          "current_price": {
            "aed": 205272,
            "ars": 5111095,
            "aud": 73442,
            "bch": 107.534,
            "bdt": 4735759,
            "bhd": 21073,
            "bmd": 55887,
            "bnb": 214.212,
            "brl": 311434,
            "btc": 1,
            "cad": 70184,
            "chf": 52314,
            "clp": 40635249,
            "cny": 364638,
            "czk": 1239718,
            "dkk": 351504,
            "dot": 1594,
            "eos": 13127,
            "eth": 32.790233,
            "eur": 47270,
            "gbp": 40760,
            "hkd": 434107,
            "huf": 17241466,
            "idr": 808282985,
            "ils": 184646,
            "inr": 4056773,
            "jpy": 6081221,
            "krw": 63359628,
            "kwd": 16892.59,
            "lkr": 11123236,
            "ltc": 290.917,
            "mmk": 78812858,
            "mxn": 1163190,
            "myr": 230896,
            "ngn": 21209001,
            "nok": 479422,
            "nzd": 80095,
            "php": 2715871,
            "pkr": 8722516,
            "pln": 218513,
            "rub": 4265189,
            "sar": 209601,
            "sek": 480912,
            "sgd": 75204,
            "thb": 1733046,
            "try": 443501,
            "twd": 1591888,
            "uah": 1558001,
            "usd": 55887,
            "vef": 5595.93,
            "vnd": 1291112600,
            "xag": 2218.83,
            "xau": 32.25,
            "xdr": 39238,
            "xlm": 140885,
            "xrp": 102556,
            "yfi": 1.644235,
            "zar": 832236,
            "bits": 1000188,
            "link": 2049,
            "sats": 100018755
          },
          "ath": {
            "aed": 226680,
            "ars": 5602864,
            "aud": 79533,
            "bch": 110.862,
            "bdt": 5225511,
            "bhd": 23272,
            "bmd": 61712,
            "bnb": 143062,
            "brl": 342689,
            "btc": 1.003301,
            "cad": 76992,
            "chf": 57384,
            "clp": 44685567,
            "cny": 401652,
            "czk": 1351851,
            "dkk": 383919,
            "dot": 5526,
            "eos": 15224,
            "eth": 624.203,
            "eur": 51628,
            "gbp": 44334,
            "hkd": 479035,
            "huf": 18953568,
            "idr": 888124446,
            "ils": 205335,
            "inr": 4485790,
            "jpy": 6726594,
            "krw": 70134927,
            "kwd": 18665.99,
            "lkr": 12120788,
            "ltc": 318.98,
            "mmk": 86973534,
            "mxn": 1278840,
            "myr": 254129,
            "ngn": 24720569,
            "nok": 520262,
            "nzd": 85985,
            "php": 2992599,
            "pkr": 9691850,
            "pln": 236582,
            "rub": 4521012,
            "sar": 231453,
            "sek": 523079,
            "sgd": 82972,
            "thb": 1894196,
            "try": 491200,
            "twd": 1737850,
            "uah": 1710214,
            "usd": 61712,
            "vef": 8618768857,
            "vnd": 1418476780,
            "xag": 2381.78,
            "xau": 35.73,
            "xdr": 43148,
            "xlm": 275874,
            "xrp": 159288,
            "yfi": 1.976674,
            "zar": 922477,
            "bits": 1024190,
            "link": 2874,
            "sats": 102418969
          },
          "ath_change_percentage": {
            "aed": -9.43274,
            "ars": -8.76549,
            "aud": -7.64598,
            "bch": -2.98969,
            "bdt": -9.3608,
            "bhd": -9.44029,
            "bmd": -9.4278,
            "bnb": -99.85033,
            "brl": -9.10895,
            "btc": -0.32896,
            "cad": -8.83055,
            "chf": -8.824,
            "clp": -9.05249,
            "cny": -9.20376,
            "czk": -8.28314,
            "dkk": -8.43139,
            "dot": -71.15241,
            "eos": -13.7924,
            "eth": -94.74619,
            "eur": -8.4281,
            "gbp": -8.04829,
            "hkd": -9.36731,
            "huf": -9.02158,
            "idr": -8.97833,
            "ils": -10.06423,
            "inr": -9.55241,
            "jpy": -9.58286,
            "krw": -9.6489,
            "kwd": -9.48919,
            "lkr": -8.21843,
            "ltc": -8.78599,
            "mmk": -9.37143,
            "mxn": -9.03178,
            "myr": -9.13088,
            "ngn": -14.19414,
            "nok": -7.83813,
            "nzd": -6.8385,
            "php": -9.23555,
            "pkr": -9.9901,
            "pln": -7.62583,
            "rub": -5.64655,
            "sar": -9.42995,
            "sek": -8.0497,
            "sgd": -9.35101,
            "thb": -8.49592,
            "try": -9.69907,
            "twd": -8.38734,
            "uah": -8.88868,
            "usd": -9.4278,
            "vef": -99.99994,
            "vnd": -8.96737,
            "xag": -6.82999,
            "xau": -9.73441,
            "xdr": -9.0489,
            "xlm": -48.96523,
            "xrp": -35.61978,
            "yfi": -16.89522,
            "zar": -9.77105,
            "bits": -2.33111,
            "link": -28.69768,
            "sats": -2.33111
          },
          "ath_date": {
            "aed": "2021-03-13T20:49:26.606Z",
            "ars": "2021-03-13T20:49:26.606Z",
            "aud": "2021-03-13T20:49:26.606Z",
            "bch": "2021-03-22T10:44:48.614Z",
            "bdt": "2021-03-13T20:49:26.606Z",
            "bhd": "2021-03-13T20:49:26.606Z",
            "bmd": "2021-03-13T20:49:26.606Z",
            "bnb": "2017-10-19T00:00:00.000Z",
            "brl": "2021-03-13T20:49:26.606Z",
            "btc": "2019-10-15T16:00:56.136Z",
            "cad": "2021-03-13T20:49:26.606Z",
            "chf": "2021-03-13T20:49:26.606Z",
            "clp": "2021-03-13T20:49:26.606Z",
            "cny": "2021-03-13T20:49:26.606Z",
            "czk": "2021-03-13T20:49:26.606Z",
            "dkk": "2021-03-13T20:49:26.606Z",
            "dot": "2020-12-27T11:42:47.567Z",
            "eos": "2021-03-13T01:53:26.538Z",
            "eth": "2015-10-20T00:00:00.000Z",
            "eur": "2021-03-13T20:49:26.606Z",
            "gbp": "2021-03-13T20:49:26.606Z",
            "hkd": "2021-03-13T20:49:26.606Z",
            "huf": "2021-03-13T20:49:26.606Z",
            "idr": "2021-03-13T20:49:26.606Z",
            "ils": "2021-03-13T20:49:26.606Z",
            "inr": "2021-03-13T20:49:26.606Z",
            "jpy": "2021-03-13T20:49:26.606Z",
            "krw": "2021-03-13T20:49:26.606Z",
            "kwd": "2021-03-13T20:49:26.606Z",
            "lkr": "2021-03-13T20:49:26.606Z",
            "ltc": "2017-03-05T00:00:00.000Z",
            "mmk": "2021-03-13T20:49:26.606Z",
            "mxn": "2021-03-13T20:49:26.606Z",
            "myr": "2021-03-13T20:49:26.606Z",
            "ngn": "2021-03-14T14:34:38.859Z",
            "nok": "2021-03-13T20:49:26.606Z",
            "nzd": "2021-03-13T20:49:26.606Z",
            "php": "2021-03-13T20:49:26.606Z",
            "pkr": "2021-03-13T20:49:26.606Z",
            "pln": "2021-03-13T20:49:26.606Z",
            "rub": "2021-03-13T20:49:26.606Z",
            "sar": "2021-03-13T20:49:26.606Z",
            "sek": "2021-03-13T20:49:26.606Z",
            "sgd": "2021-03-13T20:49:26.606Z",
            "thb": "2021-03-13T20:49:26.606Z",
            "try": "2021-03-21T22:10:14.452Z",
            "twd": "2021-03-13T20:49:26.606Z",
            "uah": "2021-03-13T20:49:26.606Z",
            "usd": "2021-03-13T20:49:26.606Z",
            "vef": "2021-01-03T12:04:17.372Z",
            "vnd": "2021-03-13T20:49:26.606Z",
            "xag": "2021-03-13T20:49:26.606Z",
            "xau": "2021-03-13T20:49:26.606Z",
            "xdr": "2021-03-13T20:49:26.606Z",
            "xlm": "2021-01-03T07:50:39.913Z",
            "xrp": "2021-01-03T07:54:40.240Z",
            "yfi": "2020-11-05T13:29:25.560Z",
            "zar": "2021-03-13T20:49:26.606Z",
            "bits": "2021-02-24T02:10:51.008Z",
            "link": "2021-01-03T07:43:41.985Z",
            "sats": "2021-02-24T02:10:51.008Z"
          },
          "atl": {
            "aed": 632.31,
            "ars": 1478.98,
            "aud": 72.61,
            "bch": 3.513889,
            "bdt": 9390.25,
            "bhd": 45.91,
            "bmd": 121.77,
            "bnb": 164.75,
            "brl": 149.66,
            "btc": 0.99895134,
            "cad": 69.81,
            "chf": 63.26,
            "clp": 107408,
            "cny": 407.23,
            "czk": 4101.56,
            "dkk": 382.47,
            "dot": 1295,
            "eos": 908.141,
            "eth": 6.779735,
            "eur": 51.3,
            "gbp": 43.9,
            "hkd": 514.37,
            "huf": 46598,
            "idr": 658780,
            "ils": 672.18,
            "inr": 3993.42,
            "jpy": 6641.83,
            "krw": 75594,
            "kwd": 50.61,
            "lkr": 22646,
            "ltc": 20.707835,
            "mmk": 117588,
            "mxn": 859.32,
            "myr": 211.18,
            "ngn": 4289706,
            "nok": 1316.03,
            "nzd": 84.85,
            "php": 2880.5,
            "pkr": 17315.84,
            "pln": 220.11,
            "rub": 2206.43,
            "sar": 646.04,
            "sek": 443.81,
            "sgd": 84.47,
            "thb": 5644.35,
            "try": 392.91,
            "twd": 1998.66,
            "uah": 553.37,
            "usd": 67.81,
            "vef": 766.19,
            "vnd": 3672339,
            "xag": 3.37,
            "xau": 0.0531,
            "xdr": 44.39,
            "xlm": 21608,
            "xrp": 9908,
            "yfi": 0.23958075,
            "zar": 666.26,
            "bits": 982277,
            "link": 598.477,
            "sats": 98227659
          },
          "atl_change_percentage": {
            "aed": 32367.71487,
            "ars": 345527.03259,
            "aud": 101060.06574,
            "bch": 2960.63442,
            "bdt": 50339.11429,
            "bhd": 45802.46255,
            "bmd": 45801.12343,
            "bnb": 29.96242,
            "brl": 208022.97522,
            "btc": 0.10498,
            "cad": 100453.58837,
            "chf": 82605.78634,
            "clp": 37737.34525,
            "cny": 89453.54063,
            "czk": 30129.3738,
            "dkk": 91816.10289,
            "dot": 23.10837,
            "eos": 1345.19635,
            "eth": 383.71215,
            "eur": 92059.76227,
            "gbp": 92755.31646,
            "hkd": 84305.87239,
            "huf": 36905.10893,
            "idr": 122609.51451,
            "ils": 27373.01228,
            "inr": 101499.36927,
            "jpy": 91471.03479,
            "krw": 83726.56,
            "kwd": 33281.57743,
            "lkr": 49023.48266,
            "ltc": 1305.04456,
            "mmk": 66933.11765,
            "mxn": 135279.11027,
            "myr": 109252.02223,
            "ngn": 394.47901,
            "nok": 36334.15802,
            "nzd": 94302.90384,
            "php": 94196.61816,
            "pkr": 50279.43512,
            "pln": 99186.17596,
            "rub": 193231.52785,
            "sar": 32348.08285,
            "sek": 108274.76576,
            "sgd": 88945.861,
            "thb": 30608.00805,
            "try": 112790.62685,
            "twd": 79558.06297,
            "uah": 281484.56822,
            "usd": 82328.28829,
            "vef": 630.45193,
            "vnd": 35062.23773,
            "xag": 65754.7771,
            "xau": 60640.03239,
            "xdr": 88302.9678,
            "xlm": 551.56332,
            "xrp": 935.02414,
            "yfi": 585.66038,
            "zar": 124826.57661,
            "bits": 1.83635,
            "link": 242.41134,
            "sats": 1.83635
          },
          "atl_date": {
            "aed": "2015-01-14T00:00:00.000Z",
            "ars": "2015-01-14T00:00:00.000Z",
            "aud": "2013-07-05T00:00:00.000Z",
            "bch": "2017-08-02T00:00:00.000Z",
            "bdt": "2013-09-08T00:00:00.000Z",
            "bhd": "2013-09-08T00:00:00.000Z",
            "bmd": "2013-09-08T00:00:00.000Z",
            "bnb": "2021-02-19T23:44:22.550Z",
            "brl": "2013-07-05T00:00:00.000Z",
            "btc": "2019-10-21T00:00:00.000Z",
            "cad": "2013-07-05T00:00:00.000Z",
            "chf": "2013-07-05T00:00:00.000Z",
            "clp": "2015-01-14T00:00:00.000Z",
            "cny": "2013-07-05T00:00:00.000Z",
            "czk": "2015-01-14T00:00:00.000Z",
            "dkk": "2013-07-05T00:00:00.000Z",
            "dot": "2021-03-03T02:23:03.316Z",
            "eos": "2019-04-11T00:00:00.000Z",
            "eth": "2017-06-12T00:00:00.000Z",
            "eur": "2013-07-05T00:00:00.000Z",
            "gbp": "2013-07-05T00:00:00.000Z",
            "hkd": "2013-07-05T00:00:00.000Z",
            "huf": "2015-01-14T00:00:00.000Z",
            "idr": "2013-07-05T00:00:00.000Z",
            "ils": "2015-01-14T00:00:00.000Z",
            "inr": "2013-07-05T00:00:00.000Z",
            "jpy": "2013-07-05T00:00:00.000Z",
            "krw": "2013-07-05T00:00:00.000Z",
            "kwd": "2015-01-14T00:00:00.000Z",
            "lkr": "2015-01-14T00:00:00.000Z",
            "ltc": "2013-11-28T00:00:00.000Z",
            "mmk": "2013-09-08T00:00:00.000Z",
            "mxn": "2013-07-05T00:00:00.000Z",
            "myr": "2013-07-05T00:00:00.000Z",
            "ngn": "2020-10-15T09:39:31.080Z",
            "nok": "2015-01-14T00:00:00.000Z",
            "nzd": "2013-07-05T00:00:00.000Z",
            "php": "2013-07-05T00:00:00.000Z",
            "pkr": "2015-01-14T00:00:00.000Z",
            "pln": "2013-07-05T00:00:00.000Z",
            "rub": "2013-07-05T00:00:00.000Z",
            "sar": "2015-01-14T00:00:00.000Z",
            "sek": "2013-07-05T00:00:00.000Z",
            "sgd": "2013-07-05T00:00:00.000Z",
            "thb": "2015-01-14T00:00:00.000Z",
            "try": "2015-01-14T00:00:00.000Z",
            "twd": "2013-07-05T00:00:00.000Z",
            "uah": "2013-07-06T00:00:00.000Z",
            "usd": "2013-07-06T00:00:00.000Z",
            "vef": "2013-09-08T00:00:00.000Z",
            "vnd": "2015-01-14T00:00:00.000Z",
            "xag": "2013-07-05T00:00:00.000Z",
            "xau": "2013-07-05T00:00:00.000Z",
            "xdr": "2013-07-05T00:00:00.000Z",
            "xlm": "2018-11-20T00:00:00.000Z",
            "xrp": "2018-12-25T00:00:00.000Z",
            "yfi": "2020-09-12T20:09:36.122Z",
            "zar": "2013-07-05T00:00:00.000Z",
            "bits": "2021-02-23T09:13:10.643Z",
            "link": "2020-08-16T08:13:13.338Z",
            "sats": "2021-02-23T09:13:10.643Z"
          },
          "market_cap": {
            "aed": 3831531539321,
            "ars": 95401901528984,
            "aud": 1370849589373,
            "bch": 2007185049,
            "bdt": 88396012350081,
            "bhd": 393334408444,
            "bmd": 1043161322984,
            "bnb": 3996062780,
            "brl": 5813119745300,
            "btc": 18663275,
            "cad": 1310030154759,
            "chf": 976472019606,
            "clp": 758483201932168,
            "cny": 6806210367942,
            "czk": 23140133636199,
            "dkk": 6561058068589,
            "dot": 29751647223,
            "eos": 244944802564,
            "eth": 612050908,
            "eur": 882334012336,
            "gbp": 760818236144,
            "hkd": 8102896403058,
            "huf": 321823111670592,
            "idr": 15087124817987348,
            "ils": 3446531989847,
            "inr": 75722297021265,
            "jpy": 113509930302401,
            "krw": 1182648450866462,
            "kwd": 315311157292,
            "lkr": 207622402026434,
            "ltc": 5430160356,
            "mmk": 1471092976810030,
            "mxn": 21711692153345,
            "myr": 4309821005909,
            "ngn": 395879722072477,
            "nok": 8948726028057,
            "nzd": 1495020211132,
            "php": 50693492687609,
            "pkr": 162811403484748,
            "pln": 4078679406285,
            "rub": 79612507428164,
            "sar": 3912329599592,
            "sek": 8976532536282,
            "sgd": 1403724818467,
            "thb": 32348432625738,
            "try": 8278241389838,
            "twd": 29713616799306,
            "uah": 29081088628985,
            "usd": 1043161322984,
            "vef": 104451743270,
            "vnd": 24099451936045260,
            "xag": 41415830772,
            "xau": 601945810,
            "xdr": 732408780674,
            "xlm": 2627633683127,
            "xrp": 1913918862953,
            "yfi": 30658354,
            "zar": 15534217021153,
            "bits": 18669147629329,
            "link": 38245783681,
            "sats": 1866914762932859
          },
          "market_cap_rank": 1,
          "total_volume": {
            "aed": 229595741717,
            "ars": 5716140103824,
            "aud": 82123390127,
            "bch": 120356311,
            "bdt": 5296928346301,
            "bhd": 23570975193,
            "bmd": 62509050291,
            "bnb": 237882009,
            "brl": 348600471661,
            "btc": 1111089,
            "cad": 78465423013,
            "chf": 58462526920,
            "clp": 45481508417854,
            "cny": 407846549526,
            "czk": 1386811162629,
            "dkk": 393012714329,
            "dot": 1775457418,
            "eos": 14577502306,
            "eth": 36633441,
            "eur": 52851839584,
            "gbp": 45585975105,
            "hkd": 485560926300,
            "huf": 19272540349397,
            "idr": 903993383492608,
            "ils": 206525526527,
            "inr": 4539144694092,
            "jpy": 6800609617316,
            "krw": 70828504874386,
            "kwd": 18895423249,
            "lkr": 12441296359224,
            "ltc": 323186445,
            "mmk": 88151873390504,
            "mxn": 1301421112043,
            "myr": 258256141276,
            "ngn": 23753439110428,
            "nok": 535671181447,
            "nzd": 89504521294,
            "php": 3036316859141,
            "pkr": 9756100024105,
            "pln": 244422575901,
            "rub": 4767127702312,
            "sar": 234443506095,
            "sek": 537794738904,
            "sgd": 84081236091,
            "thb": 1937155468506,
            "try": 495352969028,
            "twd": 1780914097304,
            "uah": 1742617552590,
            "usd": 62509050291,
            "vef": 6259031206,
            "vnd": 1443770780390312,
            "xag": 2485698014,
            "xau": 36032717,
            "xdr": 43887916754,
            "xlm": 156920379152,
            "xrp": 114185125489,
            "yfi": 1837513,
            "zar": 931474424799,
            "bits": 1111088605499,
            "link": 2287288421,
            "sats": 111108860549922
          },
          "high_24h": {
            "aed": 210237,
            "ars": 5241837,
            "aud": 75176,
            "bch": 108.759,
            "bdt": 4850360,
            "bhd": 21579,
            "bmd": 57239,
            "bnb": 216.568,
            "brl": 316463,
            "btc": 1,
            "cad": 71978,
            "chf": 53563,
            "clp": 41260681,
            "cny": 373302,
            "czk": 1269452,
            "dkk": 359839,
            "dot": 1609,
            "eos": 13642,
            "eth": 33.095308,
            "eur": 48389,
            "gbp": 41732,
            "hkd": 444665,
            "huf": 17672303,
            "idr": 827136962,
            "ils": 188416,
            "inr": 4156217,
            "jpy": 6227184,
            "krw": 64749741,
            "kwd": 17294.91,
            "lkr": 11392408,
            "ltc": 299.034,
            "mmk": 80720053,
            "mxn": 1186003,
            "myr": 236426,
            "ngn": 23416144,
            "nok": 491487,
            "nzd": 82157,
            "php": 2782822,
            "pkr": 8894426,
            "pln": 224114,
            "rub": 4357183,
            "sar": 214671,
            "sek": 491653,
            "sgd": 77000,
            "thb": 1774412,
            "try": 454434,
            "twd": 1631310,
            "uah": 1595703,
            "usd": 57239,
            "vef": 5731.35,
            "vnd": 1321737006,
            "xag": 2267.03,
            "xau": 33.07,
            "xdr": 40147,
            "xlm": 142318,
            "xrp": 103206,
            "yfi": 1.658089,
            "zar": 847511,
            "bits": 1005679,
            "link": 2064,
            "sats": 100567923
          },
          "low_24h": {
            "aed": 196924,
            "ars": 4908690,
            "aud": 70437,
            "bch": 105.339,
            "bdt": 4544646,
            "bhd": 20211,
            "bmd": 53611,
            "bnb": 211.337,
            "brl": 296024,
            "btc": 1,
            "cad": 67470,
            "chf": 50104,
            "clp": 38760785,
            "cny": 349351,
            "czk": 1186637,
            "dkk": 336656,
            "dot": 1567,
            "eos": 13089,
            "eth": 32.203974,
            "eur": 45276,
            "gbp": 39045,
            "hkd": 416491,
            "huf": 16572792,
            "idr": 775218066,
            "ils": 176501,
            "inr": 3892838,
            "jpy": 5822291,
            "krw": 60794738,
            "kwd": 16199.43,
            "lkr": 10638744,
            "ltc": 282.236,
            "mmk": 75569925,
            "mxn": 1114922,
            "myr": 221574,
            "ngn": 20398994,
            "nok": 463832,
            "nzd": 76671,
            "php": 2609603,
            "pkr": 8368681,
            "pln": 209229,
            "rub": 4101420,
            "sar": 201063,
            "sek": 461237,
            "sgd": 72176,
            "thb": 1662344,
            "try": 424689,
            "twd": 1528826,
            "uah": 1489692,
            "usd": 53611,
            "vef": 5368.07,
            "vnd": 1241259874,
            "xag": 2128.98,
            "xau": 31.06,
            "xdr": 37563,
            "xlm": 136446,
            "xrp": 98265,
            "yfi": 1.581367,
            "zar": 798040,
            "bits": 996621,
            "link": 2007,
            "sats": 99662061
          },
          "price_change_24h": 715.518,
          "price_change_percentage_24h": 1.28409,
          "price_change_percentage_7d": -0.69137,
          "price_change_percentage_14d": 3.17562,
          "price_change_percentage_30d": -2.13625,
          "price_change_percentage_60d": 71.24067,
          "price_change_percentage_200d": 438.29466,
          "price_change_percentage_1y": 774.13733,
          "market_cap_change_24h": 14454862237,
          "market_cap_change_percentage_24h": 1.39511,
          "price_change_24h_in_currency": {
            "aed": 2628.1,
            "ars": 54771,
            "aud": 1388.32,
            "bch": 1.738013,
            "bdt": 58840,
            "bhd": 269.53,
            "bmd": 715.52,
            "bnb": 0.36963806,
            "brl": 9170.43,
            "btc": 0,
            "cad": 891.76,
            "chf": 791.84,
            "clp": 765750,
            "cny": 5125.39,
            "czk": 21096,
            "dkk": 5560.68,
            "dot": 27.155469,
            "eos": -62.764572049,
            "eth": 0.58082648,
            "eur": 744.56,
            "gbp": 677.72,
            "hkd": 5553.58,
            "huf": 215997,
            "idr": 12161428,
            "ils": 3014.85,
            "inr": 57578,
            "jpy": 82358,
            "krw": 926830,
            "kwd": 221.47,
            "lkr": 175215,
            "ltc": -3.867691783,
            "mmk": 1044090,
            "mxn": 22125,
            "myr": 3457.66,
            "ngn": 244036,
            "nok": 4419.36,
            "nzd": 1349.38,
            "php": 29376,
            "pkr": 111675,
            "pln": 3915.15,
            "rub": 59220,
            "sar": 2700.92,
            "sek": 7307.82,
            "sgd": 1010.09,
            "thb": 22154,
            "try": 6806.85,
            "twd": 22386,
            "uah": 25007,
            "usd": 715.52,
            "vef": 71.64,
            "vnd": 15489195,
            "xag": 27.97,
            "xau": 0.275378,
            "xdr": 582.55,
            "xlm": 3371,
            "xrp": 3985,
            "yfi": 0.01849916,
            "zar": 18356.21,
            "bits": 1393.88,
            "link": 50.483,
            "sats": 139388
          },
          "price_change_percentage_1h_in_currency": {
            "aed": 0.93478,
            "ars": 0.91823,
            "aud": 0.96368,
            "bch": 1.04227,
            "bdt": 0.93478,
            "bhd": 0.94041,
            "bmd": 0.93478,
            "bnb": 0.19916,
            "brl": 1.1779,
            "btc": 0,
            "cad": 0.9134,
            "chf": 0.85046,
            "clp": 1.04571,
            "cny": 0.93478,
            "czk": 0.96102,
            "dkk": 0.90748,
            "dot": 0.30256,
            "eos": 0.32939,
            "eth": 0.90241,
            "eur": 0.90614,
            "gbp": 0.98228,
            "hkd": 0.93712,
            "huf": 0.86286,
            "idr": 0.96096,
            "ils": 0.93478,
            "inr": 0.97852,
            "jpy": 0.91988,
            "krw": 0.93644,
            "kwd": 0.9408,
            "lkr": 0.93478,
            "ltc": 0.36694,
            "mmk": 0.93478,
            "mxn": 1.04578,
            "myr": 0.93478,
            "ngn": 1.06777,
            "nok": 0.90956,
            "nzd": 0.88279,
            "php": 0.89539,
            "pkr": 0.93478,
            "pln": 0.91623,
            "rub": 1.00524,
            "sar": 0.93742,
            "sek": 0.93198,
            "sgd": 0.90553,
            "thb": 0.88921,
            "try": 1.04597,
            "twd": 0.95311,
            "uah": 0.93478,
            "usd": 0.93478,
            "vef": 0.93478,
            "vnd": 0.91147,
            "xag": 1.21293,
            "xau": 0.89978,
            "xdr": 0.93478,
            "xlm": 0.59897,
            "xrp": 0.5952,
            "yfi": 0.90827,
            "zar": 1.17893,
            "bits": 0.30543,
            "link": 0.73821,
            "sats": 0.30543
          },
          "price_change_percentage_24h_in_currency": {
            "aed": 1.28409,
            "ars": 1.07265,
            "aud": 1.90813,
            "bch": 1.62541,
            "bdt": 1.24567,
            "bhd": 1.28275,
            "bmd": 1.28409,
            "bnb": 0.1724,
            "brl": 3.00109,
            "btc": 0,
            "cad": 1.27481,
            "chf": 1.52301,
            "clp": 1.90022,
            "cny": 1.41154,
            "czk": 1.71374,
            "dkk": 1.59205,
            "dot": 1.72323,
            "eos": -0.47462,
            "eth": 1.78747,
            "eur": 1.58506,
            "gbp": 1.67418,
            "hkd": 1.28305,
            "huf": 1.25693,
            "idr": 1.51257,
            "ils": 1.64342,
            "inr": 1.42495,
            "jpy": 1.35955,
            "krw": 1.47065,
            "kwd": 1.31526,
            "lkr": 1.58456,
            "ltc": -1.30815,
            "mmk": 1.32928,
            "mxn": 1.91908,
            "myr": 1.50521,
            "ngn": 1.151,
            "nok": 0.9222,
            "nzd": 1.69817,
            "php": 1.08317,
            "pkr": 1.28409,
            "pln": 1.80617,
            "rub": 1.39511,
            "sar": 1.29249,
            "sek": 1.52804,
            "sgd": 1.34851,
            "thb": 1.28293,
            "try": 1.5455,
            "twd": 1.41188,
            "uah": 1.61506,
            "usd": 1.28409,
            "vef": 1.28409,
            "vnd": 1.20254,
            "xag": 1.26194,
            "xau": 0.85369,
            "xdr": 1.4921,
            "xlm": 2.43756,
            "xrp": 4.02122,
            "yfi": 1.12763,
            "zar": 2.23137,
            "bits": 0.13914,
            "link": 2.50582,
            "sats": 0.13914
          },
          "price_change_percentage_7d_in_currency": {
            "aed": -0.69678,
            "ars": -0.3586,
            "aud": 1.05038,
            "bch": 1.06063,
            "bdt": -0.76072,
            "bhd": -0.67425,
            "bmd": -0.69137,
            "bnb": -2.10194,
            "brl": -1.53359,
            "btc": 0,
            "cad": 0.17828,
            "chf": 0.40211,
            "clp": -0.71878,
            "cny": -0.40593,
            "czk": 0.32777,
            "dkk": -0.05564,
            "dot": 0.54152,
            "eos": -5.64995,
            "eth": 5.16276,
            "eur": -0.06006,
            "gbp": 0.67154,
            "hkd": -0.65812,
            "huf": -0.83846,
            "idr": -0.5001,
            "ils": -0.45033,
            "inr": -0.55436,
            "jpy": -0.91633,
            "krw": -0.46368,
            "kwd": -0.56374,
            "lkr": -0.55387,
            "ltc": 3.3255,
            "mmk": -0.67896,
            "mxn": 0.28016,
            "myr": -0.26894,
            "ngn": -0.69137,
            "nok": 0.35911,
            "nzd": 2.27488,
            "php": -0.87099,
            "pkr": -1.08747,
            "pln": 0.57699,
            "rub": 3.89888,
            "sar": -0.69413,
            "sek": 0.50778,
            "sgd": -0.71426,
            "thb": 0.05118,
            "try": 5.02892,
            "twd": 0.1757,
            "uah": -0.02197,
            "usd": -0.69137,
            "vef": -0.69137,
            "vnd": -1.00076,
            "xag": 2.36617,
            "xau": -0.89596,
            "xdr": -0.35359,
            "xlm": -0.65436,
            "xrp": -16.21015,
            "yfi": 2.13633,
            "zar": -0.51668,
            "bits": 0.1045,
            "link": 1.70969,
            "sats": 0.1045
          },
          "price_change_percentage_14d_in_currency": {
            "aed": 3.17,
            "ars": 4.16711,
            "aud": 4.60352,
            "bch": 8.04796,
            "bdt": 3.08836,
            "bhd": 3.15647,
            "bmd": 3.17562,
            "bnb": 15.3702,
            "brl": -0.84615,
            "btc": 0,
            "cad": 2.45045,
            "chf": 3.9727,
            "clp": 2.08111,
            "cny": 3.46263,
            "czk": 3.95232,
            "dkk": 3.79618,
            "dot": 12.63475,
            "eos": -0.03452,
            "eth": 12.83477,
            "eur": 3.80322,
            "gbp": 4.51024,
            "hkd": 3.25271,
            "huf": 3.22617,
            "idr": 3.62535,
            "ils": 2.46203,
            "inr": 2.94843,
            "jpy": 3.3704,
            "krw": 2.91965,
            "kwd": 2.98653,
            "lkr": 4.43201,
            "ltc": 8.48189,
            "mmk": 3.18468,
            "mxn": 1.39185,
            "myr": 3.539,
            "ngn": -1.01496,
            "nok": 4.41376,
            "nzd": 6.07266,
            "php": 3.43421,
            "pkr": 2.53903,
            "pln": 5.03751,
            "rub": 6.11431,
            "sar": 3.14806,
            "sek": 4.45429,
            "sgd": 3.30656,
            "thb": 4.00472,
            "try": 7.32762,
            "twd": 3.99103,
            "uah": 3.81558,
            "usd": 3.17562,
            "vef": 3.17562,
            "vnd": 3.30706,
            "xag": 6.42074,
            "xau": 2.04793,
            "xdr": 3.32852,
            "xlm": 11.88002,
            "xrp": -8.80475,
            "yfi": 18.51389,
            "zar": 0.48472,
            "bits": 0.29175,
            "link": 19.18537,
            "sats": 0.29175
          },
          "price_change_percentage_30d_in_currency": {
            "aed": -2.13699,
            "ars": 0.3879,
            "aud": 1.42966,
            "bch": 33.9693,
            "bdt": -2.2126,
            "bhd": -2.14326,
            "bmd": -2.13625,
            "bnb": 10.23032,
            "brl": 1.38868,
            "btc": 0,
            "cad": -2.49898,
            "chf": 2.06866,
            "clp": 0.48061,
            "cny": -1.34495,
            "czk": 1.63284,
            "dkk": 0.32416,
            "dot": 9.41658,
            "eos": 17.64973,
            "eth": 11.39911,
            "eur": 0.33429,
            "gbp": 0.11699,
            "hkd": -1.95045,
            "huf": 2.03971,
            "idr": 0.52272,
            "ils": -1.11257,
            "inr": -2.06418,
            "jpy": 0.89159,
            "krw": 0.29021,
            "kwd": -2.2378,
            "lkr": -0.53237,
            "ltc": 15.20974,
            "mmk": -2.28174,
            "mxn": -0.57281,
            "myr": 0.10252,
            "ngn": -6.26325,
            "nok": -0.74291,
            "nzd": 2.47679,
            "php": -1.91442,
            "pkr": -4.11753,
            "pln": 3.45958,
            "rub": 0.78166,
            "sar": -2.13356,
            "sek": 1.84394,
            "sgd": -0.53044,
            "thb": 1.21302,
            "try": 11.04106,
            "twd": -0.18436,
            "uah": -2.19743,
            "usd": -2.13625,
            "vef": -2.13625,
            "vnd": -1.90951,
            "xag": 6.75998,
            "xau": 0.70079,
            "xdr": -1.05392,
            "xlm": 22.37257,
            "xrp": -1.4884,
            "yfi": 24.34741,
            "zar": -0.67739,
            "bits": 0.33383,
            "link": 22.3389,
            "sats": 0.33383
          },
          "price_change_percentage_60d_in_currency": {
            "aed": 71.24067,
            "ars": 81.13628,
            "aud": 73.60226,
            "bch": 45.82853,
            "bdt": 71.04517,
            "bhd": 71.38156,
            "bmd": 71.24067,
            "bnb": -73.50092,
            "brl": 74.6767,
            "btc": 0,
            "cad": 68.80528,
            "chf": 80.9999,
            "clp": 71.24066,
            "cny": 72.36873,
            "czk": 76.98947,
            "dkk": 76.15836,
            "dot": -16.25768,
            "eos": 5.14607,
            "eth": 24.20045,
            "eur": 76.26872,
            "gbp": 70.89923,
            "hkd": 71.58747,
            "huf": 79.65848,
            "idr": 75.65955,
            "ils": 72.88003,
            "inr": 70.34083,
            "jpy": 79.50532,
            "krw": 75.50829,
            "kwd": 71.14499,
            "lkr": 74.31207,
            "ltc": 22.02261,
            "mmk": 81.21079,
            "mxn": 78.50193,
            "myr": 74.98907,
            "ngn": 70.56738,
            "nok": 72.77696,
            "nzd": 76.17743,
            "php": 73.05637,
            "pkr": 66.36407,
            "pln": 79.52287,
            "rub": 73.51198,
            "sar": 71.19868,
            "sek": 77.53591,
            "sgd": 73.38102,
            "thb": 77.11711,
            "try": 83.01931,
            "twd": 74.44853,
            "uah": 69.39702,
            "usd": 71.24067,
            "vef": 71.24067,
            "vnd": 71.36163,
            "xag": 73.54909,
            "xau": 83.21016,
            "xdr": 73.38494,
            "xlm": 16.72184,
            "xrp": -14.63336,
            "yfi": 55.55827,
            "zar": 68.38032,
            "bits": 0.18916,
            "link": 35.91828,
            "sats": 0.18916
          },
          "price_change_percentage_200d_in_currency": {
            "aed": 438.30931,
            "ars": 561.2758,
            "aud": 415.18328,
            "bch": 139.42797,
            "bdt": 437.82133,
            "bhd": 438.4403,
            "bmd": 438.29466,
            "bnb": -57.05089,
            "brl": 466.14081,
            "btc": 0,
            "cad": 417.29011,
            "chf": 451.51548,
            "clp": 407.66332,
            "cny": 413.28569,
            "czk": 433.9139,
            "dkk": 438.49876,
            "dot": -21.51039,
            "eos": 276.95517,
            "eth": 22.30244,
            "eur": 438.78533,
            "gbp": 421.2831,
            "hkd": 439.49375,
            "huf": 445.50995,
            "idr": 427.63514,
            "ils": 427.31872,
            "inr": 433.66177,
            "jpy": 451.20677,
            "krw": 413.66175,
            "kwd": 431.6135,
            "lkr": 478.98383,
            "ltc": 40.84297,
            "mmk": 470.37127,
            "mxn": 419.73724,
            "myr": 435.9596,
            "ngn": 430.50461,
            "nok": 417.62458,
            "nzd": 418.08142,
            "php": 438.277,
            "pkr": 406.26296,
            "pln": 459.10966,
            "rub": 444.78308,
            "sar": 438.3202,
            "sek": 429.6646,
            "sgd": 430.5889,
            "thb": 431.37119,
            "try": 473.57249,
            "twd": 422.75361,
            "uah": 441.64847,
            "usd": 438.29466,
            "vef": -99.99978,
            "vnd": 435.97607,
            "xag": 476.12867,
            "xau": 499.96243,
            "xdr": 434.77647,
            "xlm": 9.91302,
            "xrp": 151.20272,
            "yfi": 335.02604,
            "zar": 383.70964,
            "bits": 0.3165,
            "link": 145.95842,
            "sats": 0.3165
          },
          "price_change_percentage_1y_in_currency": {
            "aed": 774.08974,
            "ars": 1155.20133,
            "aud": 573.3316,
            "bch": 271.53174,
            "bdt": 779.72644,
            "bhd": 772.75326,
            "bmd": 774.13733,
            "bnb": -59.51529,
            "brl": 847.85034,
            "btc": 0,
            "cad": 657.66295,
            "chf": 732.4789,
            "clp": 638.95811,
            "cny": 704.1674,
            "czk": 650.17338,
            "dkk": 691.87189,
            "eos": 366.87957,
            "eth": -30.66541,
            "eur": 695.44834,
            "gbp": 638.85273,
            "hkd": 775.47853,
            "huf": 725.22031,
            "idr": 644.609,
            "ils": 677.67447,
            "inr": 728.98463,
            "jpy": 757.37504,
            "krw": 685.19008,
            "kwd": 746.24577,
            "lkr": 836.97833,
            "ltc": 76.49923,
            "mmk": 774.51859,
            "mxn": 617.67752,
            "myr": 712.9428,
            "ngn": 772.37009,
            "nok": 550.10969,
            "nzd": 617.70006,
            "php": 728.29711,
            "pkr": 764.23654,
            "pln": 698.24776,
            "rub": 740.97046,
            "sar": 773.00562,
            "sek": 629.78716,
            "sgd": 706.83293,
            "thb": 726.15175,
            "try": 957.89574,
            "twd": 723.72852,
            "uah": 775.49071,
            "usd": 774.13733,
            "vef": -99.99965,
            "vnd": 763.69201,
            "xag": 375.175,
            "xau": 688.4333,
            "xdr": 729.94971,
            "xlm": -13.08961,
            "xrp": 152.17039,
            "zar": 632.66469,
            "bits": 0.3165,
            "link": -28.17377,
            "sats": 0.3165
          },
          "market_cap_change_24h_in_currency": {
            "aed": 53092708997,
            "ars": 1129800455386,
            "aud": 27228117106,
            "bch": 29306704,
            "bdt": 1191563166621,
            "bhd": 5445473345,
            "bmd": 14454862237,
            "bnb": -5550929.578901291,
            "brl": 176127453756,
            "btc": 1025,
            "cad": 18264220139,
            "chf": 15447669124,
            "clp": 14655723516070,
            "cny": 102808316354,
            "czk": 413830566067,
            "dkk": 110021531975,
            "dot": 481732133,
            "eos": -1621926424.5206604,
            "eth": 10423163,
            "eur": 14787009756,
            "gbp": 13348209866,
            "hkd": 112181663150,
            "huf": 4359294224472,
            "idr": 241318229939810,
            "ils": 59859646565,
            "inr": 1139849444032,
            "jpy": 1638287012204,
            "krw": 18638378666957,
            "kwd": 4463745356,
            "lkr": 3486941514452,
            "ltc": -88762820.44849396,
            "mmk": 21036314238811,
            "mxn": 446452463324,
            "myr": 69045275504,
            "ngn": 4974791418429,
            "nok": 101614480604,
            "nzd": 27666031574,
            "php": 604236343647,
            "pkr": 2256042623681,
            "pln": 76811239512,
            "rub": 1204051783669,
            "sar": 54417841084,
            "sek": 145907717696,
            "sgd": 20355181900,
            "thb": 451408965864,
            "try": 155938045736,
            "twd": 445499907633,
            "uah": 497051478399,
            "usd": 14454862237,
            "vef": 1447365356,
            "vnd": 309040406688176,
            "xag": 2079948505,
            "xau": 5382620,
            "xdr": 11639796886,
            "xlm": 74390542267,
            "xrp": 63763039660,
            "yfi": 235433,
            "zar": 346894915959,
            "bits": 63281197731,
            "link": 638076316,
            "sats": 6328119773093
          },
          "market_cap_change_percentage_24h_in_currency": {
            "aed": 1.39511,
            "ars": 1.18996,
            "aud": 2.01149,
            "bch": 1.4745,
            "bdt": 1.35664,
            "bhd": 1.39376,
            "bmd": 1.39511,
            "bnb": -0.13875,
            "brl": 3.09583,
            "btc": 0.00549,
            "cad": 1.40399,
            "chf": 1.59714,
            "clp": 1.95588,
            "cny": 1.5227,
            "czk": 1.80726,
            "dkk": 1.69362,
            "dot": 1.64126,
            "eos": -0.65696,
            "eth": 1.72145,
            "eur": 1.69262,
            "gbp": 1.77263,
            "hkd": 1.39387,
            "huf": 1.3639,
            "idr": 1.61398,
            "ils": 1.75483,
            "inr": 1.51702,
            "jpy": 1.45433,
            "krw": 1.59038,
            "kwd": 1.42564,
            "lkr": 1.6959,
            "ltc": -1.60836,
            "mmk": 1.44035,
            "mxn": 2.08246,
            "myr": 1.61647,
            "ngn": 1.26187,
            "nok": 1.13981,
            "nzd": 1.87241,
            "php": 1.19795,
            "pkr": 1.39511,
            "pln": 1.90519,
            "rub": 1.52512,
            "sar": 1.40043,
            "sek": 1.64021,
            "sgd": 1.46109,
            "thb": 1.40541,
            "try": 1.90643,
            "twd": 1.5109,
            "uah": 1.72644,
            "usd": 1.39511,
            "vef": 1.39511,
            "vnd": 1.29004,
            "xag": 5.23543,
            "xau": 0.89645,
            "xdr": 1.60335,
            "xlm": 2.88443,
            "xrp": 3.43325,
            "yfi": 0.76979,
            "zar": 2.26531,
            "bits": 0.33925,
            "link": 1.68962,
            "sats": 0.33925
          },
          "total_supply": 21000000,
          "max_supply": 21000000,
          "circulating_supply": 18663281,
          "last_updated": "2021-03-24T17:59:32.013Z"
        },
        "community_data": {
          "facebook_likes": null,
          "twitter_followers": 82681,
          "reddit_average_posts_48h": 7.75,
          "reddit_average_comments_48h": 1501.167,
          "reddit_subscribers": 2620224,
          "reddit_accounts_active_48h": 10105,
          "telegram_channel_user_count": null
        },
        "developer_data": {
          "forks": 28101,
          "stars": 50951,
          "subscribers": 3745,
          "total_issues": 6093,
          "closed_issues": 5533,
          "pull_requests_merged": 8426,
          "pull_request_contributors": 719,
          "code_additions_deletions_4_weeks": {
            "additions": 2382,
            "deletions": -1591
          },
          "commit_count_4_weeks": 355,
          "last_4_weeks_commit_activity_series": [
            1,
            9,
            9,
            12,
            9,
            4,
            2,
            4,
            5,
            4,
            5,
            4,
            10,
            2,
            4,
            11,
            3,
            0,
            2,
            2,
            1,
            3,
            1,
            2,
            0,
            0,
            0,
            0
          ]
        },
        "public_interest_stats": {
          "alexa_rank": 9440,
          "bing_matches": null
        },
        "status_updates": [],
        "last_updated": "2021-03-24T17:59:32.013Z"
        }
      );
  static String generalJson = JsonEncoder().convert(
      {
        "id": "bitcoin",
        "symbol": "btc",
        "name": "Bitcoin",
        "image": "https://assets.coingecko.com/coins/images/1/large/bitcoin.png?1547033579",
        "current_price": 55627,
        "market_cap": 1042738130963,
        "market_cap_rank": 1,
        "fully_diluted_valuation": 1173120723358,
        "total_volume": 47202412431,
        "high_24h": 55912,
        "low_24h": 53594,
        "price_change_24h": 1481.17,
        "price_change_percentage_24h": 2.73551,
        "market_cap_change_24h": 40694742447,
        "market_cap_change_percentage_24h": 4.06118,
        "circulating_supply": 18666025,
        "total_supply": 21000000,
        "max_supply": 21000000,
        "ath": 61712,
        "ath_change_percentage": -9.86626,
        "ath_date": "2021-03-13T20:49:26.606Z",
        "atl": 67.81,
        "atl_change_percentage": 81929.25497,
        "atl_date": "2013-07-06T00:00:00.000Z",
        "roi": null,
        "last_updated": "2021-03-27T16:37:14.141Z"
      }
  );
}
