import 'package:crypto_prices/database/settings_dao.dart';
import 'package:crypto_prices/generated/l10n.dart';
import 'package:flutter/material.dart';

import '../../constants.dart';

///Displays the notification settings
class NotificationsWidget extends StatefulWidget {
  @override
  _NotificationsWidgetState createState() => _NotificationsWidgetState();
}

class _NotificationsWidgetState extends State<NotificationsWidget> {
  SettingsDAO _settingsDAO = SettingsDAO();

  double _largeMoveThreshold = SettingsDAO().getLargeMoveAlertThresholdHive();

  List<double> _thresholds = [10.0, 15.0, 20.0, 25.0];

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(S.of(context).settingsNotifications)
      ),
      body: ListView(
        children: <Widget>[
          ListTile(
            dense: true,
            title: Text(
              S.of(context).settingsNotificationsLargePriceMoveAlerts,
              style: TextStyle(
                  color: Theme.of(context).colorScheme.secondary,
                  fontSize: 15,
                  fontWeight: FontWeight.bold
              ),
            ),
          ),
          SwitchListTile(
            title: Text(S.of(context).settingsNotificationsEnableMoveAlerts),
            subtitle: Text(S.of(context).settingsNotificationsEnableAlertsText),
            isThreeLine: true,
            activeColor: Theme.of(context).colorScheme.secondary,
            value: _settingsDAO.getLargeMoveAlertsEnabledHive(),
            onChanged: (bool enabled) {
              setState(() {
                _settingsDAO.setLargeMoveAlertsEnabled(enabled);
              });
            },
          ),
          ListTile(
            title: Text(S.of(context).settingsNotificationsMoveThreshold),
            subtitle: Text("${_largeMoveThreshold.toInt().toString()}%"),
            onTap: () {
              _showThresholdDialog();
            },
          ),
        ],
      ),
    );
  }

  ///Shows a dialog to select the large move alert threshold
  void _showThresholdDialog() {
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return SimpleDialog(
          title: Text(S.of(context).settingsNotificationsMoveThreshold),
          children: [
            SimpleDialogOption(
              child: RadioListTile(
                title: Text("${_thresholds[0].toInt()}%"),
                activeColor: (currentTheme.isThemeDark()
                    ? Constants.accentColorDark
                    : Constants.accentColorLight),
                value: _thresholds[0],
                groupValue: _largeMoveThreshold,
                onChanged: (double? value) {
                  setState(() {
                    _largeMoveThreshold = value!;
                    _settingsDAO.setLargeMoveAlertThreshold(value);
                    Navigator.pop(context);
                  });
                }
              ),
            ),
            SimpleDialogOption(
              child: RadioListTile(
                title: Text("${_thresholds[1].toInt()}%"),
                activeColor: (currentTheme.isThemeDark()
                    ? Constants.accentColorDark
                    : Constants.accentColorLight),
                value: _thresholds[1],
                groupValue: _largeMoveThreshold,
                onChanged: (double? value) {
                  setState(() {
                    _largeMoveThreshold = value!;
                    _settingsDAO.setLargeMoveAlertThreshold(value);
                    Navigator.pop(context);
                  });
                }
              ),
            ),
            SimpleDialogOption(
              child: RadioListTile(
                title: Text("${_thresholds[2].toInt()}%"),
                activeColor: (currentTheme.isThemeDark()
                    ? Constants.accentColorDark
                    : Constants.accentColorLight),
                value: _thresholds[2],
                groupValue: _largeMoveThreshold,
                onChanged: (double? value) {
                  setState(() {
                    _largeMoveThreshold = value!;
                    _settingsDAO.setLargeMoveAlertThreshold(value);
                    Navigator.pop(context);
                  });
                }
              ),
            ),
            SimpleDialogOption(
              child: RadioListTile(
                title: Text("${_thresholds[3].toInt()}%"),
                activeColor: (currentTheme.isThemeDark()
                    ? Constants.accentColorDark
                    : Constants.accentColorLight),
                value: _thresholds[3],
                groupValue: _largeMoveThreshold,
                onChanged: (double? value) {
                  setState(() {
                    _largeMoveThreshold = value!;
                    _settingsDAO.setLargeMoveAlertThreshold(value);
                    Navigator.pop(context);
                  });
                }
              ),
            ),
          ],
        );
      }
    );
  }
}