_Перш ніж почати: на більшості екранів у меню є посилання на систему довідки на пристрої, що надає вам прямий доступ до інформації, яка стосується поточного контексту. Ви також можете легко повернутися до цього тексту. Якщо у вас є більший пристрій, наприклад планшет, ви можете відкрити систему довідки в окремому розділеному вікні.  Всі тексти довідки та іншу інформацію (часті запитання, навчальні посібники) також можна знайти на [сайті документації Vespucci](https://vespucci.io/). Ви також можете запустити переглядач довідки безпосередньо на пристроях, що підтримують швидкі команди, натиснувши і утримуючи іконку програми та вибравши «Довідка»_

# Веспуччі – вступ

Vespucci — це повнофункціональний редактор OpenStreetMap, який підтримує більшість операцій, що надаються настільними редакторами. Він був успішно протестований на Google Android 2.3 до 14.0 (версії до 4.1 більше не підтримуються) та різних варіантах на базі AOSP. Застереження: хоча можливості мобільних пристроїв наздогнали своїх настільних конкурентів, особливо старі пристрої мають дуже обмежену пам'ять і, як правило, працюють досить повільно. Ви повинні враховувати це під час використання Vespucci і, наприклад, зберігати розумний розмір областей, які ви редагуєте.

## Редагування у Веспуччі

В залежності від розміру екрана вашого пристрою перехід в режим редагування можливий за допомогою значка зверху на панелі інструментів, через меню на панелі інструментів праворуч, з панелі інструментів знизу (якщо є) або за допомогою кнопки меню.

<a id="download"></a>

### Завантаження даних OSM

Виберіть піктограму перенесення ![Перенесення](../images/menu_transfer.png) або пункт меню «Перенесення». З'явиться одинадцять опцій:

* **Завантажити дані на сервер OSM...** - переглянути та завантажити зміни до OpenStreetMap *(потрібна автентифікація)* *(потрібне підключення до мережі)*
* **Переглянути зміни...** - переглянути поточні зміни
* **Завантажити поточний вигляд** - завантажити область, видиму на екрані, та об'єднати її з існуючими даними *(потрібне підключення до мережі або офлайн-джерело даних)*
* **Очистити та завантажити поточний вигляд** - очистити будь-які дані в пам'яті, включаючи зміни, що очікують на розгляд, а потім завантажити область, видиму на екрані *(потрібне підключення до мережі)*
* **Запит до Overpass...** - виконати запит до сервера Overpass API *(потрібне підключення до мережі)*
* **Автозавантаження на основі розташування** - автоматично завантажити область навколо поточного географічного розташування *(потрібне підключення до мережі або офлайн-дані)* *(потрібний GPS)*
* **Автозавантаження поточного екрану** - автоматично завантажити дані для поточної відображеної області карти *(потрібне підключення до мережі або офлайн-дані)* *(потрібний GPS)*
* **Оновити дані** - повторно завантажити дані для всіх областей та оновити те, що є в  пам'ять *(потрібне підключення до мережі)*
* **Очистити дані** - видалити будь-які дані OSM з пам'яті, включаючи зміни, що очікують на розгляд.
* **Файл...** - збереження та завантаження даних OSM у/з файлів на пристрої.
* **Завдання...** - завантажити (автоматично та вручну) нотатки OSM та "помилки" з інструментів контролю якості (наразі OSMOSE) *(потрібне підключення до мережі)*

Найпростіший спосіб завантажити дані на пристрій — це масштабування та панорамування до місця, яке потрібно відредагувати, потім виберіть "Звантажити дані для поточного місця". Ви можете масштабувати за допомогою жестів, кнопок масштабування або кнопок регулювання гучності на пристрої. Після цього Веспуччі повинен завантажити дані для поточного місця. Для завантаження даних на пристрій автентифікація не потрібна.

У розблокованому стані всі незавантажені області будуть затемнені порівняно із завантаженими, якщо ви наблизили зображення настільки, щоб можна було редагувати. Це зроблено для того, щоб уникнути випадкового додавання дублікатів об'єктів у областях, які не відображаються. У заблокованому стані затемнення вимкнено. Цю поведінку можна змінити в [Розширених налаштуваннях](Advanced%20preferences.md), щоб затемнення було завжди активним.

Якщо вам потрібно використовувати нестандартний запис OSM API або використовувати [офлайн-дані](https://vespucci.io/tutorials/offline/) у форматі _MapSplit_, ви можете додавати або змінювати записи за допомогою запису _Configure..._ для шару даних у контролі шару.

### Редагування

<a id="lock"></a>

#### Перегляд, розблокування та перемикання режимів

Для того щоб уникнути випадкових змін, Веспуччі запускається в режимі "перегляду", в якому можливе лише пересування мапою та змінення її масштабу. Натисніть на значок ![Locked](../images/locked.png) для розблокування екрану. 

Тривале натискання на піктограму замка або меню «Режими» в меню переповнення відображення карти відкриє меню з 4 опціями:

* **Нормальний** - режим редагування за замовчуванням, можна додавати нові об'єкти, редагувати, переміщати та видаляти існуючі. Відображається проста біла іконка замка.
* **Тільки теги** - вибір існуючого об'єкта запускає редактор властивостей, нові об'єкти можна додавати за допомогою зеленої кнопки «+» або тривалим натисканням, але інші операції з геометрією не доступні. Відображається біла іконка замка з літерою «T».
* **Адреса** — увімкнення режиму адреси, дещо спрощеного режиму з конкретними діями, доступними за допомогою кнопки «+» у [простому режимі](../en/Simple%20actions.md). Відображається біла іконка замка з літерою «A».
* **Всередині приміщення** - увімкнення режиму «Всередині приміщення», див. [Режим «Всередині приміщення»](#indoor). Відображається біла іконка замка з літерою «I».
* **Режим C** - увімкнення режиму C, відображатимуться лише об'єкти, для яких встановлено прапорець попередження, див. [Режим C](#c-mode). Відображається біла іконка замка з літерою «C».

Якщо ви використовуєте Vespucci на пристрої Android, який підтримує швидкі команди (довге натискання на піктограму програми), ви можете перейти безпосередньо до режимів «Адреса» та «Всередині приміщення».

#### Звичайне, подвійне та довге натискання

Типово, точки та лінії мають помаранчеву підсвітку навколо них, що показує де ви можете торкнутись екрану щоб їх виділити. У вас є три варіанти:

* Одне натискання: вибирає об'єкт.
   * Ізольований вузол/шлях відразу виділяється.
   * Однак, якщо ви намагаєтеся вибрати об'єкт, а Vespucci визначає, що вибір може означати кілька об'єктів, він відобразить меню вибору, що дозволить вам вибрати об'єкт, який ви хочете вибрати.
   * Вибрані об'єкти виділяються жовтим кольором. 
   * Для отримання додаткової інформації див. [Вибраний вузол](Node%20selected.md), [Вибраний шлях](Way%20selected.md) та [Вибране відношення](Relation%20selected.md).
* Подвійне натискання: запустити [Режим багаторазового вибору](Multiselect.md)
* Тривале натискання: створює «перехрестя», що дозволяє додавати вузли, див. нижче та [Створення нових об'єктів](Creating%20new%20objects.md). Ця функція доступна лише у разі вимкнення «Простого режиму».

Кращє наблизитись для вибору об’єкта, якщо ви намагаєтесь редагувати ділянку з великою кількістю об’єктів.

Веспуччі має гарну систему "відміни/повтору"дій, тож не бійтеся експериментувати з вашим пристроєм, але, будь ласка, не надсилайте суто тестові дані, у разі потреби зберігайте їх локально.

#### Вибір / скасування вибору (одноразове натискання та «меню вибору»)

Торкніться об'єкта, щоб вибрати та виділити його. Торкнення екрана в порожній області скасує вибір. Якщо ви вибрали об'єкт і вам потрібно вибрати щось інше, просто торкніться потрібного об'єкта, немає необхідності спочатку скасовувати вибір. Подвійне торкання об'єкта запустить [режим багаторазового вибору](Multiselect.md).

Зверніть увагу, що якщо ви спробуєте вибрати об'єкт, а Vespucci визначить, що вибір може означати кілька об'єктів (наприклад, вузол на шляху або інші об'єкти, що перекриваються), він пред'явить меню вибору: Натисніть на об'єкт, який ви хочете вибрати, і об'єкт буде вибрано. 

Вибрані об'єкти позначаються тонкою жовтою рамкою. Жовта рамка може бути важко помітною, залежно від фону карти та коефіцієнта масштабування. Після вибору ви побачите повідомлення, що підтверджує вибір.

Після завершення вибору ви побачите (у вигляді кнопок або пунктів меню) список підтримуваних операцій для вибраного об'єкта: Для отримання додаткової інформації див. [Вибрана точка](Node%20selected.md), [Вибрана лінія](Way%20selected.md) та [Вибраний зв'язок](Relation%20selected.md).

#### Вибрані об'єкти: редагування тегів

Друге натискання на вибраний об'єкт відкриває редактор тегів, де ви можете редагувати теги, пов'язані з об'єктом.

Зверніть увагу, що для об'єктів, які перекриваються (наприклад, точна на лінії), меню вибору з'являється вдруге. Вибір того самого об'єкта відкриває редактор тегів; вибір іншого об'єкта просто вибирає інший об'єкт.

#### Вибрані об'єкти: переміщення точки або лінії

Після вибору об'єкта його можна перемістити. Зверніть увагу, що об'єкти можна перетягувати/переміщати тільки тоді, коли вони вибрані. Щоб перемістити об'єкт, просто перетягніть його поблизу (тобто в межах зони допуску) вибраного об'єкта. Якщо ви виберете велику область перетягування в [налаштуваннях](Preferences.md), ви отримаєте велику область навколо вибраної точки, що полегшить розміщення об'єкта. 

#### Додавання нової Точки або Лінії 

При першому запуску програма запускається в «Простому режимі», це можна змінити в головному меню, знявши відповідний прапорець.

##### Простий режим

Натиснувши велику зелену плаваючу кнопку на екрані карти, ви відкриєте меню. Після вибору одного з елементів вам буде запропоновано натиснути на екрані в тому місці, де ви хочете створити об'єкт. Функції панорамування та масштабування продовжують працювати, якщо вам потрібно налаштувати вигляд карти. 

Докладнішу інформацію див. у розділі [Створення нових об'єктів у режимі простих дій](Simple%20actions.md). Простий режим є стандартним для нових інсталяцій.

##### Розширений режим (довге натискання)

Довго натисніть у місці, де ви хочете створити точку або початок лінії. Ви побачите чорний символ «перехрестя».
* Якщо ви хочете створити нову точку (не пов'язану з об'єктом), торкніться в місці, віддаленому від існуючих об'єктів.
* Якщо ви хочете продовжити лінію, торкніться в межах «зони чутливості» лінії (або точки на лінії). Зона чутливості позначається областями навколо точки або лінії.

Як тільки ви побачите символ перехрестя, у вас з'являться такі опції:

* _Звичайне натискання в тому самому місці._
    * Якщо перехрестя не знаходиться поблизу точки, повторне натискання в тому самому місці створює нову точку. Якщо ви знаходитесь поблизу лінії (але не поблизу точки), нова точка буде на лінії (і з'єднана з нею).
    * Якщо перехрестя знаходиться поблизу точки (тобто в межах зони чутливості точки), дотик до того самого місця просто вибирає точку (і відкриває редактор тегів. Нова точка не створюється. Дія така сама, як і у випадку вибору вище.
* _Звичайне дотик в іншому місці._ Дотик до іншого місця (поза зоною чутливості перехрестя) додає сегмент лінії від початкового положення до поточного положення. Якщо перехрестя було поблизу лінії або точки, новий сегмент буде з'єднаний з цією точкою або лінією.

Просто торкніться екрана в тому місці, де ви хочете додати додаткові точки лінії. Щоб закінчити, двічі торкніться кінцевої точки. Якщо кінцева точка розташована на лінії або точці, сегмент буде автоматично підключений до лінії або точки. 

Ви також можете скористатися пунктом меню: Дивіться [Створення нових об'єктів](Creating%20new%20objects.md) для отримання додаткової інформації.

#### Додавання області

На відміну від інших систем геоданих, OpenStreetMap наразі не має типу об'єкта «область». Онлайн-редактор «iD» намагається створити абстракцію області з базових елементів OSM, що в деяких випадках працює добре, а в інших — не дуже. Vespucci наразі не намагається робити нічого подібного, тому вам потрібно трохи знати про те, як представлені області:

* _закриті лінії (*полігони")_: найпростіший і найпоширеніший варіант області — це лінії, які мають спільну першу і останню точку, що утворюють закрите «кільце» (наприклад, більшість будівель є саме такого типу). Їх дуже легко створити в Vespucci, просто з'єднайте лінію з першою точкою, коли закінчите малювати область. Примітка: інтерпретація закритої лінії залежить від її тегування: наприклад, якщо закрита лінія тегується як будівля, вона буде вважатися областю, а якщо тегується як кільцева дорога, то ні. У деяких ситуаціях, коли обидві інтерпретації можуть бути правильними, тег «область» може уточнити передбачуване використання.
* _мультиполігони_: деякі області мають кілька частин, отвори та кільця, які не можна представити лише однією лінією. OSM використовує для цього спеціальний тип зв'язку (наш універсальний об'єкт, який може моделювати відношення між елементами) — мультиполігон. Мультиполігон може мати кілька «зовнішніх» кілець і кілька «внутрішніх» кілець. Кожне кільце може бути або закритою лінією, як описано вище, або декількома окремими лініями, що мають спільні кінцеві точки. Хоча великі мультиполігони важко обробляти будь-яким інструментом, невеликі мультиполігони неважко створити в Vespucci.
* _берегова лінія_: для дуже великих об'єктів, континентів і островів навіть модель мультиполігону не працює задовільно. Для ліній natural=coastline ми припускаємо семантику, що залежить від напрямку: земля знаходиться з лівого боку лінії, вода — з правого. Побічним ефектом цього є те, що, як правило, не слід змінювати напрямок лінії з тегом coastline. Більше інформації можна знайти на [OSM wiki](http://wiki.openstreetmap.org/wiki/Tag:natural%3Dcoastline).

#### Покращення геометрії ліній

Якщо ви достатньо збільшите вибрану лінію, ви побачите невеликий знак «x» посередині сегментів лінії, які є достатньо довгими. Перетягнувши знак «x», ви створите точку на лінії в цьому місці. Примітка: щоб уникнути випадкового створення точок, зона чутливості до дотику для цієї операції є досить малою.

#### Вирізання, Копіювання та Вставка

Ви можете скопіювати вибрані точки та лінії, а потім вставити їх один або кілька разів у нове місце. При вирізанні зберігаються ідентифікатор osm та версія, тому вставити можна тільки один раз. Щоб вставити, натисніть і утримуйте місце, куди ви хочете вставити (ви побачите хрестик, що позначає місце). Потім виберіть «Вставити» з меню.

#### Швидке додавання адрес

Vespucci підтримує функціонал, який робить обстеження адрес більш ефективним, передбачаючи номери будинків (окремо для лівої та правої сторін вулиць) та автоматично додаючи теги _addr:street_ або _addr:place_ на основі останнього використаного значення та близькості. У найкращому випадку це дозволяє додавати адресу без будь-якого набору тексту.   

Додавання тегів можна активувати, натиснувши ![Адреса](../images/address.png): 

* після тривалого натискання (тільки в не простих режимах): Vespucci додасть точку у цьому місці, зробить найкраще припущення щодо номера будинку та додасть теги адреси, які ви останнім часом використовували. Якщо точка знаходиться на контурі будівлі, він автоматично додасть тег «entrance=yes» до точки. Відкриється редактор тегів для даного об'єкта, де ви зможете внести необхідні зміни.
* у режимах вибору точки/лінії: Vespucci додасть теги адреси, як зазначено вище, і запустить редактор тегів.
* у редакторі властивостей.

Щоб додати окремі точки адреси безпосередньо в стандартному «Простому режимі», перейдіть у режим редагування «Адреса» (довго натисніть кнопку блокування), «Додати точку адреси» додасть точку адреси в цьому місці, а якщо він знаходиться на контурі будівлі, додайте до нього тег входу, як описано вище.

Пропонування номерів будинків потребує наявності не менше двох номерів з кожного боку вулиці, чим більше є даних, тим звісно краще.

Розгляньте можливість використання цього з одним із режимів [Автоматичного завантаження](#download).  

#### Додавання обмежень поворотів

Vespucci має швидкий спосіб додавання обмежень повороту. При необхідності він автоматично розділить шляхи і попросить вас повторно вибрати елементи. 

* виберіть лінію із тегом highway (обмеження поворотів можна додавати тільки до highway, якщо вам потрібно зробити це для інших ліній, скористайтеся загальним режимом «створити зв'язок») 
* виберіть «Додати обмеження» з меню
* виберіть точку або лінію «через» (тільки можливі елементи «через» матимуть відображену зону дотику)
* виберіть шлях «до» (можна повернутися назад і встановити елемент «до» як елемент «від», Vespucci вважатиме, що ви додаєте обмеження no_u_turn)
* встановіть тип обмеження

### Веспуччі в режимі "перегляду"

Коли показується червоний замок, вам доступні дії не повʼязані з редагуванням. Довге торкання до обʼєкта дозволяє побачити інформацію про нього, якщо він є обʼєктом ОСМ.

### Збереження вашіх змін

*(потрібне зʼєднання з мережею)*

Виберіть ту саму кнопку або пункт меню, що й для завантаження, і тепер виберіть «Завантажити дані на сервер OSM».

Vespucci підтримує авторизацію OAuth 2, OAuth 1.0a та класичний метод імені користувача та пароля. З 1 липня 2024 року стандартний API OpenStreetMap підтримує лише OAuth 2, а інші методи доступні лише на приватних інсталяціях API або в інших проектах, які перепрофілювали програмне забезпечення OSM.  

Авторизація Vespucci для доступу до вашого облікового запису від вашого імені вимагає від вас одноразового входу з вашим ім'ям користувача та паролем. Якщо ваша інсталяція Vespucci не авторизована при спробі завантажити змінені дані, вам буде запропоновано увійти на сайт OSM (через зашифроване з'єднання). Після входу вам буде запропоновано авторизувати Vespucci для редагування за допомогою вашого облікового запису. Якщо ви хочете або вам необхідно авторизувати OAuth доступ до вашого облікового запису перед редагуванням, в меню "Інструменти" є відповідний пункт.

Якщо ви хочете зберегти свою роботу і не маєте доступу до Інтернету, ви можете зберегти у JOSM-сумісний файл .osm і завантажити пізніше за допомогою Vespucci або JOSM. 

#### Вирішення конфліктів щодо завантажених файлів

Vespucci має простий механізм вирішення конфліктів. Однак, якщо ви підозрюєте, що ваші редагування містять серйозні проблеми, експортуйте зміни у файл .osc (пункт меню «Експорт» у меню «Передача») та виправте їх і завантажте за допомогою JOSM. Дивіться докладну довідку про [вирішення конфліктів](Conflict%20resolution.md).  

### Відображення найближчих цікавих місць

Поруч розташовані цікаві місця можна переглянути, потягнувши вгору ручку в середині та верхній частині нижньої панелі меню. 

Більше інформації про цю та інші доступні функції на головному дисплеї можна знайти тут [Головний дисплей карти](Main%20map%display.md).

## Використання GPS та GPX треків

За стандартних налаштувань Vespucci спробує увімкнути GPS (та інші супутникові навігаційні системи) і, якщо це неможливо, перейде до визначення місцезнаходження за допомогою так званого «мережевого розташування». Така поведінка передбачає, що під час звичайного використання ви налаштували свій пристрій Android так, щоб він використовував лише місцезнаходження, згенеровані GPX (щоб уникнути відстеження), тобто ви вимкнули опцію з евфемістичною назвою «Покращити точність визначення місцезнаходження». Якщо ви хочете увімкнути цю опцію, але не хочете, щоб Vespucci переходив до «мережевого розташування», ви повинні вимкнути відповідну опцію в [Розширених налаштуваннях](Advanced%20preferences.md). 

Натискання кнопки ![GPS](../images/menu_gps.png) (зазвичай розташована в лівій частині екрана з картою) призведе до центрування екрана на поточній позиції, і під час переміщення карта буде панорамуватися, щоб зберегти це положення.  Ручне переміщення екрану або редагування призведе до вимкнення режиму «слідувати за GPS», а синя стрілка GPS зміниться з контурної на заповнену. Щоб швидко повернутися до режиму «слідувати», просто натисніть кнопку GPS або повторно перевірте відповідний пункт меню. Якщо пристрій не має поточного місцезнаходження, маркер/стрілка місцезнаходження буде відображатися чорним кольором, якщо поточне місцезнаходження доступне, маркер буде синім.

Щоб записати трек GPX і відобразити його на вашому пристрої, виберіть пункт «Почати трек GPX» в меню ![GPS](../images/menu_gps.png). Це додасть шар на дисплей з поточним записаним треком, який ви можете завантажити та експортувати з запису в [керуванні шарами](Main%20map%20display.md). Додаткові шари можна додати з локальних файлів GPX та треків, завантажених з OSM API.

Примітка: за замовчуванням Vespucci не записує дані про висоту над рівнем моря разом із вашим треком GPX, це пов'язано з деякими проблемами, характерними для Android. Щоб увімкнути запис висоти над рівнем моря, встановіть гравітаційну модель або, що простіше, перейдіть до [Розширених налаштувань](Advanced%20preferences.md) і налаштуйте вхід NMEA.

### Як експортувати трек GPX?

Відкрийте меню шару, потім натисніть на меню з трьома крапками поруч із «Запис GPX», а потім виберіть **Експортувати трек GPX...**. Виберіть папку, в яку потрібно експортувати трек, а потім дайте йому ім'я з розширенням `.gpx` (наприклад: MyTrack.gpx).

## Примітки, помилки та завдання

Vespucci підтримує завантаження, коментування та закриття нотаток osm (раніше osm bugs) та еквівалентну функціональність для "помилок", створених [інструментом забезпечення якості osmose] (http://osmose.openstreetmap.fr/en/map/). Обидва інструменти потрібно або завантажити окремо, або скористатися функцією автоматичного завантаження, щоб отримати доступ до елементів, які знаходяться у вашій безпосередній близькості. Після редагування або закриття ви можете або негайно завантажити помилку або примітку, або завантажити всі одразу. 

Крім того, ми підтримуємо «Todos», які можна створити з елементів OSM, з шару GeoJSON або зовні Vespucci. Вони забезпечують зручний спосіб відстежувати роботу, яку ви хочете виконати. 

На карті примітки та помилки позначаються маленькою піктограмою помилки ![Bug](../images/bug_open.png), зелені позначки означають закриті/вирішені помилки, сині — створені або відредаговані вами, а жовті — активні та незмінені. Завдання позначаються жовтою піктограмою з галочкою.

Окно OSMOSE bug і Todos відображатиме посилання на відповідний елемент синім кольором (у випадку Todos тільки якщо з ним пов'язаний елемент OSM). При натисканні на посилання об'єкт буде виділено, екран буде відцентровано на ньому і, за необхідності, попередньо завантажено відповідну область. 

### Фільтрування

Окрім глобального ввімкнення відображення приміток та помилок, ви можете встановити грубий фільтр відображення, щоб зменшити захаращення. До налаштувань фільтра можна отримати доступ із запису шару завдань у [керуванні шарами](#layers):

* Примітки
* Помилка Osmose
* Попередження Osmose
* Незначна проблема Osmose
* Maproulette
* Todo

<a id="indoor"></a>

## Режим редагування приміщень

Редагування планів приміщень завжди є не простим завданням через високу щільність об'єктів, які дуже часто перекривають друг друга. Веспуччі має спеціальний режим для цього, який дозволяє показувати тільки ті об'єкти які знаходяться на одному поверсі та який автоматично додає номер поверху до новостворених об'єктів.

Цей режим можна увімкнути, натиснувши і утримуючи елемент блокування, див. [Блокування, розблокування, перемикання режимів](#lock) і вибравши відповідний пункт меню.

<a id="c-mode"></a>

## C-Mode

У режимі C відображаються тільки об'єкти, для яких встановлено прапорець попередження, що дозволяє легко виявити об'єкти, які мають певні проблеми або відповідають настроюваним перевіркам. Якщо об'єкт вибрано і редактор властивостей запущено в режимі C, автоматично буде застосовано найкраще відповідне попереднє налаштування.

Цей режим можна увімкнути, натиснувши і утримуючи елемент блокування, див. [Блокування, розблокування, перемикання режимів](#lock) і вибравши відповідний пункт меню.

### Налаштування перевірок

Усі перевірки можна вимкнути/увімкнути в розділі «Налаштування валідатора/Увімкнені перевірки» в [налаштуваннях](Preferences.md). 

Конфігурація для записів «Повторне сканування» дозволяє встановити час, після якого комбінація тегів повинна бути повторно просканована. Записи «Перевірити» — це теги, які повинні бути присутніми на об'єктах відповідно до заданих налаштувань. Записи можна редагувати, натиснувши на них, а зелена кнопка меню дозволяє додавати записи.

#### Повторні записи опитування

Записи повторного опитування мають такі властивості:

* **Ключ** - ключ тегу, що цікавить.
* **Значення** - значення, яке повинен мати тег, що цікавить; якщо поле порожнє, значення тегу буде проігноровано.
* **Вік** - через скільки днів після останньої зміни елемента його слід повторно перевірити. Якщо тег _check_date_ присутній, він буде використаний, інакше буде використана дата створення поточної версії. Встановлення значення нуль призведе до того, що перевірка буде просто порівнювати ключ і значення.
* **Регулярний вираз** - якщо встановлено прапорець, **Значення** вважається регулярним виразом JAVA.

**Ключ** і **значення** перевіряються на відповідність існуючим тегам відповідного об'єкта.

Група «Анотації» у стандартних пресетах містить елемент, який автоматично додає тег «check_date_» з поточною датою.

#### Перевірка записів

Перевірка записів має такі дві властивості:

* **Ключ** — ключ, який повинен бути присутнім в об'єкті відповідно до відповідного пресету.
* **Вимагати опціональний** — вимагати ключ, навіть якщо він знаходиться в опціональних тегах відповідного пресету.

Ця перевірка працює таким чином: спочатку визначається відповідний пресет, а потім перевіряється, чи є **Key** «рекомендованим» ключем для цього об'єкта відповідно до пресету. **Require optional** розширює перевірку на теги, які є «опціональними» для об'єкта. Примітка: наразі пов'язані пресети не перевіряються.

## Фільтри

### Фільтр на основі тегів

Фільтр можна ввімкнути в головному меню, а потім змінити, натиснувши на піктограму фільтра. Більше інформації можна знайти тут [Фільтр тегів](Tag%20filter.md).

### Фільтр на основі пресетів

Як альтернатива вищезазначеному, об'єкти фільтруються або за індивідуальними пресетами, або за групами пресетів. Натискання на піктограму фільтра відобразить діалогове вікно вибору пресетів, подібне до того, що використовується в інших частинах Vespucci. Індивідуальні пресети можна вибрати звичайним клацанням, а групи пресетів — довгим клацанням (звичайне клацання відкриває групу). Більше документації можна знайти тут [Фільтр пресетів](Preset%20filter.md).

## Налаштування Vespucci

Багато аспектів програми можна налаштувати. Якщо ви шукаєте щось конкретне і не можете знайти, на [веб-сайті Vespucci](https://vespucci.io/) можна здійснити пошук і знайти додаткову інформацію, яка не доступна на пристрої.

<a id="layers"></a>

### Налаштування шарів

Налаштування шарів можна змінити за допомогою панелі керування шарами (меню «гамбургер» у верхньому правому куті), всі інші налаштування доступні через кнопку налаштувань головного меню. Шари можна вмикати, вимикати та тимчасово приховувати.

Доступні типи шарів:

* Рівень даних - це рівень, на який завантажуються дані OpenStreetMap. При звичайному використанні вам не потрібно нічого змінювати тут. За замовчуванням: увімкнено.
* Рівень фону - доступний широкий вибір аерофотознімків та супутникових зображень. За замовчуванням використовується карта «стандартного стилю» з openstreetmap.org.
* Шар накладення — це напівпрозорі шари з додатковою інформацією, наприклад, інформацією про забезпечення якості. Додавання накладення може спричинити проблеми на старих пристроях та пристроях з обмеженою пам'яттю. За замовчуванням: відсутній.
* Відображення приміток/помилок — відкриті примітки та помилки відображатимуться у вигляді жовтої піктограми помилки, закриті — у вигляді зеленої піктограми. За замовчуванням: увімкнено.
* Шар фотографій — відображає геореферентні фотографії у вигляді червоних піктограм камери, якщо доступна інформація про напрямок, піктограма буде обертатися. За замовчуванням: вимкнено.
* Шар Mapillary — відображає сегменти Mapillary з маркерами, де є зображення, натискання на маркер відображає зображення. За замовчуванням: вимкнено.
* Шар GeoJSON — відображає вміст файлу GeoJSON, з файлів можна додати кілька шарів. За замовчуванням: відсутній.
* Шар GPX — відображає треки та точки маршруту GPX, з файлів можна додати кілька шарів, під час запису генерований трек GPX відображається в окремому шарі. За замовчуванням: відсутній.
* Сітка — відображає шкалу вздовж боків карти або сітку. За замовчуванням: увімкнено. 

Більше інформації можна знайти в розділі [відображення карти](Main%20map%20display.md).

#### Уподобання

* Тримати екран увімкненим. За замовчуванням: вимкнено.
* Велика область перетягування вузлів. Переміщення вузлів на пристрої з сенсорним введенням є проблематичним, оскільки пальці закривають поточне положення на дисплеї. Увімкнення цієї опції забезпечить велику область, яку можна використовувати для перетягування поза центром (вибір та інші операції все ще використовують звичайну область чутливості до дотику). За замовчуванням: вимкнено.

Повний опис можна знайти тут [Налаштування] (Preferences.md)

#### Розширені налаштування

* Повний екран. На пристроях без апаратних кнопок Vespucci може працювати в повноекранному режимі, що означає, що «віртуальні» кнопки навігації будуть автоматично приховані під час відображення карти, забезпечуючи більше місця на екрані для карти. Залежно від вашого пристрою, це може працювати добре або ні. У режимі _Auto_ ми намагаємося автоматично визначити, чи доцільно використовувати повноекранний режим, а налаштування _Force_ або _Never_ пропускає автоматичну перевірку, і повноекранний режим буде завжди використовуватися або завжди не використовуватися відповідно. На пристроях з Android 11 або вище режим _Auto_ ніколи не вмикає повноекранний режим, оскільки жестова навігація Android є його життєздатною альтернативою. За замовчуванням: «Авто».
* Піктограми точок. За замовчуванням: «увімкнено».
* Завжди показувати контекстне меню. Коли ця опція увімкнена, під час кожного вибору відображається контекстне меню, а коли вимкнена, меню відображається лише тоді, коли неможливо визначити однозначний вибір. За замовчуванням: вимкнено (раніше було увімкнено).
* Увімкнути світлу тему. На сучасних пристроях ця опція увімкнена за замовчуванням. Хоча ви можете увімкнути її для старіших версій Android, стиль, ймовірно, буде несумісним. 

Повний опис можна знайти тут [Розширені налаштування](Advanced%20preferences.md)

## Звітування та вирішення проблем

Якщо Vespucci виходить з ладу або виявляє невідповідність стану, вам буде запропоновано надіслати дамп пам'яті. У такому випадку, будь ласка, зробіть це, але тільки один раз для конкретної ситуації. Якщо ви хочете надати додаткову інформацію або створити запит на додавання функції чи подібне, будь ласка, зробіть це тут: [Система відстеження проблем Vespucci](https://github.com/MarcusWolschon/osmeditor4android/issues). Функція «Надати відгук» з головного меню відкриє нову проблему та включить відповідну інформацію про додаток та пристрій без додаткового введення даних.

Якщо у вас виникли труднощі із запуском програми після збою, ви можете спробувати запустити її в Безпечному режимі на пристроях, які підтримують швидкі клавіші: довго натисніть на іконку програми, а потім виберіть _Безпечний режим_ в меню. 

Якщо ви хочете обговорити щось, пов'язане з Vespucci, ви можете розпочати дискусію на [OpenStreetMap форумі](https://community.openstreetmap.org).


