package com.zinaro.cachecleanerwidget;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.widget.RemoteViews;
import android.widget.Toast;

import java.io.DataOutputStream;
import java.util.List;

public class CacheWidgetProvider extends AppWidgetProvider {

    @Override
    public void onReceive(Context context, Intent intent) {
        super.onReceive(context, intent);
        if ("CACHE_CLEAN".equals(intent.getAction())) {
            if (clearUserAppCaches(context)) {
                Toast.makeText(context, "All user app caches cleared.", Toast.LENGTH_SHORT).show();
            } else {
                Toast.makeText(context, "Cache clear failed.", Toast.LENGTH_SHORT).show();
            }
        }
    }

    @Override
    public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds) {
        for (int appWidgetId : appWidgetIds) {
            Intent intent = new Intent(context, CacheWidgetProvider.class);
            intent.setAction("CACHE_CLEAN");
            PendingIntent pendingIntent = PendingIntent.getBroadcast(context, 0, intent, PendingIntent.FLAG_IMMUTABLE);
            RemoteViews views = new RemoteViews(context.getPackageName(), R.layout.widget_layout);
            views.setOnClickPendingIntent(R.id.widget_button, pendingIntent);
            appWidgetManager.updateAppWidget(appWidgetId, views);
        }
    }

    private boolean clearUserAppCaches(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            List<ApplicationInfo> apps = pm.getInstalledApplications(0);

            Process su = Runtime.getRuntime().exec("su");
            DataOutputStream os = new DataOutputStream(su.getOutputStream());

            for (ApplicationInfo app : apps) {
                if ((app.flags & ApplicationInfo.FLAG_SYSTEM) != 0) continue;

                String pkg = app.packageName;
                os.writeBytes("rm -rf /data/data/" + pkg + "/cache/*\n");
                os.writeBytes("rm -rf /sdcard/Android/data/" + pkg + "/cache/*\n");
                os.writeBytes("rm -rf /storage/emulated/0/Android/data/" + pkg + "/cache/*\n");
            }

            os.writeBytes("exit\n");
            os.flush();
            int result = su.waitFor();
            return result == 0;
        } catch (Exception e) {
            return false;
        }
    }
}

