# Add project specific ProGuard rules here.
# You can control the set of applied configuration files using the
# proguardFiles setting in build.gradle.
#
# For more details, see
#   http://developer.android.com/guide/developing/tools/proguard.html

# If your project uses WebView with JS, uncomment the following
# and specify the fully qualified class name to the JavaScript interface
# class:
#-keepclassmembers class fqcn.of.javascript.interface.for.webview {
#   public *;
#}

# Uncomment this to preserve the line number information for
# debugging stack traces.
-keepattributes SourceFile,LineNumberTable
-keepnames class ** { *; }
-keepnames class * { <methods>; }
# If you keep the line number information, uncomment this to
# hide the original source file name.
#-renamesourcefileattribute SourceFile

-dontwarn javax.annotation.**
-dontwarn org.conscrypt.**
# A resource is loaded with a relative path so the package of this class must be preserved.
-keepnames class okhttp3.internal.publicsuffix.PublicSuffixDatabase

-if class androidx.credentials.CredentialManager
-keep class androidx.credentials.playservices.** {
  *;
}

# For Google Drive API
-dontwarn com.google.common.**
-dontwarn com.google.api.client.util.**

-keep class com.google.googlesignin.** { *; }
-keepnames class com.google.googlesignin.* { *; }

-keep class com.google.android.gms.auth.** { *; }

-keep class * extends com.google.api.client.json.GenericJson { *; }
-keep class com.google.api.services.drive.** { *; }
-keepclassmembers class * { @com.google.api.client.util.Key <fields>; }

# Keep all classes in Gson
-keep class com.google.gson.** { *; }

# Keep Gson internal serialization classes
-keep class sun.misc.** { *; }
-keep class com.google.gson.stream.** { *; }

# GSON
-keepattributes Signature
-keep class com.google.gson.reflect.TypeToken { *; }
-keep class * extends com.google.gson.reflect.TypeToken
-keep class com.wirelessalien.android.moviedb.work.UpdateWorker$* { *; }
-keep class com.wirelessalien.android.moviedb.data.CollectionDetails
-keep class com.wirelessalien.android.moviedb.data.Episode
-keep class com.wirelessalien.android.moviedb.data.EpisodeDbDetails
-keep class com.wirelessalien.android.moviedb.data.ListDataTmdb
-keep class com.wirelessalien.android.moviedb.data.ListDetailsData
-keep class com.wirelessalien.android.moviedb.data.ListDetailsData
-keep class com.wirelessalien.android.moviedb.data.MovieImage
-keep class com.wirelessalien.android.moviedb.data.NotificationItem
-keep class com.wirelessalien.android.moviedb.data.Release
-keep class com.wirelessalien.android.moviedb.data.TktTokenResponse
-keep class com.wirelessalien.android.moviedb.data.TraktMediaObject
-keep class com.wirelessalien.android.moviedb.data.TVSeason

-keep class com.wirelessalien.android.moviedb.data.** {
    !transient <fields>;
}

# Preserve Serializable Classes
-keepclassmembers,allowobfuscation,allowshrinking class * {
    @com.google.gson.annotations.SerializedName <fields>;
}
-keepclassmembers class * implements java.io.Serializable {
    static final long serialVersionUID;
    private static final java.io.ObjectStreamField[] serialPersistentFields;
    private void writeObject(java.io.ObjectOutputStream);
    private void readObject(java.io.ObjectInputStream);
    java.lang.Object readResolve();
    java.lang.Object writeReplace();
}