package com.willchan.simple_random_stock.util;

import android.util.Log;

import java.util.Random;

public class RandomStock {
    private static final String TAG = "RandomStock";

    private static final String[] DOW30_STOCK_TICKER = new String[]{
            "WBA", "V", "CRM", "CVX", "PG", "VZ", "WMT", "UNH", "TRV", "MCD", "MMM", "NKE", "MRK", "MSFT", "JPM", "KO", "JNJ", "GS", "HD", "HON", "IBM", "INTC", "DIS", "CAT", "CSCO", "AXP", "BA", "AMGN", "AAPL", "DOW"
    };
    private static final String[] DOW30_STOCK_NAME = new String[]{
            "Walgreen Boots Alliance Inc", "Visa Inc Class A", "Salesforce.Com Inc", "Chevron Corp", "Procter & Gamble", "Verizon Communications Inc", "Walmart Stores Inc", "Unitedhealth Group Inc", "Travelers Companies Inc", "Mcdonalds Corp", "3M", "Nike Inc Class B", "Merck & Co Inc", "Microsoft Corp", "JP Morgan Chase & Co", "Coca-Cola", "Johnson & Johnson", "Goldman Sachs Group Inc", "Home Depot Inc", "Honeywell International Inc", "International Business Machines Co", "Intel Corporation Corp", "Walt Disney", "Caterpillar Inc", "Cisco Systems Inc", "American Express", "Boeing", "Amgen Inc", "Apple Inc", "Dow Inc."
    };
    private static final String[] SPY500_STOCK_TICKER = new String[]{
            "MMM", "AOS", "ABT", "ABBV", "ABMD", "ACN", "ATVI", "ADM", "ADBE", "AAP", "AMD", "AES", "AFL", "A", "APD", "AKAM", "ALK", "ALB", "ARE", "ALGN", "ALLE", "LNT", "ALL", "GOOGL", "GOOG", "MO", "AMZN", "AMCR", "AEE", "AAL", "AEP", "AXP", "AIG", "AMT", "AWK", "AMP", "ABC", "AME", "AMGN", "APH", "ADI", "ANSS", "ANTM", "AON", "APA", "AAPL", "AMAT", "APTV", "ANET", "AJG", "AIZ", "T", "ATO", "ADSK", "ADP", "AZO", "AVB", "AVY", "BKR", "BLL", "BAC", "BBWI", "BAX", "BDX", "BRK.B", "BBY", "BIO", "TECH", "BIIB", "BLK", "BK", "BA", "BKNG", "BWA", "BXP", "BSX", "BMY", "AVGO", "BR", "BRO", "BF.B", "CHRW", "COG", "CDNS", "CZR", "CPB", "COF", "CAH", "KMX", "CCL", "CARR", "CTLT", "CAT", "CBOE", "CBRE", "CDW", "CE", "CNC", "CNP", "CDAY", "CERN", "CF", "CRL", "SCHW", "CHTR", "CVX", "CMG", "CB", "CHD", "CI", "CINF", "CTAS", "CSCO", "C", "CFG", "CTXS", "CLX", "CME", "CMS", "KO", "CTSH", "CL", "CMCSA", "CMA", "CAG", "COP", "ED", "STZ", "CPRT", "GLW", "CTVA", "COST", "CCI", "CSX", "CMI", "CVS", "DHI", "DHR", "DRI", "DVA", "DE", "DAL", "XRAY", "DVN", "DXCM", "FANG", "DLR", "DFS", "DISCA", "DISCK", "DISH", "DG", "DLTR", "D", "DPZ", "DOV", "DOW", "DTE", "DUK", "DRE", "DD", "DXC", "EMN", "ETN", "EBAY", "ECL", "EIX", "EW", "EA", "LLY", "EMR", "ENPH", "ETR", "EOG", "EFX", "EQIX", "EQR", "ESS", "EL", "ETSY", "RE", "EVRG", "ES", "EXC", "EXPE", "EXPD", "EXR", "XOM", "FFIV", "FB", "FAST", "FRT", "FDX", "FIS", "FITB", "FRC", "FE", "FISV", "FLT", "FMC", "F", "FTNT", "FTV", "FBHS", "FOXA", "FOX", "BEN", "FCX", "GPS", "GRMN", "IT", "GNRC", "GD", "GE", "GIS", "GM", "GPC", "GILD", "GPN", "GL", "GS", "HAL", "HBI", "HAS", "HCA", "PEAK", "HSIC", "HES", "HPE", "HLT", "HOLX", "HD", "HON", "HRL", "HST", "HWM", "HPQ", "HUM", "HBAN", "HII", "IBM", "IEX", "IDXX", "INFO", "ITW", "ILMN", "INCY", "IR", "INTC", "ICE", "IFF", "IP", "IPG", "INTU", "ISRG", "IVZ", "IPGP", "IQV", "IRM", "JBHT", "JKHY", "J", "SJM", "JNJ", "JCI", "JPM", "JNPR", "KSU", "K", "KEY", "KEYS", "KMB", "KIM", "KMI", "KLAC", "KHC", "KR", "LHX", "LH", "LRCX", "LW", "LVS", "LEG", "LDOS", "LEN", "LNC", "LIN", "LYV", "LKQ", "LMT", "L", "LOW", "LUMN", "LYB", "MTB", "MRO", "MPC", "MKTX", "MAR", "MMC", "MLM", "MAS", "MA", "MTCH", "MKC", "MCD", "MCK", "MDT", "MRK", "MET", "MTD", "MGM", "MCHP", "MU", "MSFT", "MAA", "MRNA", "MHK", "TAP", "MDLZ", "MPWR", "MNST", "MCO", "MS", "MSI", "MSCI", "NDAQ", "NTAP", "NFLX", "NWL", "NEM", "NWSA", "NWS", "NEE", "NLSN", "NKE", "NI", "NSC", "NTRS", "NOC", "NLOK", "NCLH", "NRG", "NUE", "NVDA", "NVR", "NXPI", "ORLY", "OXY", "ODFL", "OMC", "OKE", "ORCL", "OGN", "OTIS", "PCAR", "PKG", "PH", "PAYX", "PAYC", "PYPL", "PENN", "PNR", "PBCT", "PEP", "PKI", "PFE", "PM", "PSX", "PNW", "PXD", "PNC", "POOL", "PPG", "PPL", "PFG", "PG", "PGR", "PLD", "PRU", "PTC", "PEG", "PSA", "PHM", "PVH", "QRVO", "QCOM", "PWR", "DGX", "RL", "RJF", "RTX", "O", "REG", "REGN", "RF", "RSG", "RMD", "RHI", "ROK", "ROL", "ROP", "ROST", "RCL", "SPGI", "CRM", "SBAC", "SLB", "STX", "SEE", "SRE", "NOW", "SHW", "SPG", "SWKS", "SNA", "SO", "LUV", "SWK", "SBUX", "STT", "STE", "SYK", "SIVB", "SYF", "SNPS", "SYY", "TMUS", "TROW", "TTWO", "TPR", "TGT", "TEL", "TDY", "TFX", "TER", "TSLA", "TXN", "TXT", "COO", "HIG", "HSY", "MOS", "TRV", "DIS", "TMO", "TJX", "TSCO", "TT", "TDG", "TRMB", "TFC", "TWTR", "TYL", "TSN", "USB", "UDR", "ULTA", "UAA", "UA", "UNP", "UAL", "UPS", "URI", "UNH", "UHS", "VLO", "VTR", "VRSN", "VRSK", "VZ", "VRTX", "VFC", "VIAC", "VTRS", "V", "VNO", "VMC", "WRB", "GWW", "WAB", "WBA", "WMT", "WM", "WAT", "WEC", "WFC", "WELL", "WST", "WDC", "WU", "WRK", "WY", "WHR", "WMB", "WLTW", "WYNN", "XEL", "XLNX", "XYL", "YUM", "ZBRA", "ZBH", "ZION", "ZTS"
    };
    private static final String[] SPY500_STOCK_NAME = new String[]{
            "3M", "A. O. Smith", "Abbott Laboratories", "AbbVie", "Abiomed", "Accenture", "Activision Blizzard", "ADM", "Adobe", "Advance Auto Parts", "Advanced Micro Devices", "AES Corp", "Aflac", "Agilent Technologies", "Air Products & Chemicals", "Akamai Technologies", "Alaska Air Group", "Albemarle Corporation", "Alexandria Real Estate Equities", "Align Technology", "Allegion", "Alliant Energy", "Allstate Corp", "Alphabet (Class A)", "Alphabet (Class C)", "Altria Group", "Amazon", "Amcor", "Ameren Corp", "American Airlines Group", "American Electric Power", "American Express", "American International Group", "American Tower", "American Water Works", "Ameriprise Financial", "AmerisourceBergen", "Ametek", "Amgen", "Amphenol Corp", "Analog Devices", "Ansys", "Anthem", "Aon", "APA Corporation", "Apple", "Applied Materials", "Aptiv", "Arista Networks", "Arthur J. Gallagher & Co.", "Assurant", "AT&T", "Atmos Energy", "Autodesk", "Automatic Data Processing", "AutoZone", "AvalonBay Communities", "Avery Dennison", "Baker Hughes", "Ball Corp", "Bank of America", "Bath & Body Works Inc.", "Baxter International", "Becton Dickinson", "Berkshire Hathaway", "Best Buy", "Bio-Rad Laboratories", "Bio-Techne", "Biogen", "BlackRock", "BNY Mellon", "Boeing", "Booking Holdings", "BorgWarner", "Boston Properties", "Boston Scientific", "Bristol Myers Squibb", "Broadcom", "Broadridge Financial Solutions", "Brown & Brown", "Brown\u2013Forman", "C. H. Robinson", "Cabot Oil & Gas", "Cadence Design Systems", "Caesars Entertainment", "Campbell Soup", "Capital One Financial", "Cardinal Health", "CarMax", "Carnival Corporation", "Carrier Global", "Catalent", "Caterpillar", "Cboe Global Markets", "CBRE", "CDW", "Celanese", "Centene Corporation", "CenterPoint Energy", "Ceridian", "Cerner", "CF Industries", "Charles River Laboratories", "Charles Schwab Corporation", "Charter Communications", "Chevron Corporation", "Chipotle Mexican Grill", "Chubb", "Church & Dwight", "Cigna", "Cincinnati Financial", "Cintas Corporation", "Cisco Systems", "Citigroup", "Citizens Financial Group", "Citrix Systems", "Clorox", "CME Group", "CMS Energy", "Coca-Cola Company", "Cognizant Technology Solutions", "Colgate-Palmolive", "Comcast", "Comerica", "Conagra Brands", "ConocoPhillips", "Consolidated Edison", "Constellation Brands", "Copart", "Corning", "Corteva", "Costco", "Crown Castle", "CSX", "Cummins", "CVS Health", "D. R. Horton", "Danaher Corporation", "Darden Restaurants", "DaVita", "Deere & Co.", "Delta Air Lines", "Dentsply Sirona", "Devon Energy", "DexCom", "Diamondback Energy", "Digital Realty Trust", "Discover Financial Services", "Discovery (Series A)", "Discovery (Series C)", "Dish Network", "Dollar General", "Dollar Tree", "Dominion Energy", "Domino's Pizza", "Dover Corporation", "Dow", "DTE Energy", "Duke Energy", "Duke Realty Corp", "DuPont", "DXC Technology", "Eastman Chemical", "Eaton Corporation", "eBay", "Ecolab", "Edison International", "Edwards Lifesciences", "Electronic Arts", "Eli Lilly & Co", "Emerson Electric Company", "Enphase Energy", "Entergy", "EOG Resources", "Equifax", "Equinix", "Equity Residential", "Essex Property Trust", "Est\u00e9e Lauder Companies", "Etsy", "Everest Re", "Evergy", "Eversource Energy", "Exelon", "Expedia Group", "Expeditors", "Extra Space Storage", "ExxonMobil", "F5 Networks", "Facebook", "Fastenal", "Federal Realty Investment Trust", "FedEx", "Fidelity National Information Services", "Fifth Third Bancorp", "First Republic Bank", "FirstEnergy", "Fiserv", "Fleetcor", "FMC Corporation", "Ford", "Fortinet", "Fortive", "Fortune Brands Home & Security", "Fox Corporation (Class A)", "Fox Corporation (Class B)", "Franklin Resources", "Freeport-McMoRan", "Gap", "Garmin", "Gartner", "Generac Holdings", "General Dynamics", "General Electric", "General Mills", "General Motors", "Genuine Parts", "Gilead Sciences", "Global Payments", "Globe Life", "Goldman Sachs", "Halliburton", "Hanesbrands", "Hasbro", "HCA Healthcare", "Healthpeak Properties", "Henry Schein", "Hess Corporation", "Hewlett Packard Enterprise", "Hilton Worldwide", "Hologic", "Home Depot", "Honeywell", "Hormel", "Host Hotels & Resorts", "Howmet Aerospace", "HP", "Humana", "Huntington Bancshares", "Huntington Ingalls Industries", "IBM", "IDEX Corporation", "Idexx Laboratories", "IHS Markit", "Illinois Tool Works", "Illumina", "Incyte", "Ingersoll Rand", "Intel", "Intercontinental Exchange", "International Flavors & Fragrances", "International Paper", "Interpublic Group", "Intuit", "Intuitive Surgical", "Invesco", "IPG Photonics", "IQVIA", "Iron Mountain", "J. B. Hunt", "Jack Henry & Associates", "Jacobs Engineering Group", "JM Smucker", "Johnson & Johnson", "Johnson Controls", "JPMorgan Chase", "Juniper Networks", "Kansas City Southern", "Kellogg's", "KeyCorp", "Keysight Technologies", "Kimberly-Clark", "Kimco Realty", "Kinder Morgan", "KLA Corporation", "Kraft Heinz", "Kroger", "L3Harris Technologies", "LabCorp", "Lam Research", "Lamb Weston", "Las Vegas Sands", "Leggett & Platt", "Leidos", "Lennar", "Lincoln National", "Linde", "Live Nation Entertainment", "LKQ Corporation", "Lockheed Martin", "Loews Corporation", "Lowe's", "Lumen Technologies", "LyondellBasell", "M&T Bank", "Marathon Oil", "Marathon Petroleum", "MarketAxess", "Marriott International", "Marsh & McLennan", "Martin Marietta Materials", "Masco", "Mastercard", "Match Group", "McCormick & Company", "McDonald's", "McKesson Corporation", "Medtronic", "Merck & Co.", "MetLife", "Mettler Toledo", "MGM Resorts International", "Microchip Technology", "Micron Technology", "Microsoft", "Mid-America Apartments", "Moderna", "Mohawk Industries", "Molson Coors Beverage Company", "Mondelez International", "Monolithic Power Systems", "Monster Beverage", "Moody's Corporation", "Morgan Stanley", "Motorola Solutions", "MSCI", "Nasdaq", "NetApp", "Netflix", "Newell Brands", "Newmont", "News Corp (Class A)", "News Corp (Class B)", "NextEra Energy", "Nielsen Holdings", "Nike", "NiSource", "Norfolk Southern", "Northern Trust", "Northrop Grumman", "NortonLifeLock", "Norwegian Cruise Line Holdings", "NRG Energy", "Nucor", "Nvidia", "NVR", "NXP", "O'Reilly Automotive", "Occidental Petroleum", "Old Dominion Freight Line", "Omnicom Group", "Oneok", "Oracle", "Organon & Co.", "Otis Worldwide", "Paccar", "Packaging Corporation of America", "Parker-Hannifin", "Paychex", "Paycom", "PayPal", "Penn National Gaming", "Pentair", "People's United Financial", "PepsiCo", "PerkinElmer", "Pfizer", "Philip Morris International", "Phillips 66", "Pinnacle West Capital", "Pioneer Natural Resources", "PNC Financial Services", "Pool Corporation", "PPG Industries", "PPL", "Principal Financial Group", "Procter & Gamble", "Progressive Corporation", "Prologis", "Prudential Financial", "PTC", "Public Service Enterprise Group", "Public Storage", "PulteGroup", "PVH", "Qorvo", "Qualcomm", "Quanta Services", "Quest Diagnostics", "Ralph Lauren Corporation", "Raymond James Financial", "Raytheon Technologies", "Realty Income Corporation", "Regency Centers", "Regeneron Pharmaceuticals", "Regions Financial Corporation", "Republic Services", "ResMed", "Robert Half International", "Rockwell Automation", "Rollins", "Roper Technologies", "Ross Stores", "Royal Caribbean Group", "S&P Global", "Salesforce", "SBA Communications", "Schlumberger", "Seagate Technology", "Sealed Air", "Sempra Energy", "ServiceNow", "Sherwin-Williams", "Simon Property Group", "Skyworks Solutions", "Snap-on", "Southern Company", "Southwest Airlines", "Stanley Black & Decker", "Starbucks", "State Street Corporation", "Steris", "Stryker Corporation", "SVB Financial", "Synchrony Financial", "Synopsys", "Sysco", "T-Mobile US", "T. Rowe Price", "Take-Two Interactive", "Tapestry", "Target Corporation", "TE Connectivity", "Teledyne Technologies", "Teleflex", "Teradyne", "Tesla", "Texas Instruments", "Textron", "The Cooper Companies", "The Hartford", "The Hershey Company", "The Mosaic Company", "The Travelers Companies", "The Walt Disney Company", "Thermo Fisher Scientific", "TJX Companies", "Tractor Supply Company", "Trane Technologies", "TransDigm Group", "Trimble", "Truist Financial", "Twitter", "Tyler Technologies", "Tyson Foods", "U.S. Bancorp", "UDR", "Ulta Beauty", "Under Armour (Class A)", "Under Armour (Class C)", "Union Pacific", "United Airlines", "United Parcel Service", "United Rentals", "UnitedHealth Group", "Universal Health Services", "Valero Energy", "Ventas", "Verisign", "Verisk Analytics", "Verizon Communications", "Vertex Pharmaceuticals", "VF Corporation", "ViacomCBS", "Viatris", "Visa", "Vornado Realty Trust", "Vulcan Materials", "W. R. Berkley Corporation", "W. W. Grainger", "Wabtec", "Walgreens Boots Alliance", "Walmart", "Waste Management", "Waters Corporation", "WEC Energy Group", "Wells Fargo", "Welltower", "West Pharmaceutical Services", "Western Digital", "Western Union", "WestRock", "Weyerhaeuser", "Whirlpool Corporation", "Williams Companies", "Willis Towers Watson", "Wynn Resorts", "Xcel Energy", "Xilinx", "Xylem", "Yum! Brands", "Zebra Technologies", "Zimmer Biomet", "Zions Bancorp", "Zoetis"
    };
    private static final String[] NASDAQ100_STOCK_TICKER = new String[]{
            "AAPL", "ADBE", "ADI", "ADP", "ADSK", "AEP", "ALGN", "AMAT", "AMD", "AMGN", "AMZN", "ANSS", "ASML", "ATVI", "AVGO", "BIDU", "BIIB", "BKNG", "CDNS", "CDW", "CERN", "CHKP", "CHTR", "CMCSA", "COST", "CPRT", "CRWD", "CSCO", "CSX", "CTAS", "CTSH", "DLTR", "DOCU", "DXCM", "EA", "EBAY", "EXC", "FAST", "FB", "FISV", "FOX", "FOXA", "GILD", "GOOG", "GOOGL", "HON", "IDXX", "ILMN", "INCY", "INTC", "INTU", "ISRG", "JD", "KDP", "KHC", "KLAC", "LRCX", "LULU", "MAR", "MCHP", "MDLZ", "MELI", "MNST", "MRNA", "MRVL", "MSFT", "MTCH", "MU", "NFLX", "NTES", "NVDA", "NXPI", "OKTA", "ORLY", "PAYX", "PCAR", "PDD", "PEP", "PTON", "PYPL", "QCOM", "REGN", "ROST", "SBUX", "SGEN", "SIRI", "SNPS", "SPLK", "SWKS", "TCOM", "TEAM", "TMUS", "TSLA", "TXN", "VRSK", "VRSN", "VRTX", "WBA", "WDAY", "XEL", "XLNX", "ZM"
    };
    private static final String[] NASDAQ100_STOCK_NAME = new String[]{
            "Apple Inc", "Adobe Systems Inc", "Analog Devices", "Automatic Data Procs", "Autodesk Inc", "American Electric Power Company", "Align Technology", "Applied Materials", "Adv Micro Devices", "Amgen Inc", "Amazon.com Inc", "Ansys Inc", "Asml Holdings NY Reg ADR", "Activision Blizzard", "Broadcom Ltd", "Baidu Inc ADR", "Biogen Inc", "Booking Holdings Inc", "Cadence Design Sys", "CDW Corp", "Cerner Corp", "Check Point Software", "Charter Communicatio", "Comcast Corp A", "Costco Wholesale", "Copart Inc", "Crowdstrike Holdings Inc", "Cisco Systems Inc", "CSX Corp", "Cintas Corp", "Cognizant Tech Sol", "Dollar Tree Inc", "Docusign Inc", "Dexcom", "Electronic Arts Inc", "Ebay Inc", "Exelon Corp", "Fastenal Company", "Facebook Inc", "Fiserv Inc", "Fox Corp Cl B", "Fox Corp Cl A", "Gilead Sciences Inc", "Alphabet Cl C", "Alphabet Cl A", "Honeywell International Inc", "Idexx Laboratories", "Illumina Inc", "Incyte Corp", "Intel Corp", "Intuit Inc", "Intuitive Surg Inc", "Jd.com Inc ADR", "Keurig Dr Pepper Inc", "Kraft Heinz Company", "K L A-Tencor Corp", "Lam Research Corp", "Lululemon Athletica", "Marriot Int Cl A", "Microchip Technology", "Mondelez Intl Inc", "Mercadolibre Inc", "Monster Beverage Cp", "Moderna Inc", "Marvell Technology Inc", "Microsoft Corp", "Match Group Inc", "Micron Technology", "Netflix Inc", "Netease Inc ADR", "Nvidia Corp", "Nxp Semiconductors", "Okta Inc Cl A", "O'Reilly Automotive", "Paychex Inc", "Paccar Inc", "Pinduoduo Inc ADR", "Pepsico Inc", "Peloton Interactive Inc", "Paypal Holdings", "Qualcomm Inc", "Regeneron Pharmaceuticals", "Ross Stores Inc", "Starbucks Corp", "Seagen Inc", "Sirius XM Holdings", "Synopsys Inc", "Splunk Inc", "Skyworks Solutions", "Trip.com Group Ltd ADR", "Atlassian Cls A Ord", "T-Mobile US", "Tesla Inc", "Texas Instruments", "Verisk Analytics Inc", "Verisign Inc", "Vertex Pharmaceutic", "Walgreens Boots Alliance", "Workday Inc", "XCEL Energy Inc", "Xilinx Inc", "Zoom Video Communications Cl A"
    };

    public static String[] getDow30StockTicker() {
        return DOW30_STOCK_TICKER;
    }

    public static String[] getDow30StockName() {
        return DOW30_STOCK_NAME;
    }

    public static String[] getSpy500StockTicker() {
        return SPY500_STOCK_TICKER;
    }

    public static String[] getSpy500StockName() {
        return SPY500_STOCK_NAME;
    }

    public static String[] getNasdaq100StockTicker() {
        return NASDAQ100_STOCK_TICKER;
    }

    public static String[] getNasdaq100StockName() {
        return NASDAQ100_STOCK_NAME;
    }

    public static int getRandomStockPosition(StockIndex stockIndex) {
        int position = -1;
        if (stockIndex == StockIndex.DOW) {
            position = new Random().nextInt(DOW30_STOCK_TICKER.length);
//            String ticker = DOW30_STOCK_TICKER[position];
//            String name = DOW30_STOCK_NAME[position];
//            System.out.println("Name " + name + " and Ticker: " + ticker);
        } else if (stockIndex == StockIndex.SPY) {
            position = new Random().nextInt(SPY500_STOCK_TICKER.length);
//            String ticker = SPY500_STOCK_TICKER[position];
//            String name = SPY500_STOCK_NAME[position];
//            System.out.println("Name " + name + " and Ticker: " + ticker);
        } else if (stockIndex == StockIndex.NASDAQ) {
            position = new Random().nextInt(NASDAQ100_STOCK_TICKER.length);
//            String ticker = NASDAQ100_STOCK_TICKER[position];
//            String name = NASDAQ100_STOCK_NAME[position];
//            System.out.println("Name " + name + " and Ticker: " + ticker);
        } else {
            Log.e(TAG, "Maybe there's a new ENUM declared?");
        }
        return position;
    }

    public enum StockIndex {
        DOW, SPY, NASDAQ
    }
}
