// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// @dart=3.0

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 22;
// AUTOGENERATED END

const String file = 'breakpoint_on_record_assignment_test.dart';

void testMain() {
  final (int, String name, bool) triple = (3, 'f', true); // LINE_A
  final ({int n, String s}) pair = (n: 2, s: 's');
  final (bool, num, {int n, String s}) quad = (false, 3.14, n: 7, s: 'd');
  print('$pair $triple $quad');
}

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtUriAndLine(file, LINE_A),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  setBreakpointAtUriAndLine(file, LINE_A + 1),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A + 1),
  setBreakpointAtUriAndLine(file, LINE_A + 2),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A + 2),
  setBreakpointAtUriAndLine(file, LINE_A + 3),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A + 3),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'breakpoint_on_record_assignment_test.dart',
      testeeConcurrent: testMain,
      pauseOnStart: true,
      pauseOnExit: true,
    );
