/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.util;

import java.io.ByteArrayOutputStream;
import java.util.Vector;

public final class Strings {
    public static String fromUTF8ByteArray(byte[] bytes) {
        int i = 0;
        int length = 0;
        while (i < bytes.length) {
            ++length;
            if ((bytes[i] & 0xF0) == 240) {
                ++length;
                i += 4;
                continue;
            }
            if ((bytes[i] & 0xE0) == 224) {
                i += 3;
                continue;
            }
            if ((bytes[i] & 0xC0) == 192) {
                i += 2;
                continue;
            }
            ++i;
        }
        char[] cs = new char[length];
        i = 0;
        length = 0;
        while (i < bytes.length) {
            char ch;
            if ((bytes[i] & 0xF0) == 240) {
                int codePoint = (bytes[i] & 3) << 18 | (bytes[i + 1] & 0x3F) << 12 | (bytes[i + 2] & 0x3F) << 6 | bytes[i + 3] & 0x3F;
                int U = codePoint - 65536;
                char W1 = (char)(0xD800 | U >> 10);
                char W2 = (char)(0xDC00 | U & 0x3FF);
                cs[length++] = W1;
                ch = W2;
                i += 4;
            } else if ((bytes[i] & 0xE0) == 224) {
                ch = (char)((bytes[i] & 0xF) << 12 | (bytes[i + 1] & 0x3F) << 6 | bytes[i + 2] & 0x3F);
                i += 3;
            } else if ((bytes[i] & 0xD0) == 208) {
                ch = (char)((bytes[i] & 0x1F) << 6 | bytes[i + 1] & 0x3F);
                i += 2;
            } else if ((bytes[i] & 0xC0) == 192) {
                ch = (char)((bytes[i] & 0x1F) << 6 | bytes[i + 1] & 0x3F);
                i += 2;
            } else {
                ch = (char)(bytes[i] & 0xFF);
                ++i;
            }
            cs[length++] = ch;
        }
        return new String(cs);
    }

    public static byte[] toUTF8ByteArray(String string) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        char[] c = string.toCharArray();
        int i = 0;
        while (i < c.length) {
            char ch = c[i];
            if (ch < '\u0080') {
                bOut.write(ch);
            } else if (ch < '\u0800') {
                bOut.write(0xC0 | ch >> 6);
                bOut.write(0x80 | ch & 0x3F);
            } else if (ch >= '\ud800' && ch <= '\udfff') {
                if (i + 1 >= c.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char W1 = ch;
                char W2 = ch = c[++i];
                if (W1 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int codePoint = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                bOut.write(0xF0 | codePoint >> 18);
                bOut.write(0x80 | codePoint >> 12 & 0x3F);
                bOut.write(0x80 | codePoint >> 6 & 0x3F);
                bOut.write(0x80 | codePoint & 0x3F);
            } else {
                bOut.write(0xE0 | ch >> 12);
                bOut.write(0x80 | ch >> 6 & 0x3F);
                bOut.write(0x80 | ch & 0x3F);
            }
            ++i;
        }
        return bOut.toByteArray();
    }

    public static String toUpperCase(String string) {
        boolean changed = false;
        char[] chars = string.toCharArray();
        int i = 0;
        while (i != chars.length) {
            char ch = chars[i];
            if ('a' <= ch && 'z' >= ch) {
                changed = true;
                chars[i] = (char)(ch - 97 + 65);
            }
            ++i;
        }
        if (changed) {
            return new String(chars);
        }
        return string;
    }

    public static String toLowerCase(String string) {
        boolean changed = false;
        char[] chars = string.toCharArray();
        int i = 0;
        while (i != chars.length) {
            char ch = chars[i];
            if ('A' <= ch && 'Z' >= ch) {
                changed = true;
                chars[i] = (char)(ch - 65 + 97);
            }
            ++i;
        }
        if (changed) {
            return new String(chars);
        }
        return string;
    }

    public static byte[] toByteArray(String string) {
        byte[] bytes = new byte[string.length()];
        int i = 0;
        while (i != bytes.length) {
            char ch = string.charAt(i);
            bytes[i] = (byte)ch;
            ++i;
        }
        return bytes;
    }

    public static String[] split(String input, char delimiter) {
        Vector<String> v = new Vector<String>();
        boolean moreTokens = true;
        while (moreTokens) {
            int tokenLocation = input.indexOf(delimiter);
            if (tokenLocation > 0) {
                String subString = input.substring(0, tokenLocation);
                v.addElement(subString);
                input = input.substring(tokenLocation + 1);
                continue;
            }
            moreTokens = false;
            v.addElement(input);
        }
        String[] res = new String[v.size()];
        int i = 0;
        while (i != res.length) {
            res[i] = (String)v.elementAt(i);
            ++i;
        }
        return res;
    }
}

