/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.jce.provider;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.gudy.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.gudy.bouncycastle.crypto.params.ElGamalParameters;
import org.gudy.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.gudy.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.gudy.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import org.gudy.bouncycastle.jce.interfaces.ElGamalPublicKey;

public class ElGamalUtil {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof ElGamalPublicKey) {
            ElGamalPublicKey k = (ElGamalPublicKey)key;
            return new ElGamalPublicKeyParameters(k.getY(), new ElGamalParameters(k.getParams().getP(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify ElGamal public key.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof ElGamalPrivateKey) {
            ElGamalPrivateKey k = (ElGamalPrivateKey)key;
            return new ElGamalPrivateKeyParameters(k.getX(), new ElGamalParameters(k.getParams().getP(), k.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify ElGamal private key.");
    }
}

