/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.gudy.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.gudy.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.gudy.bouncycastle.crypto.KeyGenerationParameters;
import org.gudy.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.gudy.bouncycastle.crypto.params.DSAParameters;
import org.gudy.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.gudy.bouncycastle.crypto.params.DSAPublicKeyParameters;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        DSAParameters dsaParams = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = dsaParams.getQ();
        BigInteger p = dsaParams.getP();
        BigInteger g = dsaParams.getG();
        while ((x = new BigInteger(160, random)).equals(ZERO) || x.compareTo(q) >= 0) {
        }
        BigInteger y = g.modPow(x, p);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }
}

