/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.gudy.bouncycastle.asn1.ASN1EncodableVector;
import org.gudy.bouncycastle.asn1.ASN1OctetString;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DERBitString;
import org.gudy.bouncycastle.asn1.DEREncodable;
import org.gudy.bouncycastle.asn1.DERInteger;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DERSequence;
import org.gudy.bouncycastle.asn1.x9.X9FieldElement;
import org.gudy.bouncycastle.asn1.x9.X9FieldID;
import org.gudy.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.gudy.bouncycastle.math.ec.ECCurve;

public class X9Curve
implements DEREncodable,
X9ObjectIdentifiers {
    private ECCurve curve;
    private byte[] seed;

    public X9Curve(ECCurve curve) {
        this.curve = curve;
        this.seed = null;
    }

    public X9Curve(ECCurve curve, byte[] seed) {
        this.curve = curve;
        this.seed = seed;
    }

    public X9Curve(X9FieldID fieldID, ASN1Sequence seq) {
        if (!fieldID.getIdentifier().equals(prime_field)) {
            throw new RuntimeException("not implemented");
        }
        BigInteger q = ((DERInteger)fieldID.getParameters()).getValue();
        X9FieldElement x9A = new X9FieldElement(true, q, (ASN1OctetString)seq.getObjectAt(0));
        X9FieldElement x9B = new X9FieldElement(true, q, (ASN1OctetString)seq.getObjectAt(1));
        this.curve = new ECCurve.Fp(q, x9A.getValue().toBigInteger(), x9B.getValue().toBigInteger());
        if (seq.size() == 3) {
            this.seed = ((DERBitString)seq.getObjectAt(2)).getBytes();
        }
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    @Override
    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new X9FieldElement(this.curve.getA()).getDERObject());
        v.add(new X9FieldElement(this.curve.getB()).getDERObject());
        if (this.seed != null) {
            v.add(new DERBitString(this.seed));
        }
        return new DERSequence(v);
    }
}

