/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update.sf.impl2;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsException;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;
import org.gudy.azureus2.pluginsimpl.update.sf.impl2.SFPluginDetailsImpl;

public class SFPluginDetailsLoaderImpl
implements SFPluginDetailsLoader,
ResourceDownloaderListener {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String site_prefix_default = "http://plugins.vuze.com/";
    private static String site_prefix;
    private static String base_url_params;
    private static String page_url;
    private static SFPluginDetailsLoaderImpl singleton;
    private static AEMonitor class_mon;
    private static final int RELOAD_MIN_TIME = 3600000;
    protected boolean plugin_ids_loaded;
    protected long plugin_ids_loaded_at;
    protected List plugin_ids;
    protected Map plugin_map;
    protected List listeners = new ArrayList();
    protected ResourceDownloaderFactory rd_factory = ResourceDownloaderFactoryImpl.getSingleton();
    protected AEMonitor this_mon = new AEMonitor("SFPluginDetailsLoader");

    static {
        try {
            Map data = VersionCheckClient.getSingleton().getVersionCheckInfo("pu");
            byte[] b_sp = (byte[])data.get("plugin_update_url");
            site_prefix = b_sp == null ? site_prefix_default : new String(b_sp);
        }
        catch (Throwable e) {
            site_prefix = site_prefix_default;
        }
        base_url_params = "version=5.7.4.1_CVS&app=" + SystemProperties.getApplicationName();
        try {
            base_url_params = String.valueOf(base_url_params) + "&os=" + URLEncoder.encode(System.getProperty("os.name"), "UTF-8");
            base_url_params = String.valueOf(base_url_params) + "&osv=" + URLEncoder.encode(System.getProperty("os.version"), "UTF-8");
            base_url_params = String.valueOf(base_url_params) + "&arch=" + URLEncoder.encode(System.getProperty("os.arch"), "UTF-8");
            base_url_params = String.valueOf(base_url_params) + "&ui=" + URLEncoder.encode(COConfigurationManager.getStringParameter("ui"), "UTF-8");
            base_url_params = String.valueOf(base_url_params) + "&java=" + URLEncoder.encode(Constants.JAVA_VERSION, "UTF-8");
            if (Constants.API_LEVEL > 0) {
                base_url_params = String.valueOf(base_url_params) + "&api_level=" + Constants.API_LEVEL;
            }
            try {
                Class<?> c = Class.forName("org.eclipse.swt.SWT");
                String swt_platform = (String)c.getMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
                base_url_params = String.valueOf(base_url_params) + "&swt_platform=" + swt_platform;
                Integer swt_version = (Integer)c.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
                base_url_params = String.valueOf(base_url_params) + "&swt_version=" + swt_version;
            }
            catch (Throwable c) {}
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        page_url = String.valueOf(site_prefix) + "update/pluginlist3.php?type=&" + base_url_params;
        try {
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            if (pm.hasCapability(PlatformManagerCapabilities.GetVersion)) {
                page_url = String.valueOf(page_url) + "&pmv=" + pm.getVersion();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_mon = new AEMonitor("SFPluginDetailsLoader:class");
    }

    public static SFPluginDetailsLoader getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new SFPluginDetailsLoaderImpl();
            }
            SFPluginDetailsLoaderImpl sFPluginDetailsLoaderImpl = singleton;
            return sFPluginDetailsLoaderImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected SFPluginDetailsLoaderImpl() {
        this.reset();
    }

    protected String getRelativeURLBase() {
        return site_prefix;
    }

    protected void loadPluginList() throws SFPluginDetailsException {
        try {
            URL original_url;
            String page_url_to_use = this.addEPIDS(page_url);
            URL url = original_url = new URL(page_url_to_use);
            Proxy proxy = null;
            AEProxyFactory.PluginProxy plugin_proxy = null;
            boolean tried_proxy = false;
            boolean ok = false;
            try {
                while (true) {
                    try {
                        ResourceDownloader dl = this.rd_factory.create(url, proxy);
                        if (plugin_proxy != null) {
                            dl.setProperty("URL_HOST", plugin_proxy.getURLHostRewrite());
                        }
                        dl = this.rd_factory.getRetryDownloader(dl, 5);
                        dl.addListener(this);
                        Properties details = new Properties();
                        InputStream is = dl.download();
                        details.load(is);
                        is.close();
                        for (String string : details.keySet()) {
                            String data = (String)details.get(string);
                            int pos = 0;
                            ArrayList<String> bits = new ArrayList<String>();
                            while (pos < data.length()) {
                                int p1 = data.indexOf(59, pos);
                                if (p1 == -1) {
                                    bits.add(data.substring(pos).trim());
                                    break;
                                }
                                bits.add(data.substring(pos, p1).trim());
                                pos = p1 + 1;
                            }
                            if (bits.size() < 3) {
                                Logger.log(new LogEvent(LOGID, 3, "SF loadPluginList failed for plugin '" + string + "'.  Details array is " + bits.size() + " (3 min)"));
                                continue;
                            }
                            String version = (String)bits.get(0);
                            String cvs_version = (String)bits.get(1);
                            String name = (String)bits.get(2);
                            String category = "";
                            if (bits.size() > 3) {
                                category = (String)bits.get(3);
                            }
                            this.plugin_ids.add(string);
                            this.plugin_map.put(string.toLowerCase(MessageText.LOCALE_ENGLISH), new SFPluginDetailsImpl(this, string, version, cvs_version, name, category));
                        }
                        ok = true;
                    }
                    catch (Throwable e) {
                        if (!tried_proxy) {
                            tried_proxy = true;
                            plugin_proxy = AEProxyFactory.getPluginProxy("loading plugin details", url);
                            if (plugin_proxy == null) {
                                throw e;
                            }
                            url = plugin_proxy.getURL();
                            proxy = plugin_proxy.getProxy();
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
            }
            finally {
                if (plugin_proxy != null) {
                    plugin_proxy.setOK(ok);
                }
            }
            this.plugin_ids_loaded = true;
            this.plugin_ids_loaded_at = SystemTime.getCurrentTime();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new SFPluginDetailsException("Plugin list load failed", e);
        }
    }

    private String addEPIDS(String str) {
        try {
            PluginInterface[] pis;
            String pids = "";
            PluginInterface[] pluginInterfaceArray = pis = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaces();
            int n = pis.length;
            int n2 = 0;
            while (n2 < n) {
                String pid;
                String version;
                PluginInterface pi = pluginInterfaceArray[n2];
                PluginState ps = pi.getPluginState();
                if (!ps.isBuiltIn() && !ps.isDisabled() && (version = pi.getPluginVersion()) != null && Constants.compareVersions(version, "0") > 0 && (pid = pi.getPluginID()) != null && pid.length() > 0) {
                    pids = String.valueOf(pids) + pid + ":";
                }
                ++n2;
            }
            str = String.valueOf(str) + "&epids=" + UrlUtils.encode(pids);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return str;
    }

    protected void loadPluginDetails(SFPluginDetailsImpl details) throws SFPluginDetailsException {
        try {
            URL original_url;
            String page_url_to_use = String.valueOf(site_prefix) + "update/pluginlist3.php?plugin=" + UrlUtils.encode(details.getId()) + "&" + base_url_params;
            page_url_to_use = this.addEPIDS(page_url_to_use);
            try {
                String existing_version;
                PluginInterface pi;
                PluginInterface defPI = PluginInitializer.getDefaultInterface();
                PluginInterface pluginInterface = pi = defPI == null ? null : defPI.getPluginManager().getPluginInterfaceByID(details.getId(), false);
                if (pi != null && (existing_version = pi.getPluginVersion()) != null) {
                    page_url_to_use = String.valueOf(page_url_to_use) + "&ver_" + details.getId() + "=" + UrlUtils.encode(existing_version);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            URL url = original_url = new URL(page_url_to_use);
            Proxy proxy = null;
            AEProxyFactory.PluginProxy plugin_proxy = null;
            boolean tried_proxy = false;
            boolean ok = false;
            try {
                while (true) {
                    try {
                        ResourceDownloader p_dl = this.rd_factory.create(url, proxy);
                        if (proxy != null) {
                            p_dl.setProperty("URL_HOST", original_url.getHost());
                        }
                        p_dl = this.rd_factory.getRetryDownloader(p_dl, 5);
                        p_dl.addListener(this);
                        InputStream is = p_dl.download();
                        try {
                            if (!this.processPluginStream(details, is)) {
                                throw new SFPluginDetailsException("Plugin details load fails for '" + details.getId() + "': data not found");
                            }
                            ok = true;
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!tried_proxy) {
                            tried_proxy = true;
                            plugin_proxy = AEProxyFactory.getPluginProxy("loading plugin details", url);
                            if (plugin_proxy == null) {
                                throw e;
                            }
                            url = plugin_proxy.getURL();
                            proxy = plugin_proxy.getProxy();
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
            }
            finally {
                if (plugin_proxy != null) {
                    plugin_proxy.setOK(ok);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new SFPluginDetailsException("Plugin details load fails", e);
        }
    }

    protected boolean processPluginStream(SFPluginDetailsImpl details, InputStream is) {
        Properties properties = new Properties();
        try {
            properties.load(is);
            String pid = details.getId();
            String download_url = properties.getProperty(String.valueOf(pid) + ".dl_link", "");
            download_url = download_url.length() == 0 ? "<unknown>" : String.valueOf(site_prefix) + download_url;
            String author = properties.getProperty(String.valueOf(pid) + ".author", "");
            String desc = properties.getProperty(String.valueOf(pid) + ".description", "");
            String cvs_download_url = properties.getProperty(String.valueOf(pid) + ".dl_link_cvs", null);
            cvs_download_url = cvs_download_url == null || cvs_download_url.length() == 0 ? "<unknown>" : String.valueOf(site_prefix) + cvs_download_url;
            String comment = properties.getProperty(String.valueOf(pid) + ".comment", "");
            String info_url = properties.getProperty(String.valueOf(pid) + ".info_url", null);
            details.setDetails(download_url, author, cvs_download_url, desc, comment, info_url);
            return true;
        }
        catch (IOException e) {
            Debug.out(e);
            return false;
        }
    }

    @Override
    public String[] getPluginIDs() throws SFPluginDetailsException {
        try {
            this.this_mon.enter();
            if (!this.plugin_ids_loaded) {
                this.loadPluginList();
            }
            String[] res = new String[this.plugin_ids.size()];
            this.plugin_ids.toArray(res);
            String[] stringArray = res;
            return stringArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public SFPluginDetails getPluginDetails(String name) throws SFPluginDetailsException {
        try {
            this.this_mon.enter();
            this.getPluginIDs();
            SFPluginDetails details = (SFPluginDetails)this.plugin_map.get(name.toLowerCase(MessageText.LOCALE_ENGLISH));
            if (details == null) {
                throw new SFPluginDetailsException("Plugin '" + name + "' not found");
            }
            SFPluginDetails sFPluginDetails = details;
            return sFPluginDetails;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public SFPluginDetails[] getPluginDetails() throws SFPluginDetailsException {
        String[] plugin_ids = this.getPluginIDs();
        SFPluginDetails[] res = new SFPluginDetails[plugin_ids.length];
        int i = 0;
        while (i < plugin_ids.length) {
            res[i] = this.getPluginDetails(plugin_ids[i]);
            ++i;
        }
        return res;
    }

    @Override
    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
    }

    @Override
    public void reportAmountComplete(ResourceDownloader downloader, long amount) {
    }

    @Override
    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.informListeners(activity);
    }

    @Override
    public boolean completed(ResourceDownloader downloader, InputStream data) {
        return true;
    }

    @Override
    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.informListeners("Error: " + e.getMessage());
    }

    protected void informListeners(String log) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SFPluginDetailsLoaderListener)this.listeners.get(i)).log(log);
            ++i;
        }
    }

    @Override
    public void reset() {
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            if (now < this.plugin_ids_loaded_at) {
                this.plugin_ids_loaded_at = 0L;
            }
            if (now - this.plugin_ids_loaded_at > 3600000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SFPluginDetailsLoader: resetting values"));
                }
                this.plugin_ids_loaded = false;
                this.plugin_ids = new ArrayList();
                this.plugin_map = new HashMap();
            } else if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "SFPluginDetailsLoader: not resetting, cache still valid"));
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addListener(SFPluginDetailsLoaderListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(SFPluginDetailsLoaderListener l) {
        this.listeners.remove(l);
    }
}

