/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;
import org.gudy.azureus2.update.CorePatchChecker;

public class PluginUpdatePlugin
implements Plugin {
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.update";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.update";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private boolean loader_listener_added;
    private String last_id_info = "";

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Plugin Updater");
        this.log = this.plugin_interface.getLogger().getChannel("Plugin Update");
        this.log.setDiagnostic();
        this.log.setForce(true);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        final PluginConfig plugin_config = this.plugin_interface.getPluginconfig();
        boolean enabled = plugin_config.getPluginBooleanParameter("enable.update", true);
        model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        model.getStatus().setText(enabled ? "Running" : "Optional checks disabled");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(String.valueOf(message) + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(String.valueOf(error.toString()) + "\n");
            }
        });
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addBooleanParameter2("enable.update", "Plugin.pluginupdate.enablecheck", true);
        this.plugin_interface.addEventListener(new PluginEventListener(){

            @Override
            public void handleEvent(PluginEvent ev) {
                if (ev.getType() == 7) {
                    PluginUpdatePlugin.this.plugin_interface.removeEventListener(this);
                    PluginUpdatePlugin.this.initComplete(plugin_config);
                }
            }
        });
    }

    protected void initComplete(final PluginConfig plugin_config) {
        UpdateManager update_manager = this.plugin_interface.getUpdateManager();
        update_manager.addListener(new UpdateManagerListener(){

            @Override
            public void checkInstanceCreated(UpdateCheckInstance inst) {
                SFPluginDetailsLoaderFactory.getSingleton().reset();
            }
        });
        final PluginManager plugin_manager = this.plugin_interface.getPluginManager();
        PluginInterface[] plugins = plugin_manager.getPlugins();
        int mandatory_count = 0;
        int non_mandatory_count = 0;
        int i = 0;
        while (i < plugins.length) {
            PluginInterface pi = plugins[i];
            boolean pi_mandatory = pi.getPluginState().isMandatory();
            if (pi_mandatory) {
                ++mandatory_count;
            } else {
                ++non_mandatory_count;
            }
            ++i;
        }
        final int f_non_mandatory_count = non_mandatory_count;
        final int f_mandatory_count = mandatory_count;
        update_manager.registerUpdatableComponent(new UpdatableComponent(){

            @Override
            public String getName() {
                return "Non-mandatory plugins";
            }

            @Override
            public int getMaximumCheckTime() {
                return f_non_mandatory_count * 30;
            }

            @Override
            public void checkForUpdate(UpdateChecker checker) {
                if (PluginUpdatePlugin.this.checkForUpdateSupport(checker, null, false) == 0) {
                    VersionCheckClient vc = VersionCheckClient.getSingleton();
                    String[] rps = vc.getRecommendedPlugins();
                    boolean found_one = false;
                    int i = 0;
                    while (i < rps.length) {
                        String rp_id = rps[i];
                        if (plugin_manager.getPluginInterfaceByID(rp_id, false) == null) {
                            final String config_key = "recommended.processed." + rp_id;
                            if (!plugin_config.getPluginBooleanParameter(config_key, false)) {
                                try {
                                    final PluginInstaller installer = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                    StandardPlugin[] sps = installer.getStandardPlugins();
                                    int j = 0;
                                    while (j < sps.length) {
                                        final StandardPlugin sp = sps[j];
                                        if (sp.getId().equals(rp_id)) {
                                            found_one = true;
                                            checker.getCheckInstance().addListener(new UpdateCheckInstanceListener(){

                                                @Override
                                                public void cancelled(UpdateCheckInstance instance) {
                                                }

                                                @Override
                                                public void complete(UpdateCheckInstance instance) {
                                                    if (instance.getUpdates().length == 0) {
                                                        PluginUpdatePlugin.this.installRecommendedPlugin(installer, sp);
                                                        plugin_config.setPluginParameter(config_key, true);
                                                    }
                                                }
                                            });
                                            break;
                                        }
                                        ++j;
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            if (found_one) break;
                        }
                        ++i;
                    }
                    if (!found_one) {
                        Set<String> auto_install = vc.getAutoInstallPluginIDs();
                        final ArrayList<String> to_do = new ArrayList<String>();
                        for (String pid : auto_install) {
                            if (plugin_manager.getPluginInterfaceByID(pid, false) != null) continue;
                            to_do.add(pid);
                        }
                        if (to_do.size() > 0) {
                            new AEThread2("pup:autoinst"){

                                @Override
                                public void run() {
                                    try {
                                        Thread.sleep(120000L);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                        return;
                                    }
                                    UpdateManager update_manager = PluginUpdatePlugin.this.plugin_interface.getUpdateManager();
                                    final ArrayList<UpdateCheckInstance> l_instances = new ArrayList<UpdateCheckInstance>();
                                    update_manager.addListener(new UpdateManagerListener(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void checkInstanceCreated(UpdateCheckInstance instance) {
                                            List list = l_instances;
                                            synchronized (list) {
                                                l_instances.add(instance);
                                            }
                                        }
                                    });
                                    UpdateCheckInstance[] instances = update_manager.getCheckInstances();
                                    l_instances.addAll(Arrays.asList(instances));
                                    long start = SystemTime.getMonotonousTime();
                                    while (SystemTime.getMonotonousTime() - start < 300000L) {
                                        try {
                                            Thread.sleep(5000L);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                            return;
                                        }
                                        if (l_instances.size() <= 0) continue;
                                        boolean all_done = true;
                                        for (UpdateCheckInstance instance : l_instances) {
                                            if (instance.isCompleteOrCancelled()) continue;
                                            all_done = false;
                                            break;
                                        }
                                        if (!all_done) continue;
                                    }
                                    if (update_manager.getInstallers().length > 0) {
                                        return;
                                    }
                                    PluginInstaller installer = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                    ArrayList<StandardPlugin> sps = new ArrayList<StandardPlugin>();
                                    for (String pid : to_do) {
                                        try {
                                            StandardPlugin sp = installer.getStandardPlugin(pid);
                                            if (sp != null) {
                                                PluginUpdatePlugin.this.log.log("Auto-installing " + pid);
                                                sps.add(sp);
                                                continue;
                                            }
                                            PluginUpdatePlugin.this.log.log("Standard plugin '" + pid + "' missing");
                                        }
                                        catch (Throwable e) {
                                            PluginUpdatePlugin.this.log.log("Standard plugin '" + pid + "' missing", e);
                                        }
                                    }
                                    if (sps.size() > 0) {
                                        HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
                                        properties.put(1, 3);
                                        properties.put(3, true);
                                        try {
                                            installer.install(sps.toArray(new InstallablePlugin[sps.size()]), false, properties, new PluginInstallationListener(){

                                                @Override
                                                public void completed() {
                                                }

                                                @Override
                                                public void cancelled() {
                                                }

                                                @Override
                                                public void failed(PluginException e) {
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            PluginUpdatePlugin.this.log.log("Auto install failed", e);
                                        }
                                    }
                                }
                            }.start();
                        }
                    }
                }
            }
        }, false);
        update_manager.registerUpdatableComponent(new UpdatableComponent(){

            @Override
            public String getName() {
                return "Mandatory plugins";
            }

            @Override
            public int getMaximumCheckTime() {
                return f_mandatory_count * 30;
            }

            @Override
            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, null, true);
            }
        }, true);
        update_manager.addListener(new UpdateManagerListener(){

            @Override
            public void checkInstanceCreated(UpdateCheckInstance instance) {
                PluginUpdatePlugin.this.log.log(1, "**** Update check starts ****");
            }
        });
    }

    protected void installRecommendedPlugin(PluginInstaller installer, StandardPlugin plugin) {
        try {
            installer.requestInstall(MessageText.getString("plugin.installer.recommended.plugin"), plugin);
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    public UpdatableComponent getCustomUpdateableComponent(final String id, final boolean mandatory) {
        return new UpdatableComponent(){

            @Override
            public String getName() {
                return "Installation of '" + id + "'";
            }

            @Override
            public int getMaximumCheckTime() {
                return 30;
            }

            @Override
            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, new String[]{id}, mandatory);
            }
        };
    }

    protected int checkForUpdateSupport(UpdateChecker checker, String[] ids_to_check, boolean mandatory) {
        int num_updates_found = 0;
        try {
            if (!mandatory && ids_to_check == null && !this.plugin_interface.getPluginconfig().getPluginBooleanParameter("enable.update", true)) {
                int n = num_updates_found;
                return n;
            }
            try {
                String id;
                PluginInterface[] plugins = this.plugin_interface.getPluginManager().getPlugins();
                ArrayList<PluginInterface> plugins_to_check = new ArrayList<PluginInterface>();
                ArrayList<String> plugins_to_check_ids = new ArrayList<String>();
                HashMap<String, String> plugins_to_check_names = new HashMap<String, String>();
                int i = 0;
                while (i < plugins.length) {
                    block41: {
                        String name;
                        String version;
                        PluginInterface pi;
                        block42: {
                            boolean pi_mandatory;
                            pi = plugins[i];
                            if (pi.getPluginState().isDisabled() && !pi.getPluginState().hasFailed()) break block41;
                            String mand = pi.getPluginProperties().getProperty("plugin.mandatory");
                            boolean bl = pi_mandatory = mand != null && mand.trim().toLowerCase().equals("true");
                            if (pi_mandatory != mandatory) break block41;
                            id = pi.getPluginID();
                            version = pi.getPluginVersion();
                            name = pi.getPluginName();
                            if (ids_to_check == null) break block42;
                            boolean id_selected = false;
                            int j = 0;
                            while (j < ids_to_check.length) {
                                if (ids_to_check[j].equals(id)) {
                                    id_selected = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!id_selected) break block41;
                        }
                        if (version != null) {
                            if (plugins_to_check_ids.contains(id)) {
                                String s = (String)plugins_to_check_names.get(id);
                                if (!name.equals(id)) {
                                    plugins_to_check_names.put(id, String.valueOf(s) + "," + name);
                                }
                            } else {
                                plugins_to_check_ids.add(id);
                                plugins_to_check.add(pi);
                                plugins_to_check_names.put(id, name.equals(id) ? "" : name);
                            }
                        }
                        String location = pi.getPluginDirectoryName();
                        this.log.log(1, String.valueOf(mandatory ? "*" : "-") + pi.getPluginName() + ", id = " + id + (version == null ? "" : ", version = " + pi.getPluginVersion()) + (location == null ? "" : ", loc = " + location));
                    }
                    ++i;
                }
                SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
                if (!this.loader_listener_added) {
                    this.loader_listener_added = true;
                    loader.addListener(new SFPluginDetailsLoaderListener(){

                        @Override
                        public void log(String str) {
                            PluginUpdatePlugin.this.log.log(1, "[" + str + "]");
                        }
                    });
                }
                String[] ids = loader.getPluginIDs();
                String id_info = "";
                int i2 = 0;
                while (i2 < ids.length) {
                    id = ids[i2];
                    SFPluginDetails details = loader.getPluginDetails(id);
                    id_info = String.valueOf(id_info) + (i2 == 0 ? "" : ",") + ids[i2] + "=" + details.getVersion() + "/" + details.getCVSVersion();
                    ++i2;
                }
                if (!id_info.equals(this.last_id_info)) {
                    this.last_id_info = id_info;
                    this.log.log(1, "Downloaded plugin info = " + id_info);
                }
                i2 = 0;
                while (i2 < plugins_to_check.size()) {
                    if (checker.getCheckInstance().isCancelled()) {
                        throw new Exception("Update check cancelled");
                    }
                    PluginInterface pi_being_checked = (PluginInterface)plugins_to_check.get(i2);
                    String plugin_id = pi_being_checked.getPluginID();
                    boolean found = false;
                    int j = 0;
                    while (j < ids.length) {
                        if (ids[j].equalsIgnoreCase(plugin_id)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        if (!pi_being_checked.getPluginState().isBuiltIn()) {
                            this.log.log(1, "Skipping " + plugin_id + " as not listed on web site");
                        }
                    } else {
                        String plugin_names = (String)plugins_to_check_names.get(plugin_id);
                        this.log.log(1, "Checking " + plugin_id);
                        try {
                            String sf_cvs_version;
                            String sf_plugin_version;
                            checker.reportProgress("Loading details for " + plugin_id + "/" + pi_being_checked.getPluginName());
                            SFPluginDetails details = loader.getPluginDetails(plugin_id);
                            if (plugin_names.length() == 0) {
                                plugin_names = details.getName();
                            }
                            boolean az_cvs = this.plugin_interface.getUtilities().isCVSVersion();
                            String pi_version_info = pi_being_checked.getPluginProperties().getProperty("plugin.version.info");
                            String az_plugin_version = pi_being_checked.getPluginVersion();
                            String sf_comp_version = sf_plugin_version = details.getVersion();
                            if (az_cvs && (sf_cvs_version = details.getCVSVersion()).length() > 0) {
                                sf_plugin_version = sf_cvs_version;
                                sf_comp_version = sf_plugin_version.substring(0, sf_plugin_version.length() - 4);
                            }
                            if (sf_comp_version.length() == 0 || !Character.isDigit(sf_comp_version.charAt(0))) {
                                this.log.log(1, "Skipping " + plugin_id + " as no valid version to check");
                            } else {
                                int comp2 = PluginUtils.comparePluginVersions(az_plugin_version, sf_comp_version);
                                this.log.log(1, "    Current: " + az_plugin_version + (comp2 == 0 && sf_plugin_version.endsWith("_CVS") ? "_CVS" : "") + ", Latest: " + sf_plugin_version + (pi_version_info == null ? "" : " [" + pi_version_info + "]"));
                                checker.reportProgress("    current=" + az_plugin_version + (comp2 == 0 && sf_plugin_version.endsWith("_CVS") ? "_CVS" : "") + ", latest=" + sf_plugin_version);
                                if (comp2 < 0 && !(pi_being_checked.getPlugin() instanceof UpdatableComponent)) {
                                    String sf_cvs_version2;
                                    String sf_plugin_download = details.getDownloadURL();
                                    if (az_cvs && (sf_cvs_version2 = details.getCVSVersion()).length() > 0) {
                                        sf_plugin_download = details.getCVSDownloadURL();
                                    }
                                    this.log.log(1, "    Description:");
                                    ArrayList update_desc = new ArrayList();
                                    List desc_lines = HTMLUtils.convertHTMLToText("", details.getDescription());
                                    this.logMultiLine("        ", desc_lines);
                                    update_desc.addAll(desc_lines);
                                    this.log.log(1, "    Comment:");
                                    List comment_lines = HTMLUtils.convertHTMLToText("    ", details.getComment());
                                    this.logMultiLine("    ", comment_lines);
                                    update_desc.addAll(comment_lines);
                                    String msg = "A newer version (version " + sf_plugin_version + ") of plugin '" + plugin_id + "' " + (plugin_names.length() == 0 ? "" : "(" + plugin_names + ") ") + "is available. ";
                                    this.log.log(1, "");
                                    this.log.log(1, "        " + msg + "Download from " + sf_plugin_download);
                                    ResourceDownloaderFactory rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                                    ResourceDownloader direct_rdl = rdf.create(new URL(sf_plugin_download));
                                    ResourceDownloader direct_ap_rdl = rdf.createWithAutoPluginProxy(new URL(sf_plugin_download));
                                    String torrent_download = "http://cf1.vuze.com/torrent/torrents/";
                                    int slash_pos = sf_plugin_download.lastIndexOf("/");
                                    torrent_download = slash_pos == -1 ? String.valueOf(torrent_download) + sf_plugin_download : String.valueOf(torrent_download) + sf_plugin_download.substring(slash_pos + 1);
                                    torrent_download = String.valueOf(torrent_download) + ".torrent";
                                    ResourceDownloader torrent_rdl = rdf.create(new URL(torrent_download));
                                    torrent_rdl = rdf.getSuffixBasedDownloader(torrent_rdl);
                                    ResourceDownloader alternate_rdl = rdf.getAlternateDownloader(new ResourceDownloader[]{torrent_rdl, direct_rdl, direct_ap_rdl});
                                    rdf.getTimeoutDownloader(rdf.getRetryDownloader(alternate_rdl, 3), 10000).getSize();
                                    String[] update_d = new String[update_desc.size()];
                                    update_desc.toArray(update_d);
                                    ++num_updates_found;
                                    boolean plugin_unloadable = true;
                                    int j2 = 0;
                                    while (j2 < plugins.length) {
                                        PluginInterface pi = plugins[j2];
                                        if (pi.getPluginID().equals(plugin_id)) {
                                            plugin_unloadable &= pi.getPluginState().isUnloadable();
                                        }
                                        ++j2;
                                    }
                                    if (plugin_unloadable) {
                                        checker.reportProgress("Plugin is unloadable");
                                    }
                                    Update update = this.addUpdate(pi_being_checked, checker, String.valueOf(plugin_id) + "/" + plugin_names, update_d, az_plugin_version, sf_plugin_version, alternate_rdl, sf_plugin_download.toLowerCase().endsWith(".jar"), plugin_unloadable ? 1 : 2, true);
                                    update.setRelativeURLBase(details.getRelativeURLBase());
                                    update.setDescriptionURL(details.getInfoURL());
                                }
                            }
                        }
                        catch (Throwable e) {
                            checker.reportProgress("Failed to load details for plugin '" + plugin_id + "': " + Debug.getNestedExceptionMessage(e));
                            this.log.log("    Plugin check failed", e);
                        }
                    }
                    ++i2;
                }
            }
            catch (Throwable e) {
                if (!"Update check cancelled".equals(e.getMessage())) {
                    this.log.log("Failed to load plugin details", e);
                }
                checker.reportProgress("Failed to load plugin details: " + Debug.getNestedExceptionMessage(e));
                checker.failed();
            }
        }
        finally {
            checker.completed();
        }
        return num_updates_found;
    }

    public Update addUpdate(final PluginInterface pi_for_update, final UpdateChecker checker, String update_name, String[] update_details, final String old_version, final String new_version, ResourceDownloader resource_downloader, final boolean is_jar, final int restart_type, final boolean verify) {
        final Update update = checker.addUpdate(update_name, update_details, old_version, new_version, resource_downloader, restart_type);
        update.setUserObject(pi_for_update);
        resource_downloader.addListener(new ResourceDownloaderAdapter(){

            @Override
            public boolean completed(final ResourceDownloader downloader, InputStream data) {
                LoggerChannelListener list = new LoggerChannelListener(){

                    @Override
                    public void messageLogged(int type, String content2) {
                        downloader.reportActivity(content2);
                    }

                    @Override
                    public void messageLogged(String str, Throwable error) {
                        downloader.reportActivity(str);
                    }
                };
                try {
                    PluginUpdatePlugin.this.log.addListener(list);
                    PluginUpdatePlugin.this.installUpdate(checker, update, pi_for_update, restart_type == 1, is_jar, old_version, new_version, data, verify);
                    return true;
                }
                finally {
                    PluginUpdatePlugin.this.log.removeListener(list);
                }
            }

            @Override
            public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                if (!downloader.isCancelled()) {
                    Debug.out(String.valueOf(downloader.getName()) + " failed", e);
                }
                update.complete(false);
            }
        });
        return update;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installUpdate(UpdateChecker checker, Update update, PluginInterface plugin, boolean unloadable, boolean is_jar, String old_version, String new_version, InputStream data, boolean verify) {
        this.log.log(1, "Installing plugin '" + update.getName() + "', version " + new_version);
        String target_version = new_version.endsWith("_CVS") ? new_version.substring(0, new_version.length() - 4) : new_version;
        UpdateInstaller installer = null;
        boolean update_successful = false;
        try {
            try {
                data = update.verifyData(data, verify);
                this.log.log("    Data verification stage complete");
                boolean update_txt_found = false;
                String plugin_dir_name = plugin.getPluginDirectoryName();
                if (plugin_dir_name == null || plugin_dir_name.length() == 0) {
                    this.log.log(1, "    This is a built-in plugin, updating core");
                    CorePatchChecker.patchAzureus2(update.getCheckInstance(), data, String.valueOf(plugin.getPluginID()) + "_" + new_version, this.log);
                    update.setRestartRequired(2);
                } else {
                    File target_prog_dir;
                    File target_user_dir;
                    File target_plugin_dir;
                    File plugin_dir = new File(plugin_dir_name);
                    File user_dir = new File(this.plugin_interface.getUtilities().getAzureusUserDir());
                    File prog_dir = new File(this.plugin_interface.getUtilities().getAzureusProgramDir());
                    HashMap<String, List<String[]>> install_properties = new HashMap<String, List<String[]>>();
                    boolean force_indirect_install = false;
                    if (Constants.isWindowsVistaOrHigher) {
                        File test_file = new File(plugin_dir, "_aztest45.dll");
                        boolean ok = false;
                        try {
                            if (test_file.exists()) {
                                test_file.delete();
                            }
                            FileOutputStream os = new FileOutputStream(test_file);
                            try {
                                os.write(32);
                            }
                            finally {
                                os.close();
                            }
                            ok = test_file.delete();
                        }
                        catch (Throwable os) {
                            // empty catch block
                        }
                        if (!ok) {
                            this.log.log("Can't write directly to the plugin directroy, installing indirectly");
                            force_indirect_install = true;
                        }
                    }
                    if (force_indirect_install) {
                        File temp_dir = AETemporaryFileHandler.createTempDir();
                        target_plugin_dir = new File(temp_dir, "plugin");
                        target_user_dir = new File(temp_dir, "user");
                        target_prog_dir = new File(temp_dir, "prog");
                        target_plugin_dir.mkdirs();
                        target_user_dir.mkdirs();
                        target_prog_dir.mkdirs();
                        installer = update.getCheckInstance().createInstaller();
                        update.setRestartRequired(2);
                    } else {
                        target_plugin_dir = plugin_dir;
                        target_user_dir = user_dir;
                        target_prog_dir = prog_dir;
                    }
                    File target_jar_zip = new File(target_plugin_dir, String.valueOf(plugin.getPluginID()) + "_" + target_version + (is_jar ? ".jar" : ".zip"));
                    FileUtil.copyFile(data, new FileOutputStream(target_jar_zip));
                    if (!is_jar) {
                        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(target_jar_zip)));
                        String common_prefix = null;
                        String selected_platform = null;
                        ArrayList<String> selected_sub_platforms = new ArrayList<String>();
                        try {
                            ZipEntry entry;
                            block47: while ((entry = zis.getNextEntry()) != null) {
                                int len;
                                String name = entry.getName();
                                if (name.equals("plugin_install.properties")) {
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
                                    byte[] buffer = new byte[65536];
                                    while (true) {
                                        int len2;
                                        if ((len2 = zis.read(buffer)) <= 0) {
                                            try {
                                                String line;
                                                LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), "UTF-8"));
                                                while ((line = lnr.readLine()) != null) {
                                                    if ((line = line.trim()).endsWith("defer_install")) {
                                                        force_indirect_install = true;
                                                        continue;
                                                    }
                                                    String[] command = line.split(",");
                                                    if (command.length <= 1) continue;
                                                    ArrayList<String[]> commands = (ArrayList<String[]>)install_properties.get(command[0]);
                                                    if (commands == null) {
                                                        commands = new ArrayList<String[]>();
                                                        install_properties.put(command[0], commands);
                                                    }
                                                    commands.add(command);
                                                }
                                                continue block47;
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                                continue block47;
                                            }
                                        }
                                        baos.write(buffer, 0, len2);
                                    }
                                }
                                if (!name.equals("azureus.sig") && !name.endsWith("/")) {
                                    int plat_end_pos;
                                    if (common_prefix == null) {
                                        common_prefix = name;
                                    } else {
                                        int len3 = 0;
                                        int i = 0;
                                        while (i < Math.min(common_prefix.length(), name.length()) && common_prefix.charAt(i) == name.charAt(i)) {
                                            ++len3;
                                            ++i;
                                        }
                                        common_prefix = common_prefix.substring(0, len3);
                                    }
                                    int plat_pos = name.indexOf("platform/");
                                    if (plat_pos != -1 && (plat_end_pos = name.indexOf("/", plat_pos += 9)) != -1) {
                                        String platform = name.substring(plat_pos, plat_end_pos);
                                        String sub_platform = null;
                                        int sub_plat_pos = platform.indexOf("_");
                                        if (sub_plat_pos != -1) {
                                            sub_platform = platform.substring(sub_plat_pos + 1);
                                            platform = platform.substring(0, sub_plat_pos);
                                        }
                                        if (Constants.isWindows && platform.equalsIgnoreCase("windows") || Constants.isLinux && platform.equalsIgnoreCase("linux") || Constants.isUnix && platform.equalsIgnoreCase("unix") || Constants.isFreeBSD && platform.equalsIgnoreCase("freebsd") || Constants.isSolaris && platform.equalsIgnoreCase("solaris") || Constants.isOSX && platform.equalsIgnoreCase("osx")) {
                                            selected_platform = platform;
                                            if (sub_platform != null && !selected_sub_platforms.contains(sub_platform)) {
                                                selected_sub_platforms.add(sub_platform);
                                            }
                                        }
                                    }
                                }
                                byte[] buffer = new byte[65536];
                                while ((len = zis.read(buffer)) > 0) {
                                }
                            }
                        }
                        finally {
                            zis.close();
                        }
                        if (selected_platform != null) {
                            String[] options = new String[selected_sub_platforms.size()];
                            selected_sub_platforms.toArray(options);
                            if (options.length == 1) {
                                selected_platform = String.valueOf(selected_platform) + "_" + options[0];
                                this.log.log(1, "platform is '" + selected_platform + "'");
                            } else if (options.length > 1) {
                                String selected_sub_platform = (String)update.getDecision(0, "Select Platform", "Multiple platform options exist for this plugin, please select required one", options);
                                if (selected_sub_platform == null) {
                                    throw new Exception("Valid sub-platform selection not selected");
                                }
                                selected_platform = String.valueOf(selected_platform) + "_" + selected_sub_platform;
                                this.log.log(1, "platform is '" + selected_platform + "'");
                            }
                        }
                        if (common_prefix != null) {
                            int pos = common_prefix.lastIndexOf("/");
                            common_prefix = pos == -1 ? "" : common_prefix.substring(0, pos + 1);
                            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(target_jar_zip)));
                            try {
                                ZipEntry entry;
                                while ((entry = zis.getNextEntry()) != null) {
                                    String name = entry.getName();
                                    OutputStream entry_os = null;
                                    File origin = null;
                                    File initial_target = null;
                                    File final_target = null;
                                    boolean is_plugin_properties = false;
                                    try {
                                        int len;
                                        if (name.length() >= common_prefix.length() && !name.equals("azureus.sig") && !name.endsWith("/")) {
                                            File install_root;
                                            File origin_root;
                                            boolean skip_file = false;
                                            String file_name = entry.getName().substring(common_prefix.length());
                                            if (selected_platform != null && file_name.contains("platform/")) {
                                                String bit_to_remove = "platform/" + selected_platform;
                                                int pp = file_name.indexOf(bit_to_remove);
                                                if (pp != -1) {
                                                    file_name = String.valueOf(file_name.substring(0, pp)) + file_name.substring(pp + bit_to_remove.length() + 1);
                                                } else {
                                                    skip_file = true;
                                                }
                                            }
                                            if (file_name.startsWith("shared/lib")) {
                                                update.setRestartRequired(2);
                                                unloadable = false;
                                                if (plugin.getPluginState().isShared()) {
                                                    origin_root = prog_dir;
                                                    install_root = target_prog_dir;
                                                } else {
                                                    origin_root = user_dir;
                                                    install_root = target_user_dir;
                                                }
                                            } else {
                                                origin_root = plugin_dir;
                                                install_root = target_plugin_dir;
                                            }
                                            origin = new File(origin_root, file_name);
                                            final_target = initial_target = new File(install_root, file_name);
                                            if (origin.exists()) {
                                                if (file_name.indexOf(47) == -1 && (file_name.toLowerCase(MessageText.LOCALE_ENGLISH).endsWith(".properties") || file_name.toLowerCase(MessageText.LOCALE_ENGLISH).endsWith(".config"))) {
                                                    is_plugin_properties = file_name.toLowerCase(MessageText.LOCALE_ENGLISH).equals("plugin.properties");
                                                    String old_file_name = file_name;
                                                    file_name = String.valueOf(file_name) + "_" + target_version;
                                                    final_target = new File(install_root, file_name);
                                                    this.log.log(1, "saving new file '" + old_file_name + "'as '" + file_name + "'");
                                                } else if (this.isVersioned(file_name)) {
                                                    this.log.log(1, "Version '" + file_name + "' already present, skipping");
                                                    skip_file = true;
                                                } else {
                                                    this.log.log(1, "overwriting '" + file_name + "'");
                                                    File backup = new File(origin.getParentFile(), String.valueOf(origin.getName()) + ".bak");
                                                    if (force_indirect_install) {
                                                        if (backup.exists()) {
                                                            installer.addRemoveAction(backup.getAbsolutePath());
                                                        }
                                                        installer.addMoveAction(origin.getAbsolutePath(), backup.getAbsolutePath());
                                                    } else {
                                                        if (backup.exists()) {
                                                            backup.delete();
                                                        }
                                                        if (!initial_target.renameTo(backup)) {
                                                            this.log.log(1, "    failed to backup '" + file_name + "', deferring until restart");
                                                            if (installer == null) {
                                                                update.setRestartRequired(2);
                                                                installer = update.getCheckInstance().createInstaller();
                                                            }
                                                            File tmp = new File(initial_target.getParentFile(), String.valueOf(initial_target.getName()) + ".tmp");
                                                            tmp.delete();
                                                            installer.addMoveAction(tmp.getAbsolutePath(), initial_target.getAbsolutePath());
                                                            final_target = tmp;
                                                        }
                                                    }
                                                }
                                            }
                                            if (!skip_file) {
                                                FileUtil.mkdirs(final_target.getParentFile());
                                                entry_os = new FileOutputStream(final_target);
                                            }
                                        }
                                        byte[] buffer = new byte[65536];
                                        while ((len = zis.read(buffer)) > 0) {
                                            if (entry_os == null) continue;
                                            entry_os.write(buffer, 0, len);
                                        }
                                    }
                                    finally {
                                        if (entry_os != null) {
                                            entry_os.close();
                                        }
                                    }
                                    if (is_plugin_properties) {
                                        File tmp_file;
                                        Properties old_props = new Properties();
                                        Properties new_props = new Properties();
                                        ArrayList<String> props_to_delete = new ArrayList<String>();
                                        HashMap<String, String> props_to_replace = new HashMap<String, String>();
                                        HashMap<String, String> props_to_insert = new HashMap<String, String>();
                                        try {
                                            FileInputStream fis;
                                            block150: {
                                                fis = new FileInputStream(origin);
                                                try {
                                                    try {
                                                        old_props.load(fis);
                                                    }
                                                    catch (Throwable throwable) {
                                                        fis.close();
                                                        break block150;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    fis.close();
                                                    throw throwable;
                                                }
                                                fis.close();
                                            }
                                            fis = new FileInputStream(final_target);
                                            try {
                                                try {
                                                    new_props.load(fis);
                                                }
                                                finally {
                                                    fis.close();
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                fis.close();
                                                throw throwable;
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                        new_props.put("plugin.version", target_version);
                                        String[] prop_names = new String[]{"plugin.name", "plugin.names", "plugin.class", "plugin.classes", "plugin.version", "plugin.langfile"};
                                        int z = 0;
                                        while (true) {
                                            if (z >= prop_names.length) {
                                                tmp_file = force_indirect_install ? initial_target : new File(initial_target.getParentFile(), String.valueOf(initial_target.getName()) + ".tmp");
                                            }
                                            String prop_name = prop_names[z];
                                            String old_name = old_props.getProperty(prop_name);
                                            String new_name = new_props.getProperty(prop_name);
                                            if (new_name != null) {
                                                if (prop_name.equals("plugin.name")) {
                                                    props_to_delete.add("plugin.names");
                                                } else if (prop_name.equals("plugin.names")) {
                                                    props_to_delete.add("plugin.name");
                                                } else if (prop_name.equals("plugin.class")) {
                                                    props_to_delete.add("plugin.classes");
                                                } else if (prop_name.equals("plugin.classes")) {
                                                    props_to_delete.add("plugin.class");
                                                }
                                                if (old_name == null) {
                                                    props_to_insert.put(prop_name, new_name);
                                                } else if (!new_name.equals(old_name)) {
                                                    props_to_replace.put(prop_name, new_name);
                                                }
                                            }
                                            ++z;
                                        }
                                        BufferedReader lnr = null;
                                        PrintWriter tmp = null;
                                        try {
                                            String line;
                                            lnr = new LineNumberReader(new FileReader(origin));
                                            tmp = new PrintWriter(new FileWriter(tmp_file));
                                            for (String pn : props_to_insert.keySet()) {
                                                String pv = (String)props_to_insert.get(pn);
                                                this.log.log("    Inserting property:" + pn + "=" + pv);
                                                tmp.println(String.valueOf(pn) + "=" + pv);
                                            }
                                            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                                                int ep = line.indexOf(61);
                                                if (ep != -1) {
                                                    String pn = line.substring(0, ep).trim();
                                                    if (props_to_delete.contains(pn)) {
                                                        this.log.log("    Deleting property:" + pn);
                                                        continue;
                                                    }
                                                    String rv = (String)props_to_replace.get(pn);
                                                    if (rv != null) {
                                                        this.log.log("    Replacing property:" + pn + " with " + rv);
                                                        tmp.println(String.valueOf(pn) + "=" + rv);
                                                        continue;
                                                    }
                                                    tmp.println(line);
                                                    continue;
                                                }
                                                tmp.println(line);
                                            }
                                        }
                                        finally {
                                            lnr.close();
                                            if (tmp != null) {
                                                tmp.close();
                                            }
                                        }
                                        File bak_file = new File(origin.getParentFile(), String.valueOf(origin.getName()) + ".bak");
                                        if (force_indirect_install) {
                                            if (bak_file.exists()) {
                                                installer.addRemoveAction(bak_file.getAbsolutePath());
                                            }
                                            installer.addMoveAction(origin.getAbsolutePath(), bak_file.getAbsolutePath());
                                            continue;
                                        }
                                        if (bak_file.exists()) {
                                            bak_file.delete();
                                        }
                                        if (!initial_target.renameTo(bak_file)) {
                                            throw new IOException("Failed to rename '" + initial_target.toString() + "' to '" + bak_file.toString() + "'");
                                        }
                                        if (!tmp_file.renameTo(initial_target)) {
                                            bak_file.renameTo(initial_target);
                                            throw new IOException("Failed to rename '" + tmp_file.toString() + "' to '" + initial_target.toString() + "'");
                                        }
                                        bak_file.delete();
                                        continue;
                                    }
                                    if (final_target == null || !final_target.getName().equalsIgnoreCase("update.txt")) continue;
                                    update_txt_found = true;
                                    BufferedReader lnr = null;
                                    try {
                                        try {
                                            String line;
                                            lnr = new LineNumberReader(new FileReader(final_target));
                                            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                                                this.log.log(1, line);
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            if (lnr == null) continue;
                                            lnr.close();
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (lnr == null) throw throwable;
                                        lnr.close();
                                        throw throwable;
                                    }
                                    if (lnr == null) continue;
                                    lnr.close();
                                }
                            }
                            finally {
                                zis.close();
                            }
                        }
                    }
                    if (unloadable) {
                        String plugin_id = plugin.getPluginID();
                        PluginInterface[] plugins = plugin.getPluginManager().getPlugins();
                        boolean plugin_unloadable = true;
                        int j = 0;
                        while (true) {
                            if (j >= plugins.length) {
                                if (plugin_unloadable) break;
                                this.log.log("Switching unloadability for " + plugin_id + " as changed during update");
                                update.setRestartRequired(2);
                                unloadable = false;
                                break;
                            }
                            PluginInterface pi = plugins[j];
                            if (pi.getPluginID().equals(plugin_id)) {
                                plugin_unloadable &= pi.getPluginState().isUnloadable();
                            }
                            ++j;
                        }
                    }
                    if (force_indirect_install) {
                        boolean defer_restart = false;
                        if (this.addInstallationActions(installer, install_properties, "%plugin%", target_plugin_dir, plugin_dir)) {
                            defer_restart = true;
                        }
                        if (this.addInstallationActions(installer, install_properties, "%app%", target_prog_dir, prog_dir)) {
                            defer_restart = true;
                        }
                        if (this.addInstallationActions(installer, install_properties, "%user%", target_user_dir, user_dir)) {
                            defer_restart = true;
                        }
                        if (defer_restart && update.getRestartRequired() == 2) {
                            this.log.log("Deferring restart for '" + plugin.getPluginID() + "'");
                            update.setRestartRequired(1);
                        }
                    } else {
                        boolean defer_restart = false;
                        if (this.applyInstallProperties(install_properties, "%plugin%", plugin_dir)) {
                            defer_restart = true;
                        }
                        if (this.applyInstallProperties(install_properties, "%app%", prog_dir)) {
                            defer_restart = true;
                        }
                        if (this.applyInstallProperties(install_properties, "%user%", user_dir)) {
                            defer_restart = true;
                        }
                        if (unloadable) {
                            this.log.log("Plugin initialising, please wait... ");
                            plugin.getPluginState().reload();
                            this.log.log("... initialisation complete.");
                        } else if (defer_restart && update.getRestartRequired() == 2) {
                            this.log.log("Deferring restart for '" + plugin.getPluginID() + "'");
                            update.setRestartRequired(1);
                        }
                    }
                }
                Boolean b_disable = (Boolean)update.getCheckInstance().getProperty(3);
                if (update_txt_found || b_disable == null || !b_disable.booleanValue()) {
                    String msg = MessageText.getString("plugin.update.ok", new String[]{new_version, update.getName()});
                    if (update_txt_found) {
                        msg = String.valueOf(msg) + " - " + MessageText.getString("plugin.update.ok.msg");
                    }
                    this.log.logAlertRepeatable(update_txt_found ? 2 : 1, msg);
                }
                try {
                    String plugin_id = plugin.getPluginID();
                    PluginInitializer.fireEvent(checker.getCheckInstance().getType() == 1 ? 10 : 11, plugin_id);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                update_successful = true;
                return;
            }
            catch (Throwable e) {
                String msg = MessageText.getString("plugin.update.fail", new String[]{new_version, update.getName(), e.getMessage()});
                this.log.logAlertRepeatable(3, msg);
                update.complete(update_successful);
                if (data == null) return;
                try {
                    data.close();
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }
        finally {
            update.complete(update_successful);
            if (data != null) {
                try {
                    data.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected boolean addInstallationActions(UpdateInstaller installer, Map<String, List<String[]>> install_properties, String prefix, File from_file, File to_file) throws UpdateException {
        boolean defer_restart;
        block7: {
            block6: {
                defer_restart = false;
                if (!from_file.isDirectory()) break block6;
                File[] files = from_file.listFiles();
                if (files == null) break block7;
                int i = 0;
                while (i < files.length) {
                    if (this.addInstallationActions(installer, install_properties, String.valueOf(prefix) + "/" + files[i].getName(), files[i], new File(to_file, files[i].getName()))) {
                        defer_restart = true;
                    }
                    ++i;
                }
                break block7;
            }
            installer.addMoveAction(from_file.getAbsolutePath(), to_file.getAbsolutePath());
            List<String[]> commands = install_properties.get(prefix);
            if (commands != null) {
                for (String[] command : commands) {
                    String cmd = command[1];
                    if (cmd.equals("chmod")) {
                        if (Constants.isWindows) continue;
                        this.log.log("Applying " + cmd + " " + command[2] + " to " + to_file);
                        installer.addChangeRightsAction(command[2], to_file.getAbsolutePath());
                        continue;
                    }
                    if (cmd.equals("rm")) {
                        this.log.log("Deleting " + to_file);
                        installer.addRemoveAction(to_file.getAbsolutePath());
                        continue;
                    }
                    if (!cmd.equals("defer_restart")) continue;
                    defer_restart = true;
                }
            }
        }
        return defer_restart;
    }

    protected boolean applyInstallProperties(Map<String, List<String[]>> install_properties, String prefix, File to_file) {
        boolean defer_restart;
        block9: {
            block8: {
                defer_restart = false;
                if (!to_file.isDirectory()) break block8;
                File[] files = to_file.listFiles();
                if (files == null) break block9;
                int i = 0;
                while (i < files.length) {
                    File file = files[i];
                    String file_name = file.getName();
                    if (!file_name.equals(".") && !file_name.equals("..")) {
                        String new_prefix = String.valueOf(prefix) + "/" + file_name;
                        boolean match = false;
                        for (String s : install_properties.keySet()) {
                            if (!s.startsWith(new_prefix)) continue;
                            match = true;
                            break;
                        }
                        if (match && this.applyInstallProperties(install_properties, new_prefix, files[i])) {
                            defer_restart = true;
                        }
                    }
                    ++i;
                }
                break block9;
            }
            List<String[]> commands = install_properties.get(prefix);
            if (commands != null) {
                for (String[] command : commands) {
                    String cmd = command[1];
                    if (cmd.equals("chmod")) {
                        if (Constants.isWindows) continue;
                        this.runCommand(new String[]{"chmod", command[2], to_file.getAbsolutePath().replaceAll(" ", "\\ ")});
                        continue;
                    }
                    if (cmd.equals("rm")) {
                        this.log.log("Deleting " + to_file);
                        to_file.delete();
                        continue;
                    }
                    if (!cmd.equals("defer_restart")) continue;
                    defer_restart = true;
                }
            }
        }
        return defer_restart;
    }

    private void runCommand(String[] command) {
        try {
            command[0] = this.findCommand(command[0]);
            String str = "";
            String[] stringArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                str = String.valueOf(str) + " " + s;
                ++n2;
            }
            this.log.log("Executing" + str);
            Runtime.getRuntime().exec(command).waitFor();
        }
        catch (Throwable e) {
            this.log.log("Failed to execute command", e);
        }
    }

    private String findCommand(String name) {
        String[] locations;
        String[] stringArray = locations = new String[]{"/bin", "/usr/bin"};
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            File f = new File(s, name);
            if (f.exists() && f.canRead()) {
                return f.getAbsolutePath();
            }
            ++n2;
        }
        return name;
    }

    protected boolean isVersioned(String name) {
        int pos = name.lastIndexOf(95);
        if (pos == -1 || name.endsWith("_")) {
            return false;
        }
        String rem = name.substring(pos + 1);
        if ((pos = rem.lastIndexOf(46)) != -1) {
            rem = rem.substring(0, pos);
        }
        int i = 0;
        while (i < rem.length()) {
            char c = rem.charAt(i);
            if (c != '.' && !Character.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void logMultiLine(String indent, List lines) {
        int i = 0;
        while (i < lines.size()) {
            this.log.log(1, String.valueOf(indent) + (String)lines.get(i));
            ++i;
        }
    }
}

