/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class StringParameterImpl
extends ParameterImpl
implements StringParameter {
    private String defaultValue;
    private int line_count;

    public StringParameterImpl(PluginConfigImpl config, String key, String label, String defaultValue) {
        super(config, key, label);
        config.notifyParamExists(this.getKey());
        COConfigurationManager.setStringDefault(this.getKey(), defaultValue);
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getValue() {
        return this.config.getUnsafeStringParameter(this.getKey(), this.getDefaultValue());
    }

    @Override
    public void setValue(String s) {
        this.config.setUnsafeStringParameter(this.getKey(), s);
    }

    @Override
    public void setMultiLine(int visible_line_count) {
        this.line_count = visible_line_count;
    }

    public int getMultiLine() {
        return this.line_count;
    }
}

