/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.security.MessageDigest;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class PasswordParameterImpl
extends ParameterImpl
implements PasswordParameter {
    protected byte[] defaultValue;
    protected int encoding_type;

    public PasswordParameterImpl(PluginConfigImpl config, String key, String label, int _encoding_type, byte[] _default_value) {
        super(config, key, label);
        this.encoding_type = _encoding_type;
        this.defaultValue = _default_value == null ? new byte[0] : this.encode(_default_value);
        config.notifyParamExists(this.getKey());
        COConfigurationManager.setByteDefault(this.getKey(), this.defaultValue);
    }

    public byte[] getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(String plain_password) {
        byte[] encoded = plain_password == null || plain_password.length() == 0 ? new byte[]{} : this.encode(plain_password);
        this.config.setUnsafeByteParameter(this.getKey(), encoded);
    }

    public int getEncodingType() {
        return this.encoding_type;
    }

    @Override
    public byte[] getValue() {
        return this.config.getUnsafeByteParameter(this.getKey(), this.getDefaultValue());
    }

    protected byte[] encode(String str) {
        try {
            return this.encode(this.encoding_type == 3 ? str.getBytes("UTF-8") : str.getBytes());
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    protected byte[] encode(byte[] bytes) {
        if (this.encoding_type == 2) {
            SHA1Hasher hasher = new SHA1Hasher();
            return hasher.calculateHash(bytes);
        }
        if (this.encoding_type == 3) {
            try {
                return MessageDigest.getInstance("md5").digest(bytes);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return bytes;
    }
}

