/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.config.ConfigParameterListener;
import org.gudy.azureus2.plugins.ui.config.EnablerParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterGroupImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImplListener;

public class ParameterImpl
implements EnablerParameter,
org.gudy.azureus2.core3.config.ParameterListener {
    protected PluginConfigImpl config;
    private String key;
    private String labelKey;
    private String label;
    private int mode = 0;
    private boolean enabled = true;
    private boolean visible = true;
    private boolean generate_intermediate_events = true;
    private List<Parameter> toDisable;
    private List<Parameter> toEnable;
    private List listeners;
    private List<ParameterImplListener> impl_listeners;
    private ParameterGroupImpl parameter_group;

    public ParameterImpl(PluginConfigImpl _config, String _key, String _labelKey) {
        this.config = _config;
        this.key = _key;
        this.labelKey = _labelKey;
        if ("_blank".equals(this.labelKey)) {
            this.labelKey = "!!";
        }
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void addDisabledOnSelection(Parameter parameter) {
        if (this.toDisable == null) {
            this.toDisable = new ArrayList<Parameter>(1);
        }
        if (parameter instanceof ParameterGroupImpl) {
            ParameterImpl[] parameters = ((ParameterGroupImpl)parameter).getParameters();
            Collections.addAll(this.toDisable, parameters);
            return;
        }
        this.toDisable.add(parameter);
    }

    @Override
    public void addEnabledOnSelection(Parameter parameter) {
        if (this.toEnable == null) {
            this.toEnable = new ArrayList<Parameter>(1);
        }
        if (parameter instanceof ParameterGroupImpl) {
            ParameterImpl[] parameters = ((ParameterGroupImpl)parameter).getParameters();
            Collections.addAll(this.toEnable, parameters);
            return;
        }
        this.toEnable.add(parameter);
    }

    public List getDisabledOnSelectionParameters() {
        return this.toDisable == null ? Collections.EMPTY_LIST : this.toDisable;
    }

    public List getEnabledOnSelectionParameters() {
        return this.toEnable == null ? Collections.EMPTY_LIST : this.toEnable;
    }

    @Override
    public void parameterChanged(String key) {
        this.fireParameterChanged();
    }

    protected void fireParameterChanged() {
        if (this.listeners == null) {
            return;
        }
        Object[] listenerArray = this.listeners.toArray();
        int i = 0;
        while (i < listenerArray.length) {
            try {
                Object o = listenerArray[i];
                if (o instanceof ParameterListener) {
                    ((ParameterListener)o).parameterChanged(this);
                } else {
                    ((ConfigParameterListener)o).configParameterChanged(this);
                }
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    @Override
    public void setEnabled(boolean e) {
        this.enabled = e;
        if (this.impl_listeners == null) {
            return;
        }
        Object[] listenersArray = this.impl_listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            try {
                ParameterImplListener l = (ParameterImplListener)listenersArray[i];
                l.enabledChanged(this);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getMinimumRequiredUserMode() {
        return this.mode;
    }

    @Override
    public void setMinimumRequiredUserMode(int _mode) {
        this.mode = _mode;
    }

    @Override
    public void setVisible(boolean _visible) {
        this.visible = _visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setGenerateIntermediateEvents(boolean b) {
        this.generate_intermediate_events = b;
    }

    @Override
    public boolean getGenerateIntermediateEvents() {
        return this.generate_intermediate_events;
    }

    public void setGroup(ParameterGroupImpl _group) {
        this.parameter_group = _group;
    }

    public ParameterGroupImpl getGroup() {
        return this.parameter_group;
    }

    @Override
    public void addListener(ParameterListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(l);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, (org.gudy.azureus2.core3.config.ParameterListener)this);
        }
    }

    @Override
    public void removeListener(ParameterListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    public void addImplListener(ParameterImplListener l) {
        if (this.impl_listeners == null) {
            this.impl_listeners = new ArrayList<ParameterImplListener>(1);
        }
        this.impl_listeners.add(l);
    }

    public void removeImplListener(ParameterImplListener l) {
        if (this.impl_listeners == null) {
            return;
        }
        this.impl_listeners.remove(l);
    }

    @Override
    public void addConfigParameterListener(ConfigParameterListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(l);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, (org.gudy.azureus2.core3.config.ParameterListener)this);
        }
    }

    @Override
    public void removeConfigParameterListener(ConfigParameterListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    @Override
    public String getLabelText() {
        if (this.label == null) {
            this.label = MessageText.getString(this.labelKey);
        }
        return this.label;
    }

    @Override
    public void setLabelText(String sText) {
        this.labelKey = null;
        this.label = sText;
        this.triggerLabelChanged(sText, false);
    }

    @Override
    public String getLabelKey() {
        return this.labelKey;
    }

    @Override
    public void setLabelKey(String sLabelKey) {
        this.labelKey = sLabelKey;
        this.label = null;
        this.triggerLabelChanged(this.labelKey, true);
    }

    @Override
    public String getConfigKeyName() {
        return this.key;
    }

    @Override
    public boolean hasBeenSet() {
        return COConfigurationManager.doesParameterNonDefaultExist(this.key);
    }

    private void triggerLabelChanged(String text, boolean isKey) {
        if (this.impl_listeners == null) {
            return;
        }
        Object[] listenersArray = this.impl_listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            try {
                ParameterImplListener l = (ParameterImplListener)listenersArray[i];
                l.labelChanged(this, text, isKey);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    public void destroy() {
        this.listeners = null;
        this.impl_listeners = null;
        this.toDisable = null;
        this.toEnable = null;
        COConfigurationManager.removeParameterListener(this.key, this);
    }
}

