/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.launch;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.launcher.Launcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.LaunchablePlugin;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.local.launch.PluginSingleInstanceHandler;

public class PluginLauncherImpl {
    private static Map preloaded_plugins = new HashMap();

    private static void main(String[] args) {
        PluginLauncherImpl.launch(args);
    }

    public static void launch(String[] args) {
        if (Launcher.checkAndLaunch(PluginLauncherImpl.class, args)) {
            return;
        }
        COConfigurationManager.preInitialise();
        final LoggerChannelListener listener = new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String content2) {
                this.log(content2, false);
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                this.log(str, true);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                this.log(sw.toString(), true);
            }

            protected synchronized void log(String str, boolean stdout) {
                block10: {
                    File log_file = PluginLauncherImpl.getApplicationFile("launch.log");
                    PrintWriter pw = null;
                    try {
                        try {
                            pw = new PrintWriter(new FileWriter(log_file, true));
                            if (str.endsWith("\n")) {
                                if (stdout) {
                                    System.err.print("PluginLauncher: " + str);
                                }
                                pw.print(str);
                                break block10;
                            }
                            if (stdout) {
                                System.err.println("PluginLauncher: " + str);
                            }
                            pw.println(str);
                        }
                        catch (Throwable throwable) {
                            if (pw != null) {
                                pw.close();
                            }
                        }
                    }
                    finally {
                        if (pw != null) {
                            pw.close();
                        }
                    }
                }
            }
        };
        LaunchablePlugin[] launchables = PluginLauncherImpl.findLaunchablePlugins(listener);
        if (launchables.length == 0) {
            listener.messageLogged(3, "No launchable plugins found");
            return;
        }
        if (launchables.length > 1) {
            listener.messageLogged(3, "Multiple launchable plugins found, running first");
        }
        try {
            SystemProperties.setApplicationEntryPoint("org.gudy.azureus2.plugins.PluginLauncher");
            launchables[0].setDefaults(args);
            if (PluginSingleInstanceHandler.process(listener, args)) {
                return;
            }
            Thread core_thread = new Thread("PluginLauncher"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        AzureusCore azureus_core = AzureusCoreFactory.create();
                        azureus_core.start();
                    }
                    catch (Throwable e) {
                        listener.messageLogged("PluginLauncher: launch fails", e);
                    }
                }
            };
            core_thread.setDaemon(true);
            core_thread.start();
            boolean restart = false;
            boolean process_succeeded = false;
            try {
                restart = launchables[0].process();
                process_succeeded = true;
            }
            finally {
                block16: {
                    try {
                        if (restart) {
                            AzureusCoreFactory.getSingleton().restart();
                        } else {
                            AzureusCoreFactory.getSingleton().stop();
                        }
                    }
                    catch (Throwable e) {
                        if (!process_succeeded) break block16;
                        throw e;
                    }
                }
            }
        }
        catch (Throwable e) {
            listener.messageLogged("PluginLauncher: launch fails", e);
        }
    }

    private static LaunchablePlugin[] findLaunchablePlugins(LoggerChannelListener listener) {
        ArrayList<Plugin> res = new ArrayList<Plugin>();
        File app_dir = PluginLauncherImpl.getApplicationFile("plugins");
        if (!app_dir.exists() && app_dir.isDirectory()) {
            listener.messageLogged(3, "Application dir '" + app_dir + "' not found");
            return new LaunchablePlugin[0];
        }
        File[] plugins = app_dir.listFiles();
        if (plugins == null || plugins.length == 0) {
            listener.messageLogged(3, "Application dir '" + app_dir + "' empty");
            return new LaunchablePlugin[0];
        }
        int i = 0;
        while (i < plugins.length) {
            File plugin_dir = plugins[i];
            if (plugin_dir.isDirectory()) {
                try {
                    ClassLoader classLoader;
                    ClassLoader root_cl = classLoader = PluginLauncherImpl.class.getClassLoader();
                    File[] contents = plugin_dir.listFiles();
                    if (contents != null && contents.length != 0) {
                        Class<?> c;
                        Plugin plugin;
                        String plugin_class;
                        URLClassLoader current;
                        URL url;
                        String[] plugin_version = new String[1];
                        String[] plugin_id = new String[1];
                        contents = PluginLauncherImpl.getHighestJarVersions(contents, plugin_version, plugin_id, true);
                        int j = 0;
                        while (j < contents.length) {
                            classLoader = PluginLauncherImpl.addFileToClassPath(root_cl, classLoader, contents[j]);
                            ++j;
                        }
                        Properties props = new Properties();
                        File properties_file = new File(plugin_dir, "plugin.properties");
                        if (properties_file.exists()) {
                            FileInputStream fis = null;
                            try {
                                fis = new FileInputStream(properties_file);
                                props.load(fis);
                            }
                            finally {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                        } else if (classLoader instanceof URLClassLoader && (url = (current = (URLClassLoader)classLoader).findResource("plugin.properties")) != null) {
                            props.load(url.openStream());
                        }
                        if ((plugin_class = (String)props.get("plugin.class")) != null && plugin_class.indexOf(59) == -1 && (plugin = (Plugin)(c = classLoader.loadClass(plugin_class)).newInstance()) instanceof LaunchablePlugin) {
                            preloaded_plugins.put(plugin_class, plugin);
                            res.add(plugin);
                        }
                    }
                }
                catch (Throwable e) {
                    listener.messageLogged("Load of plugin in '" + plugin_dir + "' fails", e);
                }
            }
            ++i;
        }
        LaunchablePlugin[] x = new LaunchablePlugin[res.size()];
        res.toArray(x);
        return x;
    }

    public static Plugin getPreloadedPlugin(String cla) {
        return (Plugin)preloaded_plugins.get(cla);
    }

    private static File getApplicationFile(String filename) {
        return FileUtil.getApplicationFile(filename);
    }

    public static File[] getHighestJarVersions(File[] files, String[] version_out, String[] id_out, boolean discard_non_versioned_when_versioned_found) {
        ArrayList<File> res = new ArrayList<File>();
        HashMap<String, String> version_map = new HashMap<String, String>();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            String name = f.getName().toLowerCase();
            if (name.endsWith(".jar")) {
                int cvs_pos = name.lastIndexOf("_cvs");
                int sep_pos = cvs_pos <= 0 ? name.lastIndexOf("_") : name.lastIndexOf("_", cvs_pos - 1);
                if (sep_pos == -1 || sep_pos == name.length() - 1 || !Character.isDigit(name.charAt(sep_pos + 1))) {
                    res.add(f);
                } else {
                    String prefix = name.substring(0, sep_pos);
                    String version = name.substring(sep_pos + 1, cvs_pos <= 0 ? name.length() - 4 : cvs_pos);
                    String prev_version = (String)version_map.get(prefix);
                    if (prev_version == null) {
                        version_map.put(prefix, version);
                    } else if (PluginUtils.comparePluginVersions(prev_version, version) < 0) {
                        version_map.put(prefix, version);
                    }
                }
            }
            ++i;
        }
        if (version_map.size() > 0 && discard_non_versioned_when_versioned_found) {
            res.clear();
        }
        if (version_map.containsKey("azrating")) {
            version_map.remove("rating");
        }
        block1: for (String prefix : version_map.keySet()) {
            String version = (String)version_map.get(prefix);
            String target = String.valueOf(prefix) + "_" + version;
            version_out[0] = version;
            id_out[0] = prefix;
            int i2 = 0;
            while (i2 < files.length) {
                File f = files[i2];
                String lc_name = f.getName().toLowerCase();
                if (lc_name.equals(String.valueOf(target) + ".jar") || lc_name.equals(String.valueOf(target) + "_cvs.jar")) {
                    res.add(f);
                    continue block1;
                }
                ++i2;
            }
        }
        File[] res_array = new File[res.size()];
        res.toArray(res_array);
        return res_array;
    }

    public static ClassLoader addFileToClassPath(ClassLoader root, ClassLoader classLoader, File f) {
        if (f.exists() && !f.isDirectory() && f.getName().endsWith(".jar")) {
            try {
                classLoader = PluginLauncherImpl.extendClassLoader(root, classLoader, f.toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classLoader;
    }

    public static ClassLoader extendClassLoader(ClassLoader root, ClassLoader classLoader, URL url) {
        if (classLoader instanceof URLClassLoader) {
            URL[] old = ((URLClassLoader)classLoader).getURLs();
            URL[] new_urls = new URL[old.length + 1];
            System.arraycopy(old, 0, new_urls, 1, old.length);
            new_urls[0] = url;
            classLoader = new URLClassLoader(new_urls, classLoader == root ? classLoader : classLoader.getParent());
        } else {
            classLoader = new URLClassLoader(new URL[]{url}, classLoader);
        }
        return classLoader;
    }
}

