/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ipfilter;

import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.ipfilter.IPRange;

public class IPRangeImpl
implements IPRange {
    private IPFilter filter;
    private IpRange range;

    protected IPRangeImpl(IPFilter _filter, IpRange _range) {
        this.filter = _filter;
        this.range = _range;
    }

    protected IpRange getRange() {
        return this.range;
    }

    @Override
    public String getDescription() {
        return this.range.getDescription();
    }

    @Override
    public void setDescription(String str) {
        this.range.setDescription(str);
    }

    @Override
    public boolean isValid() {
        return this.range.isValid();
    }

    @Override
    public void checkValid() {
        this.range.checkValid();
    }

    @Override
    public boolean isSessionOnly() {
        return this.range.isSessionOnly();
    }

    @Override
    public String getStartIP() {
        return this.range.getStartIp();
    }

    @Override
    public void setStartIP(String str) {
        this.range.setStartIp(str);
    }

    @Override
    public String getEndIP() {
        return this.range.getEndIp();
    }

    @Override
    public void setEndIP(String str) {
        this.range.setEndIp(str);
    }

    @Override
    public void setSessionOnly(boolean sessionOnly) {
        this.range.setSessionOnly(sessionOnly);
    }

    @Override
    public boolean isInRange(String ipAddress) {
        return this.range.isInRange(ipAddress);
    }

    @Override
    public void delete() {
        this.filter.removeRange(this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof IPRangeImpl)) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int hash = this.getStartIP().hashCode();
        String ip = this.getEndIP();
        if (ip != null) {
            hash += ip.hashCode();
        }
        return hash;
    }

    public int compareTo(Object other) {
        String ip2;
        if (!(other instanceof IPRangeImpl)) {
            throw new RuntimeException("other object must be IPRange");
        }
        IPRangeImpl o = (IPRangeImpl)other;
        String ip1 = this.getStartIP();
        int res = ip1.compareTo(ip2 = o.getStartIP());
        if (res != 0) {
            return res;
        }
        ip1 = this.getEndIP();
        ip2 = o.getEndIP();
        if (ip1 == null && ip2 == null) {
            return 0;
        }
        if (ip1 == null) {
            return -1;
        }
        if (ip2 == null) {
            return 1;
        }
        return ip1.compareTo(ip2);
    }
}

