/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform;

import java.util.Properties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.unix.PlatformManagerUnixPlugin;
import org.gudy.azureus2.platform.win32.PlatformManagerUpdateChecker;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateChecker;

public class PlatformManagerPluginDelegate
implements Plugin,
UpdatableComponent {
    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Platform-Specific Support");
    }

    @Override
    public void initialize(PluginInterface pluginInterface) throws PluginException {
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        int platformType = platform.getPlatformType();
        if (platformType == 1) {
            PlatformManagerUpdateChecker plugin = new PlatformManagerUpdateChecker();
            plugin.initialize(pluginInterface);
        } else if (platformType == 3) {
            org.gudy.azureus2.platform.macosx.PlatformManagerUpdateChecker plugin = new org.gudy.azureus2.platform.macosx.PlatformManagerUpdateChecker();
            plugin.initialize(pluginInterface);
        } else if (platformType == 4) {
            PlatformManagerUnixPlugin plugin = new PlatformManagerUnixPlugin();
            plugin.initialize(pluginInterface);
        } else {
            Properties pluginProperties = pluginInterface.getPluginProperties();
            pluginProperties.setProperty("plugin.name", "Platform-Specific Support");
            pluginProperties.setProperty("plugin.version", "1.0");
            pluginProperties.setProperty("plugin.version.info", "Not required for this platform");
        }
    }

    @Override
    public String getName() {
        return "Mixin only";
    }

    @Override
    public int getMaximumCheckTime() {
        return 0;
    }

    @Override
    public void checkForUpdate(UpdateChecker checker) {
    }
}

