/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.dummy.PlatformManagerImpl;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformManagerFactory {
    protected static PlatformManager platform_manager;
    protected static AEMonitor class_mon;

    static {
        class_mon = new AEMonitor("PlatformManagerFactory");
    }

    public static PlatformManager getPlatformManager() {
        try {
            block20: {
                boolean force_dummy = System.getProperty("azureus.platform.manager.disable", "false").equals("true");
                class_mon.enter();
                if (platform_manager == null && !force_dummy) {
                    try {
                        String cla = System.getProperty("az.factory.platformmanager.impl", "");
                        if (cla.length() == 0) {
                            int platformType = PlatformManagerFactory.getPlatformType();
                            switch (platformType) {
                                case 1: {
                                    cla = "org.gudy.azureus2.platform.win32.PlatformManagerImpl";
                                    break;
                                }
                                case 3: {
                                    cla = "org.gudy.azureus2.platform.macosx.PlatformManagerImpl";
                                    break;
                                }
                                case 4: {
                                    cla = "org.gudy.azureus2.platform.unix.PlatformManagerImpl";
                                    break;
                                }
                                default: {
                                    cla = "org.gudy.azureus2.platform.dummy.PlatformManagerImpl";
                                }
                            }
                        }
                        Class<?> platform_manager_class = Class.forName(cla);
                        try {
                            Method methGetSingleton = platform_manager_class.getMethod("getSingleton", new Class[0]);
                            platform_manager = (PlatformManager)methGetSingleton.invoke(null, new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        if (platform_manager == null) {
                            platform_manager = (PlatformManager)Class.forName(cla).newInstance();
                        }
                    }
                    catch (Throwable e) {
                        if (e instanceof PlatformManagerException) break block20;
                        Debug.printStackTrace(e);
                    }
                }
            }
            if (platform_manager == null) {
                platform_manager = PlatformManagerImpl.getSingleton();
            }
            PlatformManager platformManager = platform_manager;
            return platformManager;
        }
        finally {
            class_mon.exit();
        }
    }

    public static int getPlatformType() {
        if (Constants.isWindows) {
            return 1;
        }
        if (Constants.isOSX) {
            return 3;
        }
        if (Constants.isUnix) {
            return 4;
        }
        return 2;
    }
}

