/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class AEJarReader {
    protected final Map entries = new HashMap();

    public AEJarReader(String name) {
        InputStream is = null;
        ZipInputStream jis = null;
        try {
            try {
                JarEntry ent;
                is = this.getClass().getClassLoader().getResourceAsStream(name);
                jis = new JarInputStream(is);
                while ((ent = ((JarInputStream)jis).getNextJarEntry()) != null) {
                    int l;
                    if (ent.isDirectory()) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    while ((l = jis.read(buffer)) > 0) {
                        baos.write(buffer, 0, l);
                    }
                    this.entries.put(ent.getName(), new ByteArrayInputStream(baos.toByteArray()));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    if (jis != null) {
                        jis.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                if (jis != null) {
                    jis.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public InputStream getResource(String name) {
        return (InputStream)this.entries.get(name);
    }
}

