/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEJavaManagement;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class ThreadPool {
    private static final boolean NAME_THREADS = Constants.IS_CVS_VERSION && System.getProperty("az.thread.pool.naming.enable", "true").equals("true");
    private static final boolean LOG_WARNINGS = false;
    private static final int WARN_TIME = 10000;
    static final List busy_pools = new ArrayList();
    private static boolean busy_pool_timer_set = false;
    private static boolean debug_thread_pool;
    private static boolean debug_thread_pool_log_on;
    static final ThreadLocal tls;
    final String name;
    private final int max_size;
    private int thread_name_index = 1;
    private long execution_limit;
    final List busy;
    private final boolean queue_when_full;
    final List task_queue = new ArrayList();
    final AESemaphore thread_sem;
    private int reserved_target;
    private int reserved_actual;
    private int thread_priority = 5;
    private boolean warn_when_full;
    private long task_total;
    private long task_total_last;
    private final Average task_average = Average.getInstance(10000, 120);
    private boolean log_cpu = false;

    static {
        if (System.getProperty("transitory.startup", "0").equals("0")) {
            AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void generate(IndentWriter writer) {
                    writer.println("Thread Pools");
                    try {
                        ArrayList pools;
                        writer.indent();
                        List list = busy_pools;
                        synchronized (list) {
                            pools = new ArrayList(busy_pools);
                        }
                        int i = 0;
                        while (i < pools.size()) {
                            ((ThreadPool)pools.get(i)).generateEvidence(writer);
                            ++i;
                        }
                    }
                    finally {
                        writer.exdent();
                    }
                }
            });
        }
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkAllTimeouts() {
        ArrayList pools;
        List list = busy_pools;
        synchronized (list) {
            pools = new ArrayList(busy_pools);
        }
        int i = 0;
        while (i < pools.size()) {
            ((ThreadPool)pools.get(i)).checkTimeouts();
            ++i;
        }
    }

    public ThreadPool(String _name, int _max_size) {
        this(_name, _max_size, false);
    }

    public ThreadPool(String _name, int _max_size, boolean _queue_when_full) {
        this.name = _name;
        this.max_size = _max_size;
        this.queue_when_full = _queue_when_full;
        this.thread_sem = new AESemaphore("ThreadPool::" + this.name, _max_size);
        this.busy = new ArrayList(_max_size);
    }

    private void generateEvidence(IndentWriter writer) {
        writer.println(String.valueOf(this.name) + ": max=" + this.max_size + ",qwf=" + this.queue_when_full + ",queue=" + this.task_queue.size() + ",busy=" + this.busy.size() + ",total=" + this.task_total + ":" + DisplayFormatters.formatDecimal(this.task_average.getDoubleAverage(), 2) + "/sec");
    }

    public void setWarnWhenFull() {
        this.warn_when_full = true;
    }

    public void setLogCPU() {
        this.log_cpu = true;
    }

    public int getMaxThreads() {
        return this.max_size;
    }

    public void setThreadPriority(int _priority) {
        this.thread_priority = _priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecutionLimit(long millis) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.execution_limit = millis;
        }
    }

    public threadPoolWorker run(AERunnable runnable) {
        return this.run(runnable, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public threadPoolWorker run(AERunnable runnable, boolean high_priority, boolean manualRelease) {
        threadPoolWorker allocated_worker;
        if (manualRelease && !(runnable instanceof ThreadPoolTask)) {
            throw new IllegalArgumentException("manual release only allowed for ThreadPoolTasks");
        }
        if (manualRelease) {
            ((ThreadPoolTask)runnable).setManualRelease();
        }
        if (!this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
            threadPoolWorker recursive_worker = (threadPoolWorker)tls.get();
            if (recursive_worker == null || recursive_worker.getOwner() != this) {
                this.checkWarning();
                this.thread_sem.reserve();
            } else {
                if (runnable instanceof ThreadPoolTask) {
                    ThreadPoolTask task2 = (ThreadPoolTask)runnable;
                    task2.worker = recursive_worker;
                    try {
                        task2.taskStarted();
                        this.runIt(runnable);
                        task2.join();
                    }
                    finally {
                        task2.taskCompleted();
                    }
                } else {
                    this.runIt(runnable);
                }
                return recursive_worker;
            }
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (high_priority) {
                this.task_queue.add(0, runnable);
            } else {
                this.task_queue.add(runnable);
            }
            if (this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
                allocated_worker = null;
                this.checkWarning();
            } else {
                allocated_worker = new threadPoolWorker();
            }
        }
        return allocated_worker;
    }

    protected void runIt(AERunnable runnable) {
        if (this.log_cpu) {
            long start_cpu = this.log_cpu ? AEJavaManagement.getThreadCPUTime() : 0L;
            long start_time = SystemTime.getHighPrecisionCounter();
            runnable.run();
            if (start_cpu > 0L) {
                long end_cpu = this.log_cpu ? AEJavaManagement.getThreadCPUTime() : 0L;
                long diff_cpu = (end_cpu - start_cpu) / 1000000L;
                long end_time = SystemTime.getHighPrecisionCounter();
                long diff_millis = (end_time - start_time) / 1000000L;
                if (diff_cpu > 10L || diff_millis > 10L) {
                    System.out.println(String.valueOf(TimeFormatter.milliStamp()) + ": Thread: " + Thread.currentThread().getName() + ": " + runnable + " -> " + diff_cpu + "/" + diff_millis);
                }
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkWarning() {
        if (this.warn_when_full) {
            String task_names = "";
            try {
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    int i = 0;
                    while (i < this.busy.size()) {
                        threadPoolWorker x = (threadPoolWorker)this.busy.get(i);
                        AERunnable r = x.runnable;
                        if (r != null) {
                            String name = r instanceof ThreadPoolTask ? ((ThreadPoolTask)r).getName() : r.getClass().getName();
                            task_names = String.valueOf(task_names) + (task_names.length() == 0 ? "" : ",") + name;
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Debug.out("Thread pool '" + this.getName() + "' is full (busy=" + task_names + ")");
            this.warn_when_full = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getQueuedTasks() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            AERunnable[] res = new AERunnable[this.task_queue.size()];
            this.task_queue.toArray(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueued(AERunnable task2) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.contains(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getRunningTasks() {
        ArrayList<AERunnable> runnables = new ArrayList<AERunnable>();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            for (threadPoolWorker worker : this.busy) {
                AERunnable runnable = worker.getRunnable();
                if (runnable == null) continue;
                runnables.add(runnable);
            }
        }
        AERunnable[] res = new AERunnable[runnables.size()];
        runnables.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningCount() {
        int res = 0;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            for (threadPoolWorker worker : this.busy) {
                AERunnable runnable = worker.getRunnable();
                if (runnable == null) continue;
                ++res;
            }
        }
        return res;
    }

    public boolean isFull() {
        return this.thread_sem.getValue() == 0;
    }

    public void setMaxThreads(int max) {
        if (max > this.max_size) {
            Debug.out("should support this sometime...");
            return;
        }
        this.setReservedThreadCount(this.max_size - max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReservedThreadCount(int res) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (res < 0) {
                res = 0;
            } else if (res > this.max_size) {
                res = this.max_size;
            }
            int diff = res - this.reserved_actual;
            while (diff < 0) {
                this.thread_sem.release();
                --this.reserved_actual;
                ++diff;
            }
            while (diff > 0) {
                if (!this.thread_sem.reserveIfAvailable()) break;
                ++this.reserved_actual;
                --diff;
            }
            this.reserved_target = res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long diff = this.task_total - this.task_total_last;
            this.task_average.addValue(diff);
            this.task_total_last = this.task_total;
            if (debug_thread_pool_log_on) {
                System.out.println("ThreadPool '" + this.getName() + "'/" + this.thread_name_index + ": max=" + this.max_size + ",sem=[" + this.thread_sem.getString() + "],busy=" + this.busy.size() + ",queue=" + this.task_queue.size());
            }
            long now = SystemTime.getMonotonousTime();
            int i = 0;
            while (i < this.busy.size()) {
                threadPoolWorker x = (threadPoolWorker)this.busy.get(i);
                long elapsed = now - x.run_start_time;
                if (elapsed > 10000L * (long)(x.warn_count + 1)) {
                    AERunnable r;
                    threadPoolWorker threadPoolWorker2 = x;
                    threadPoolWorker2.warn_count = threadPoolWorker2.warn_count + 1;
                    if (this.execution_limit > 0L && elapsed > this.execution_limit && (r = x.runnable) != null) {
                        try {
                            if (r instanceof ThreadPoolTask) {
                                ((ThreadPoolTask)r).interruptTask();
                            } else {
                                x.interrupt();
                            }
                        }
                        catch (Throwable e) {
                            DebugLight.printStackTrace(e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseManual(ThreadPoolTask toRelease) {
        if (!toRelease.canManualRelease()) {
            throw new IllegalStateException("task not manually releasable");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long elapsed = SystemTime.getMonotonousTime() - toRelease.worker.run_start_time;
            if (!this.busy.remove(toRelease.worker)) {
                throw new IllegalStateException("task already released");
            }
            if (this.busy.size() == 0 && !debug_thread_pool) {
                List list = busy_pools;
                synchronized (list) {
                    busy_pools.remove(this);
                }
            }
            if (this.busy.size() == 0) {
                if (this.reserved_target > this.reserved_actual) {
                    ++this.reserved_actual;
                } else {
                    this.thread_sem.release();
                }
            } else {
                new threadPoolWorker();
            }
        }
    }

    public void registerThreadAsChild(threadPoolWorker parent) {
        if (tls.get() != null && tls.get() != parent) {
            throw new IllegalStateException("another parent is already set for this thread");
        }
        tls.set(parent);
    }

    public void deregisterThreadAsChild(threadPoolWorker parent) {
        if (tls.get() != parent) {
            throw new IllegalStateException("tls is not set to parent");
        }
        tls.set(null);
    }

    static /* synthetic */ int access$5(ThreadPool threadPool) {
        return threadPool.reserved_target;
    }

    static /* synthetic */ int access$6(ThreadPool threadPool) {
        return threadPool.reserved_actual;
    }

    static /* synthetic */ void access$7(ThreadPool threadPool, int n) {
        threadPool.reserved_actual = n;
    }

    static /* synthetic */ boolean access$8() {
        return debug_thread_pool;
    }

    static /* synthetic */ long access$9(ThreadPool threadPool) {
        return threadPool.task_total;
    }

    static /* synthetic */ void access$10(ThreadPool threadPool, long l) {
        threadPool.task_total = l;
    }

    static /* synthetic */ boolean access$11() {
        return busy_pool_timer_set;
    }

    static /* synthetic */ void access$14(boolean bl) {
        busy_pool_timer_set = bl;
    }

    class threadPoolWorker
    extends AEThread2 {
        private final String worker_name;
        private volatile AERunnable runnable;
        private long run_start_time;
        private int warn_count;
        private String state;

        protected threadPoolWorker() {
            super(NAME_THREADS ? String.valueOf(ThreadPool.this.name) + " " + ThreadPool.this.thread_name_index : ThreadPool.this.name, true);
            this.state = "<none>";
            ThreadPool threadPool2 = ThreadPool.this;
            threadPool2.thread_name_index = threadPool2.thread_name_index + 1;
            this.setPriority(ThreadPool.this.thread_priority);
            this.worker_name = this.getName();
            this.start();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void setState(String _state) {
            this.state = _state;
        }

        public String getState() {
            return this.state;
        }

        protected String getWorkerName() {
            return this.worker_name;
        }

        protected ThreadPool getOwner() {
            return ThreadPool.this;
        }

        protected AERunnable getRunnable() {
            return this.runnable;
        }
    }
}

