/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

public class HashWrapper2 {
    private final byte[] hash;
    private final short offset;
    private final short length;
    private final int hash_code;

    public HashWrapper2(byte[] hash) {
        this(hash, 0, hash.length);
    }

    public HashWrapper2(byte[] _hash, int _offset, int _length) {
        if (_offset >= Short.MAX_VALUE) {
            throw new RuntimeException("Illegal value - offset too large");
        }
        if (_length >= Short.MAX_VALUE) {
            throw new RuntimeException("Illegal value - length too large");
        }
        this.hash = _hash;
        this.offset = (short)_offset;
        this.length = (short)_length;
        int hc = 0;
        int i = this.offset;
        while (i < this.offset + this.length) {
            hc = 31 * hc + this.hash[i];
            ++i;
        }
        this.hash_code = hc;
    }

    public byte[] getBytes() {
        return this.hash;
    }

    public short getOffset() {
        return this.offset;
    }

    public short getLength() {
        return this.length;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof HashWrapper2)) {
            return false;
        }
        HashWrapper2 other = (HashWrapper2)o;
        if (other.length != this.length) {
            return false;
        }
        byte[] other_hash = other.hash;
        short other_offset = other.offset;
        int i = 0;
        while (i < this.length) {
            if (this.hash[this.offset + i] != other_hash[other_offset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hash_code;
    }
}

