/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;

public class Debug {
    private static final boolean STOP_AT_INITIALIZER = System.getProperty("debug.stacktrace.full", "0").equals("0");
    private static final AEDiagnosticsLogger diag_logger;

    static {
        AEDiagnosticsLogger temp_diag_logger = null;
        try {
            temp_diag_logger = AEDiagnostics.getLogger("debug");
            temp_diag_logger.setForced(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        diag_logger = temp_diag_logger;
    }

    public static void out(String _debug_message) {
        Debug.out(_debug_message, null);
    }

    public static void out(Throwable _exception) {
        Debug.out("", _exception);
    }

    public static void outNoStack(String str) {
        Debug.outNoStack(str, false);
    }

    public static void outNoStack(String str, boolean stderr) {
        Debug.diagLoggerLogAndOut("DEBUG::" + new Date(SystemTime.getCurrentTime()).toString() + "  " + str, stderr);
    }

    public static void outDiagLoggerOnly(String str) {
        Debug.diagLoggerLog(str);
    }

    public static void out(String _debug_msg, Throwable _exception) {
        if (_exception instanceof ConnectException && _exception.getMessage().startsWith("No route to host")) {
            Debug.diagLoggerLog(_exception.toString());
            return;
        }
        if (_exception instanceof UnknownHostException) {
            Debug.diagLoggerLog(_exception.toString());
            return;
        }
        String header = "DEBUG::";
        header = String.valueOf(header) + new Date(SystemTime.getCurrentTime()).toString() + "::";
        String trace_trace_tail = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            StackTraceElement first_line = st[2];
            String className = String.valueOf(first_line.getClassName()) + "::";
            String methodName = String.valueOf(first_line.getMethodName()) + "::";
            int lineNumber = first_line.getLineNumber();
            trace_trace_tail = Debug.getCompressedStackTrace(e, 3, 200, false);
            Debug.diagLoggerLogAndOut(String.valueOf(header) + className + methodName + lineNumber + ":", true);
            if (_debug_msg.length() > 0) {
                Debug.diagLoggerLogAndOut("  " + _debug_msg, true);
            }
            if (trace_trace_tail != null) {
                Debug.diagLoggerLogAndOut("    " + trace_trace_tail, true);
            }
            if (_exception != null) {
                Debug.diagLoggerLogAndOut(_exception);
            }
            return;
        }
    }

    public static String getLastCaller() {
        return Debug.getLastCaller(0);
    }

    public static String getLastCaller(int numToGoBackFurther) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            if (st == null || st.length == 0) {
                return "??";
            }
            if (st.length > 3 + numToGoBackFurther) {
                return st[3 + numToGoBackFurther].toString();
            }
            return st[st.length - 1].toString();
        }
    }

    public static String getLastCallerShort() {
        return Debug.getLastCallerShort(0);
    }

    public static String getLastCallerShort(int numToGoBackFurther) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] st = e.getStackTrace();
            if (st == null || st.length == 0) {
                return "??";
            }
            StackTraceElement ste = st.length > 3 + numToGoBackFurther ? st[3 + numToGoBackFurther] : st[st.length - 1];
            String fn = ste.getFileName();
            if (fn != null) {
                return String.valueOf(fn) + ":" + ste.getLineNumber();
            }
            return ste.toString();
        }
    }

    public static void outStackTrace() {
        Debug.diagLoggerLogAndOut(Debug.getStackTrace(1), false);
    }

    /*
     * Unable to fully structure code
     */
    private static String getStackTrace(int endNumToSkip) {
        sStackTrace = "";
        try {
            throw new Exception();
        }
        catch (Exception e) {
            st = e.getStackTrace();
            i = 1;
            ** while (i < st.length - endNumToSkip)
        }
lbl-1000:
        // 1 sources

        {
            if (!st[i].getMethodName().endsWith("StackTrace")) {
                sStackTrace = String.valueOf(sStackTrace) + st[i].toString() + "\n";
            }
            ++i;
            continue;
        }
lbl12:
        // 1 sources

        if (e.getCause() != null) {
            sStackTrace = String.valueOf(sStackTrace) + "\tCaused By: " + Debug.getStackTrace(e.getCause()) + "\n";
        }
        return sStackTrace;
    }

    public static void killAWTThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Debug.killAWTThreads(threadGroup);
    }

    private static String getCompressedStackTrace(Throwable t, int frames_to_skip) {
        return Debug.getCompressedStackTrace(t, frames_to_skip, 200);
    }

    public static String getCompressedStackTrace(Throwable t, int frames_to_skip, int iMaxLines) {
        return Debug.getCompressedStackTrace(t, frames_to_skip, iMaxLines, true);
    }

    public static String getCompressedStackTrace(Throwable t, int frames_to_skip, int iMaxLines, boolean showErrString) {
        StringBuilder sbStackTrace = new StringBuilder(showErrString ? String.valueOf(t.toString()) + "; " : "");
        StackTraceElement[] st = t.getStackTrace();
        if (iMaxLines < 0 && (iMaxLines = st.length + iMaxLines) < 0) {
            iMaxLines = 1;
        }
        int iMax = Math.min(st.length, iMaxLines + frames_to_skip);
        int i = frames_to_skip;
        while (i < iMax) {
            if (i > frames_to_skip) {
                sbStackTrace.append(", ");
            }
            String classname = st[i].getClassName();
            String cnShort = classname.substring(classname.lastIndexOf(".") + 1);
            if (Constants.IS_CVS_VERSION) {
                if (STOP_AT_INITIALIZER && st[i].getClassName().equals("com.aelitis.azureus.ui.swt.Initializer")) {
                    sbStackTrace.append("Initializer");
                    break;
                }
                sbStackTrace.append(st[i].getMethodName());
                sbStackTrace.append(" (");
                sbStackTrace.append(st[i].getFileName());
                sbStackTrace.append(':');
                sbStackTrace.append(st[i].getLineNumber());
                sbStackTrace.append(')');
            } else {
                sbStackTrace.append(cnShort);
                sbStackTrace.append("::");
                sbStackTrace.append(st[i].getMethodName());
                sbStackTrace.append("::");
                sbStackTrace.append(st[i].getLineNumber());
            }
            ++i;
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            sbStackTrace.append("\n\tCaused By: ");
            sbStackTrace.append(Debug.getCompressedStackTrace(cause, 0));
        }
        return sbStackTrace.toString();
    }

    public static String getStackTrace(boolean bCompressed, boolean bIncludeSelf) {
        return Debug.getStackTrace(bCompressed, bIncludeSelf, bIncludeSelf ? 0 : 1, 200);
    }

    public static String getStackTrace(boolean bCompressed, boolean bIncludeSelf, int iNumLinesToSkip, int iMaxLines) {
        if (bCompressed) {
            return Debug.getCompressedStackTrace(bIncludeSelf ? 2 + iNumLinesToSkip : 3 + iNumLinesToSkip, iMaxLines);
        }
        return Debug.getStackTrace(1);
    }

    private static String getCompressedStackTrace(int frames_to_skip, int iMaxLines) {
        String trace_trace_tail = null;
        try {
            throw new Exception();
        }
        catch (Exception e) {
            trace_trace_tail = Debug.getCompressedStackTrace(e, frames_to_skip, iMaxLines, false);
            return trace_trace_tail;
        }
    }

    public static void killAWTThreads(ThreadGroup threadGroup) {
        Thread[] threadList = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadList);
        int i = 0;
        while (i < threadList.length) {
            String name;
            Thread t = threadList[i];
            if (t != null && (name = t.getName()).startsWith("AWT")) {
                Debug.out("Interrupting thread '".concat(t.toString()).concat("'"));
                t.interrupt();
            }
            ++i;
        }
        if (threadGroup.getParent() != null) {
            Debug.killAWTThreads(threadGroup.getParent());
        }
    }

    public static void dumpThreads(String name) {
        Debug.out(String.valueOf(name) + ":");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Debug.dumpThreads(threadGroup, "\t");
    }

    public static void dumpThreads(ThreadGroup threadGroup, String indent) {
        Thread[] threadList = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadList);
        int i = 0;
        while (i < threadList.length) {
            Thread t = threadList[i];
            if (t != null) {
                Debug.out(indent.concat("active thread = ").concat(t.toString()).concat(", daemon = ").concat(String.valueOf(t.isDaemon())));
            }
            ++i;
        }
        if (threadGroup.getParent() != null) {
            Debug.dumpThreads(threadGroup.getParent(), String.valueOf(indent) + "\t");
        }
    }

    public static void dumpThreadsLoop(final String name) {
        new AEThread("Thread Dumper"){

            @Override
            public void runSupport() {
                while (true) {
                    Debug.dumpThreads(name);
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public static void dumpSystemProperties() {
        Debug.out("System Properties:");
        Properties props = System.getProperties();
        for (String string : props.keySet()) {
            Debug.out("\t".concat(string).concat(" = '").concat(props.get(string).toString()).concat("'"));
        }
    }

    public static String getNestedExceptionMessage(Throwable e) {
        String last_message = "";
        while (e != null) {
            String this_message = e instanceof UnknownHostException ? "Unknown host " + e.getMessage() : (e instanceof FileNotFoundException ? "File not found: " + e.getMessage() : e.getMessage());
            if (this_message == null) {
                this_message = e.getClass().getName();
                int pos = this_message.lastIndexOf(".");
                this_message = this_message.substring(pos + 1).trim();
            }
            if (this_message.length() > 0 && !last_message.contains(this_message)) {
                last_message = String.valueOf(last_message) + (last_message.length() == 0 ? "" : ", ") + this_message;
            }
            e = e.getCause();
        }
        return last_message;
    }

    public static boolean containsException(Throwable error, Class<? extends Throwable> cla) {
        if (error == null) {
            return false;
        }
        if (cla.isInstance(error)) {
            return true;
        }
        return Debug.containsException(error.getCause(), cla);
    }

    public static String getNestedExceptionMessageAndStack(Throwable e) {
        return String.valueOf(Debug.getNestedExceptionMessage(e)) + ", " + Debug.getCompressedStackTrace(e, 0);
    }

    public static String getCompressedStackTraceSkipFrames(int frames_to_skip) {
        return Debug.getCompressedStackTrace(new Throwable(), frames_to_skip + 1, 200, false);
    }

    public static String getCompressedStackTrace() {
        return Debug.getCompressedStackTrace(new Throwable(), 1, 200, false);
    }

    public static String getCompressedStackTrace(int iMaxLines) {
        return Debug.getCompressedStackTrace(new Throwable(), 1, iMaxLines, false);
    }

    public static String getExceptionMessage(Throwable e) {
        String message = e.getMessage();
        if (message == null || message.length() == 0) {
            message = e.getClass().getName();
            int pos = message.lastIndexOf(".");
            message = message.substring(pos + 1);
        } else if (e instanceof ClassNotFoundException && !message.toLowerCase().contains("found")) {
            message = "Class " + message + " not found";
        }
        return message;
    }

    public static void printStackTrace(Throwable e) {
        Debug.printStackTrace(e, null);
    }

    /*
     * Unable to fully structure code
     */
    public static void printStackTrace(Throwable e, Object context) {
        if (e instanceof ConnectException && e.getMessage().startsWith("No route to host")) {
            Debug.diagLoggerLog(e.toString());
            return;
        }
        if (e instanceof UnknownHostException) {
            Debug.diagLoggerLog(e.toString());
            return;
        }
        header = "DEBUG::";
        header = String.valueOf(header) + new Date(SystemTime.getCurrentTime()).toString() + "::";
        className = "?::";
        methodName = "?::";
        lineNumber = -1;
        try {
            throw new Exception();
        }
        catch (Exception f) {
            st = f.getStackTrace();
            i = 1;
            ** while (i < st.length)
        }
lbl-1000:
        // 1 sources

        {
            first_line = st[i];
            className = String.valueOf(first_line.getClassName()) + "::";
            methodName = String.valueOf(first_line.getMethodName()) + "::";
            lineNumber = first_line.getLineNumber();
            if (!className.contains(".logging.") && !className.endsWith(".Debug::")) break;
            ++i;
            continue;
        }
lbl25:
        // 2 sources

        Debug.diagLoggerLogAndOut(String.valueOf(header) + className + methodName + lineNumber + ":", true);
        try {
            baos = new ByteArrayOutputStream();
            pw = new PrintWriter(new OutputStreamWriter(baos));
            if (context != null) {
                pw.print("  ");
                pw.println(context);
            }
            pw.print("  ");
            e.printStackTrace(pw);
            pw.close();
            stack = baos.toString();
            Debug.diagLoggerLogAndOut(stack, true);
        }
        catch (Throwable ignore) {
            e.printStackTrace();
        }
    }

    public static String getStackTrace(Throwable e) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            e.printStackTrace(pw);
            pw.close();
            return baos.toString();
        }
        catch (Throwable ignore) {
            return "";
        }
    }

    private static void diagLoggerLog(String str) {
        if (diag_logger == null) {
            System.out.println(str);
        } else {
            diag_logger.log(str);
        }
    }

    private static void diagLoggerLogAndOut(String str, boolean stderr) {
        if (diag_logger == null) {
            if (stderr) {
                System.err.println(str);
            } else {
                System.out.println(str);
            }
        } else {
            diag_logger.logAndOut(str, stderr);
        }
    }

    private static void diagLoggerLogAndOut(Throwable e) {
        if (diag_logger == null) {
            e.printStackTrace();
        } else {
            diag_logger.logAndOut(e);
        }
    }

    public static String secretFileName(String key) {
        if (key == null) {
            return "";
        }
        String sep = File.separator;
        String regex = "([\\" + sep + "]?[^\\" + sep + "]{0,3}+)[^\\" + sep + "]*";
        String secretName = key.replaceAll(regex, "$1");
        int iExtensionPos = key.lastIndexOf(".");
        if (iExtensionPos >= 0) {
            secretName = String.valueOf(secretName) + key.substring(iExtensionPos);
        }
        return secretName;
    }

    public static void main(String[] args) {
        System.out.println(Debug.secretFileName("c:\\temp\\hello there.txt"));
        System.out.println(Debug.secretFileName("hello there.txt"));
    }
}

