/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class AsyncDispatcher {
    private final String name;
    private AEThread2 thread;
    private int priority = 5;
    private AERunnable queue_head;
    private LinkedList<AERunnable> queue_tail;
    final AESemaphore queue_sem = new AESemaphore("AsyncDispatcher");
    private int num_priority;
    final int quiesce_after_millis;

    public AsyncDispatcher() {
        this("AsyncDispatcher: " + Debug.getLastCallerShort(), 10000);
    }

    public AsyncDispatcher(String name) {
        this(name, 10000);
    }

    public AsyncDispatcher(int quiesce_after_millis) {
        this("AsyncDispatcher: " + Debug.getLastCallerShort(), quiesce_after_millis);
    }

    public AsyncDispatcher(String _name, int _quiesce_after_millis) {
        this.name = _name;
        this.quiesce_after_millis = _quiesce_after_millis;
    }

    public void dispatch(AERunnable target) {
        this.dispatch(target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(AERunnable target, boolean is_priority) {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            if (this.queue_head == null) {
                this.queue_head = target;
                if (is_priority) {
                    ++this.num_priority;
                }
            } else {
                if (this.queue_tail == null) {
                    this.queue_tail = new LinkedList();
                }
                if (is_priority) {
                    if (this.num_priority == 0) {
                        this.queue_tail.add(0, this.queue_head);
                        this.queue_head = target;
                    } else {
                        this.queue_tail.add(this.num_priority - 1, target);
                    }
                    ++this.num_priority;
                } else {
                    this.queue_tail.add(target);
                }
            }
            if (this.thread == null) {
                this.thread = new AEThread2(this.name, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            AsyncDispatcher.this.queue_sem.reserve(AsyncDispatcher.this.quiesce_after_millis);
                            AERunnable to_run = null;
                            AsyncDispatcher asyncDispatcher = AsyncDispatcher.this;
                            synchronized (asyncDispatcher) {
                                if (AsyncDispatcher.this.queue_head == null) {
                                    AsyncDispatcher.this.queue_tail = null;
                                    AsyncDispatcher.this.thread = null;
                                    break;
                                }
                                to_run = AsyncDispatcher.this.queue_head;
                                if (AsyncDispatcher.this.queue_tail != null && !AsyncDispatcher.this.queue_tail.isEmpty()) {
                                    AsyncDispatcher.this.queue_head = (AERunnable)AsyncDispatcher.this.queue_tail.removeFirst();
                                } else {
                                    AsyncDispatcher.this.queue_head = null;
                                }
                                if (AsyncDispatcher.this.num_priority > 0) {
                                    AsyncDispatcher asyncDispatcher2 = AsyncDispatcher.this;
                                    asyncDispatcher2.num_priority = asyncDispatcher2.num_priority - 1;
                                }
                            }
                            try {
                                to_run.runSupport();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                };
                this.thread.setPriority(this.priority);
                this.thread.start();
            }
        }
        this.queue_sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuiescent() {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            return this.thread == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            int result;
            int n = result = this.queue_head == null ? 0 : 1;
            if (this.queue_tail != null) {
                result += this.queue_tail.size();
            }
            return result;
        }
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDispatchThread() {
        AsyncDispatcher asyncDispatcher = this;
        synchronized (asyncDispatcher) {
            return this.thread != null && this.thread.isCurrentThread();
        }
    }
}

