/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.Collections;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonSem;
import org.gudy.azureus2.core3.util.Debug;

public class AEMonitor
extends AEMonSem {
    private int dont_wait = 1;
    private int nests = 0;
    private int total_reserve = 0;
    private int total_release = 1;
    protected Thread owner;
    protected Thread last_waiter;

    public AEMonitor(String _name) {
        super(_name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter() {
        Thread current_thread = Thread.currentThread();
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            ++this.entry_count;
            if (this.owner == current_thread) {
                ++this.nests;
            } else {
                block13: {
                    if (this.dont_wait == 0) {
                        try {
                            try {
                                block12: {
                                    ++this.waiting;
                                    this.last_waiter = current_thread;
                                    int spurious_count = 0;
                                    do {
                                        this.wait();
                                        if (this.total_reserve != this.total_release) break block12;
                                    } while (++spurious_count <= 1024);
                                    --this.waiting;
                                    Debug.out("AEMonitor: spurious wakeup limit exceeded");
                                    throw new Throwable("die die die");
                                }
                                ++this.total_reserve;
                                break block13;
                            }
                            catch (Throwable e) {
                                --this.waiting;
                                this.owner = current_thread;
                                Debug.out("**** monitor interrupted ****");
                                throw new RuntimeException("AEMonitor:interrupted");
                            }
                        }
                        finally {
                            this.last_waiter = null;
                        }
                    }
                    ++this.total_reserve;
                    --this.dont_wait;
                }
                this.owner = current_thread;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean enter(int max_millis) {
        Thread current_thread = Thread.currentThread();
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            ++this.entry_count;
            if (this.owner == current_thread) {
                ++this.nests;
            } else {
                if (this.dont_wait == 0) {
                    try {
                        ++this.waiting;
                        this.last_waiter = current_thread;
                        this.wait(max_millis);
                        if (this.total_reserve == this.total_release) {
                            --this.waiting;
                            return false;
                        }
                        ++this.total_reserve;
                    }
                    catch (Throwable e) {
                        --this.waiting;
                        this.owner = current_thread;
                        Debug.out("**** monitor interrupted ****");
                        throw new RuntimeException("AEMonitor:interrupted");
                    }
                    finally {
                        this.last_waiter = null;
                    }
                } else {
                    ++this.total_reserve;
                    --this.dont_wait;
                }
                this.owner = current_thread;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            if (this.nests > 0) {
                --this.nests;
            } else {
                this.owner = null;
                ++this.total_release;
                if (this.waiting != 0) {
                    --this.waiting;
                    this.notify();
                } else {
                    ++this.dont_wait;
                    if (this.dont_wait > 1) {
                        Debug.out("**** AEMonitor '" + this.name + "': multiple exit detected");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeld() {
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            return this.owner == Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaiters() {
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            return this.waiting > 0;
        }
    }

    public static Map getSynchronisedMap(Map m) {
        return Collections.synchronizedMap(m);
    }
}

