/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PRUDPPacketReplyScrape2
extends PRUDPPacketReply {
    protected static final int BYTES_PER_ENTRY = 12;
    protected int[] complete;
    protected int[] incomplete;
    protected int[] downloaded;

    public PRUDPPacketReplyScrape2(int trans_id) {
        super(2, trans_id);
    }

    protected PRUDPPacketReplyScrape2(DataInputStream is, int trans_id) throws IOException {
        super(2, trans_id);
        this.complete = new int[is.available() / 12];
        this.incomplete = new int[this.complete.length];
        this.downloaded = new int[this.complete.length];
        int i = 0;
        while (i < this.complete.length) {
            this.complete[i] = is.readInt();
            this.downloaded[i] = is.readInt();
            this.incomplete[i] = is.readInt();
            ++i;
        }
    }

    public void setDetails(int[] _complete, int[] _downloaded, int[] _incomplete) {
        this.complete = _complete;
        this.downloaded = _downloaded;
        this.incomplete = _incomplete;
    }

    public int[] getComplete() {
        return this.complete;
    }

    public int[] getDownloaded() {
        return this.downloaded;
    }

    public int[] getIncomplete() {
        return this.incomplete;
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        if (this.complete != null) {
            int i = 0;
            while (i < this.complete.length) {
                os.writeInt(this.complete[i]);
                os.writeInt(this.downloaded[i]);
                os.writeInt(this.incomplete[i]);
                ++i;
            }
        }
    }

    @Override
    public String getString() {
        String data = "";
        int i = 0;
        while (i < this.complete.length) {
            data = String.valueOf(data) + (i == 0 ? "" : ",") + this.complete[i] + "/" + this.incomplete[i] + "/" + this.downloaded[i];
            ++i;
        }
        return String.valueOf(super.getString()) + "[entries=" + this.complete.length + "=" + data + "]";
    }
}

