/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerHostImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public class TRHostTorrentHostImpl
implements TRHostTorrent {
    private final TRHostImpl host;
    private final TRTrackerServer server;
    private TRTrackerServerTorrent server_torrent;
    private TOTorrent torrent;
    private long date_added;
    private final int port;
    private List listeners_cow = new ArrayList();
    private final List removal_listeners = new ArrayList();
    private int status = 1;
    private boolean persistent;
    private boolean passive;
    private long sos_uploaded;
    private long sos_downloaded;
    private long sos_bytes_in;
    private long sos_bytes_out;
    private long sos_announce;
    private long sos_scrape;
    private long sos_complete;
    private long last_uploaded;
    private long last_downloaded;
    private long last_bytes_in;
    private long last_bytes_out;
    private long last_announce;
    private long last_scrape;
    private final Average average_uploaded = Average.getInstance(60000, 600);
    private final Average average_downloaded = Average.getInstance(60000, 600);
    private final Average average_bytes_in = Average.getInstance(60000, 600);
    private final Average average_bytes_out = Average.getInstance(60000, 600);
    private final Average average_announce = Average.getInstance(60000, 600);
    private final Average average_scrape = Average.getInstance(60000, 600);
    private boolean disable_reply_caching;
    private HashMap data;
    protected final AEMonitor this_mon = new AEMonitor("TRHostTorrentHost");

    protected TRHostTorrentHostImpl(TRHostImpl _host, TRTrackerServer _server, TOTorrent _torrent, int _port, long _date_added) {
        this.host = _host;
        this.server = _server;
        this.torrent = _torrent;
        this.port = _port;
        this.date_added = _date_added;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() {
        this.host.startTorrent(this);
    }

    protected void startSupport() {
        block6: {
            try {
                try {
                    this.this_mon.enter();
                    this.status = 2;
                    this.server_torrent = this.server.permit("", this.torrent.getHash(), true);
                    if (this.disable_reply_caching) {
                        this.server_torrent.disableCaching();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    this.this_mon.exit();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.this_mon.exit();
                throw throwable;
            }
            this.this_mon.exit();
        }
        this.host.hostTorrentStateChange(this);
    }

    @Override
    public void stop() {
        this.host.stopTorrent(this);
    }

    protected void stopSupport() {
        block6: {
            try {
                try {
                    TRTrackerServerTorrentStats torrent_stats;
                    this.this_mon.enter();
                    this.status = 1;
                    this.server.deny(this.torrent.getHash(), true);
                    TRTrackerServerTorrent st = this.server_torrent;
                    TRTrackerServerTorrentStats tRTrackerServerTorrentStats = torrent_stats = st == null ? null : st.getStats();
                    if (torrent_stats != null) {
                        this.sos_uploaded += torrent_stats.getUploaded();
                        this.sos_downloaded += torrent_stats.getDownloaded();
                        this.sos_bytes_in += torrent_stats.getBytesIn();
                        this.sos_bytes_out += torrent_stats.getBytesOut();
                        this.sos_announce += torrent_stats.getAnnounceCount();
                        this.sos_scrape += torrent_stats.getScrapeCount();
                        this.sos_complete += torrent_stats.getCompletedCount();
                        torrent_stats = null;
                    }
                    this.last_uploaded = 0L;
                    this.last_downloaded = 0L;
                    this.last_bytes_in = 0L;
                    this.last_bytes_out = 0L;
                    this.last_announce = 0L;
                    this.last_scrape = 0L;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    this.this_mon.exit();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.this_mon.exit();
                throw throwable;
            }
            this.this_mon.exit();
        }
        this.host.hostTorrentStateChange(this);
    }

    @Override
    public void remove() throws TRHostTorrentRemovalVetoException {
        this.canBeRemoved();
        this.stop();
        this.host.remove(this);
    }

    @Override
    public boolean canBeRemoved() throws TRHostTorrentRemovalVetoException {
        ArrayList listeners_copy;
        try {
            this.this_mon.enter();
            listeners_copy = new ArrayList(this.removal_listeners);
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < listeners_copy.size()) {
            ((TRHostTorrentWillBeRemovedListener)listeners_copy.get(i)).torrentWillBeRemoved(this);
            ++i;
        }
        return true;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    protected void setPersistent(boolean _persistent) {
        this.persistent = _persistent;
    }

    @Override
    public boolean isPassive() {
        return this.passive;
    }

    @Override
    public void setPassive(boolean b) {
        this.passive = b;
    }

    @Override
    public long getDateAdded() {
        return this.date_added;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public void setTorrent(TOTorrent _torrent) {
        if (_torrent != this.torrent) {
            this.torrent = _torrent;
            if (this.torrent != null) {
                this.passive = false;
            }
            this.host.torrentUpdated(this);
        }
    }

    protected void setTorrentInternal(TOTorrent _torrent) {
        this.torrent = _torrent;
    }

    @Override
    public TRTrackerServerTorrent getTrackerTorrent() {
        return this.server_torrent;
    }

    @Override
    public TRHostPeer[] getPeers() {
        try {
            TRTrackerServerPeer[] peers = this.server.getPeers(this.torrent.getHash());
            if (peers != null) {
                TRHostPeer[] res = new TRHostPeer[peers.length];
                int i = 0;
                while (i < peers.length) {
                    res[i] = new TRHostPeerHostImpl(peers[i]);
                    ++i;
                }
                return res;
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
        return new TRHostPeer[0];
    }

    protected TRTrackerServerTorrentStats getStats() {
        TRTrackerServerTorrent st = this.server_torrent;
        if (st != null) {
            return st.getStats();
        }
        return null;
    }

    protected void setStartOfDayValues(long _date_added, long completed, long announces, long scrapes, long uploaded, long downloaded, long bytes_in, long bytes_out) {
        this.date_added = _date_added;
        this.sos_complete = completed;
        this.sos_announce = announces;
        this.sos_scrape = scrapes;
        this.sos_uploaded = uploaded;
        this.sos_downloaded = downloaded;
        this.sos_bytes_in = bytes_in;
        this.sos_bytes_out = bytes_out;
    }

    @Override
    public int getSeedCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getSeedCount();
        }
        return 0;
    }

    @Override
    public int getLeecherCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getLeecherCount();
        }
        return 0;
    }

    @Override
    public int getBadNATCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getBadNATPeerCount();
        }
        return 0;
    }

    protected void updateStats() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            long current_uploaded = stats.getUploaded();
            long ul_diff = current_uploaded - this.last_uploaded;
            if (ul_diff < 0L) {
                ul_diff = 0L;
            }
            this.average_uploaded.addValue(ul_diff);
            this.last_uploaded = current_uploaded;
            long current_downloaded = stats.getDownloaded();
            long dl_diff = current_downloaded - this.last_downloaded;
            if (dl_diff < 0L) {
                dl_diff = 0L;
            }
            this.average_downloaded.addValue(dl_diff);
            this.last_downloaded = current_downloaded;
            long current_bytes_in = stats.getBytesIn();
            long bi_diff = current_bytes_in - this.last_bytes_in;
            if (bi_diff < 0L) {
                bi_diff = 0L;
            }
            this.average_bytes_in.addValue(bi_diff);
            this.last_bytes_in = current_bytes_in;
            long current_bytes_out = stats.getBytesOut();
            long bo_diff = current_bytes_out - this.last_bytes_out;
            if (bo_diff < 0L) {
                bo_diff = 0L;
            }
            this.average_bytes_out.addValue(bo_diff);
            this.last_bytes_out = current_bytes_out;
            long current_announce = stats.getAnnounceCount();
            long an_diff = current_announce - this.last_announce;
            if (an_diff < 0L) {
                an_diff = 0L;
            }
            this.average_announce.addValue(an_diff);
            this.last_announce = current_announce;
            long current_scrape = stats.getScrapeCount();
            long sc_diff = current_scrape - this.last_scrape;
            if (sc_diff < 0L) {
                sc_diff = 0L;
            }
            this.average_scrape.addValue(sc_diff);
            this.last_scrape = current_scrape;
        }
    }

    protected TRTrackerServer getServer() {
        return this.server;
    }

    @Override
    public long getTotalUploaded() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_uploaded + stats.getUploaded();
        }
        return this.sos_uploaded;
    }

    @Override
    public long getTotalDownloaded() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_downloaded + stats.getDownloaded();
        }
        return this.sos_downloaded;
    }

    @Override
    public long getTotalLeft() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return stats.getAmountLeft();
        }
        return 0L;
    }

    @Override
    public long getTotalBytesIn() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_bytes_in + stats.getBytesIn();
        }
        return this.sos_bytes_in;
    }

    @Override
    public long getTotalBytesOut() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_bytes_out + stats.getBytesOut();
        }
        return this.sos_bytes_out;
    }

    @Override
    public long getAnnounceCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_announce + stats.getAnnounceCount();
        }
        return this.sos_announce;
    }

    @Override
    public long getScrapeCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_scrape + stats.getScrapeCount();
        }
        return this.sos_scrape;
    }

    @Override
    public long getCompletedCount() {
        TRTrackerServerTorrentStats stats = this.getStats();
        if (stats != null) {
            return this.sos_complete + stats.getCompletedCount();
        }
        return this.sos_complete;
    }

    @Override
    public long getAverageBytesIn() {
        return this.average_bytes_in.getAverage();
    }

    @Override
    public long getAverageBytesOut() {
        return this.average_bytes_out.getAverage();
    }

    @Override
    public long getAverageUploaded() {
        return this.average_uploaded.getAverage();
    }

    @Override
    public long getAverageDownloaded() {
        return this.average_downloaded.getAverage();
    }

    @Override
    public long getAverageAnnounceCount() {
        return this.average_announce.getAverage();
    }

    @Override
    public long getAverageScrapeCount() {
        return this.average_scrape.getAverage();
    }

    @Override
    public void disableReplyCaching() {
        TRTrackerServerTorrent st = this.server_torrent;
        this.disable_reply_caching = true;
        if (st != null) {
            st.disableCaching();
        }
    }

    protected void preProcess(TRHostTorrentRequest req) throws TRHostException {
        List listeners_ref = this.listeners_cow;
        int i = 0;
        while (i < listeners_ref.size()) {
            try {
                ((TRHostTorrentListener)listeners_ref.get(i)).preProcess(req);
            }
            catch (TRHostException e) {
                throw e;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void postProcess(TRHostTorrentRequest req) throws TRHostException {
        List listeners_ref = this.listeners_cow;
        int i = 0;
        while (i < listeners_ref.size()) {
            try {
                ((TRHostTorrentListener)listeners_ref.get(i)).postProcess(req);
            }
            catch (TRHostException e) {
                throw e;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void addListener(TRHostTorrentListener l) {
        try {
            this.this_mon.enter();
            ArrayList<TRHostTorrentListener> new_listeners = new ArrayList<TRHostTorrentListener>(this.listeners_cow);
            new_listeners.add(l);
            this.listeners_cow = new_listeners;
        }
        finally {
            this.this_mon.exit();
        }
        this.host.torrentListenerRegistered();
    }

    @Override
    public void removeListener(TRHostTorrentListener l) {
        try {
            this.this_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners_cow);
            new_listeners.remove(l);
            this.listeners_cow = new_listeners;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addRemovalListener(TRHostTorrentWillBeRemovedListener l) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeRemovalListener(TRHostTorrentWillBeRemovedListener l) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    @Override
    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

