/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactoryListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostListener;
import org.gudy.azureus2.core3.tracker.host.TRHostListener2;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostConfigImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostExternalTorrent;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentPublishImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentRequestImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactoryListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequest;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TRHostImpl
implements TRHost,
TRTrackerAnnouncerFactoryListener,
TRTrackerServerListener2,
TRTrackerServerListener,
TRTrackerServerFactoryListener,
TRTrackerServerRequestListener,
TRTrackerServerAuthenticationListener {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int URL_DEFAULT_PORT = 80;
    private static final int URL_DEFAULT_PORT_SSL = 443;
    public static final int STATS_PERIOD_SECS = 60;
    private static final int TICK_PERIOD_SECS = 10;
    private static final int TICKS_PER_STATS_PERIOD = 6;
    private static TRHostImpl singleton;
    private static final AEMonitor class_mon;
    private TRHostConfigImpl config;
    private final Hashtable server_map = new Hashtable();
    final List host_torrents = new ArrayList();
    private final Map host_torrent_hash_map = new HashMap();
    private final Map host_torrent_map = new HashMap();
    private final Map tracker_client_map = new HashMap();
    private static final int LDT_TORRENT_ADDED = 1;
    private static final int LDT_TORRENT_REMOVED = 2;
    private static final int LDT_TORRENT_CHANGED = 3;
    private final ListenerManager<TRHostListener> listeners = ListenerManager.createAsyncManager("TRHost:ListenDispatcher", new ListenerManagerDispatcher<TRHostListener>(){

        @Override
        public void dispatch(TRHostListener _listener, int type, Object value) {
            TRHostListener target = _listener;
            if (type == 1) {
                target.torrentAdded((TRHostTorrent)value);
            } else if (type == 2) {
                target.torrentRemoved((TRHostTorrent)value);
            } else if (type == 3) {
                target.torrentChanged((TRHostTorrent)value);
            }
        }
    });
    private final CopyOnWriteList<TRHostListener2> listeners2 = new CopyOnWriteList();
    private static boolean host_add_announce_urls;
    private final List<TRHostAuthenticationListener> auth_listeners = new ArrayList<TRHostAuthenticationListener>();
    private boolean server_factory_listener_added;
    protected final AEMonitor this_mon = new AEMonitor("TRHost");
    private volatile boolean closed;
    final AsyncDispatcher dispatcher = new AsyncDispatcher("TRHost:stopHosting");

    static {
        class_mon = new AEMonitor("TRHost:class");
        COConfigurationManager.addAndFireParameterListener("Tracker Host Add Our Announce URLs", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                host_add_announce_urls = COConfigurationManager.getBooleanParameter(name);
            }
        });
    }

    public static TRHost create() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRHostImpl();
            }
            TRHostImpl tRHostImpl = singleton;
            return tRHostImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TRHostImpl() {
        try {
            this.this_mon.enter();
            this.config = new TRHostConfigImpl(this);
            TRTrackerAnnouncerFactory.addListener(this);
            AEThread t = new AEThread("TRHost::stats.loop"){
                private int tick_count;
                private final Set failed_ports;
                {
                    this.tick_count = 0;
                    this.failed_ports = new HashSet();
                }

                @Override
                public void runSupport() {
                    while (true) {
                        try {
                            URL[][] url_sets = TRTrackerUtils.getAnnounceURLs();
                            int i = 0;
                            while (i < url_sets.length) {
                                URL[] urls = url_sets[i];
                                int j = 0;
                                while (j < urls.length) {
                                    block25: {
                                        URL url = urls[j];
                                        int port = url.getPort();
                                        if (port == -1) {
                                            port = url.getDefaultPort();
                                        }
                                        String protocol = url.getProtocol().toLowerCase();
                                        try {
                                            if (protocol.equals("http")) {
                                                TRHostImpl.this.startServer(1, port, false);
                                            } else if (protocol.equals("udp")) {
                                                TRHostImpl.this.startServer(2, port, false);
                                            } else if (protocol.equals("https")) {
                                                TRHostImpl.this.startServer(1, port, true);
                                            } else {
                                                Debug.out("Unknown protocol '" + protocol + "'");
                                            }
                                        }
                                        catch (Throwable e) {
                                            Integer port_i = new Integer(port);
                                            if (this.failed_ports.contains(port_i)) break block25;
                                            this.failed_ports.add(port_i);
                                            Logger.log(new LogEvent(LOGID, "Tracker Host: failed to start server", e));
                                        }
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            Thread.sleep(10000L);
                            if (TRHostImpl.this.closed) break;
                            try {
                                if (this.tick_count % 6 == 0) {
                                    try {
                                        TRHostImpl.this.this_mon.enter();
                                        i = 0;
                                        while (i < TRHostImpl.this.host_torrents.size()) {
                                            TRHostTorrent ht = (TRHostTorrent)TRHostImpl.this.host_torrents.get(i);
                                            if (ht instanceof TRHostTorrentHostImpl) {
                                                ((TRHostTorrentHostImpl)ht).updateStats();
                                            } else {
                                                ((TRHostTorrentPublishImpl)ht).updateStats();
                                            }
                                            ++i;
                                        }
                                    }
                                    finally {
                                        TRHostImpl.this.this_mon.exit();
                                    }
                                    TRHostImpl.this.config.saveConfig(true);
                                    continue;
                                }
                                TRHostImpl.this.config.saveConfig(false);
                                continue;
                            }
                            catch (InterruptedException e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        finally {
                            ++this.tick_count;
                            continue;
                        }
                        break;
                    }
                }
            };
            t.setDaemon(true);
            t.setPriority(9);
            t.start();
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void initialise(TRHostTorrentFinder finder) {
        this.config.loadConfig(finder);
    }

    @Override
    public String getName() {
        return TRTrackerServer.DEFAULT_NAME;
    }

    @Override
    public TRHostTorrent hostTorrent(TOTorrent torrent, boolean persistent, boolean passive) throws TRHostException {
        return this.addTorrent(torrent, 2, persistent, passive, SystemTime.getCurrentTime());
    }

    @Override
    public TRHostTorrent publishTorrent(TOTorrent torrent) throws TRHostException {
        return this.addTorrent(torrent, 3, true, false, SystemTime.getCurrentTime());
    }

    protected TRHostTorrent addTorrent(TOTorrent torrent, int state, boolean persistent, boolean passive, long date_added) throws TRHostException {
        try {
            TRHostTorrent host_torrent;
            TRHostTorrent new_torrent;
            boolean ssl;
            int port;
            TRHostTorrent ht;
            this.this_mon.enter();
            if (persistent && state != 3 && host_add_announce_urls) {
                this.addTrackerAnnounce(torrent);
            }
            if ((ht = this.lookupHostTorrent(torrent)) != null) {
                try {
                    TRHostTorrentHostImpl hti;
                    ht = this.lookupHostTorrentViaHash(torrent.getHash());
                    if (ht instanceof TRHostTorrentHostImpl && (hti = (TRHostTorrentHostImpl)ht).getTorrent() != torrent) {
                        hti.setTorrentInternal(torrent);
                        if (persistent && !hti.isPersistent()) {
                            hti.setPersistent(true);
                        }
                        if (passive && !hti.isPassive()) {
                            hti.setPassive(true);
                        }
                        if (state != 3) {
                            this.startHosting(hti);
                            if (state == 2) {
                                hti.start();
                            }
                        }
                        this.listeners.dispatch(3, ht);
                    }
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
                TRHostTorrent tRHostTorrent = ht;
                return tRHostTorrent;
            }
            int protocol = 1;
            if (state == 3) {
                port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                ssl = false;
            } else {
                String tracker_ip;
                URL announce_url = torrent.getAnnounceURL();
                String protocol_str = announce_url.getProtocol();
                ssl = protocol_str.equalsIgnoreCase("https");
                if (protocol_str.equalsIgnoreCase("udp")) {
                    protocol = 2;
                } else if (TorrentUtils.isDecentralised(torrent)) {
                    protocol = 3;
                }
                boolean force_external = COConfigurationManager.getBooleanParameter("Tracker Port Force External");
                port = announce_url.getPort();
                if (force_external && (tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "")).length() > 0 && !announce_url.getHost().equalsIgnoreCase(tracker_ip)) {
                    port = ssl ? COConfigurationManager.getIntParameter("Tracker Port SSL", 7000) : COConfigurationManager.getIntParameter("Tracker Port", 6969);
                }
                if (port == -1) {
                    port = ssl ? 443 : 80;
                }
            }
            TRTrackerServer server = this.startServer(protocol, port, ssl);
            if (state == 3) {
                new_torrent = new TRHostTorrentPublishImpl(this, torrent, date_added);
                ((TRHostTorrentPublishImpl)new_torrent).setPersistent(persistent);
                host_torrent = new_torrent;
            } else {
                new_torrent = new TRHostTorrentHostImpl(this, server, torrent, port, date_added);
                ((TRHostTorrentHostImpl)new_torrent).setPersistent(persistent);
                ((TRHostTorrentHostImpl)new_torrent).setPassive(passive);
                host_torrent = new_torrent;
            }
            this.host_torrents.add(host_torrent);
            try {
                this.host_torrent_hash_map.put(new HashWrapper(torrent.getHash()), host_torrent);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
            this.host_torrent_map.put(torrent, host_torrent);
            if (state != 3) {
                this.startHosting((TRHostTorrentHostImpl)host_torrent);
                if (state == 2) {
                    host_torrent.start();
                }
                if (!persistent) {
                    this.config.recoverStats((TRHostTorrentHostImpl)host_torrent);
                }
            }
            this.listeners.dispatch(1, host_torrent);
            this.config.saveRequired();
            TRHostTorrent tRHostTorrent = host_torrent;
            return tRHostTorrent;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void torrentUpdated(TRHostTorrentHostImpl hti) {
        int state = hti.getStatus();
        if (state != 3) {
            this.startHosting(hti);
            if (state == 2) {
                hti.start();
            }
        }
        this.listeners.dispatch(3, hti);
    }

    @Override
    public InetAddress getBindIP() {
        return null;
    }

    protected TRTrackerServer startServer(int protocol, int port, boolean ssl) throws TRHostException {
        try {
            this.this_mon.enter();
            String key = protocol + ":" + port;
            TRTrackerServer server = (TRTrackerServer)this.server_map.get(key);
            if (server == null) {
                try {
                    server = ssl ? TRTrackerServerFactory.createSSL("tracker", protocol, port, true, true) : TRTrackerServerFactory.create("tracker", protocol, port, true, true);
                    this.server_map.put(key, server);
                    if (this.auth_listeners.size() > 0) {
                        server.addAuthenticationListener(this);
                    }
                    server.addListener(this);
                    server.addListener2(this);
                }
                catch (TRTrackerServerException e) {
                    throw new TRHostException("startServer failed", e);
                }
            }
            TRTrackerServer tRTrackerServer = server;
            return tRTrackerServer;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected TRHostTorrent lookupHostTorrent(TOTorrent torrent) {
        if (torrent == null) {
            return null;
        }
        try {
            return (TRHostTorrent)this.host_torrent_hash_map.get(torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected void startHosting(TRHostTorrentHostImpl host_torrent) {
        TOTorrent torrent = host_torrent.getTorrent();
        TRTrackerAnnouncer tc = (TRTrackerAnnouncer)this.tracker_client_map.get(torrent);
        if (tc != null) {
            this.startHosting(host_torrent, tc);
        }
    }

    protected void startHosting(TRTrackerAnnouncer tracker_client) {
        TRHostTorrent host_torrent = (TRHostTorrent)this.host_torrent_map.get(tracker_client.getTorrent());
        if (host_torrent instanceof TRHostTorrentHostImpl) {
            this.startHosting((TRHostTorrentHostImpl)host_torrent, tracker_client);
        }
    }

    protected void startHosting(TRHostTorrentHostImpl host_torrent, final TRTrackerAnnouncer tracker_client) {
        final TOTorrent torrent = host_torrent.getTorrent();
        URL announce = torrent.getAnnounceURL();
        if (host_add_announce_urls) {
            tracker_client.setIPOverride(announce.getHost());
        } else if (TRTrackerUtils.isHosting(announce)) {
            tracker_client.setIPOverride(announce.getHost());
        }
        TRTrackerAnnouncerListener listener = new TRTrackerAnnouncerListener(){

            @Override
            public void receivedTrackerResponse(TRTrackerAnnouncerResponse response) {
                try {
                    TRTrackerScraperFactory.getSingleton().scrape(torrent, true);
                }
                finally {
                    tracker_client.removeListener(this);
                }
            }

            @Override
            public void urlChanged(TRTrackerAnnouncer announcer, URL old_url, URL new_url, boolean explicit) {
            }

            @Override
            public void urlRefresh() {
            }
        };
        tracker_client.addListener(listener);
        tracker_client.refreshListeners();
    }

    protected void remove(TRHostTorrent host_torrent) {
        try {
            this.this_mon.enter();
            if (!this.host_torrents.contains(host_torrent)) {
                return;
            }
            this.host_torrents.remove(host_torrent);
            TOTorrent torrent = host_torrent.getTorrent();
            try {
                this.host_torrent_hash_map.remove(new HashWrapper(torrent.getHash()));
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
            this.host_torrent_map.remove(torrent);
            if (host_torrent instanceof TRHostTorrentHostImpl) {
                this.stopHosting((TRHostTorrentHostImpl)host_torrent);
            }
            this.listeners.dispatch(2, host_torrent);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void stopHosting(TRHostTorrentHostImpl host_torrent) {
        TOTorrent torrent = host_torrent.getTorrent();
        TRTrackerAnnouncer tc = (TRTrackerAnnouncer)this.tracker_client_map.get(torrent);
        if (tc != null) {
            this.stopHosting(host_torrent, tc);
        }
    }

    protected void stopHosting(TRTrackerAnnouncer tracker_client) {
        TRHostTorrent host_torrent = (TRHostTorrent)this.host_torrent_map.get(tracker_client.getTorrent());
        if (host_torrent instanceof TRHostTorrentHostImpl) {
            this.stopHosting((TRHostTorrentHostImpl)host_torrent, tracker_client);
        }
    }

    protected void stopHosting(final TRHostTorrentHostImpl host_torrent, final TRTrackerAnnouncer tracker_client) {
        SimpleTimer.addEvent("StopHosting", SystemTime.getOffsetTime(2500L), new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                TRHostImpl.this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        try {
                            (this).TRHostImpl.this.this_mon.enter();
                            TRHostTorrent ht = TRHostImpl.this.lookupHostTorrent(host_torrent.getTorrent());
                            if (ht == null || ht == host_torrent && ht.getStatus() == 1) {
                                tracker_client.clearIPOverride();
                            }
                        }
                        finally {
                            (this).TRHostImpl.this.this_mon.exit();
                        }
                    }
                });
            }
        });
    }

    protected TRTrackerAnnouncer getTrackerClient(TRHostTorrent host_torrent) {
        try {
            this.this_mon.enter();
            TRTrackerAnnouncer tRTrackerAnnouncer = (TRTrackerAnnouncer)this.tracker_client_map.get(host_torrent.getTorrent());
            return tRTrackerAnnouncer;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void hostTorrentStateChange(TRHostTorrent host_torrent) {
        try {
            this.this_mon.enter();
            TOTorrent torrent = host_torrent.getTorrent();
            TRTrackerAnnouncer tc = (TRTrackerAnnouncer)this.tracker_client_map.get(torrent);
            if (tc != null) {
                tc.refreshListeners();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public TRHostTorrent[] getTorrents() {
        try {
            this.this_mon.enter();
            TRHostTorrent[] res = new TRHostTorrent[this.host_torrents.size()];
            this.host_torrents.toArray(res);
            TRHostTorrent[] tRHostTorrentArray = res;
            return tRHostTorrentArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void clientCreated(TRTrackerAnnouncer client) {
        try {
            this.this_mon.enter();
            this.tracker_client_map.put(client.getTorrent(), client);
            this.startHosting(client);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void clientDestroyed(TRTrackerAnnouncer client) {
        try {
            this.this_mon.enter();
            this.tracker_client_map.remove(client.getTorrent());
            this.stopHosting(client);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected TRHostTorrent lookupHostTorrentViaHash(byte[] hash) {
        return (TRHostTorrent)this.host_torrent_hash_map.get(new HashWrapper(hash));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean permitted(String originator, byte[] hash, boolean explicit) {
        try {
            this.this_mon.enter();
            TRHostTorrent ht = this.lookupHostTorrentViaHash(hash);
            if (ht != null) {
                if (!explicit && ht.getStatus() != 2) {
                    return false;
                }
                return true;
            }
            this.addExternalTorrent(hash, 2, SystemTime.getCurrentTime());
            return true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void addExternalTorrent(byte[] hash, int state, long date_added) {
        try {
            this.this_mon.enter();
            if (this.lookupHostTorrentViaHash(hash) != null) {
                return;
            }
            String tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "127.0.0.1");
            int port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
            try {
                TRHostExternalTorrent external_torrent = new TRHostExternalTorrent(hash, new URL("http://" + UrlUtils.convertIPV6Host(tracker_ip) + ":" + port + "/announce"));
                this.addTorrent(external_torrent, state, true, false, date_added);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean denied(byte[] hash, boolean permitted) {
        return true;
    }

    @Override
    public boolean handleExternalRequest(InetSocketAddress client_address, String user, String url, URL absolute_url, String header, InputStream is, OutputStream os, AsyncController async) throws IOException {
        List<TRHostListener> listeners_copy = this.listeners.getListenersCopy();
        int i = 0;
        while (i < listeners_copy.size()) {
            TRHostListener listener = listeners_copy.get(i);
            try {
                if (listener.handleExternalRequest(client_address, user, url, absolute_url, header, is, os, async)) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean handleExternalRequest(TRTrackerServerListener2.ExternalRequest request2) throws IOException {
        Iterator<TRHostListener2> it = this.listeners2.iterator();
        while (it.hasNext()) {
            try {
                if (!it.next().handleExternalRequest(request2)) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return false;
    }

    @Override
    public TRHostTorrent getHostTorrent(TOTorrent torrent) {
        return this.lookupHostTorrent(torrent);
    }

    @Override
    public void addListener(TRHostListener l) {
        try {
            this.this_mon.enter();
            this.listeners.addListener(l);
            int i = 0;
            while (i < this.host_torrents.size()) {
                this.listeners.dispatch(l, 1, this.host_torrents.get(i));
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(TRHostListener l) {
        this.listeners.removeListener(l);
    }

    @Override
    public void addListener2(TRHostListener2 l) {
        this.listeners2.add(l);
    }

    @Override
    public void removeListener2(TRHostListener2 l) {
        this.listeners2.remove(l);
    }

    protected void torrentListenerRegistered() {
        try {
            this.this_mon.enter();
            if (!this.server_factory_listener_added) {
                this.server_factory_listener_added = true;
                TRTrackerServerFactory.addListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void serverCreated(TRTrackerServer server) {
        server.addRequestListener(this);
    }

    @Override
    public void serverDestroyed(TRTrackerServer server) {
        server.removeRequestListener(this);
    }

    @Override
    public void preProcess(TRTrackerServerRequest request2) throws TRTrackerServerException {
        TRTrackerServerTorrent ts_torrent;
        HashWrapper hash_wrapper;
        TRHostTorrent h_torrent;
        if ((request2.getType() == 1 || request2.getType() == 2) && (h_torrent = this.lookupHostTorrentViaHash((hash_wrapper = (ts_torrent = request2.getTorrent()).getHash()).getHash())) != null) {
            TRHostTorrentRequestImpl req = new TRHostTorrentRequestImpl(h_torrent, new TRHostPeerHostImpl(request2.getPeer()), request2);
            try {
                if (h_torrent instanceof TRHostTorrentHostImpl) {
                    ((TRHostTorrentHostImpl)h_torrent).preProcess(req);
                } else {
                    ((TRHostTorrentPublishImpl)h_torrent).preProcess(req);
                }
            }
            catch (TRHostException e) {
                throw new TRTrackerServerException(e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new TRTrackerServerException("Pre-process fails", e);
            }
        }
    }

    @Override
    public void postProcess(TRTrackerServerRequest request2) throws TRTrackerServerException {
        HashWrapper hash_wrapper;
        TRHostTorrent h_torrent;
        TRTrackerServerTorrent ts_torrent;
        if ((request2.getType() == 1 || request2.getType() == 2) && (ts_torrent = request2.getTorrent()) != null && (h_torrent = this.lookupHostTorrentViaHash((hash_wrapper = ts_torrent.getHash()).getHash())) != null) {
            TRHostTorrentRequestImpl req = new TRHostTorrentRequestImpl(h_torrent, new TRHostPeerHostImpl(request2.getPeer()), request2);
            try {
                if (h_torrent instanceof TRHostTorrentHostImpl) {
                    ((TRHostTorrentHostImpl)h_torrent).postProcess(req);
                } else {
                    ((TRHostTorrentPublishImpl)h_torrent).postProcess(req);
                }
            }
            catch (TRHostException e) {
                throw new TRTrackerServerException("Post process fails", e);
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.config.saveConfig(true);
    }

    @Override
    public boolean authenticate(String headers, URL resource, String user, String password) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                boolean res = this.auth_listeners.get(i).authenticate(headers, resource, user, password);
                if (res) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return false;
    }

    @Override
    public byte[] authenticate(URL resource, String user) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                byte[] res = this.auth_listeners.get(i).authenticate(resource, user);
                if (res != null) {
                    return res;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addAuthenticationListener(TRHostAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(l);
            if (this.auth_listeners.size() == 1) {
                Iterator it = this.server_map.values().iterator();
                while (it.hasNext()) {
                    ((TRTrackerServer)it.next()).addAuthenticationListener(this);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeAuthenticationListener(TRHostAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(l);
            if (this.auth_listeners.size() == 0) {
                Iterator it = this.server_map.values().iterator();
                while (it.hasNext()) {
                    ((TRTrackerServer)it.next()).removeAuthenticationListener(this);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void startTorrent(TRHostTorrentHostImpl torrent) {
        try {
            this.this_mon.enter();
            torrent.startSupport();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void stopTorrent(TRHostTorrentHostImpl torrent) {
        try {
            this.this_mon.enter();
            torrent.stopSupport();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void addTrackerAnnounce(TOTorrent torrent) {
        if (TorrentUtils.isDecentralised(torrent)) {
            return;
        }
        URL[][] url_sets = TRTrackerUtils.getAnnounceURLs();
        if (url_sets.length == 0) {
            TorrentUtils.setDecentralised(torrent);
        } else {
            URL[] primary_urls = url_sets[0];
            int i = primary_urls.length - 1;
            while (i >= 0) {
                String url_str = primary_urls[i].toString();
                if (TorrentUtils.announceGroupsContainsURL(torrent, url_str)) {
                    TorrentUtils.announceGroupsSetFirst(torrent, url_str);
                } else {
                    TorrentUtils.announceGroupsInsertFirst(torrent, url_str);
                }
                --i;
            }
        }
    }
}

