/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.util.HashWrapper;

public class TRTrackerAnnouncerResponseImpl
implements TRTrackerAnnouncerResponse {
    private final URL url;
    private final HashWrapper hash;
    private final int status;
    private final long time_to_wait;
    private String failure_reason;
    private boolean was_udp_probe = false;
    private int scrape_complete = -1;
    private int scrape_incomplete = -1;
    private int scrape_downloaded = -1;
    protected TRTrackerAnnouncerResponsePeer[] peers;
    protected Map extensions;

    public TRTrackerAnnouncerResponseImpl(URL _url, HashWrapper _hash, int _status, long _time_to_wait) {
        this.url = _url;
        this.hash = _hash;
        this.status = _status;
        this.time_to_wait = _time_to_wait;
    }

    public TRTrackerAnnouncerResponseImpl(URL _url, HashWrapper _hash, int _status, long _time_to_wait, String _failure_reason) {
        this.url = _url;
        this.hash = _hash;
        this.status = _status;
        this.time_to_wait = _time_to_wait;
        this.failure_reason = _failure_reason;
    }

    public TRTrackerAnnouncerResponseImpl(URL _url, HashWrapper _hash, int _status, long _time_to_wait, TRTrackerAnnouncerResponsePeer[] _peers) {
        this.url = _url;
        this.hash = _hash;
        this.status = _status;
        this.time_to_wait = _time_to_wait;
        this.peers = _peers;
    }

    @Override
    public HashWrapper getHash() {
        return this.hash;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getStatusString() {
        String str = "";
        if (this.status == 0) {
            str = "Offline";
        } else if (this.status == 2) {
            str = "OK";
            if (this.was_udp_probe) {
                str = String.valueOf(str) + " (UDP Probe)";
            }
        } else {
            str = "Failed";
        }
        if (this.failure_reason != null && this.failure_reason.length() > 0) {
            str = String.valueOf(str) + " - " + this.failure_reason;
        }
        return str;
    }

    public void setFailureReason(String reason) {
        this.failure_reason = reason;
    }

    public void setWasProbe() {
        this.was_udp_probe = true;
    }

    public boolean wasProbe() {
        return this.was_udp_probe;
    }

    @Override
    public long getTimeToWait() {
        return this.time_to_wait;
    }

    @Override
    public String getAdditionalInfo() {
        return this.failure_reason;
    }

    @Override
    public void setPeers(TRTrackerAnnouncerResponsePeer[] _peers) {
        this.peers = _peers;
    }

    @Override
    public TRTrackerAnnouncerResponsePeer[] getPeers() {
        return this.peers;
    }

    public void setExtensions(Map _extensions) {
        this.extensions = _extensions;
    }

    @Override
    public Map getExtensions() {
        return this.extensions;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public int getScrapeCompleteCount() {
        return this.scrape_complete;
    }

    @Override
    public int getScrapeIncompleteCount() {
        return this.scrape_incomplete;
    }

    @Override
    public int getScrapeDownloadedCount() {
        return this.scrape_downloaded;
    }

    public void setScrapeResult(int _complete, int _incomplete, int _downloaded) {
        this.scrape_complete = _complete;
        this.scrape_incomplete = _incomplete;
        if (_downloaded >= 0) {
            this.scrape_downloaded = _downloaded;
        }
    }

    @Override
    public void print() {
        System.out.println("TRTrackerResponse::print");
        System.out.println("\tstatus = " + this.getStatus() + ", probe = " + this.was_udp_probe);
        System.out.println("\tfail msg = " + this.getAdditionalInfo());
        System.out.println("\tpeers:");
        if (this.peers != null) {
            int i = 0;
            while (i < this.peers.length) {
                TRTrackerAnnouncerResponsePeer peer = this.peers[i];
                System.out.println("\t\t" + peer.getAddress() + ":" + peer.getPort());
                ++i;
            }
        }
    }

    public String getString() {
        String str = "url=" + this.url + ", status=" + this.getStatus() + ", probe=" + this.was_udp_probe;
        if (this.getStatus() != 2) {
            str = String.valueOf(str) + ", error=" + this.getAdditionalInfo();
        }
        str = String.valueOf(str) + ", time_to_wait=" + this.time_to_wait;
        str = String.valueOf(str) + ", scrape_comp=" + this.scrape_complete + ", scrape_incomp=" + this.scrape_incomplete;
        return str;
    }
}

