/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;

public class TorrentOpenFileOptions {
    public final String orgFullName;
    public final String orgFileName;
    public final long lSize;
    private boolean toDownload;
    private int priority;
    private String destFileName;
    private String destPathName;
    private boolean didManualRename;
    private final int iIndex;
    public boolean isValid;
    public final TorrentOpenOptions parent;

    public TorrentOpenFileOptions(TorrentOpenOptions parent, int iIndex, String orgFullName, String orgFileName, long lSize, boolean wanted) {
        this.parent = parent;
        this.iIndex = iIndex;
        this.orgFullName = orgFullName;
        this.orgFileName = orgFileName;
        this.lSize = lSize;
        this.setToDownload(wanted);
        this.isValid = true;
    }

    public int getIndex() {
        return this.iIndex;
    }

    public void setFullDestName(String newFullName) {
        if (newFullName == null) {
            this.setDestPathName(null);
            this.setDestFileName(null, true);
            return;
        }
        File newPath = new File(newFullName);
        this.setDestPathName(newPath.getParent());
        this.setDestFileName(newPath.getName(), true);
    }

    public void setDestPathName(String newPath) {
        if (this.parent.getTorrent().isSimpleTorrent()) {
            this.parent.setParentDir(newPath);
        } else {
            this.destPathName = newPath;
        }
    }

    public void setDestFileName(String newFileName, boolean manualRename) {
        if (this.orgFileName.equals(newFileName)) {
            this.destFileName = null;
            this.didManualRename = false;
        } else {
            this.destFileName = newFileName;
            this.didManualRename = manualRename;
        }
    }

    public String getDestPathName() {
        if (this.destPathName != null) {
            return this.destPathName;
        }
        if (this.parent.getTorrent().isSimpleTorrent()) {
            return this.parent.getParentDir();
        }
        return new File(this.parent.getDataDir(), this.orgFullName).getParent();
    }

    public boolean isManualRename() {
        return this.didManualRename;
    }

    public String getDestFileName() {
        return this.destFileName == null ? this.orgFileName : this.destFileName;
    }

    public File getDestFileFullName() {
        String path = this.getDestPathName();
        String file = this.getDestFileName();
        return new File(path, file);
    }

    public boolean okToDisable() {
        return this.parent.okToDisableAll();
    }

    public File getInitialLink() {
        return this.parent.getInitialLinkage(this.iIndex);
    }

    public boolean isLinked() {
        return this.destFileName != null || this.destPathName != null;
    }

    public boolean isToDownload() {
        return this.toDownload;
    }

    public void setToDownload(boolean toDownload) {
        this.toDownload = toDownload;
        this.parent.fileDownloadStateChanged(this, toDownload);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int _priority) {
        this.priority = _priority;
        this.parent.filePriorityStateChanged(this, _priority);
    }
}

