/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.download.impl.DownloadManagerRateController;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;

public class DownloadManagerController
extends LogRelation
implements PEPeerManagerAdapter,
PeerManagerRegistrationAdapter,
SimpleTimer.TimerTickReceiver {
    private static final long STATE_FLAG_HASDND = 1L;
    private static final long STATE_FLAG_COMPLETE_NO_DND = 2L;
    private static long skeleton_builds;
    private static boolean tracker_stats_exclude_lan;
    private static ExternalSeedPlugin ext_seed_plugin;
    private static boolean ext_seed_plugin_tried;
    private static final int LDT_DL_ADDED = 1;
    private static final int LDT_DL_REMOVED = 2;
    static final ListenerManager disk_listeners_agregator;
    private final ListenerManager disk_listeners = ListenerManager.createManager("DMC:DiskListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            disk_listeners_agregator.dispatch(listener, type, value);
        }
    });
    private final AEMonitor disk_listeners_mon = new AEMonitor("DownloadManagerController:DL");
    final AEMonitor control_mon = new AEMonitor("DownloadManagerController");
    private final AEMonitor state_mon = new AEMonitor("DownloadManagerController:State");
    final AEMonitor facade_mon = new AEMonitor("DownloadManagerController:Facade");
    final DownloadManagerImpl download_manager;
    final DownloadManagerStatsImpl stats;
    private volatile int state_set_by_method = -1;
    private volatile int substate;
    private volatile boolean force_start;
    private volatile DiskManager disk_manager_use_accessors;
    private DiskManagerListener disk_manager_listener_use_accessors;
    final FileInfoFacadeSet fileFacadeSet = new FileInfoFacadeSet();
    private boolean files_facade_destroyed;
    private boolean cached_complete_excluding_dnd;
    private boolean cached_has_dnd_files;
    private boolean cached_values_set;
    private Set<String> cached_networks;
    final Object cached_networks_lock = new Object();
    private PeerManagerRegistration peer_manager_registration;
    private PEPeerManager peer_manager;
    private List<Object[]> external_rate_limiters_cow;
    private String errorDetail;
    private int errorType = 0;
    final GlobalManagerStats global_stats;
    private boolean bInitialized = false;
    private long data_send_rate_at_close;
    private static final int ACTIVATION_REBUILD_TIME = 600000;
    private static final int BLOOM_SIZE = 64;
    private volatile BloomFilter activation_bloom;
    private volatile long activation_bloom_create_time = SystemTime.getCurrentTime();
    private volatile int activation_count;
    private volatile long activation_count_time;
    private boolean piece_checking_enabled = true;
    private long priority_connection_count;
    private static final int HTTP_SEEDS_MAX = 64;
    private final LinkedList<ExternalSeedPeer> http_seeds = new LinkedList();
    private int md_info_dict_size;
    private volatile WeakReference<byte[]> md_info_dict_ref = new WeakReference<Object>(null);
    private static final int MD_INFO_PEER_HISTORY_MAX = 128;
    private final Map<String, int[]> md_info_peer_history = new LinkedHashMap<String, int[]>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, int[]> eldest) {
            return this.size() > 128;
        }
    };

    static {
        COConfigurationManager.addAndFireParameterListener("Tracker Client Exclude LAN", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                tracker_stats_exclude_lan = COConfigurationManager.getBooleanParameter(name);
            }
        });
        disk_listeners_agregator = ListenerManager.createAsyncManager("DMC:DiskListenAgregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DownloadManagerDiskListener listener = (DownloadManagerDiskListener)_listener;
                if (type == 1) {
                    listener.diskManagerAdded((DiskManager)value);
                } else if (type == 2) {
                    listener.diskManagerRemoved((DiskManager)value);
                }
            }
        });
    }

    public static ExternalSeedPlugin getExternalSeedPlugin() {
        if (!ext_seed_plugin_tried) {
            ext_seed_plugin_tried = true;
            try {
                PluginInterface ext_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(ExternalSeedPlugin.class);
                if (ext_pi != null) {
                    ext_seed_plugin = (ExternalSeedPlugin)ext_pi.getPlugin();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return ext_seed_plugin;
    }

    protected DownloadManagerController(DownloadManagerImpl _download_manager) {
        this.download_manager = _download_manager;
        GlobalManager gm = this.download_manager.getGlobalManager();
        this.global_stats = gm.getStats();
        this.stats = (DownloadManagerStatsImpl)this.download_manager.getStats();
        this.cached_values_set = false;
    }

    protected void setInitialState(int initial_state) {
        DownloadManagerState state;
        block7: {
            this.bInitialized = true;
            if (this.getState() == -1) {
                this.setState(initial_state, true);
            }
            state = this.download_manager.getDownloadState();
            TOTorrent torrent = this.download_manager.getTorrent();
            if (torrent != null) {
                try {
                    this.peer_manager_registration = PeerManager.getSingleton().registerLegacyManager(torrent.getHashWrapper(), this);
                    this.md_info_dict_size = state.getIntAttribute("mdinfodictsize");
                    if (this.md_info_dict_size != 0) break block7;
                    try {
                        this.md_info_dict_size = BEncoder.encode((Map)torrent.serialiseToMap().get("info")).length;
                    }
                    catch (Throwable e) {
                        this.md_info_dict_size = -1;
                    }
                    state.setIntAttribute("mdinfodictsize", this.md_info_dict_size);
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (state.parameterExists("dndflags")) {
            long flags = state.getLongParameter("dndflags");
            this.cached_complete_excluding_dnd = (flags & 2L) != 0L;
            this.cached_has_dnd_files = (flags & 1L) != 0L;
            this.cached_values_set = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startDownload(TRTrackerAnnouncer tracker_client) {
        List<Object[]> limiters;
        DiskManager dm;
        try {
            this.control_mon.enter();
            if (this.getState() != 40) {
                Debug.out("DownloadManagerController::startDownload state must be ready, " + this.getState());
                this.setFailed("Inconsistent download state: startDownload, state = " + this.getState());
                return;
            }
            if (tracker_client == null) {
                Debug.out("DownloadManagerController:startDownload: tracker_client is null");
                this.stopIt(70, false, false, false);
                return;
            }
            if (this.peer_manager != null) {
                Debug.out("DownloadManagerController::startDownload: peer manager not null");
                this.peer_manager.stopAll();
                SimpleTimer.removeTickReceiver(this);
                DownloadManagerRateController.removePeerManager(this.peer_manager);
                this.peer_manager = null;
            }
            if ((dm = this.getDiskManager()) == null) {
                Debug.out("DownloadManagerController::startDownload: disk manager is null");
                return;
            }
            this.setState(50, false);
        }
        finally {
            this.control_mon.exit();
        }
        this.cacheNetworks();
        final PEPeerManager temp = PEPeerManagerFactory.create(tracker_client.getPeerId(), this, dm);
        this.download_manager.informWillBeStarted(temp);
        temp.start();
        tracker_client.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){
            private final PEPeerManagerStats pm_stats;
            private long last_reported_total_received;
            private long last_reported_total_received_data;
            private long last_reported_total_received_discard;
            private long last_reported_total_received_failed;
            {
                this.pm_stats = pEPeerManager.getStats();
            }

            @Override
            public String getName() {
                return DownloadManagerController.this.getDisplayName();
            }

            @Override
            public long getTotalSent() {
                return tracker_stats_exclude_lan ? this.pm_stats.getTotalDataBytesSentNoLan() : this.pm_stats.getTotalDataBytesSent();
            }

            @Override
            public long getTotalReceived() {
                long received = tracker_stats_exclude_lan ? this.pm_stats.getTotalDataBytesReceivedNoLan() : this.pm_stats.getTotalDataBytesReceived();
                long discarded = this.pm_stats.getTotalDiscarded();
                long failed = this.pm_stats.getTotalHashFailBytes();
                long verified = received - (discarded + failed);
                if ((verified -= temp.getHiddenBytes()) < this.last_reported_total_received) {
                    verified = this.last_reported_total_received;
                    if (this.last_reported_total_received_data != -1L) {
                        this.last_reported_total_received_data = -1L;
                    }
                } else {
                    this.last_reported_total_received = verified;
                    this.last_reported_total_received_data = received;
                    this.last_reported_total_received_discard = discarded;
                    this.last_reported_total_received_failed = failed;
                }
                return verified < 0L ? 0L : verified;
            }

            @Override
            public long getRemaining() {
                return Math.max(temp.getRemaining(), temp.getHiddenBytes());
            }

            @Override
            public long getFailedHashCheck() {
                return this.pm_stats.getTotalHashFailBytes();
            }

            @Override
            public String getExtensions() {
                return DownloadManagerController.this.getTrackerClientExtensions();
            }

            @Override
            public int getMaxNewConnectionsAllowed(String network) {
                return temp.getMaxNewConnectionsAllowed(network);
            }

            @Override
            public int getPendingConnectionCount() {
                return temp.getPendingPeerCount();
            }

            @Override
            public int getConnectedConnectionCount() {
                return temp.getNbPeers() + temp.getNbSeeds();
            }

            @Override
            public int getUploadSpeedKBSec(boolean estimate) {
                long current_local = DownloadManagerController.this.stats.getDataSendRate();
                if (estimate && (current_local = DownloadManagerController.this.data_send_rate_at_close) == 0L) {
                    int old_global;
                    int current_global = DownloadManagerController.this.global_stats.getDataSendRate();
                    if (current_global < (old_global = DownloadManagerController.this.global_stats.getDataSendRateAtClose())) {
                        current_global = old_global;
                    }
                    List<DownloadManager> managers = DownloadManagerController.this.download_manager.getGlobalManager().getDownloadManagers();
                    int num_dls = 0;
                    int i = 0;
                    while (i < managers.size()) {
                        int state;
                        DownloadManager dm = managers.get(i);
                        if (dm.getStats().getDownloadCompleted(false) != 1000 && (state = dm.getState()) != 100 && state != 65 && state != 70) {
                            ++num_dls;
                        }
                        ++i;
                    }
                    current_local = num_dls == 0 ? (long)current_global : (long)(current_global / num_dls);
                }
                return (int)((current_local + 1023L) / 1024L);
            }

            @Override
            public int getCryptoLevel() {
                return DownloadManagerController.this.download_manager.getCryptoLevel();
            }

            @Override
            public void setPeerSources(String[] allowed_sources) {
                DownloadManagerState dms = DownloadManagerController.this.download_manager.getDownloadState();
                String[] sources = PEPeerSource.PS_SOURCES;
                int i = 0;
                while (i < sources.length) {
                    String s = sources[i];
                    boolean ok = false;
                    int j = 0;
                    while (j < allowed_sources.length) {
                        if (s.equals(allowed_sources[j])) {
                            ok = true;
                            break;
                        }
                        ++j;
                    }
                    if (!ok) {
                        dms.setPeerSourcePermitted(s, false);
                    }
                    ++i;
                }
                PEPeerManager pm = DownloadManagerController.this.getPeerManager();
                if (pm != null) {
                    HashSet<String> allowed = new HashSet<String>();
                    allowed.addAll(Arrays.asList(allowed_sources));
                    for (PEPeer peer : pm.getPeers()) {
                        if (allowed.contains(peer.getPeerSource())) continue;
                        pm.removePeer(peer, "Peer source not permitted");
                    }
                }
            }

            @Override
            public boolean isPeerSourceEnabled(String peer_source) {
                return DownloadManagerController.this.isPeerSourceEnabled(peer_source);
            }
        });
        try {
            this.control_mon.enter();
            this.peer_manager = temp;
            DownloadManagerRateController.addPeerManager(this.peer_manager);
            SimpleTimer.addTickReceiver(this);
            limiters = this.external_rate_limiters_cow;
        }
        finally {
            this.control_mon.exit();
        }
        if (limiters != null) {
            int i = 0;
            while (i < limiters.size()) {
                Object[] entry = limiters.get(i);
                temp.addRateLimiter((LimitedRateGroup)entry[0], (Boolean)entry[1]);
                ++i;
            }
        }
        if (this.getState() == 50) {
            this.download_manager.informStateChanged();
        }
        this.download_manager.informStarted(temp);
    }

    public void initializeDiskManager(boolean open_for_seeding) {
        this.initializeDiskManagerSupport(10, new DiskManagerListener_Default(open_for_seeding));
    }

    protected void initializeDiskManagerSupport(int initialising_state, DiskManagerListener listener) {
        try {
            this.control_mon.enter();
            int entry_state = this.getState();
            if (entry_state != 0 && entry_state != 70 && entry_state != 75 && entry_state != 100) {
                Debug.out("DownloadManagerController::initializeDiskManager: Illegal initialize state, " + entry_state);
                this.setFailed("Inconsistent download state: initSupport, state = " + entry_state);
                return;
            }
            DiskManager old_dm = this.getDiskManager();
            if (old_dm != null) {
                Debug.out("DownloadManagerController::initializeDiskManager: disk manager is not null");
                old_dm.stop(false);
                this.setDiskManager(null, null);
            }
            this.errorDetail = "";
            this.errorType = 0;
            this.setState(initialising_state, false);
            DiskManager dm = DiskManagerFactory.create(this.download_manager.getTorrent(), this.download_manager);
            this.setDiskManager(dm, listener);
        }
        finally {
            this.control_mon.exit();
            this.download_manager.informStateChanged();
        }
    }

    public boolean canForceRecheck() {
        int state = this.getState();
        return state == 70 || state == 75 || state == 100 && this.getDiskManager() == null;
    }

    public void forceRecheck(ForceRecheckListener l) {
        try {
            this.control_mon.enter();
            if (this.getDiskManager() != null || !this.canForceRecheck()) {
                Debug.out("DownloadManagerController::forceRecheck: illegal entry state");
                return;
            }
            int start_state = this.getState();
            this.download_manager.getDownloadState().clearResumeData();
            boolean wasForceStarted = this.force_start;
            this.force_start = true;
            this.download_manager.setDataAlreadyAllocated(false);
            this.initializeDiskManagerSupport(30, new forceRecheckDiskManagerListener(wasForceStarted, start_state, l));
        }
        finally {
            this.control_mon.exit();
        }
    }

    public void setPieceCheckingEnabled(boolean enabled) {
        this.piece_checking_enabled = enabled;
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            dm.setPieceCheckingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void stopIt(int _stateAfterStopping, boolean remove_torrent, boolean remove_data, boolean for_removal) {
        current_up = this.stats.getDataSendRate();
        if (current_up != 0L) {
            this.data_send_rate_at_close = current_up;
        }
        v0 = closing = _stateAfterStopping == 71;
        if (closing) {
            _stateAfterStopping = 70;
        }
        stateAfterStopping = _stateAfterStopping;
        try {
            this.control_mon.enter();
            state = this.getState();
            if (state == 70 || state == 100 && this.getDiskManager() == null) {
                if (remove_data) {
                    this.download_manager.deleteDataFiles();
                } else if (for_removal && COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                    this.download_manager.deletePartialDataFiles();
                }
                if (remove_torrent) {
                    this.download_manager.deleteTorrentFile();
                }
                this.setState(_stateAfterStopping, false);
                return;
            }
            try {
                if (state == 65) ** continue;
                this.setSubState(_stateAfterStopping);
                this.setState(65, false);
                nd_sem = new AESemaphore("DM:DownloadManager.NDTR");
                NonDaemonTaskRunner.runAsync(new NonDaemonTask(){

                    @Override
                    public Object run() {
                        nd_sem.reserve();
                        return null;
                    }

                    @Override
                    public String getName() {
                        return "Stopping '" + DownloadManagerController.this.getDisplayName() + "'";
                    }
                });
                try {
                    block44: {
                        try {
                            if (this.peer_manager != null) {
                                this.peer_manager.stopAll();
                                this.stats.saveSessionTotals();
                                dmState = this.download_manager.getDownloadState();
                                dmState.setLongParameter("stats.download.last.active.time", SystemTime.getCurrentTime());
                                SimpleTimer.removeTickReceiver(this);
                                DownloadManagerRateController.removePeerManager(this.peer_manager);
                            }
                            this.download_manager.informStopped(this.peer_manager, stateAfterStopping == 75);
                            this.peer_manager = null;
                            dm = this.getDiskManager();
                            if (dm != null) {
                                went_async = dm.stop(closing);
                                if (went_async) {
                                    wait_count = 0;
                                    Thread.sleep(10L);
                                    while (!dm.isStopped()) {
                                        if (++wait_count > 1200) {
                                            Debug.out("Download stop took too long to complete");
                                            break;
                                        }
                                        if (wait_count % 200 == 0) {
                                            Debug.out("Waiting for download to stop - elapsed=" + wait_count + " sec");
                                        }
                                        Thread.sleep(100L);
                                    }
                                }
                                this.stats.setCompleted(this.stats.getCompleted());
                                this.stats.recalcDownloadCompleteBytes();
                                if (!this.download_manager.getAssumedComplete()) {
                                    this.download_manager.getDownloadState().save();
                                }
                                this.setDiskManager(null, null);
                            }
                            break block44;
                        }
                        catch (Throwable var14_14) {
                            this.force_start = false;
                            if (remove_data) {
                                this.download_manager.deleteDataFiles();
                            } else if (for_removal && COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                                this.download_manager.deletePartialDataFiles();
                            }
                            if (remove_torrent) {
                                this.download_manager.deleteTorrentFile();
                            }
                            to_remove = new ArrayList<ExternalSeedPeer>();
                            var16_17 = this.http_seeds;
                            synchronized (var16_17) {
                                to_remove.addAll(this.http_seeds);
                                this.http_seeds.clear();
                            }
                            ** for (peer : to_remove)
                        }
lbl-1000:
                        // 1 sources

                        {
                            peer.remove();
                            continue;
                        }
lbl82:
                        // 1 sources

                        if (this.getState() == 65) {
                            this.setState(stateAfterStopping, true);
                        }
                        throw var14_14;
                    }
                    this.force_start = false;
                    if (remove_data) {
                        this.download_manager.deleteDataFiles();
                    } else if (for_removal && COConfigurationManager.getBooleanParameter("Delete Partial Files On Library Removal")) {
                        this.download_manager.deletePartialDataFiles();
                    }
                    if (remove_torrent) {
                        this.download_manager.deleteTorrentFile();
                    }
                    to_remove = new ArrayList<ExternalSeedPeer>();
                    peer = this.http_seeds;
                    synchronized (peer) {
                        to_remove.addAll(this.http_seeds);
                        this.http_seeds.clear();
                    }
                    for (Object peer : to_remove) {
                        peer.remove();
                    }
                    if (this.getState() == 65) {
                        this.setState(stateAfterStopping, true);
                    }
                }
                finally {
                    nd_sem.release();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            this.control_mon.exit();
            this.download_manager.informStateChanged();
        }
    }

    protected void setStateWaiting() {
        this.setState(0, true);
    }

    @Override
    public void setStateFinishing() {
        this.setState(55, true);
    }

    public void setStateDownloading() {
        if (this.getState() == 60) {
            this.setState(50, true);
        } else if (this.getState() != 50) {
            Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Trying to set state to downloading when state is not seeding"));
        }
    }

    @Override
    public void setStateSeeding(boolean never_downloaded) {
        this.setStateFinishing();
        this.download_manager.downloadEnded(never_downloaded);
        this.setState(60, true);
    }

    public boolean isStateSeeding() {
        return this.getState() == 60;
    }

    protected void setStateQueued() {
        this.setState(75, true);
    }

    public int getState() {
        if (this.state_set_by_method != 10) {
            return this.state_set_by_method;
        }
        DiskManager dm = this.getDiskManager();
        if (dm == null) {
            return 10;
        }
        int diskManagerState = dm.getState();
        if (diskManagerState == 1) {
            return 10;
        }
        if (diskManagerState == 2) {
            return 20;
        }
        if (diskManagerState == 3) {
            return 30;
        }
        if (diskManagerState == 4) {
            return 40;
        }
        if (diskManagerState == 10) {
            return 100;
        }
        return 100;
    }

    protected int getSubState() {
        if (this.state_set_by_method == 65) {
            return this.substate;
        }
        return this.getState();
    }

    private void setSubState(int ss) {
        this.substate = ss;
    }

    private void setState(int _state, boolean _inform_changed) {
        boolean call_filesExist = false;
        try {
            this.state_mon.enter();
            int old_state = this.state_set_by_method;
            if (old_state != _state) {
                File save_dir_file;
                TOTorrent torrent;
                this.state_set_by_method = _state;
                if (this.state_set_by_method != 75) {
                    this.activation_bloom = null;
                    if (this.state_set_by_method == 70) {
                        this.activation_count = 0;
                    }
                }
                if (this.state_set_by_method != 75 && this.state_set_by_method == 100 && (torrent = this.download_manager.getTorrent()) != null && !torrent.isSimpleTorrent() && (save_dir_file = this.download_manager.getAbsoluteSaveLocation()) != null && save_dir_file.exists() && save_dir_file.isDirectory()) {
                    TorrentUtils.recursiveEmptyDirDelete(save_dir_file, false);
                }
            }
        }
        finally {
            this.state_mon.exit();
        }
        if (call_filesExist) {
            this.filesExist(true);
        }
        if (_inform_changed) {
            this.download_manager.informStateChanged();
        }
    }

    @Override
    public void restartDownload(boolean forceRecheck) {
        boolean was_force_start = this.isForceStart();
        this.stopIt(70, false, false, false);
        if (forceRecheck) {
            this.download_manager.getDownloadState().clearResumeData();
        }
        this.download_manager.initialize();
        if (was_force_start) {
            this.setForceStart(true);
        }
    }

    protected void destroy() {
        if (this.peer_manager_registration != null) {
            this.peer_manager_registration.unregister();
            this.peer_manager_registration = null;
        }
        this.fileFacadeSet.destroyFileInfo();
    }

    @Override
    public boolean isPeerSourceEnabled(String peer_source) {
        return this.download_manager.getDownloadState().isPeerSourceEnabled(peer_source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheNetworks() {
        Object object = this.cached_networks_lock;
        synchronized (object) {
            if (this.cached_networks != null) {
                return;
            }
            DownloadManagerState state = this.download_manager.getDownloadState();
            this.cached_networks = new HashSet<String>(Arrays.asList(state.getNetworks()));
            state.addListener(new DownloadManagerStateAttributeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
                    DownloadManagerState state = DownloadManagerController.this.download_manager.getDownloadState();
                    Object object = DownloadManagerController.this.cached_networks_lock;
                    synchronized (object) {
                        DownloadManagerController.this.cached_networks = new HashSet<String>(Arrays.asList(state.getNetworks()));
                    }
                    PEPeerManager pm = DownloadManagerController.this.peer_manager;
                    if (pm != null) {
                        List<PEPeer> peers = pm.getPeers();
                        for (PEPeer peer : peers) {
                            pm.removePeer(peer, "Networks changed, reconnection required");
                        }
                    }
                }
            }, "networks", 1);
        }
    }

    @Override
    public boolean isNetworkEnabled(String network) {
        Set<String> cache = this.cached_networks;
        if (cache == null) {
            return this.download_manager.getDownloadState().isNetworkEnabled(network);
        }
        return cache.contains(network);
    }

    @Override
    public String[] getEnabledNetworks() {
        Set<String> cache = this.cached_networks;
        if (cache == null) {
            return this.download_manager.getDownloadState().getNetworks();
        }
        return cache.toArray(new String[cache.size()]);
    }

    @Override
    public byte[][] getSecrets() {
        TOTorrent torrent = this.download_manager.getTorrent();
        try {
            byte[] secret1 = torrent.getHash();
            try {
                byte[] secret2 = this.getSecret2(torrent);
                return new byte[][]{secret1, secret2};
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return new byte[][]{secret1};
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new byte[0][];
        }
    }

    @Override
    public byte[][] getSecrets(int crypto_level) {
        TOTorrent torrent = this.download_manager.getTorrent();
        try {
            byte[] secret = crypto_level == 1 ? torrent.getHash() : this.getSecret2(torrent);
            return new byte[][]{secret};
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new byte[0][];
        }
    }

    protected byte[] getSecret2(TOTorrent torrent) throws TOTorrentException {
        AbstractMap secrets_map = this.download_manager.getDownloadState().getMapAttribute("secrets");
        secrets_map = secrets_map == null ? new HashMap() : new LightHashMap(secrets_map);
        if (secrets_map.size() == 0) {
            secrets_map.put("p1", torrent.getPieces()[0]);
            this.download_manager.getDownloadState().setMapAttribute("secrets", secrets_map);
        }
        return (byte[])secrets_map.get("p1");
    }

    @Override
    public boolean manualRoute(NetworkConnection connection) {
        return false;
    }

    @Override
    public long getRandomSeed() {
        return this.download_manager.getDownloadState().getLongParameter("rand");
    }

    public void addRateLimiter(LimitedRateGroup group, boolean upload) {
        PEPeerManager pm;
        try {
            this.control_mon.enter();
            ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow == null ? 1 : this.external_rate_limiters_cow.size() + 1);
            if (this.external_rate_limiters_cow != null) {
                new_limiters.addAll(this.external_rate_limiters_cow);
            }
            new_limiters.add(new Object[]{group, upload});
            this.external_rate_limiters_cow = new_limiters;
            pm = this.peer_manager;
        }
        finally {
            this.control_mon.exit();
        }
        if (pm != null) {
            pm.addRateLimiter(group, upload);
        }
    }

    public LimitedRateGroup[] getRateLimiters(boolean upload) {
        try {
            this.control_mon.enter();
            if (this.external_rate_limiters_cow == null) {
                LimitedRateGroup[] limitedRateGroupArray = new LimitedRateGroup[]{};
                return limitedRateGroupArray;
            }
            ArrayList<LimitedRateGroup> result = new ArrayList<LimitedRateGroup>();
            for (Object[] entry : this.external_rate_limiters_cow) {
                if ((Boolean)entry[1] != upload) continue;
                result.add((LimitedRateGroup)entry[0]);
            }
            LimitedRateGroup[] limitedRateGroupArray = result.toArray(new LimitedRateGroup[result.size()]);
            return limitedRateGroupArray;
        }
        finally {
            this.control_mon.exit();
        }
    }

    public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
        PEPeerManager pm;
        try {
            this.control_mon.enter();
            if (this.external_rate_limiters_cow != null) {
                ArrayList<Object[]> new_limiters = new ArrayList<Object[]>(this.external_rate_limiters_cow.size() - 1);
                int i = 0;
                while (i < this.external_rate_limiters_cow.size()) {
                    Object[] entry = this.external_rate_limiters_cow.get(i);
                    if (entry[0] != group) {
                        new_limiters.add(entry);
                    }
                    ++i;
                }
                this.external_rate_limiters_cow = new_limiters.size() == 0 ? null : new_limiters;
            }
            pm = this.peer_manager;
        }
        finally {
            this.control_mon.exit();
        }
        if (pm != null) {
            pm.removeRateLimiter(group, upload);
        }
    }

    @Override
    public void enqueueReadRequest(PEPeer peer, DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.getDiskManager().enqueueReadRequest(request2, listener);
    }

    @Override
    public boolean activateRequest(InetSocketAddress address) {
        if (this.getState() == 75) {
            byte[] address_bytes;
            int hit_count;
            BloomFilter bloom = this.activation_bloom;
            if (bloom == null) {
                this.activation_bloom = bloom = BloomFilterFactory.createAddRemove4Bit(64);
            }
            if ((hit_count = bloom.add(address_bytes = AddressUtils.getAddressBytes(address))) > 5) {
                Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Activate request for " + this.getDisplayName() + " from " + address + " denied as too many recently received"));
                return false;
            }
            Logger.log(new LogEvent(this, LogIDs.CORE, "Activate request for " + this.getDisplayName() + " from " + address));
            long now = SystemTime.getCurrentTime();
            if (now < this.activation_bloom_create_time || now - this.activation_bloom_create_time > 600000L) {
                this.activation_bloom = BloomFilterFactory.createAddRemove4Bit(64);
                this.activation_bloom_create_time = now;
            }
            this.activation_count = bloom.getEntryCount();
            this.activation_count_time = now;
            return this.download_manager.activateRequest(this.activation_count);
        }
        return false;
    }

    @Override
    public void deactivateRequest(InetSocketAddress address) {
        BloomFilter bloom = this.activation_bloom;
        if (bloom != null) {
            byte[] address_bytes = AddressUtils.getAddressBytes(address);
            int count = bloom.count(address_bytes);
            int i = 0;
            while (i < count) {
                bloom.remove(address_bytes);
                ++i;
            }
            this.activation_count = bloom.getEntryCount();
        }
    }

    public int getActivationCount() {
        long now = SystemTime.getCurrentTime();
        if (now < this.activation_count_time) {
            this.activation_count_time = now;
        } else if (now - this.activation_count_time > 600000L) {
            this.activation_count = 0;
        }
        return this.activation_count;
    }

    @Override
    public PeerManagerRegistration getPeerManagerRegistration() {
        return this.peer_manager_registration;
    }

    public boolean isForceStart() {
        return this.force_start;
    }

    public void setForceStart(boolean _force_start) {
        try {
            this.state_mon.enter();
            if (this.force_start != _force_start) {
                this.force_start = _force_start;
                int state = this.getState();
                if (this.force_start && (state == 70 || state == 75)) {
                    this.setState(0, false);
                }
            }
        }
        finally {
            this.state_mon.exit();
        }
        this.download_manager.informStateChanged();
    }

    private void setFailed(DiskManager dm) {
        this.setFailed(dm.getErrorType(), dm.getErrorMessage());
    }

    protected void setFailed(String reason) {
        this.setFailed(1, reason);
    }

    private void setFailed(int type, String reason) {
        if (reason != null) {
            this.errorDetail = reason;
        }
        this.errorType = type;
        this.stopIt(100, false, false, false);
    }

    public boolean filesExist(boolean expected_to_be_allocated) {
        if (!expected_to_be_allocated && !this.download_manager.isDataAlreadyAllocated()) {
            return false;
        }
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            return dm.filesExist();
        }
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        DiskManagerFileInfo[] files = this.fileFacadeSet.getFiles();
        int i = 0;
        while (i < files.length) {
            DiskManagerFileInfo fileInfo2 = files[i];
            if (!fileInfo2.isSkipped()) {
                File file;
                block10: {
                    file = fileInfo2.getFile(true);
                    try {
                        File save_path;
                        long start = SystemTime.getMonotonousTime();
                        boolean exists = file.exists();
                        long elapsed = SystemTime.getMonotonousTime() - start;
                        if (elapsed >= 500L) {
                            Debug.out("Accessing '" + file.getAbsolutePath() + "' in '" + this.getDisplayName() + "' took " + elapsed + "ms - possibly offline");
                        }
                        if (exists) break block10;
                        if (!this.download_manager.getTorrent().isSimpleTorrent() && FileUtil.isAncestorOf(save_path = this.download_manager.getAbsoluteSaveLocation(), file) && !save_path.exists()) {
                            file = save_path;
                        }
                        this.setFailed(String.valueOf(MessageText.getString("DownloadManager.error.datamissing")) + " " + file);
                        return false;
                    }
                    catch (Exception e) {
                        this.setFailed(e.getMessage());
                        return false;
                    }
                }
                if (fileInfo2.getLength() < file.length() && !COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                    this.setFailed(String.valueOf(MessageText.getString("DownloadManager.error.badsize")) + " " + file + "(" + fileInfo2.getLength() + "/" + file.length() + ")");
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public DiskManagerFileInfoSet getDiskManagerFileInfoSet() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        return this.fileFacadeSet;
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        return this.fileFacadeSet.getFiles();
    }

    protected void fileInfoChanged() {
        this.fileFacadeSet.makeSureFilesFacadeFilled(true);
    }

    protected void filePrioritiesChanged(List files) {
        if (!this.cached_values_set) {
            this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files && files.size() == 1 && !((DiskManagerFileInfo)files.get(0)).isSkipped()) {
            return;
        }
        this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        this.calculateCompleteness(this.fileFacadeSet.facadeFiles);
    }

    protected void calculateCompleteness(DiskManagerFileInfo[] active) {
        boolean complete_excluding_dnd = true;
        boolean has_dnd_files = false;
        int i = 0;
        while (i < active.length) {
            DiskManagerFileInfo file = active[i];
            if (file.isSkipped()) {
                has_dnd_files = true;
            } else if (file.getDownloaded() != file.getLength()) {
                complete_excluding_dnd = false;
            }
            if (has_dnd_files && !complete_excluding_dnd) break;
            ++i;
        }
        this.cached_complete_excluding_dnd = complete_excluding_dnd;
        this.cached_has_dnd_files = has_dnd_files;
        this.cached_values_set = true;
        DownloadManagerState state = this.download_manager.getDownloadState();
        long flags = (this.cached_complete_excluding_dnd ? 2L : 0L) | (this.cached_has_dnd_files ? 1L : 0L);
        state.setLongParameter("dndflags", flags);
    }

    protected boolean isDownloadComplete(boolean bIncludeDND) {
        int dm_state;
        if (!this.cached_values_set) {
            this.fileFacadeSet.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files) {
            return this.stats.getRemaining() == 0L;
        }
        DiskManager dm = this.getDiskManager();
        if (dm != null && (dm_state = dm.getState()) == 4) {
            long remaining;
            long l = remaining = bIncludeDND ? dm.getRemaining() : dm.getRemainingExcludingDND();
            return remaining == 0L;
        }
        if (bIncludeDND) {
            return false;
        }
        return this.cached_complete_excluding_dnd;
    }

    protected PEPeerManager getPeerManager() {
        return this.peer_manager;
    }

    protected DiskManager getDiskManager() {
        return this.disk_manager_use_accessors;
    }

    protected String getErrorDetail() {
        return this.errorDetail;
    }

    protected int getErrorType() {
        return this.errorType;
    }

    protected void setDiskManager(DiskManager new_disk_manager, DiskManagerListener new_disk_manager_listener) {
        if (new_disk_manager != null) {
            new_disk_manager.setPieceCheckingEnabled(this.piece_checking_enabled);
        }
        try {
            this.disk_listeners_mon.enter();
            DiskManager old_disk_manager = this.disk_manager_use_accessors;
            if (old_disk_manager != null && this.disk_manager_listener_use_accessors != null) {
                old_disk_manager.removeListener(this.disk_manager_listener_use_accessors);
            }
            this.disk_manager_use_accessors = new_disk_manager;
            this.disk_manager_listener_use_accessors = new_disk_manager_listener;
            if (new_disk_manager != null) {
                new_disk_manager.addListener(new_disk_manager_listener);
            }
            this.fileInfoChanged();
            if (new_disk_manager == null && old_disk_manager != null) {
                this.disk_listeners.dispatch(2, old_disk_manager);
            } else if (new_disk_manager != null && old_disk_manager == null) {
                this.disk_listeners.dispatch(1, new_disk_manager);
            } else {
                Debug.out("inconsistent DiskManager state - " + new_disk_manager + "/" + old_disk_manager);
            }
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    public void addDiskListener(DownloadManagerDiskListener listener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.addListener(listener);
            DiskManager dm = this.getDiskManager();
            if (dm != null) {
                this.disk_listeners.dispatch(listener, 1, dm);
            }
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    public void removeDiskListener(DownloadManagerDiskListener listener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.removeListener(listener);
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    public long getDiskListenerCount() {
        return this.disk_listeners.size();
    }

    @Override
    public String getDisplayName() {
        return this.download_manager.getDisplayName();
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.download_manager.getEffectiveUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.stats.getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public int getPermittedBytesToReceive() {
        return NetworkManager.getSingleton().getRateHandler(false, false).getCurrentNumBytesAllowed()[0];
    }

    @Override
    public void permittedReceiveBytesUsed(int bytes) {
        NetworkManager.getSingleton().getRateHandler(false, false).bytesProcessed(bytes, 0);
    }

    @Override
    public int getPermittedBytesToSend() {
        return NetworkManager.getSingleton().getRateHandler(true, false).getCurrentNumBytesAllowed()[0];
    }

    @Override
    public void permittedSendBytesUsed(int bytes) {
        NetworkManager.getSingleton().getRateHandler(true, false).bytesProcessed(bytes, 0);
    }

    @Override
    public int getMaxUploads() {
        return this.download_manager.getEffectiveMaxUploads();
    }

    @Override
    public int[] getMaxConnections() {
        int[] result = this.download_manager.isMaxConnectionsWhenSeedingEnabled() && this.isStateSeeding() ? this.download_manager.getMaxConnectionsWhenSeeding(this.getEnabledNetworks().length > 1) : this.download_manager.getMaxConnections(this.getEnabledNetworks().length > 1);
        return result;
    }

    @Override
    public int[] getMaxSeedConnections() {
        return this.download_manager.getMaxSeedConnections(this.getEnabledNetworks().length > 1);
    }

    @Override
    public int getUploadPriority() {
        return this.download_manager.getEffectiveUploadPriority();
    }

    @Override
    public int getExtendedMessagingMode() {
        return this.download_manager.getExtendedMessagingMode();
    }

    @Override
    public boolean isPeerExchangeEnabled() {
        return this.download_manager.getDownloadState().isPeerSourceEnabled("PeerExchange");
    }

    @Override
    public int getCryptoLevel() {
        return this.download_manager.getCryptoLevel();
    }

    @Override
    public boolean isPeriodicRescanEnabled() {
        return this.download_manager.getDownloadState().getFlag(2L);
    }

    @Override
    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        return this.download_manager.getTrackerScrapeResponse();
    }

    @Override
    public String getTrackerClientExtensions() {
        return this.download_manager.getDownloadState().getTrackerClientExtensions();
    }

    @Override
    public void setTrackerRefreshDelayOverrides(int percent) {
        this.download_manager.setTrackerRefreshDelayOverrides(percent);
    }

    @Override
    public boolean isNATHealthy() {
        return this.download_manager.getNATStatus() == 1;
    }

    @Override
    public boolean isMetadataDownload() {
        return this.download_manager.getDownloadState().getFlag(512L);
    }

    @Override
    public int getTorrentInfoDictSize() {
        return this.md_info_dict_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getTorrentInfoDict(PEPeer peer) {
        try {
            String ip = peer.getIp();
            Map<String, int[]> map = this.md_info_peer_history;
            synchronized (map) {
                int now_secs = (int)(SystemTime.getMonotonousTime() / 1000L);
                int[] stats = this.md_info_peer_history.get(ip);
                if (stats == null) {
                    int[] nArray = new int[2];
                    nArray[0] = now_secs;
                    stats = nArray;
                    this.md_info_peer_history.put(ip, stats);
                }
                if (now_secs - stats[0] > 300) {
                    stats[1] = 16384;
                } else {
                    int bytes = stats[1];
                    if (bytes >= this.md_info_dict_size * 3) {
                        return null;
                    }
                    stats[1] = bytes + 16384;
                }
            }
            byte[] data = (byte[])this.md_info_dict_ref.get();
            if (data == null) {
                TOTorrent torrent = this.download_manager.getTorrent();
                data = BEncoder.encode((Map)torrent.serialiseToMap().get("info"));
                this.md_info_dict_ref = new WeakReference<byte[]>(data);
            }
            return data;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void addPeer(PEPeer peer) {
        this.download_manager.addPeer(peer);
    }

    @Override
    public void removePeer(PEPeer peer) {
        this.download_manager.removePeer(peer);
    }

    @Override
    public void addPiece(PEPiece piece) {
        this.download_manager.addPiece(piece);
    }

    @Override
    public void removePiece(PEPiece piece) {
        this.download_manager.removePiece(piece);
    }

    @Override
    public void discarded(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.discarded(bytes);
        }
    }

    @Override
    public void protocolBytesReceived(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesReceived(bytes, peer.isLANLocal());
        }
    }

    @Override
    public void dataBytesReceived(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesReceived(bytes, peer.isLANLocal());
        }
    }

    @Override
    public void protocolBytesSent(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesSent(bytes, peer.isLANLocal());
        }
    }

    @Override
    public void dataBytesSent(PEPeer peer, int bytes) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesSent(bytes, peer.isLANLocal());
        }
    }

    @Override
    public int getPosition() {
        return this.download_manager.getPosition();
    }

    @Override
    public void tick(long mono_now, int tick_count) {
        this.stats.timerTick(tick_count);
    }

    @Override
    public void statsRequest(PEPeer originator, Map request2, Map reply) {
        GlobalManager gm = this.download_manager.getGlobalManager();
        gm.statsRequest(request2, reply);
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        reply.put("dl", info);
        try {
            info.put("u_lim", new Long(this.getUploadRateLimitBytesPerSecond()));
            info.put("d_lim", new Long(this.getDownloadRateLimitBytesPerSecond()));
            info.put("u_rate", new Long(this.stats.getProtocolSendRate() + this.stats.getDataSendRate()));
            info.put("d_rate", new Long(this.stats.getProtocolReceiveRate() + this.stats.getDataReceiveRate()));
            info.put("u_slot", new Long(this.getMaxUploads()));
            info.put("c_max", new Long(this.getMaxConnections()[0]));
            info.put("c_leech", new Long(this.download_manager.getNbPeers()));
            info.put("c_seed", new Long(this.download_manager.getNbSeeds()));
            PEPeerManager pm = this.peer_manager;
            if (pm != null) {
                info.put("c_rem", Integer.valueOf(pm.getNbRemoteTCPConnections()));
                info.put("c_rem_utp", Integer.valueOf(pm.getNbRemoteUTPConnections()));
                info.put("c_rem_udp", Integer.valueOf(pm.getNbRemoteUDPConnections()));
                List<PEPeer> peers = pm.getPeers();
                ArrayList<Long> slot_up = new ArrayList<Long>();
                info.put("slot_up", slot_up);
                for (PEPeer p : peers) {
                    if (p.isChokedByMe()) continue;
                    long up = p.getStats().getDataSendRate() + p.getStats().getProtocolSendRate();
                    slot_up.add(up);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHTTPSeed(String address, int port) {
        block7: {
            ExternalSeedPlugin plugin = DownloadManagerController.getExternalSeedPlugin();
            try {
                if (plugin == null) break block7;
                HashMap<String, Cloneable> config = new HashMap<String, Cloneable>();
                ArrayList<byte[]> urls = new ArrayList<byte[]>();
                String seed_url = "http://" + UrlUtils.convertIPV6Host(address) + ":" + port + "/webseed";
                urls.add(seed_url.getBytes());
                config.put("httpseeds", urls);
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("supports_503", new Long(0L));
                params.put("transient", new Long(1L));
                config.put("httpseeds-params", params);
                List<ExternalSeedPeer> new_seeds = plugin.addSeed(org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl.getDownloadStatic(this.download_manager), config);
                if (new_seeds.size() <= 0) break block7;
                ArrayList<ExternalSeedPeer> to_remove = new ArrayList<ExternalSeedPeer>();
                LinkedList<ExternalSeedPeer> linkedList = this.http_seeds;
                synchronized (linkedList) {
                    this.http_seeds.addAll(new_seeds);
                    while (this.http_seeds.size() > 64) {
                        ExternalSeedPeer x = this.http_seeds.removeFirst();
                        to_remove.add(x);
                    }
                }
                for (ExternalSeedPeer peer : to_remove) {
                    peer.remove();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void priorityConnectionChanged(boolean added) {
        DownloadManagerController downloadManagerController = this;
        synchronized (downloadManagerController) {
            this.priority_connection_count = added ? ++this.priority_connection_count : --this.priority_connection_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPriorityConnection() {
        DownloadManagerController downloadManagerController = this;
        synchronized (downloadManagerController) {
            return this.priority_connection_count > 0L;
        }
    }

    @Override
    public String getDescription() {
        return this.download_manager.getDisplayName();
    }

    @Override
    public LogRelation getLogRelation() {
        return this;
    }

    @Override
    public String getRelationText() {
        return this.download_manager.getRelationText();
    }

    @Override
    public Object[] getQueryableInterfaces() {
        ArrayList<Object> interfaces = new ArrayList<Object>();
        Object[] intf = this.download_manager.getQueryableInterfaces();
        Collections.addAll(interfaces, intf);
        interfaces.add(this.download_manager);
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            interfaces.add(dm);
        }
        return interfaces.toArray();
    }

    public void generateEvidence(IndentWriter writer) {
        writer.println("DownloadManager Controller:");
        writer.indent();
        try {
            writer.println("cached info: complete w/o DND=" + this.cached_complete_excluding_dnd + "; hasDND? " + this.cached_has_dnd_files);
            writer.println("Complete w/DND? " + this.isDownloadComplete(true) + "; w/o DND? " + this.isDownloadComplete(false));
            writer.println("filesFacade length: " + this.fileFacadeSet.nbFiles());
            if (this.force_start) {
                writer.println("Force Start");
            }
            writer.println("FilesExist? " + this.filesExist(this.download_manager.isDataAlreadyAllocated()));
        }
        finally {
            writer.exdent();
        }
    }

    private class DiskManagerListener_Default
    implements DiskManagerListener {
        private final boolean open_for_seeding;

        public DiskManagerListener_Default(boolean open_for_seeding) {
            this.open_for_seeding = open_for_seeding;
        }

        @Override
        public void stateChanged(int oldDMState, int newDMState) {
            DiskManager dm;
            try {
                DownloadManagerController.this.control_mon.enter();
                dm = DownloadManagerController.this.getDiskManager();
                if (dm == null) {
                    return;
                }
            }
            finally {
                DownloadManagerController.this.control_mon.exit();
            }
            try {
                if (newDMState == 10) {
                    DownloadManagerController.this.setFailed(dm);
                }
                if (oldDMState == 3 && newDMState != 3) {
                    DownloadManagerController.this.fileFacadeSet.makeSureFilesFacadeFilled(true);
                    DownloadManagerController.this.stats.recalcDownloadCompleteBytes();
                    DownloadManagerController.this.download_manager.setAssumedComplete(DownloadManagerController.this.isDownloadComplete(false));
                }
                if (newDMState == 4) {
                    int completed = DownloadManagerController.this.stats.getDownloadCompleted(false);
                    if (DownloadManagerController.this.stats.getTotalDataBytesReceived() == 0L && DownloadManagerController.this.stats.getTotalDataBytesSent() == 0L && DownloadManagerController.this.stats.getSecondsDownloading() == 0L) {
                        if (completed < 1000) {
                            if (this.open_for_seeding) {
                                DownloadManagerController.this.setFailed("File check failed");
                                DownloadManagerController.this.download_manager.getDownloadState().clearResumeData();
                            } else {
                                long amount_downloaded = (long)completed * dm.getTotalLength() / 1000L;
                                DownloadManagerController.this.stats.setSavedDownloadedUploaded(amount_downloaded, amount_downloaded);
                            }
                        } else {
                            int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                            if (dl_copies > 0) {
                                DownloadManagerController.this.stats.setSavedDownloadedUploaded(DownloadManagerController.this.download_manager.getSize() * (long)dl_copies, DownloadManagerController.this.stats.getTotalDataBytesSent());
                            }
                            DownloadManagerController.this.download_manager.getDownloadState().setFlag(1L, true);
                        }
                    }
                    if (completed == 1000) {
                        DownloadManagerController.this.download_manager.getDownloadState().discardFluff();
                    }
                }
            }
            finally {
                DownloadManagerController.this.download_manager.informStateChanged();
            }
        }

        @Override
        public void filePriorityChanged(DiskManagerFileInfo file) {
            DownloadManagerController.this.download_manager.informPriorityChange(file);
        }

        @Override
        public void pieceDoneChanged(DiskManagerPiece piece) {
        }

        @Override
        public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
        }
    }

    protected class FileInfoFacadeSet
    implements DiskManagerFileInfoSet {
        DiskManagerFileInfoSet delegate;
        fileInfoFacade[] facadeFiles = new fileInfoFacade[0];

        protected FileInfoFacadeSet() {
        }

        @Override
        public DiskManagerFileInfo[] getFiles() {
            return this.facadeFiles;
        }

        @Override
        public int nbFiles() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.nbFiles();
        }

        @Override
        public void setPriority(int[] toChange) {
            this.delegate.setPriority(toChange);
        }

        @Override
        public void setSkipped(boolean[] toChange, boolean setSkipped) {
            this.delegate.setSkipped(toChange, setSkipped);
        }

        @Override
        public boolean[] setStorageTypes(boolean[] toChange, int newStroageType) {
            return this.delegate.setStorageTypes(toChange, newStroageType);
        }

        protected void fixupFileInfo(fileInfoFacade[] info) {
            if (info.length == 0) {
                return;
            }
            final ArrayList delayed_prio_changes = new ArrayList(0);
            try {
                int dm_state;
                DownloadManagerController.this.facade_mon.enter();
                if (DownloadManagerController.this.files_facade_destroyed) {
                    return;
                }
                DiskManager dm = DownloadManagerController.this.getDiskManager();
                DiskManagerFileInfoSet active = null;
                if (dm != null && ((dm_state = dm.getState()) == 3 || dm_state == 4)) {
                    active = dm.getFileSet();
                }
                if (active == null) {
                    final boolean[] initialising = new boolean[]{true};
                    try {
                        skeleton_builds = skeleton_builds + 1L;
                        if (skeleton_builds % 1000L == 0L) {
                            Debug.outNoStack("Skeleton builds: " + skeleton_builds);
                        }
                        active = DiskManagerFactory.getFileInfoSkeleton(DownloadManagerController.this.download_manager, new DiskManagerListener(){

                            @Override
                            public void stateChanged(int oldState, int newState) {
                            }

                            @Override
                            public void filePriorityChanged(DiskManagerFileInfo file) {
                                if (initialising[0]) {
                                    delayed_prio_changes.add(file);
                                } else {
                                    ((FileInfoFacadeSet)FileInfoFacadeSet.this).DownloadManagerController.this.download_manager.informPriorityChange(file);
                                }
                            }

                            @Override
                            public void pieceDoneChanged(DiskManagerPiece piece) {
                            }

                            @Override
                            public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                            }
                        });
                    }
                    finally {
                        initialising[0] = false;
                    }
                    DownloadManagerController.this.calculateCompleteness(active.getFiles());
                }
                DiskManagerFileInfo[] activeFiles = active.getFiles();
                int i = 0;
                while (i < info.length) {
                    info[i].setDelegate(activeFiles[i]);
                    ++i;
                }
                this.delegate = active;
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
            DownloadManagerController.this.fileFacadeSet.facadeFiles = info;
            DownloadManagerController.this.download_manager.informPrioritiesChange(delayed_prio_changes);
            delayed_prio_changes.clear();
        }

        private void makeSureFilesFacadeFilled(boolean refresh) {
            if (!DownloadManagerController.this.bInitialized) {
                return;
            }
            if (this.facadeFiles.length == 0) {
                fileInfoFacade[] newFacadeFiles = new fileInfoFacade[DownloadManagerController.this.download_manager.getTorrent() == null ? 0 : DownloadManagerController.this.download_manager.getTorrent().getFiles().length];
                int i = 0;
                while (i < newFacadeFiles.length) {
                    newFacadeFiles[i] = new fileInfoFacade();
                    ++i;
                }
                DownloadManagerController.this.fileFacadeSet.fixupFileInfo(newFacadeFiles);
            } else if (refresh) {
                this.fixupFileInfo(this.facadeFiles);
            }
        }

        protected void destroyFileInfo() {
            try {
                DownloadManagerController.this.facade_mon.enter();
                if (DownloadManagerController.this.fileFacadeSet == null || DownloadManagerController.this.files_facade_destroyed) {
                    return;
                }
                DownloadManagerController.this.files_facade_destroyed = true;
                int i = 0;
                while (i < this.facadeFiles.length) {
                    this.facadeFiles[i].close();
                    ++i;
                }
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
        }
    }

    protected class fileInfoFacade
    implements DiskManagerFileInfo {
        private volatile DiskManagerFileInfo delegate;
        private List<DiskManagerFileInfoListener> listeners;

        protected fileInfoFacade() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setDelegate(DiskManagerFileInfo new_delegate) {
            ArrayList<DiskManagerFileInfoListener> existing_listeners;
            DiskManagerFileInfo old_delegate;
            fileInfoFacade fileInfoFacade2 = this;
            synchronized (fileInfoFacade2) {
                if (new_delegate == this.delegate) {
                    return;
                }
                old_delegate = this.delegate;
                this.delegate = new_delegate;
                existing_listeners = this.listeners == null ? null : new ArrayList<DiskManagerFileInfoListener>(this.listeners);
            }
            if (old_delegate != null) {
                old_delegate.close();
            }
            if (existing_listeners != null) {
                int i = 0;
                while (i < existing_listeners.size()) {
                    new_delegate.addListener((DiskManagerFileInfoListener)existing_listeners.get(i));
                    ++i;
                }
            }
        }

        @Override
        public void setPriority(int b) {
            this.delegate.setPriority(b);
        }

        @Override
        public void setSkipped(boolean b) {
            this.delegate.setSkipped(b);
        }

        @Override
        public boolean setLink(File link_destination) {
            return this.delegate.setLink(link_destination);
        }

        @Override
        public boolean setLinkAtomic(File link_destination) {
            return this.delegate.setLinkAtomic(link_destination);
        }

        @Override
        public File getLink() {
            return this.delegate.getLink();
        }

        @Override
        public boolean setStorageType(int type) {
            return this.delegate.setStorageType(type);
        }

        @Override
        public int getStorageType() {
            return this.delegate.getStorageType();
        }

        @Override
        public int getAccessMode() {
            return this.delegate.getAccessMode();
        }

        @Override
        public long getDownloaded() {
            return this.delegate.getDownloaded();
        }

        @Override
        public String getExtension() {
            return this.delegate.getExtension();
        }

        @Override
        public int getFirstPieceNumber() {
            return this.delegate.getFirstPieceNumber();
        }

        @Override
        public int getLastPieceNumber() {
            return this.delegate.getLastPieceNumber();
        }

        @Override
        public long getLength() {
            return this.delegate.getLength();
        }

        @Override
        public int getNbPieces() {
            return this.delegate.getNbPieces();
        }

        @Override
        public int getPriority() {
            return this.delegate.getPriority();
        }

        @Override
        public boolean isSkipped() {
            return this.delegate.isSkipped();
        }

        @Override
        public int getIndex() {
            return this.delegate.getIndex();
        }

        @Override
        public DiskManager getDiskManager() {
            return this.delegate.getDiskManager();
        }

        @Override
        public DownloadManager getDownloadManager() {
            return DownloadManagerController.this.download_manager;
        }

        @Override
        public File getFile(boolean follow_link) {
            return this.delegate.getFile(follow_link);
        }

        @Override
        public TOTorrentFile getTorrentFile() {
            return this.delegate.getTorrentFile();
        }

        @Override
        public void flushCache() throws Exception {
            try {
                DownloadManagerController.this.facade_mon.enter();
                this.delegate.flushCache();
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
        }

        @Override
        public DirectByteBuffer read(long offset, int length) throws IOException {
            try {
                DownloadManagerController.this.facade_mon.enter();
                DirectByteBuffer directByteBuffer = this.delegate.read(offset, length);
                return directByteBuffer;
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
        }

        @Override
        public int getReadBytesPerSecond() {
            return this.delegate.getReadBytesPerSecond();
        }

        @Override
        public int getWriteBytesPerSecond() {
            return this.delegate.getWriteBytesPerSecond();
        }

        @Override
        public long getETA() {
            return this.delegate.getETA();
        }

        @Override
        public void close() {
            try {
                DownloadManagerController.this.facade_mon.enter();
                this.delegate.close();
            }
            finally {
                DownloadManagerController.this.facade_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(DiskManagerFileInfoListener listener) {
            DiskManagerFileInfo existing_delegate;
            fileInfoFacade fileInfoFacade2 = this;
            synchronized (fileInfoFacade2) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList<DiskManagerFileInfoListener>();
                }
                this.listeners.add(listener);
                existing_delegate = this.delegate;
            }
            if (existing_delegate != null) {
                existing_delegate.addListener(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(DiskManagerFileInfoListener listener) {
            DiskManagerFileInfo existing_delegate;
            fileInfoFacade fileInfoFacade2 = this;
            synchronized (fileInfoFacade2) {
                this.listeners.remove(listener);
                existing_delegate = this.delegate;
            }
            if (existing_delegate != null) {
                existing_delegate.removeListener(listener);
            }
        }
    }

    public class forceRecheckDiskManagerListener
    implements DiskManagerListener {
        private final boolean wasForceStarted;
        private final int start_state;
        private final ForceRecheckListener l;

        public forceRecheckDiskManagerListener(boolean wasForceStarted, int start_state, ForceRecheckListener l) {
            this.wasForceStarted = wasForceStarted;
            this.start_state = start_state;
            this.l = l;
        }

        @Override
        public void stateChanged(int oldDMState, int newDMState) {
            try {
                DownloadManagerController.this.control_mon.enter();
                if (DownloadManagerController.this.getDiskManager() == null) {
                    DownloadManagerController.this.download_manager.setAssumedComplete(false);
                    if (this.l != null) {
                        this.l.forceRecheckComplete(DownloadManagerController.this.download_manager);
                    }
                    return;
                }
            }
            finally {
                DownloadManagerController.this.control_mon.exit();
            }
            if (newDMState == 3) {
                DownloadManagerController.this.fileFacadeSet.makeSureFilesFacadeFilled(true);
            }
            if (newDMState == 4 || newDMState == 10) {
                DownloadManagerController.this.force_start = this.wasForceStarted;
                DownloadManagerController.this.stats.recalcDownloadCompleteBytes();
                if (newDMState == 4) {
                    try {
                        boolean only_seeding = false;
                        boolean update_only_seeding = false;
                        try {
                            DownloadManagerController.this.control_mon.enter();
                            DiskManager dm = DownloadManagerController.this.getDiskManager();
                            if (dm != null) {
                                dm.stop(false);
                                only_seeding = dm.getRemainingExcludingDND() == 0L;
                                update_only_seeding = true;
                                DownloadManagerController.this.setDiskManager(null, null);
                                if (this.start_state == 100) {
                                    DownloadManagerController.this.setState(70, false);
                                } else {
                                    DownloadManagerController.this.setState(this.start_state, false);
                                }
                            }
                        }
                        finally {
                            DownloadManagerController.this.control_mon.exit();
                            DownloadManagerController.this.download_manager.informStateChanged();
                        }
                        if (update_only_seeding) {
                            DownloadManagerController.this.download_manager.setAssumedComplete(only_seeding);
                        }
                    }
                    catch (Exception e) {
                        DownloadManagerController.this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                    }
                } else {
                    try {
                        DownloadManagerController.this.control_mon.enter();
                        DiskManager dm = DownloadManagerController.this.getDiskManager();
                        if (dm != null) {
                            dm.stop(false);
                            DownloadManagerController.this.setDiskManager(null, null);
                            DownloadManagerController.this.setFailed(dm);
                        }
                    }
                    finally {
                        DownloadManagerController.this.control_mon.exit();
                    }
                    DownloadManagerController.this.download_manager.setAssumedComplete(false);
                }
                if (this.l != null) {
                    this.l.forceRecheckComplete(DownloadManagerController.this.download_manager);
                }
            }
        }

        @Override
        public void filePriorityChanged(DiskManagerFileInfo file) {
            DownloadManagerController.this.download_manager.informPriorityChange(file);
        }

        @Override
        public void pieceDoneChanged(DiskManagerPiece piece) {
        }

        @Override
        public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
        }
    }
}

