/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.category.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.tag.TagDownload;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.impl.TagBase;
import com.aelitis.azureus.core.util.IdentityHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.impl.CategoryManagerImpl;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public class CategoryImpl
extends TagBase
implements Category,
Comparable,
TagDownload {
    final String sName;
    private final int type;
    private final List<DownloadManager> managers = new ArrayList<DownloadManager>();
    private int upload_speed;
    private int download_speed;
    private final Object UPLOAD_PRIORITY_KEY = new Object();
    private final Map<String, String> attributes;
    private static final AtomicInteger tag_ids = new AtomicInteger();
    private final LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "cat_up: " + CategoryImpl.this.sName;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.upload_speed;
        }

        @Override
        public boolean isDisabled() {
            return CategoryImpl.this.upload_speed == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private final LimitedRateGroup download_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "cat_down: " + CategoryImpl.this.sName;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.download_speed;
        }

        @Override
        public boolean isDisabled() {
            return CategoryImpl.this.download_speed == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private boolean destroyed;
    private static final int LDT_CATEGORY_DMADDED = 1;
    private static final int LDT_CATEGORY_DMREMOVED = 2;
    private final ListenerManager<CategoryListener> category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher<CategoryListener>(){

        @Override
        public void dispatch(CategoryListener target, int type, Object value) {
            if (type == 1) {
                target.downloadManagerAdded(CategoryImpl.this, (DownloadManager)value);
            } else if (type == 2) {
                target.downloadManagerRemoved(CategoryImpl.this, (DownloadManager)value);
            }
        }
    });

    public CategoryImpl(CategoryManagerImpl manager, String sName, int maxup, int maxdown, Map<String, String> _attributes) {
        super(manager, tag_ids.incrementAndGet(), sName);
        this.addTag();
        this.sName = sName;
        this.type = 0;
        this.upload_speed = maxup;
        this.download_speed = maxdown;
        this.attributes = _attributes;
    }

    public CategoryImpl(CategoryManagerImpl manager, String sName, int type, Map<String, String> _attributes) {
        super(manager, tag_ids.incrementAndGet(), sName);
        this.addTag();
        this.sName = sName;
        this.type = type;
        this.attributes = _attributes;
    }

    @Override
    public void addCategoryListener(CategoryListener l) {
        if (!this.category_listeners.hasListener(l)) {
            this.category_listeners.addListener(l);
        }
    }

    @Override
    public void removeCategoryListener(CategoryListener l) {
        this.category_listeners.removeListener(l);
    }

    @Override
    public boolean hasCategoryListener(CategoryListener l) {
        return this.category_listeners.hasListener(l);
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public List<DownloadManager> getDownloadManagers(List<DownloadManager> all_dms) {
        if (this.type == 0) {
            return this.managers;
        }
        if (this.type == 1 || all_dms == null) {
            return all_dms;
        }
        ArrayList<DownloadManager> result = new ArrayList<DownloadManager>();
        int i = 0;
        while (i < all_dms.size()) {
            DownloadManager dm = all_dms.get(i);
            Category cat = dm.getDownloadState().getCategory();
            if (cat == null || cat.getType() == 2) {
                result.add(dm);
            }
            ++i;
        }
        return result;
    }

    @Override
    public void addManager(DownloadManagerState manager_state) {
        Category manager_cat = manager_state.getCategory();
        if (this.type != 2 && manager_cat != this || this.type == 2 && manager_cat != null) {
            manager_state.setCategory(this);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (manager == null) {
            return;
        }
        this.addTaggable(manager);
        if (!this.managers.contains(manager)) {
            if (this.type == 0) {
                this.managers.add(manager);
            }
            manager.addRateLimiter(this.upload_limiter, true);
            manager.addRateLimiter(this.download_limiter, false);
            int pri = this.getIntAttribute("at_up_pri", -1);
            if (pri > 0 && manager.getDownloadState() != null) {
                manager.updateAutoUploadPriority(this.UPLOAD_PRIORITY_KEY, true);
            }
            this.category_listeners.dispatch(1, manager);
        }
    }

    @Override
    public void removeManager(DownloadManagerState manager_state) {
        if (manager_state.getCategory() == this) {
            manager_state.setCategory(null);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (manager == null) {
            return;
        }
        this.removeTaggable(manager);
        if (this.type != 0 || this.managers.contains(manager)) {
            this.managers.remove(manager);
            manager.removeRateLimiter(this.upload_limiter, true);
            manager.removeRateLimiter(this.download_limiter, false);
            int pri = this.getIntAttribute("at_up_pri", -1);
            if (pri > 0 && manager.getDownloadState() != null) {
                manager.updateAutoUploadPriority(this.UPLOAD_PRIORITY_KEY, false);
            }
            this.category_listeners.dispatch(2, manager);
        }
    }

    @Override
    public void setDownloadSpeed(int speed) {
        if (this.download_speed != speed) {
            this.download_speed = speed;
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getDownloadSpeed() {
        return this.download_speed;
    }

    @Override
    public void setUploadSpeed(int speed) {
        if (this.upload_speed != speed) {
            this.upload_speed = speed;
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getUploadSpeed() {
        return this.upload_speed;
    }

    protected void setAttributes(Map<String, String> a) {
        this.attributes.clear();
        this.attributes.putAll(a);
    }

    protected Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getStringAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setStringAttribute(String name, String value) {
        String old = this.attributes.put(name, value);
        if (old == null || !old.equals(value)) {
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getIntAttribute(String name) {
        return this.getIntAttribute(name, 0);
    }

    private int getIntAttribute(String name, int def) {
        String str = this.getStringAttribute(name);
        if (str == null) {
            return def;
        }
        return Integer.parseInt(str);
    }

    @Override
    public void setIntAttribute(String name, int value) {
        String str_val = String.valueOf(value);
        String old = this.attributes.put(name, str_val);
        if (old == null || !old.equals(str_val)) {
            if (name.equals("at_up_pri")) {
                for (DownloadManager dm : this.managers) {
                    dm.updateAutoUploadPriority(this.UPLOAD_PRIORITY_KEY, value > 0);
                }
            }
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public boolean getBooleanAttribute(String name) {
        String str = this.getStringAttribute(name);
        return str != null && str.equals("true");
    }

    @Override
    public void setBooleanAttribute(String name, boolean value) {
        String str_val = value ? "true" : "false";
        String old = this.attributes.put(name, str_val);
        if (old == null || !old.equals(str_val)) {
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getTaggableTypes() {
        return 2;
    }

    @Override
    public String getTagName(boolean localize) {
        if (localize && (this.type == 1 || this.type == 2)) {
            return MessageText.getString(this.getTagNameRaw());
        }
        return super.getTagName(localize);
    }

    @Override
    public boolean supportsTagRates() {
        return false;
    }

    @Override
    public boolean supportsTagUploadLimit() {
        return true;
    }

    @Override
    public boolean supportsTagDownloadLimit() {
        return true;
    }

    @Override
    public int getTagUploadLimit() {
        return this.getUploadSpeed();
    }

    @Override
    public void setTagUploadLimit(int bps) {
        this.setUploadSpeed(bps);
    }

    @Override
    public int getTagCurrentUploadRate() {
        return -1;
    }

    @Override
    public int getTagDownloadLimit() {
        return this.getDownloadSpeed();
    }

    @Override
    public void setTagDownloadLimit(int bps) {
        this.setDownloadSpeed(bps);
    }

    @Override
    public int getTagCurrentDownloadRate() {
        return -1;
    }

    @Override
    public int getTagUploadPriority() {
        if (this.type == 0) {
            return this.getIntAttribute("at_up_pri");
        }
        return -1;
    }

    @Override
    public void setTagUploadPriority(int priority) {
        this.setIntAttribute("at_up_pri", priority);
    }

    @Override
    public boolean getCanBePublicDefault() {
        return this.type == 0;
    }

    @Override
    public boolean supportsTagTranscode() {
        return false;
    }

    @Override
    public String[] getTagTranscodeTarget() {
        return null;
    }

    @Override
    public void setTagTranscodeTarget(String uid, String display_name) {
    }

    @Override
    public Set<DownloadManager> getTaggedDownloads() {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        if (!core.isStarted()) {
            return new IdentityHashSet<DownloadManager>();
        }
        return new IdentityHashSet<DownloadManager>(this.getDownloadManagers(core.getGlobalManager().getDownloadManagers()));
    }

    @Override
    public Set<Taggable> getTagged() {
        return this.getTaggedDownloads();
    }

    @Override
    public int getTaggedCount() {
        return this.getTagged().size();
    }

    @Override
    public boolean hasTaggable(Taggable t) {
        if (!(t instanceof DownloadManager)) {
            return false;
        }
        if (this.type == 0) {
            return this.managers.contains(t);
        }
        if (this.type == 1) {
            return true;
        }
        DownloadManager dm = (DownloadManager)t;
        Category cat = dm.getDownloadState().getCategory();
        return cat == null || cat.getType() == 2;
    }

    @Override
    public int getRunStateCapabilities() {
        return 0;
    }

    @Override
    public boolean hasRunStateCapability(int capability) {
        return false;
    }

    @Override
    public boolean[] getPerformableOperations(int[] ops) {
        return new boolean[ops.length];
    }

    @Override
    public void performOperation(int op) {
        Debug.out("derp");
    }

    @Override
    protected void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.removeTag();
        }
    }

    public int compareTo(Object b) {
        boolean bTypeIsUser;
        boolean aTypeIsUser = this.type == 0;
        boolean bl = bTypeIsUser = ((Category)b).getType() == 0;
        if (aTypeIsUser == bTypeIsUser) {
            return this.sName.compareToIgnoreCase(((Category)b).getName());
        }
        if (aTypeIsUser) {
            return 1;
        }
        return -1;
    }

    @Override
    public void dump(IndentWriter writer) {
        if (this.upload_speed != 0) {
            writer.println("up=" + this.upload_speed);
        }
        if (this.download_speed != 0) {
            writer.println("down=" + this.download_speed);
        }
        if (this.attributes.size() > 0) {
            writer.println("attributes: " + this.attributes);
        }
    }
}

