/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.utils;

import java.io.PrintStream;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Prefix;
import lbms.plugins.mldht.kad.utils.PopulationListener;

public class PopulationEstimator {
    static final int KEYSPACE_BITS = 160;
    static final double KEYSPACE_SIZE = Math.pow(2.0, 160.0);
    static final double DISTANCE_INITIAL_WEIGHT = 0.1;
    static final int INITIAL_WEIGHT_COUNT = 20;
    static final double DISTANCE_WEIGHT = 0.03;
    private double averageNodeDistanceExp2 = 160.0;
    private int updateCount = 0;
    private List<PopulationListener> listeners = new ArrayList<PopulationListener>(1);
    private static final int MAX_RECENT_LOOKUP_CACHE_SIZE = 40;
    private Deque<Prefix> recentlySeenPrefixes = new LinkedList<Prefix>();

    public long getEstimate() {
        return (long)Math.pow(2.0, 160.0 - this.averageNodeDistanceExp2 + 0.6180339);
    }

    public double getRawDistanceEstimate() {
        return this.averageNodeDistanceExp2;
    }

    public void setInitialRawDistanceEstimate(double initialValue) {
        this.averageNodeDistanceExp2 = initialValue;
        if (this.averageNodeDistanceExp2 > 160.0) {
            this.averageNodeDistanceExp2 = 160.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SortedSet<Key> neighbors) {
        if (neighbors.size() < 4) {
            return;
        }
        double[] distances = new double[neighbors.size() - 1];
        DHT.log("Estimator: new node group of " + neighbors.size(), DHT.LogLevel.Debug);
        Prefix prefix = Prefix.getCommonPrefix(neighbors);
        Deque<Prefix> deque = this.recentlySeenPrefixes;
        synchronized (deque) {
            for (Prefix oldPrefix : this.recentlySeenPrefixes) {
                if (oldPrefix.isPrefixOf(prefix)) {
                    this.recentlySeenPrefixes.remove(oldPrefix);
                    this.recentlySeenPrefixes.addLast(prefix);
                    return;
                }
                if (!prefix.isPrefixOf(oldPrefix)) continue;
                return;
            }
            this.recentlySeenPrefixes.addLast(prefix);
            if (this.recentlySeenPrefixes.size() > 40) {
                this.recentlySeenPrefixes.removeFirst();
            }
        }
        Key previous = null;
        int i = 0;
        for (Key entry : neighbors) {
            if (previous == null) {
                previous = entry;
                continue;
            }
            byte[] rawDistance = previous.distance(entry).getHash();
            double distance = 0.0;
            int nonZeroBytes = 0;
            int j = 0;
            while (j < 20) {
                if (rawDistance[j] != 0) {
                    if (nonZeroBytes == 8) break;
                    ++nonZeroBytes;
                    distance += (double)(rawDistance[j] & 0xFF) * Math.pow(2.0, 160 - (j + 1) * 8);
                }
                ++j;
            }
            distance = Math.log(distance) / Math.log(2.0);
            DHT.log("Estimator: distance value #" + this.updateCount + ": " + distance + " avg:" + this.averageNodeDistanceExp2, DHT.LogLevel.Debug);
            distances[i++] = distance;
            previous = entry;
        }
        Arrays.sort(distances);
        double weight = this.updateCount < 20 ? 0.1 : 0.03;
        ++this.updateCount;
        double middle = ((double)distances.length - 1.0) / 2.0;
        int idx1 = (int)Math.floor(middle);
        int idx2 = (int)Math.ceil(middle);
        double middleWeight = middle - (double)idx1;
        double median = distances[idx1] * (1.0 - middleWeight) + distances[idx2] * middleWeight;
        Class<PopulationEstimator> clazz = PopulationEstimator.class;
        synchronized (PopulationEstimator.class) {
            this.averageNodeDistanceExp2 = median * weight + this.averageNodeDistanceExp2 * (1.0 - weight);
            // ** MonitorExit[var16_18] (shouldn't be in output)
            DHT.log("Estimator: new estimate:" + this.getEstimate(), DHT.LogLevel.Info);
            this.fireUpdateEvent();
            return;
        }
    }

    public void addListener(PopulationListener l) {
        this.listeners.add(l);
    }

    public void removeListener(PopulationListener l) {
        this.listeners.remove(l);
    }

    private void fireUpdateEvent() {
        long estimated = this.getEstimate();
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).populationUpdated(estimated);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        PrintStream out = new PrintStream("dump.txt");
        Random rand = new Random();
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.GERMANY);
        formatter.setMaximumFractionDigits(30);
        PopulationEstimator estimator = new PopulationEstimator();
        ArrayList<Key> keyspace = new ArrayList<Key>(5000000);
        int i = 0;
        while (i < 5000) {
            keyspace.add(Key.createRandomKey());
            ++i;
        }
        Collections.sort(keyspace);
        i = 0;
        while (i < 1000) {
            int j = 0;
            while (j < 3) {
                Key target = Key.createRandomKey();
                int idx = Math.min(keyspace.size() - 1, Math.abs(Collections.binarySearch(keyspace, target)));
                TreeSet<Key> closestSet = new TreeSet<Key>(new Key.DistanceOrder(target));
                int sizeGoal = 5 + rand.nextInt(4);
                closestSet.addAll(keyspace);
                while (closestSet.size() > sizeGoal) {
                    closestSet.remove(closestSet.last());
                }
                double[] distances = new double[closestSet.size() - 1];
                Key previous = null;
                int k = 0;
                for (Key entry : closestSet) {
                    if (previous == null) {
                        previous = entry;
                        continue;
                    }
                    byte[] rawDistance = previous.distance(entry).getHash();
                    double distance = 0.0;
                    distance = new BigInteger(rawDistance).doubleValue();
                    distance = Math.log(distance) / Math.log(2.0);
                    distances[k++] = distance;
                    previous = entry;
                }
                Arrays.sort(distances);
                double middle = ((double)distances.length - 1.0) / 2.0;
                int idx1 = (int)Math.floor(middle);
                int idx2 = (int)Math.ceil(middle);
                double middleWeight = middle - (double)idx1;
                double median = distances[idx1] * (1.0 - middleWeight) + distances[idx2] * middleWeight;
                out.println(String.valueOf(distances.length) + "\t" + keyspace.size() + "\t" + formatter.format(median));
                ++j;
            }
            int newGoal = (int)((double)keyspace.size() * 1.008);
            System.out.println(String.valueOf(i) + ": " + newGoal);
            while (keyspace.size() < newGoal) {
                keyspace.add(Key.createRandomKey());
            }
            Collections.sort(keyspace);
            ++i;
        }
    }
}

