/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.tasks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucket;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.messages.PingRequest;
import lbms.plugins.mldht.kad.tasks.Task;

public class PingRefreshTask
extends Task {
    private boolean cleanOnTimeout;
    private Map<MessageBase, KBucketEntry> lookupMap;

    public PingRefreshTask(RPCServerBase rpc, Node node, boolean cleanOnTimeout) {
        this(rpc, node, node.getBuckets(), cleanOnTimeout);
    }

    public PingRefreshTask(RPCServerBase rpc, Node node, KBucket bucket, boolean cleanOnTimeout) {
        super(node.getRootID(), rpc, node);
        this.cleanOnTimeout = cleanOnTimeout;
        if (cleanOnTimeout) {
            this.lookupMap = new HashMap<MessageBase, KBucketEntry>();
        }
        if (bucket != null) {
            for (KBucketEntry e : bucket.getEntries()) {
                if (!e.isQuestionable() && !cleanOnTimeout) continue;
                this.todo.add(e);
            }
        }
    }

    public PingRefreshTask(RPCServerBase rpc, Node node, List<Node.RoutingTableEntry> buckets, boolean cleanOnTimeout) {
        super(node.getRootID(), rpc, node, "Multi Bucket Refresh");
        this.cleanOnTimeout = cleanOnTimeout;
        if (cleanOnTimeout) {
            this.lookupMap = new HashMap<MessageBase, KBucketEntry>();
        }
        for (Node.RoutingTableEntry tableEntry : buckets) {
            for (KBucketEntry e : tableEntry.getBucket().getEntries()) {
                if (!e.isQuestionable() && !cleanOnTimeout) continue;
                this.todo.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void callFinished(RPCCallBase c, MessageBase rsp) {
        if (this.cleanOnTimeout) {
            Map<MessageBase, KBucketEntry> map = this.lookupMap;
            synchronized (map) {
                this.lookupMap.remove(c.getRequest());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void callTimeout(RPCCallBase c) {
        if (this.cleanOnTimeout) {
            MessageBase mb = c.getRequest();
            Map<MessageBase, KBucketEntry> map = this.lookupMap;
            synchronized (map) {
                KBucketEntry e;
                KBucket bucket;
                if (this.lookupMap.containsKey(mb) && (bucket = this.node.findBucketForId((e = this.lookupMap.remove(mb)).getID()).getBucket()) != null) {
                    DHT.logDebug("Removing invalid entry from cache.");
                    bucket.removeEntry(e, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void update() {
        SortedSet sortedSet = this.todo;
        synchronized (sortedSet) {
            while (!this.todo.isEmpty() && this.canDoRequest()) {
                KBucketEntry e = (KBucketEntry)this.todo.first();
                this.todo.remove(e);
                if (e.isGood()) continue;
                PingRequest pr = new PingRequest();
                pr.setDestination(e.getAddress());
                if (this.cleanOnTimeout) {
                    Map<MessageBase, KBucketEntry> map = this.lookupMap;
                    synchronized (map) {
                        this.lookupMap.put(pr, e);
                    }
                }
                this.rpcCall(pr, e.getID());
            }
        }
        if (this.todo.isEmpty() && this.getNumOutstandingRequests() == 0 && !this.isFinished()) {
            this.done();
        }
    }
}

