/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.messages;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lbms.plugins.mldht.kad.DBItem;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.PeerAddressDBItem;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.messages.AbstractLookupRequest;
import lbms.plugins.mldht.kad.messages.AnnounceRequest;
import lbms.plugins.mldht.kad.messages.AnnounceResponse;
import lbms.plugins.mldht.kad.messages.ErrorMessage;
import lbms.plugins.mldht.kad.messages.FindNodeRequest;
import lbms.plugins.mldht.kad.messages.FindNodeResponse;
import lbms.plugins.mldht.kad.messages.GetPeersRequest;
import lbms.plugins.mldht.kad.messages.GetPeersResponse;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.messages.PingRequest;
import lbms.plugins.mldht.kad.messages.PingResponse;
import lbms.plugins.mldht.kad.utils.Token;

public class MessageDecoder {
    public static MessageBase parseMessage(Map<String, Object> map, RPCServerBase srv) {
        String msgType;
        block9: {
            try {
                msgType = MessageDecoder.getStringFromBytes((byte[])map.get("y"));
                if (msgType != null) break block9;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        String version = MessageDecoder.getStringFromBytes((byte[])map.get("v"), true);
        MessageBase mb = null;
        if (msgType.equals(MessageBase.Type.REQ_MSG.getRPCTypeName())) {
            mb = MessageDecoder.parseRequest(map, srv);
        } else if (msgType.equals(MessageBase.Type.RSP_MSG.getRPCTypeName())) {
            mb = MessageDecoder.parseResponse(map, srv);
        } else if (msgType.equals(MessageBase.Type.ERR_MSG.getRPCTypeName())) {
            mb = MessageDecoder.parseError(map);
        }
        if (mb != null && version != null) {
            mb.setVersion(version);
        }
        return mb;
    }

    private static MessageBase parseError(Map<String, Object> map) {
        Object error = map.get(MessageBase.Type.ERR_MSG.innerKey());
        int errorCode = 0;
        String errorMsg = null;
        if (error instanceof byte[]) {
            errorMsg = MessageDecoder.getStringFromBytes((byte[])error);
        } else if (error instanceof List) {
            List errmap = (List)error;
            try {
                errorCode = ((Long)errmap.get(0)).intValue();
                errorMsg = MessageDecoder.getStringFromBytes((byte[])errmap.get(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object rawMtid = map.get("t");
        if (errorMsg == null || rawMtid == null || !(rawMtid instanceof byte[])) {
            return null;
        }
        byte[] mtid = (byte[])rawMtid;
        if (mtid == null || mtid.length < 1) {
            return null;
        }
        return new ErrorMessage(mtid, errorCode, errorMsg);
    }

    private static MessageBase parseResponse(Map<String, Object> map, RPCServerBase srv) {
        byte[] mtid = (byte[])map.get("t");
        if (mtid == null || mtid.length < 1) {
            return null;
        }
        RPCCallBase c = srv.findCall(mtid);
        if (c == null) {
            DHT.logDebug("Cannot find RPC call for response: " + new String(mtid));
            return null;
        }
        return MessageDecoder.parseResponse(map, c.getMessageMethod(), mtid, c);
    }

    private static MessageBase parseResponse(Map<String, Object> map, MessageBase.Method msgMethod, byte[] mtid, RPCCallBase base) {
        Map args = (Map)map.get(MessageBase.Type.RSP_MSG.innerKey());
        if (args == null || !args.containsKey("id")) {
            return null;
        }
        byte[] hash = (byte[])args.get("id");
        if (hash == null || hash.length != 20) {
            return null;
        }
        Key id = new Key(hash);
        MessageBase msg = null;
        switch (msgMethod) {
            case PING: {
                msg = new PingResponse(mtid);
                break;
            }
            case ANNOUNCE_PEER: {
                msg = new AnnounceResponse(mtid);
                break;
            }
            case FIND_NODE: {
                if (!args.containsKey("nodes") && !args.containsKey("nodes6")) {
                    return null;
                }
                msg = new FindNodeResponse(mtid, (byte[])args.get("nodes"), (byte[])args.get("nodes6"));
                break;
            }
            case GET_PEERS: {
                Object their_token = args.get("token");
                byte[] nodes = (byte[])args.get("nodes");
                byte[] nodes6 = (byte[])args.get("nodes6");
                Object _values = args.get("values");
                ArrayList<byte[]> vals = null;
                if (_values instanceof List) {
                    vals = (ArrayList<byte[]>)_values;
                } else if (_values instanceof byte[]) {
                    vals = new ArrayList<byte[]>();
                    vals.add((byte[])_values);
                }
                ArrayList<DBItem> dbl = null;
                if (vals != null && vals.size() > 0) {
                    dbl = new ArrayList<DBItem>(vals.size());
                    int i = 0;
                    while (i < vals.size()) {
                        if (((byte[])vals.get(i)).length == DHT.DHTtype.IPV4_DHT.ADDRESS_ENTRY_LENGTH || ((byte[])vals.get(i)).length == DHT.DHTtype.IPV6_DHT.ADDRESS_ENTRY_LENGTH) {
                            dbl.add(new PeerAddressDBItem((byte[])vals.get(i), false));
                        }
                        ++i;
                    }
                }
                if (dbl != null || nodes != null || nodes6 != null) {
                    GetPeersResponse resp = new GetPeersResponse(mtid, nodes, nodes6, their_token == null ? null : new Token.TheirToken(their_token));
                    resp.setPeerItems(dbl);
                    msg = resp;
                    break;
                }
                DHT.logDebug("No nodes or values in get_peers response");
                return null;
            }
            default: {
                return null;
            }
        }
        msg.setID(id);
        return msg;
    }

    private static MessageBase parseRequest(Map<String, Object> map, RPCServerBase srv) {
        Object rawRequestMethod = map.get(MessageBase.Type.REQ_MSG.getRPCTypeName());
        Map args = (Map)map.get(MessageBase.Type.REQ_MSG.innerKey());
        if (rawRequestMethod == null || args == null) {
            return null;
        }
        byte[] mtid = (byte[])map.get("t");
        byte[] hash = (byte[])args.get("id");
        if (mtid == null || mtid.length < 1 || hash == null || hash.length != 20) {
            return null;
        }
        Key id = new Key(hash);
        MessageBase msg = null;
        String requestMethod = MessageDecoder.getStringFromBytes((byte[])rawRequestMethod);
        if (MessageBase.Method.PING.getRPCName().equals(requestMethod)) {
            msg = new PingRequest();
        } else if (MessageBase.Method.FIND_NODE.getRPCName().equals(requestMethod) || MessageBase.Method.GET_PEERS.getRPCName().equals(requestMethod)) {
            hash = (byte[])args.get("target");
            if (hash == null) {
                hash = (byte[])args.get("info_hash");
            }
            if (hash == null || hash.length != 20) {
                return null;
            }
            AbstractLookupRequest req = MessageBase.Method.FIND_NODE.getRPCName().equals(requestMethod) ? new FindNodeRequest(new Key(hash)) : new GetPeersRequest(new Key(hash));
            req.setWant4(srv.getDHT().getType() == DHT.DHTtype.IPV4_DHT);
            req.setWant6(srv.getDHT().getType() == DHT.DHTtype.IPV6_DHT);
            req.decodeWant((List)args.get("want"));
            if (req instanceof GetPeersRequest) {
                GetPeersRequest peerReq = (GetPeersRequest)req;
                peerReq.setNoSeeds(Long.valueOf(1L).equals(args.get("noseed")));
                peerReq.setScrape(Long.valueOf(1L).equals(args.get("scrape")));
            }
            msg = req;
        } else if (MessageBase.Method.ANNOUNCE_PEER.getRPCName().equals(requestMethod)) {
            if (args.containsKey("info_hash") && args.containsKey("port") && args.containsKey("token")) {
                hash = (byte[])args.get("info_hash");
                if (hash == null || hash.length != 20) {
                    return null;
                }
                Key infoHash = new Key(hash);
                Token.OurToken token = new Token.OurToken((byte[])args.get("token"));
                AnnounceRequest ann = new AnnounceRequest(infoHash, ((Long)args.get("port")).intValue(), token);
                ann.setSeed(Long.valueOf(1L).equals(args.get("seed")));
                msg = ann;
            }
        } else {
            DHT.logDebug("Received unknown Message Type: " + requestMethod);
        }
        if (msg != null) {
            msg.setMTID(mtid);
            msg.setID(id);
        }
        return msg;
    }

    private static String getStringFromBytes(byte[] bytes, boolean preserveBytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, preserveBytes ? "ISO-8859-1" : "UTF-8");
        }
        catch (Exception e) {
            DHT.log(e, DHT.LogLevel.Verbose);
            return null;
        }
    }

    private static String getStringFromBytes(byte[] bytes) {
        return MessageDecoder.getStringFromBytes(bytes, false);
    }
}

