/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lbms.plugins.mldht.kad.BloomFilterBEP33;
import lbms.plugins.mldht.kad.DBItem;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.utils.Token;

public class GetPeersResponse
extends MessageBase {
    private Token token;
    private byte[] nodes;
    private byte[] nodes6;
    private byte[] scrapeSeeds;
    private byte[] scrapePeers;
    private List<DBItem> items;

    public GetPeersResponse(byte[] mtid, byte[] nodes, byte[] nodes6, Token token) {
        super(mtid, MessageBase.Method.GET_PEERS, MessageBase.Type.RSP_MSG);
        this.nodes = nodes;
        this.nodes6 = nodes6;
        this.token = token;
    }

    @Override
    public void apply(DHT dh_table) {
        dh_table.response(this);
    }

    @Override
    public Map<String, Object> getInnerMap() {
        TreeMap<String, Object> innerMap = new TreeMap<String, Object>();
        innerMap.put("id", this.id.getHash());
        if (this.token != null) {
            innerMap.put("token", this.token.getValue());
        }
        if (this.nodes != null) {
            innerMap.put("nodes", this.nodes);
        }
        if (this.nodes6 != null) {
            innerMap.put("nodes6", this.nodes6);
        }
        if (this.items != null && !this.items.isEmpty()) {
            ArrayList<byte[]> itemsList = new ArrayList<byte[]>(this.items.size());
            for (DBItem item : this.items) {
                itemsList.add(item.getData());
            }
            innerMap.put("values", itemsList);
        }
        if (this.scrapePeers != null && this.scrapeSeeds != null) {
            innerMap.put("BFpe", this.scrapePeers);
            innerMap.put("BFse", this.scrapeSeeds);
        }
        return innerMap;
    }

    public byte[] getNodes(DHT.DHTtype type) {
        if (type == DHT.DHTtype.IPV4_DHT) {
            return this.nodes;
        }
        if (type == DHT.DHTtype.IPV6_DHT) {
            return this.nodes6;
        }
        return null;
    }

    public void setPeerItems(List<DBItem> items) {
        this.items = items;
    }

    public List<DBItem> getPeerItems() {
        return this.items == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.items);
    }

    public BloomFilterBEP33 getScrapeSeeds() {
        if (this.scrapeSeeds != null) {
            return new BloomFilterBEP33(this.scrapeSeeds);
        }
        return null;
    }

    public void setScrapeSeeds(BloomFilterBEP33 scrapeSeeds) {
        this.scrapeSeeds = this.scrapePeers != null ? scrapeSeeds.serialize() : null;
    }

    public BloomFilterBEP33 getScrapePeers() {
        if (this.scrapePeers != null) {
            return new BloomFilterBEP33(this.scrapePeers);
        }
        return null;
    }

    public void setScrapePeers(BloomFilterBEP33 scrapePeers) {
        this.scrapePeers = scrapePeers != null ? scrapePeers.serialize() : null;
    }

    public Token getToken() {
        return this.token;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "contains: " + (this.nodes != null ? String.valueOf(this.nodes.length / DHT.DHTtype.IPV4_DHT.NODES_ENTRY_LENGTH) + " nodes" : "") + (this.nodes6 != null ? String.valueOf(this.nodes6.length / DHT.DHTtype.IPV6_DHT.NODES_ENTRY_LENGTH) + " nodes6" : "") + (this.items != null ? String.valueOf(this.items.size()) + " values" : "");
    }
}

