/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.messages;

import java.util.ArrayList;
import java.util.Map;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.messages.MessageBase;

public class ErrorMessage
extends MessageBase {
    private String msg;
    private int code;

    public ErrorMessage(byte[] mtid, int code, String msg) {
        super(mtid, MessageBase.Method.NONE, MessageBase.Type.ERR_MSG);
        this.msg = msg;
        this.code = code;
    }

    @Override
    public void apply(DHT dh_table) {
        dh_table.error(this);
    }

    @Override
    public Map<String, Object> getBase() {
        Map<String, Object> base = super.getBase();
        ArrayList<Object> errorDetails = new ArrayList<Object>(2);
        errorDetails.add(this.code);
        errorDetails.add(this.msg);
        base.put(this.getType().innerKey(), errorDetails);
        return base;
    }

    public String getMessage() {
        return this.msg;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " code:" + this.code + " errormsg: '" + this.msg + "'";
    }

    public static enum ErrorCode {
        GenericError(201),
        ServerError(202),
        ProtocolError(203),
        MethodUnknown(204);

        public final int code;

        private ErrorCode(int code) {
            this.code = code;
        }
    }
}

