/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad.messages;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.messages.MessageBase;

public abstract class AbstractLookupRequest
extends MessageBase {
    protected Key target;
    private boolean want4;
    private boolean want6;

    public AbstractLookupRequest(Key target, MessageBase.Method m) {
        super(new byte[]{-1}, m, MessageBase.Type.REQ_MSG);
        this.target = target;
    }

    @Override
    public Map<String, Object> getInnerMap() {
        TreeMap<String, Object> inner = new TreeMap<String, Object>();
        inner.put("id", this.id.getHash());
        inner.put(this.targetBencodingName(), this.target.getHash());
        ArrayList<String> want = new ArrayList<String>(2);
        if (this.want4) {
            want.add("n4");
        }
        if (this.want6) {
            want.add("n6");
        }
        inner.put("want", want);
        return inner;
    }

    protected abstract String targetBencodingName();

    public Key getTarget() {
        return this.target;
    }

    public boolean doesWant4() {
        return this.want4;
    }

    public void decodeWant(List<byte[]> want) {
        if (want == null) {
            return;
        }
        ArrayList<String> wants = new ArrayList<String>(2);
        for (byte[] bytes : want) {
            wants.add(new String(bytes));
        }
        this.want4 |= wants.contains("n4");
        this.want6 |= wants.contains("n6");
    }

    public void setWant4(boolean want4) {
        this.want4 = want4;
    }

    public boolean doesWant6() {
        return this.want6;
    }

    public void setWant6(boolean want6) {
        this.want6 = want6;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "targetKey:" + this.target;
    }
}

