/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.util.ArrayList;
import java.util.List;
import lbms.plugins.mldht.kad.BloomFilterBEP33;
import lbms.plugins.mldht.kad.DBItem;
import lbms.plugins.mldht.kad.PeerAddressDBItem;
import lbms.plugins.mldht.kad.messages.GetPeersResponse;
import lbms.plugins.mldht.kad.utils.AddressUtils;

public class ScrapeResponseHandler {
    private List<GetPeersResponse> scrapeResponses = new ArrayList<GetPeersResponse>(20);
    private int scrapeSeeds;
    private int scrapePeers;

    public void addGetPeersRespone(GetPeersResponse gpr) {
        this.scrapeResponses.add(gpr);
    }

    public int getScrapedPeers() {
        return this.scrapePeers;
    }

    public int getScrapedSeeds() {
        return this.scrapeSeeds;
    }

    public void process() {
        BloomFilterBEP33 f;
        ArrayList<BloomFilterBEP33> seedFilters = new ArrayList<BloomFilterBEP33>();
        ArrayList<BloomFilterBEP33> peerFilters = new ArrayList<BloomFilterBEP33>();
        for (GetPeersResponse response : this.scrapeResponses) {
            f = response.getScrapeSeeds();
            if (f == null) continue;
            seedFilters.add(f);
        }
        this.scrapeSeeds = BloomFilterBEP33.unionSize(seedFilters);
        for (GetPeersResponse response : this.scrapeResponses) {
            f = response.getScrapePeers();
            if (f == null) {
                f = new BloomFilterBEP33();
                for (DBItem item : response.getPeerItems()) {
                    PeerAddressDBItem peer;
                    if (!(item instanceof PeerAddressDBItem) || AddressUtils.isBogon(peer = (PeerAddressDBItem)item)) continue;
                    f.insert(peer.getInetAddress());
                }
            }
            peerFilters.add(f);
        }
        this.scrapePeers = BloomFilterBEP33.unionSize(peerFilters);
    }
}

