/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.RPCCall;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCCallListener;
import lbms.plugins.mldht.kad.RPCServer;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.messages.PingRequest;
import lbms.plugins.mldht.kad.tasks.Task;

public class KBucket
implements Externalizable {
    private static final long serialVersionUID = -5507455162198975209L;
    private volatile List<KBucketEntry> entries = new ArrayList<KBucketEntry>();
    private ConcurrentLinkedQueue<KBucketEntry> replacementBucket = new ConcurrentLinkedQueue();
    private Node node;
    private Map<Key, KBucketEntry> pendingPings = new ConcurrentSkipListMap<Key, KBucketEntry>();
    private long last_modified;
    private Task refresh_task;

    public KBucket() {
    }

    public KBucket(Node node) {
        this();
        this.node = node;
    }

    public void insertOrRefresh(KBucketEntry entry) {
        if (entry == null) {
            return;
        }
        List<KBucketEntry> entriesRef = this.entries;
        int idx = entriesRef.indexOf(entry);
        if (idx != -1) {
            final KBucketEntry oldEntry = entriesRef.get(idx);
            final KBucketEntry newEntry = entry;
            if (!oldEntry.getAddress().equals(entry.getAddress())) {
                this.pingEntry(oldEntry, new RPCCallListener(){

                    @Override
                    public void onTimeout(RPCCallBase c) {
                        KBucket.this.modifyMainBucket(oldEntry, newEntry);
                        DHT.log("Node " + oldEntry.getID() + " changed address from " + oldEntry.getAddress() + " to " + newEntry.getAddress(), DHT.LogLevel.Info);
                    }

                    @Override
                    public void onStall(RPCCallBase c) {
                    }

                    @Override
                    public void onResponse(RPCCallBase c, MessageBase rsp) {
                        DHT.log("New node " + newEntry.getAddress() + " claims same Node ID (" + oldEntry.getID() + ") as " + oldEntry.getAddress() + " ; node dropped as this might be an impersonation attack", DHT.LogLevel.Error);
                    }
                });
                return;
            }
            oldEntry.mergeTimestamps(newEntry);
            this.adjustTimerOnInsert(oldEntry);
            return;
        }
        if (entriesRef.size() < 8) {
            this.modifyMainBucket(null, entry);
            return;
        }
        if (this.replaceBadEntry(entry)) {
            return;
        }
        KBucketEntry youngest = entriesRef.get(entriesRef.size() - 1);
        if (youngest.getCreationTime() > entry.getCreationTime()) {
            this.modifyMainBucket(youngest, entry);
            this.pingQuestionable(youngest);
            return;
        }
        this.pingQuestionable(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyMainBucket(KBucketEntry toRemove, KBucketEntry toInsert) {
        KBucket kBucket = this;
        synchronized (kBucket) {
            if (this.entries.contains(toInsert)) {
                return;
            }
            ArrayList<KBucketEntry> newEntries = new ArrayList<KBucketEntry>(this.entries);
            boolean removed = false;
            boolean added = false;
            if (toRemove != null) {
                removed = newEntries.remove(toRemove);
            }
            if (toInsert != null) {
                int oldSize = newEntries.size();
                boolean wasFull = oldSize >= 8;
                KBucketEntry youngest = oldSize > 0 ? (KBucketEntry)newEntries.get(oldSize - 1) : null;
                boolean unorderedInsert = youngest != null && toInsert.getCreationTime() < youngest.getCreationTime();
                boolean bl = added = !wasFull || unorderedInsert;
                if (added) {
                    newEntries.add(toInsert);
                    this.adjustTimerOnInsert(toInsert);
                } else {
                    this.insertInReplacementBucket(toInsert);
                }
                if (unorderedInsert) {
                    Collections.sort(newEntries, KBucketEntry.AGE_ORDER);
                }
                if (wasFull && added) {
                    while (newEntries.size() > 8) {
                        this.insertInReplacementBucket((KBucketEntry)newEntries.remove(newEntries.size() - 1));
                    }
                }
            }
            if (added || removed) {
                this.entries = newEntries;
            }
        }
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public List<KBucketEntry> getEntries() {
        return new ArrayList<KBucketEntry>(this.entries);
    }

    public List<KBucketEntry> getReplacementEntries() {
        return new ArrayList<KBucketEntry>(this.replacementBucket);
    }

    public boolean contains(KBucketEntry entry) {
        return this.entries.contains(entry);
    }

    public boolean onTimeout(InetSocketAddress addr) {
        List<KBucketEntry> entriesRef = this.entries;
        int i = 0;
        int n = entriesRef.size();
        while (i < n) {
            KBucketEntry e = entriesRef.get(i);
            if (e.getAddress() == addr) {
                e.signalRequestTimeout();
                this.removeEntry(e, false);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean needsToBeRefreshed() {
        long now = System.currentTimeMillis();
        if (this.refresh_task != null && this.refresh_task.isFinished()) {
            this.refresh_task = null;
        }
        return now - this.last_modified > 900000L && this.refresh_task == null && this.entries.size() > 0;
    }

    public void updateRefreshTimer() {
        this.last_modified = System.currentTimeMillis();
    }

    public String toString() {
        return "entries: " + this.entries + " replacements: " + this.replacementBucket;
    }

    private void adjustTimerOnInsert(KBucketEntry entry) {
        if (entry.getLastSeen() > this.last_modified) {
            this.last_modified = entry.getLastSeen();
        }
    }

    private boolean pingEntry(final KBucketEntry entry, RPCCallListener listener) {
        if (this.pendingPings.containsKey(entry.getID())) {
            return false;
        }
        RPCServer server = this.node.getDHT().getRandomServer();
        if (server == null) {
            return false;
        }
        PingRequest p = new PingRequest();
        p.setDestination(entry.getAddress());
        RPCCall c = server.doCall(p);
        c.setExpectedID(entry.getID());
        if (c != null) {
            this.pendingPings.put(entry.getID(), entry);
            c.addListener(listener);
            c.addListener(new RPCCallListener(){

                @Override
                public void onTimeout(RPCCallBase c) {
                    KBucket.this.pendingPings.remove(entry.getID());
                }

                @Override
                public void onStall(RPCCallBase c) {
                }

                @Override
                public void onResponse(RPCCallBase c, MessageBase rsp) {
                    KBucket.this.pendingPings.remove(entry.getID());
                }
            });
            return true;
        }
        return false;
    }

    private void pingQuestionable(final KBucketEntry replacement_entry) {
        if (this.pendingPings.size() >= 2) {
            this.insertInReplacementBucket(replacement_entry);
            return;
        }
        for (final KBucketEntry toTest : this.entries) {
            if (!toTest.isQuestionable() || !this.pingEntry(toTest, new RPCCallListener(){

                @Override
                public void onTimeout(RPCCallBase c) {
                    KBucket.this.modifyMainBucket(toTest, replacement_entry);
                    KBucketEntry nextReplacementEntry = KBucket.this.getYoungestReplacementEntry();
                    if (nextReplacementEntry != null && !KBucket.this.replaceBadEntry(nextReplacementEntry)) {
                        KBucket.this.pingQuestionable(nextReplacementEntry);
                    }
                }

                @Override
                public void onStall(RPCCallBase c) {
                }

                @Override
                public void onResponse(RPCCallBase c, MessageBase rsp) {
                    if (!KBucket.this.replaceBadEntry(replacement_entry)) {
                        KBucket.this.pingQuestionable(replacement_entry);
                    }
                }
            })) continue;
            return;
        }
        this.insertInReplacementBucket(replacement_entry);
    }

    private boolean replaceBadEntry(KBucketEntry entry) {
        List<KBucketEntry> entriesRef = this.entries;
        int i = 0;
        int n = entriesRef.size();
        while (i < n) {
            KBucketEntry e = entriesRef.get(i);
            if (e.isBad()) {
                this.modifyMainBucket(e, entry);
                return true;
            }
            ++i;
        }
        return false;
    }

    private KBucketEntry getYoungestReplacementEntry() {
        Iterator<KBucketEntry> it = this.replacementBucket.iterator();
        while (it.hasNext()) {
            KBucketEntry e = it.next();
            if (it.hasNext()) continue;
            it.remove();
            return e;
        }
        return null;
    }

    private void insertInReplacementBucket(KBucketEntry entry) {
        if (entry == null) {
            return;
        }
        int size = 1;
        Iterator<KBucketEntry> it = this.replacementBucket.iterator();
        while (it.hasNext()) {
            KBucketEntry oldEntry = it.next();
            if (oldEntry.equals(entry)) {
                it.remove();
                oldEntry.mergeTimestamps(entry);
                this.replacementBucket.add(oldEntry);
                return;
            }
            ++size;
        }
        this.replacementBucket.add(entry);
        while (size-- > 8) {
            this.replacementBucket.poll();
        }
    }

    public void checkBadEntries() {
        List<KBucketEntry> entriesRef = this.entries;
        KBucketEntry toRemove = null;
        int i = 0;
        int n = entriesRef.size();
        while (i < n) {
            KBucketEntry e = entriesRef.get(i);
            if (e.isBad()) {
                toRemove = e;
                break;
            }
            ++i;
        }
        if (toRemove == null) {
            return;
        }
        KBucketEntry replacement = this.getYoungestReplacementEntry();
        if (replacement != null) {
            this.modifyMainBucket(toRemove, replacement);
        }
    }

    public boolean checkForIDChange(MessageBase msg) {
        List<KBucketEntry> entriesRef = this.entries;
        int i = 0;
        int n = entriesRef.size();
        while (i < n) {
            KBucketEntry entry = entriesRef.get(i);
            if (entry.getAddress().equals(msg.getOrigin()) && !entry.getID().equals(msg.getID())) {
                this.removeEntry(entry, true);
                DHT.log("Node " + entry.getAddress() + " changed ID from " + entry.getID() + " to " + msg.getID(), DHT.LogLevel.Info);
                KBucketEntry newEntry = new KBucketEntry(entry.getAddress(), msg.getID(), entry.getCreationTime());
                newEntry.mergeTimestamps(entry);
                this.node.insertEntry(newEntry, false);
                return true;
            }
            if (msg.getType() == MessageBase.Type.RSP_MSG && entry.getID().equals(msg.getID())) {
                entry.signalResponse();
            }
            ++i;
        }
        return false;
    }

    public void notifyOfResponse(MessageBase msg) {
        if (msg.getType() != MessageBase.Type.RSP_MSG) {
            return;
        }
        List<KBucketEntry> entriesRef = this.entries;
        int i = 0;
        int n = entriesRef.size();
        while (i < n) {
            KBucketEntry entry = entriesRef.get(i);
            if (entry.getID().equals(msg.getID())) {
                entry.signalResponse();
                return;
            }
            ++i;
        }
    }

    public void removeEntry(KBucketEntry toRemove, boolean force) {
        List<KBucketEntry> entriesRef = this.entries;
        if (entriesRef.contains(toRemove) && (force || toRemove.isBad())) {
            KBucketEntry replacement = null;
            replacement = this.getYoungestReplacementEntry();
            if (replacement != null || force) {
                this.modifyMainBucket(toRemove, replacement);
            }
        }
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setRefreshTask(Task refresh_task) {
        this.refresh_task = refresh_task;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Map serialized = (Map)in.readObject();
        Object obj = serialized.get("mainBucket");
        if (obj instanceof Collection) {
            this.entries.addAll((Collection)obj);
        }
        if ((obj = serialized.get("replacementBucket")) instanceof Collection) {
            this.replacementBucket.addAll((Collection)obj);
        }
        if ((obj = serialized.get("lastModifiedTime")) instanceof Long) {
            this.last_modified = (Long)obj;
        }
        obj = serialized.get("prefix");
        this.entries.removeAll(Collections.singleton(null));
        this.replacementBucket.removeAll(Collections.singleton(null));
        Collections.sort(this.entries, KBucketEntry.AGE_ORDER);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        HashMap<String, Object> serialized = new HashMap<String, Object>();
        serialized.put("mainBucket", this.entries);
        serialized.put("replacementBucket", this.replacementBucket);
        serialized.put("lastModifiedTime", this.last_modified);
        out.writeObject(serialized);
    }
}

