/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lbms.plugins.mldht.kad.BloomFilterBEP33;
import lbms.plugins.mldht.kad.DBItem;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.DatabaseStats;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.PeerAddressDBItem;
import lbms.plugins.mldht.kad.utils.ThreadLocalUtils;
import lbms.plugins.mldht.kad.utils.Token;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.core3.util.SHA1;

public class Database {
    private ConcurrentMap<Key, Set<DBItem>> items;
    private DatabaseStats stats;
    private AtomicLong timestampCurrent = new AtomicLong();
    private volatile long timestampPrevious;
    private static byte[] sessionSecret = new byte[20];
    ThreadLocal<SHA1> hashStore = new ThreadLocal();

    static {
        ThreadLocalUtils.getThreadLocalRandom().nextBytes(sessionSecret);
    }

    Database() {
        this.stats = new DatabaseStats();
        this.items = new ConcurrentHashMap<Key, Set<DBItem>>(3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Key key, DBItem dbi) {
        LightHashSet keyEntries = null;
        LightHashSet insertCanidate = new LightHashSet();
        keyEntries = this.items.putIfAbsent(key, insertCanidate);
        if (keyEntries == null) {
            keyEntries = insertCanidate;
            this.stats.setKeyCount(this.items.size());
        }
        LightHashSet lightHashSet = keyEntries;
        synchronized (lightHashSet) {
            if (!keyEntries.remove(dbi)) {
                this.stats.setItemCount(this.stats.getItemCount() + 1);
            }
            keyEntries.add(dbi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DBItem> sample(Key key, int max_entries, DHT.DHTtype forType, boolean preferPeers) {
        Set keyEntry = null;
        ArrayList dbl = null;
        keyEntry = (Set)this.items.get(key);
        if (keyEntry == null) {
            return null;
        }
        Set set = keyEntry;
        synchronized (set) {
            dbl = new ArrayList(keyEntry);
        }
        ArrayList<PeerAddressDBItem> peerlist = new ArrayList<PeerAddressDBItem>(dbl.size());
        ArrayList<PeerAddressDBItem> seedlist = preferPeers ? new ArrayList<PeerAddressDBItem>(dbl.size() >> 1) : null;
        Collections.shuffle(dbl);
        for (DBItem item : dbl) {
            PeerAddressDBItem it;
            if (!(item instanceof PeerAddressDBItem) || (it = (PeerAddressDBItem)item).getAddressType() != forType.PREFERRED_ADDRESS_TYPE) continue;
            if (preferPeers && it.isSeed()) {
                seedlist.add(it);
                continue;
            }
            peerlist.add(it);
        }
        if (preferPeers) {
            peerlist.addAll(seedlist);
        }
        return peerlist.subList(0, Math.min(peerlist.size(), max_entries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BloomFilterBEP33 createScrapeFilter(Key key, boolean seedFilter) {
        Set dbl = (Set)this.items.get(key);
        if (dbl == null || dbl.isEmpty()) {
            return null;
        }
        BloomFilterBEP33 filter2 = new BloomFilterBEP33();
        Set set = dbl;
        synchronized (set) {
            for (DBItem item : dbl) {
                PeerAddressDBItem it;
                if (!(item instanceof PeerAddressDBItem) || seedFilter != (it = (PeerAddressDBItem)item).isSeed()) continue;
                filter2.insert(it.getInetAddress());
            }
        }
        return filter2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expire(long now) {
        int itemCount = 0;
        for (Set dbl : this.items.values()) {
            ArrayList tmp = null;
            Set set = dbl;
            synchronized (set) {
                tmp = new ArrayList(dbl);
                Collections.sort(tmp, DBItem.ageOrdering);
                while (dbl.size() > 0 && ((DBItem)tmp.get(0)).expired(now)) {
                    dbl.remove(tmp.remove(0));
                }
                itemCount += dbl.size();
            }
        }
        Iterator it = this.items.values().iterator();
        while (it.hasNext()) {
            if (!((Set)it.next()).isEmpty()) continue;
            it.remove();
        }
        this.stats.setKeyCount(this.items.size());
        this.stats.setItemCount(itemCount);
    }

    boolean insertForKeyAllowed(Key target) {
        Set entries = (Set)this.items.get(target);
        if (entries == null) {
            return true;
        }
        return entries.size() < 6000;
    }

    private SHA1 getHasher() {
        SHA1 hasher = this.hashStore.get();
        if (hasher == null) {
            hasher = new SHA1();
            this.hashStore.set(hasher);
        } else {
            hasher.reset();
        }
        return hasher;
    }

    Token genToken(InetAddress ip, int port, Key lookupKey) {
        this.updateTokenTimestamps();
        byte[] tdata = new byte[ip.getAddress().length + 2 + 8 + 20 + sessionSecret.length];
        ByteBuffer bb = ByteBuffer.wrap(tdata);
        bb.put(ip.getAddress());
        bb.putShort((short)port);
        bb.putLong(this.timestampCurrent.get());
        bb.put(lookupKey.getHash());
        bb.put(sessionSecret);
        return new Token.OurToken(this.getHasher().digest(bb));
    }

    private void updateTokenTimestamps() {
        long current = this.timestampCurrent.get();
        long now = System.nanoTime();
        while (TimeUnit.NANOSECONDS.toMillis(now - current) > 180000L) {
            if (this.timestampCurrent.compareAndSet(current, now)) {
                this.timestampPrevious = current;
                break;
            }
            current = this.timestampCurrent.get();
        }
    }

    boolean checkToken(Token token, InetAddress ip, int port, Key lookupKey) {
        boolean valid;
        this.updateTokenTimestamps();
        boolean bl = valid = this.checkToken(token, ip, port, lookupKey, this.timestampCurrent.get()) || this.checkToken(token, ip, port, lookupKey, this.timestampPrevious);
        if (!valid) {
            DHT.logDebug("Received Invalid token from " + ip.getHostAddress());
        }
        return valid;
    }

    private boolean checkToken(Token token, InetAddress ip, int port, Key lookupKey, long timeStamp) {
        byte[] tdata = new byte[ip.getAddress().length + 2 + 8 + 20 + sessionSecret.length];
        ByteBuffer bb = ByteBuffer.wrap(tdata);
        bb.put(ip.getAddress());
        bb.putShort((short)port);
        bb.putLong(timeStamp);
        bb.put(lookupKey.getHash());
        bb.put(sessionSecret);
        return token.equals(new Token.OurToken(this.getHasher().digest(bb)));
    }

    boolean contains(Key key) {
        return this.items.containsKey(key);
    }

    public DatabaseStats getStats() {
        return this.stats;
    }
}

