/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lbms.plugins.mldht.DHTConfiguration;
import lbms.plugins.mldht.kad.AnnounceNodeCache;
import lbms.plugins.mldht.kad.DBItem;
import lbms.plugins.mldht.kad.DHTBase;
import lbms.plugins.mldht.kad.DHTConstants;
import lbms.plugins.mldht.kad.DHTIndexingListener;
import lbms.plugins.mldht.kad.DHTLogger;
import lbms.plugins.mldht.kad.DHTStats;
import lbms.plugins.mldht.kad.DHTStatsListener;
import lbms.plugins.mldht.kad.DHTStatus;
import lbms.plugins.mldht.kad.DHTStatusListener;
import lbms.plugins.mldht.kad.Database;
import lbms.plugins.mldht.kad.KBucket;
import lbms.plugins.mldht.kad.KBucketEntryAndToken;
import lbms.plugins.mldht.kad.KClosestNodesSearch;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Node;
import lbms.plugins.mldht.kad.PeerAddressDBItem;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCServer;
import lbms.plugins.mldht.kad.RPCServerBase;
import lbms.plugins.mldht.kad.RPCServerListener;
import lbms.plugins.mldht.kad.RPCStats;
import lbms.plugins.mldht.kad.messages.AnnounceRequest;
import lbms.plugins.mldht.kad.messages.AnnounceResponse;
import lbms.plugins.mldht.kad.messages.ErrorMessage;
import lbms.plugins.mldht.kad.messages.FindNodeRequest;
import lbms.plugins.mldht.kad.messages.FindNodeResponse;
import lbms.plugins.mldht.kad.messages.GetPeersRequest;
import lbms.plugins.mldht.kad.messages.GetPeersResponse;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.messages.PingRequest;
import lbms.plugins.mldht.kad.messages.PingResponse;
import lbms.plugins.mldht.kad.tasks.AnnounceTask;
import lbms.plugins.mldht.kad.tasks.NodeLookup;
import lbms.plugins.mldht.kad.tasks.PeerLookupTask;
import lbms.plugins.mldht.kad.tasks.PingRefreshTask;
import lbms.plugins.mldht.kad.tasks.Task;
import lbms.plugins.mldht.kad.tasks.TaskListener;
import lbms.plugins.mldht.kad.tasks.TaskManager;
import lbms.plugins.mldht.kad.utils.AddressUtils;
import lbms.plugins.mldht.kad.utils.PopulationEstimator;
import lbms.plugins.mldht.kad.utils.ThreadLocalUtils;
import lbms.plugins.mldht.kad.utils.Token;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHT
implements DHTBase {
    private static DHTLogger logger;
    private static LogLevel logLevel;
    private static ScheduledThreadPoolExecutor scheduler;
    private static ThreadGroup executorGroup;
    private boolean running;
    private boolean stopped;
    private long server_create_counter;
    private long last_rpc_create;
    private boolean bootstrapping;
    private long lastBootstrap;
    private DHTConfiguration config;
    private Node node;
    private List<RPCServer> servers = new CopyOnWriteArrayList<RPCServer>();
    private Database db;
    private TaskManager tman;
    private File table_file;
    private boolean useRouterBootstrapping;
    private List<DHTStatsListener> statsListeners;
    private List<DHTStatusListener> statusListeners;
    private List<DHTIndexingListener> indexingListeners;
    private DHTStats stats;
    private DHTStatus status;
    private PopulationEstimator estimator;
    private AnnounceNodeCache cache;
    private RPCStats serverStats;
    private final DHTtype type;
    private List<ScheduledFuture<?>> scheduledActions = new ArrayList();
    static Map<DHTtype, DHT> dhts;
    private static final Map<String, Object[]> bn_resolver_history;

    static {
        logLevel = LogLevel.Info;
        executorGroup = new ThreadGroup("mlDHT");
        DHT.initStatics();
        bn_resolver_history = new HashMap<String, Object[]>();
    }

    public static void initStatics() {
        DHT.createScheduler();
        DHT.createLogger();
    }

    private static void createScheduler() {
        int threads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        scheduler = new ScheduledThreadPoolExecutor(threads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(executorGroup, r, "mlDHT Executor");
                t.setDaemon(true);
                return t;
            }
        });
        scheduler.setCorePoolSize(threads);
        scheduler.setMaximumPoolSize(threads * 2);
        scheduler.setKeepAliveTime(20L, TimeUnit.SECONDS);
        scheduler.allowCoreThreadTimeOut(true);
    }

    private static void createLogger() {
        logger = new DHTLogger(){

            @Override
            public void log(String message) {
                System.out.println(message);
            }

            @Override
            public void log(Throwable e) {
                e.printStackTrace();
            }
        };
    }

    public static synchronized Map<DHTtype, DHT> createDHTs() {
        if (dhts == null) {
            dhts = new EnumMap<DHTtype, DHT>(DHTtype.class);
            dhts.put(DHTtype.IPV4_DHT, new DHT(DHTtype.IPV4_DHT));
            dhts.put(DHTtype.IPV6_DHT, new DHT(DHTtype.IPV6_DHT));
        }
        return dhts;
    }

    public static DHT getDHT(DHTtype type) {
        return dhts.get((Object)type);
    }

    private DHT(DHTtype type) {
        this.type = type;
        this.stats = new DHTStats();
        this.status = DHTStatus.Stopped;
        this.statsListeners = new ArrayList<DHTStatsListener>(2);
        this.statusListeners = new ArrayList<DHTStatusListener>(2);
        this.indexingListeners = new ArrayList<DHTIndexingListener>();
        this.estimator = new PopulationEstimator();
    }

    @Override
    public void ping(PingRequest r) {
        if (!this.isRunning()) {
            return;
        }
        if (this.node.allLocalIDs().contains(r.getID())) {
            return;
        }
        PingResponse rsp = new PingResponse(r.getMTID());
        rsp.setDestination(r.getOrigin());
        r.getServer().sendMessage(rsp);
        this.node.recieved(this, r);
    }

    @Override
    public void findNode(FindNodeRequest r) {
        if (!this.isRunning()) {
            return;
        }
        if (this.node.allLocalIDs().contains(r.getID())) {
            return;
        }
        this.node.recieved(this, r);
        KClosestNodesSearch kns4 = null;
        KClosestNodesSearch kns6 = null;
        if (r.doesWant4()) {
            kns4 = new KClosestNodesSearch(r.getTarget(), 8, DHT.getDHT(DHTtype.IPV4_DHT));
            kns4.fill(DHTtype.IPV4_DHT != this.type);
        }
        if (r.doesWant6()) {
            kns6 = new KClosestNodesSearch(r.getTarget(), 8, DHT.getDHT(DHTtype.IPV6_DHT));
            kns6.fill(DHTtype.IPV6_DHT != this.type);
        }
        FindNodeResponse fnr = new FindNodeResponse(r.getMTID(), kns4 != null ? kns4.pack() : null, kns6 != null ? kns6.pack() : null);
        fnr.setOrigin(r.getOrigin());
        r.getServer().sendMessage(fnr);
    }

    @Override
    public void response(MessageBase r) {
        if (!this.isRunning()) {
            return;
        }
        this.node.recieved(this, r);
    }

    @Override
    public void getPeers(GetPeersRequest r) {
        if (!this.isRunning()) {
            return;
        }
        if (this.node.allLocalIDs().contains(r.getID())) {
            return;
        }
        this.node.recieved(this, r);
        List<DBItem> dbl = this.db.sample(r.getInfoHash(), 50, this.type, r.isNoSeeds());
        for (DHTIndexingListener listener : this.indexingListeners) {
            List<PeerAddressDBItem> toAdd = listener.incomingPeersRequest(r.getInfoHash(), r.getOrigin().getAddress(), r.getID());
            if (dbl == null && !toAdd.isEmpty()) {
                dbl = new ArrayList<DBItem>();
            }
            if (dbl == null || toAdd.isEmpty()) continue;
            dbl.addAll(toAdd);
        }
        Token token = this.db.genToken(r.getOrigin().getAddress(), r.getOrigin().getPort(), r.getInfoHash());
        KClosestNodesSearch kns4 = null;
        KClosestNodesSearch kns6 = null;
        if (r.doesWant4()) {
            kns4 = new KClosestNodesSearch(r.getTarget(), 8, DHT.getDHT(DHTtype.IPV4_DHT));
            kns4.fill(DHTtype.IPV4_DHT != this.type);
        }
        if (r.doesWant6()) {
            kns6 = new KClosestNodesSearch(r.getTarget(), 8, DHT.getDHT(DHTtype.IPV6_DHT));
            kns6.fill(DHTtype.IPV6_DHT != this.type);
        }
        GetPeersResponse resp = new GetPeersResponse(r.getMTID(), kns4 != null ? kns4.pack() : null, kns6 != null ? kns6.pack() : null, this.db.insertForKeyAllowed(r.getInfoHash()) ? token : null);
        if (r.isScrape()) {
            resp.setScrapePeers(this.db.createScrapeFilter(r.getInfoHash(), false));
            resp.setScrapeSeeds(this.db.createScrapeFilter(r.getInfoHash(), true));
        }
        resp.setPeerItems(dbl);
        resp.setDestination(r.getOrigin());
        r.getServer().sendMessage(resp);
    }

    @Override
    public void announce(AnnounceRequest r) {
        if (!this.isRunning()) {
            return;
        }
        if (this.node.allLocalIDs().contains(r.getID())) {
            return;
        }
        this.node.recieved(this, r);
        Token token = r.getToken();
        if (!this.db.checkToken(token, r.getOrigin().getAddress(), r.getOrigin().getPort(), r.getInfoHash())) {
            DHT.logDebug("DHT Received Announce Request with invalid token.");
            this.sendError(r, ErrorMessage.ErrorCode.ProtocolError.code, "Invalid Token");
            return;
        }
        DHT.logDebug("DHT Received Announce Request, adding peer to db: " + r.getOrigin().getAddress());
        PeerAddressDBItem item = PeerAddressDBItem.createFromAddress(r.getOrigin().getAddress(), r.getPort(), r.isSeed());
        if (!AddressUtils.isBogon(item)) {
            this.db.store(r.getInfoHash(), item);
        }
        AnnounceResponse rsp = new AnnounceResponse(r.getMTID());
        rsp.setOrigin(r.getOrigin());
        r.getServer().sendMessage(rsp);
    }

    @Override
    public void error(ErrorMessage r) {
        DHT.logError("Error [" + r.getCode() + "] from: " + r.getOrigin() + " Message: \"" + r.getMessage() + "\"");
    }

    @Override
    public void timeout(RPCCallBase r) {
        if (this.isRunning()) {
            this.node.onTimeout(r);
        }
    }

    @Override
    public void addDHTNode(String host, int hport) {
        if (!this.isRunning()) {
            return;
        }
        InetSocketAddress addr = new InetSocketAddress(host, hport);
        if (!addr.isUnresolved() && !AddressUtils.isBogon(addr)) {
            if (!this.type.PREFERRED_ADDRESS_TYPE.isInstance(addr.getAddress()) || this.node.getNumEntriesInRoutingTable() > 30) {
                return;
            }
            RPCServer server = this.getRandomServer();
            if (server != null) {
                server.ping(addr);
            }
        }
    }

    @Override
    public PeerLookupTask createPeerLookup(byte[] info_hash) {
        if (!this.isRunning()) {
            return null;
        }
        RPCServer server = this.getRandomServer();
        if (server == null) {
            return null;
        }
        Key id = new Key(info_hash);
        PeerLookupTask lookupTask = new PeerLookupTask(server, this.node, id);
        return lookupTask;
    }

    @Override
    public AnnounceTask announce(PeerLookupTask lookup, boolean isSeed, int btPort) {
        if (!this.isRunning()) {
            return null;
        }
        AnnounceTask announce = new AnnounceTask(lookup.getRPC(), this.node, lookup.getInfoHash(), btPort);
        announce.setSeed(isSeed);
        for (KBucketEntryAndToken kbe : lookup.getAnnounceCanidates()) {
            announce.addToTodo(kbe);
        }
        this.tman.addTask(announce);
        return announce;
    }

    @Override
    public PingRefreshTask refreshBuckets(List<Node.RoutingTableEntry> buckets, boolean cleanOnTimeout) {
        RPCServer server = this.getRandomServer();
        if (server == null) {
            return null;
        }
        PingRefreshTask prt = new PingRefreshTask((RPCServerBase)server, this.node, buckets, cleanOnTimeout);
        this.tman.addTask(prt, true);
        return prt;
    }

    public DHTConfiguration getConfig() {
        return this.config;
    }

    public AnnounceNodeCache getCache() {
        return this.cache;
    }

    public List<RPCServer> getServers() {
        return this.servers;
    }

    public RPCServer getRandomServer() {
        RPCServer srv = null;
        if (this.servers != null) {
            int s;
            while ((s = this.servers.size()) >= 1) {
                try {
                    srv = this.servers.get(ThreadLocalUtils.getThreadLocalRandom().nextInt(s));
                    break;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
            }
        }
        return srv;
    }

    void addServer(RPCServer toAdd) {
        this.servers.add(toAdd);
    }

    void removeServer(RPCServer toRemove) {
        this.servers.remove(toRemove);
    }

    public PopulationEstimator getEstimator() {
        return this.estimator;
    }

    public DHTtype getType() {
        return this.type;
    }

    @Override
    public DHTStats getStats() {
        return this.stats;
    }

    public DHTStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isRunning() {
        return this.running && !this.stopped && this.servers.size() > 0;
    }

    @Override
    public void portRecieved(String ip, int port) {
        if (!this.isRunning()) {
            return;
        }
        RPCServer server = this.getRandomServer();
        if (server == null) {
            return;
        }
        PingRequest r = new PingRequest();
        r.setOrigin(new InetSocketAddress(ip, port));
        server.doCall(r);
    }

    private int getPort() {
        int port = this.config.getListeningPort();
        if (port < 1 || port > 65535) {
            port = 49001;
        }
        return port;
    }

    @Override
    public void start(DHTConfiguration config, final RPCServerListener serverListener) throws SocketException {
        if (this.running || this.stopped) {
            return;
        }
        this.config = config;
        this.useRouterBootstrapping = !config.noRouterBootstrap();
        this.setStatus(DHTStatus.Initializing);
        this.stats.resetStartedTimestamp();
        this.table_file = config.getNodeCachePath();
        Node.initDataStore(config);
        DHT.logInfo("Starting DHT on port " + this.getPort());
        this.resolveBootstrapAddresses();
        this.serverStats = new RPCStats();
        this.cache = new AnnounceNodeCache();
        this.stats.setRpcStats(this.serverStats);
        this.node = new Node(this);
        this.db = new Database();
        this.stats.setDbStats(this.db.getStats());
        this.tman = new TaskManager();
        this.running = true;
        this.scheduledActions.add(scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    DHT.this.tman.removeFinishedTasks(DHT.this);
                    if (DHT.this.running && DHT.this.hasStatsListeners()) {
                        DHT.this.onStatsUpdate();
                    }
                }
                catch (Throwable e) {
                    DHT.log(e, LogLevel.Fatal);
                }
            }
        }, 5000L, 1000L, TimeUnit.MILLISECONDS));
        int i = 0;
        while (i < AddressUtils.getAvailableAddrs(config.allowMultiHoming(), this.type.PREFERRED_ADDRESS_TYPE).size()) {
            new RPCServer(this, this.getPort(), this.serverStats, serverListener);
            ++i;
        }
        this.bootstrapping = true;
        this.node.loadTable(new Runnable(){

            @Override
            public void run() {
                DHT.this.started(serverListener);
            }
        });
    }

    protected void started(final RPCServerListener serverListener) {
        if (this.stopped) {
            return;
        }
        this.bootstrapping = false;
        this.bootstrap();
        this.scheduledActions.add(scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    DHT.this.update(serverListener);
                }
                catch (Throwable e) {
                    DHT.log(e, LogLevel.Fatal);
                }
            }
        }, 5000L, 1000L, TimeUnit.MILLISECONDS));
        this.scheduledActions.add(scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    long now = System.currentTimeMillis();
                    DHT.this.db.expire(now);
                    DHT.this.cache.cleanup(now);
                }
                catch (Throwable e) {
                    DHT.log(e, LogLevel.Fatal);
                }
            }
        }, 1000L, 300000L, TimeUnit.MILLISECONDS));
        this.scheduledActions.add(scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    for (RPCServer srv : DHT.this.servers) {
                        DHT.this.findNode(Key.createRandomKey(), false, false, true, srv).setInfo("Random Refresh Lookup");
                    }
                }
                catch (Throwable e) {
                    DHT.log(e, LogLevel.Fatal);
                }
                try {
                    if (!DHT.this.node.isInSurvivalMode()) {
                        DHT.this.node.saveTable(DHT.this.table_file, false);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, 600000L, 600000L, TimeUnit.MILLISECONDS));
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.stopped();
        DHT.logInfo("Stopping DHT");
        Task[] taskArray = this.tman.getActiveTasks();
        int n = taskArray.length;
        int n2 = 0;
        while (n2 < n) {
            Task t = taskArray[n2];
            t.kill();
            ++n2;
        }
        for (ScheduledFuture<?> future : this.scheduledActions) {
            future.cancel(false);
        }
        scheduler.getQueue().removeAll(this.scheduledActions);
        scheduler.shutdownNow();
        this.scheduledActions.clear();
        for (RPCServer s : this.servers) {
            s.destroy();
        }
        try {
            if (this.node != null) {
                this.node.saveTable(this.table_file, true);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.running = false;
        this.tman = null;
        this.db = null;
        this.node = null;
        this.cache = null;
        this.setStatus(DHTStatus.Stopped);
        dhts = null;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.tman;
    }

    public void stopped() {
        this.stopped = true;
    }

    protected void update(RPCServerListener serverListener) {
        long mono_now = SystemTime.getMonotonousTime();
        if (this.running && (this.config.allowMultiHoming() || this.servers.size() < 1)) {
            int delay = 1000;
            int i = 0;
            while ((long)i < this.server_create_counter) {
                if ((delay *= 2) > 60000) {
                    delay = 60000;
                    break;
                }
                ++i;
            }
            if (this.last_rpc_create == 0L || mono_now - this.last_rpc_create >= (long)delay) {
                this.last_rpc_create = mono_now;
                new RPCServer(this, this.getPort(), this.serverStats, serverListener);
                ++this.server_create_counter;
            } else {
                return;
            }
        }
        if (!this.isRunning()) {
            return;
        }
        this.server_create_counter = 0L;
        long now = System.currentTimeMillis();
        this.node.doBucketChecks(now);
        if (!this.bootstrapping) {
            if (this.node.getNumEntriesInRoutingTable() < 30) {
                this.bootstrap();
            } else if (now - this.lastBootstrap > 1800000L) {
                PingRefreshTask prt = new PingRefreshTask(this.getRandomServer(), this.node, false);
                prt.setInfo("Refreshing old entries.");
                if (this.canStartTask(prt)) {
                    prt.start();
                }
                this.tman.addTask(prt, true);
                this.bootstrap();
            } else {
                this.setStatus(DHTStatus.Running);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveBootstrapAddresses() {
        ArrayList<InetSocketAddress> nodeAddresses = new ArrayList<InetSocketAddress>();
        int i = 0;
        while (i < DHTConstants.BOOTSTRAP_NODES.length) {
            block15: {
                long now;
                Object[] cache;
                String cache_key;
                int port;
                String hostname;
                block14: {
                    block13: {
                        long next_lookup;
                        hostname = DHTConstants.BOOTSTRAP_NODES[i];
                        port = DHTConstants.BOOTSTRAP_PORTS[i];
                        cache_key = String.valueOf(hostname) + ":" + port;
                        Map<String, Object[]> map = bn_resolver_history;
                        synchronized (map) {
                            cache = bn_resolver_history.get(cache_key);
                        }
                        now = SystemTime.getMonotonousTime();
                        if (cache == null) break block13;
                        long last_lookup = (Long)cache[0];
                        long consec_fails = (Long)cache[1];
                        InetAddress[] last_result = (InetAddress[])cache[2];
                        if (consec_fails <= 0L || (next_lookup = last_lookup + Math.min(0x6DDD00L, 300000L << (int)(consec_fails - 1L))) <= now) break block14;
                        if (last_result != null) {
                            InetAddress[] inetAddressArray = last_result;
                            int n = last_result.length;
                            int n2 = 0;
                            while (n2 < n) {
                                InetAddress addr = inetAddressArray[n2];
                                nodeAddresses.add(new InetSocketAddress(addr, port));
                                ++n2;
                            }
                        }
                        break block15;
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[0] = now;
                    objectArray[1] = 0L;
                    cache = objectArray;
                }
                try {
                    InetAddress[] result;
                    InetAddress[] inetAddressArray = result = InetAddress.getAllByName(hostname);
                    int n = result.length;
                    int n3 = 0;
                    while (n3 < n) {
                        InetAddress addr = inetAddressArray[n3];
                        nodeAddresses.add(new InetSocketAddress(addr, port));
                        ++n3;
                    }
                    cache[0] = now;
                    cache[1] = 0L;
                    cache[2] = result;
                }
                catch (Throwable e) {
                    cache[1] = (Long)cache[1] + 1L;
                }
                Map<String, Object[]> map = bn_resolver_history;
                synchronized (map) {
                    bn_resolver_history.put(cache_key, cache);
                }
            }
            ++i;
        }
        if (nodeAddresses.size() > 0) {
            DHTConstants.BOOTSTRAP_NODE_ADDRESSES = nodeAddresses;
        }
    }

    public synchronized void bootstrap() {
        if (!this.isRunning() || this.bootstrapping || System.currentTimeMillis() - this.lastBootstrap < 240000L) {
            return;
        }
        if (this.useRouterBootstrapping || this.node.getNumEntriesInRoutingTable() > 1) {
            final AtomicInteger finishCount = new AtomicInteger();
            this.bootstrapping = true;
            TaskListener bootstrapListener = new TaskListener(){

                @Override
                public void finished(Task t) {
                    int count = finishCount.decrementAndGet();
                    DHT.this.bootstrapping = false;
                    if (count == 0 && DHT.this.running && DHT.this.node.getNumEntriesInRoutingTable() > 10) {
                        DHT.this.node.fillBuckets(DHT.this);
                    }
                }
            };
            DHT.logInfo("Bootstrapping...");
            this.lastBootstrap = System.currentTimeMillis();
            for (RPCServer srv : this.servers) {
                finishCount.incrementAndGet();
                NodeLookup nl = this.findNode(srv.getDerivedID(), true, true, true, srv);
                if (nl == null) {
                    this.bootstrapping = false;
                    break;
                }
                if (this.node.getNumEntriesInRoutingTable() < 10) {
                    if (this.useRouterBootstrapping) {
                        this.resolveBootstrapAddresses();
                        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>(DHTConstants.BOOTSTRAP_NODE_ADDRESSES);
                        Collections.shuffle(addrs);
                        for (InetSocketAddress addr : addrs) {
                            if (!this.type.PREFERRED_ADDRESS_TYPE.isInstance(addr.getAddress())) continue;
                            nl.addDHTNode(addr.getAddress(), addr.getPort());
                            break;
                        }
                    }
                    nl.addListener(bootstrapListener);
                    nl.setInfo("Bootstrap: Find Peers.");
                    this.tman.removeFinishedTasks(this);
                    continue;
                }
                nl.setInfo("Bootstrap: search for ourself.");
                nl.addListener(bootstrapListener);
                this.tman.removeFinishedTasks(this);
            }
        }
    }

    private NodeLookup findNode(Key id, boolean isBootstrap, boolean isPriority, boolean queue, RPCServer server) {
        if (!this.running) {
            return null;
        }
        NodeLookup at = new NodeLookup(id, (RPCServerBase)server, this.node, isBootstrap);
        if (!queue && this.canStartTask(at)) {
            at.start();
        }
        this.tman.addTask(at, isPriority);
        return at;
    }

    @Override
    public NodeLookup findNode(Key id) {
        RPCServer server = this.getRandomServer();
        if (server == null) {
            return null;
        }
        return this.findNode(id, false, false, true, server);
    }

    @Override
    public NodeLookup fillBucket(Key id, KBucket bucket) {
        RPCServer server = this.getRandomServer();
        if (server == null) {
            return null;
        }
        bucket.updateRefreshTimer();
        return this.findNode(id, false, true, true, server);
    }

    @Override
    public PingRefreshTask refreshBucket(KBucket bucket) {
        if (!this.isRunning()) {
            return null;
        }
        RPCServer server = this.getRandomServer();
        if (server == null) {
            return null;
        }
        PingRefreshTask prt = new PingRefreshTask((RPCServerBase)server, this.node, bucket, false);
        if (this.canStartTask(prt)) {
            prt.start();
        }
        this.tman.addTask(prt);
        return prt;
    }

    public void sendError(MessageBase origMsg, int code, String msg) {
        this.sendError(origMsg.getOrigin(), origMsg.getMTID(), code, msg, origMsg.getServer());
    }

    public void sendError(InetSocketAddress target, byte[] mtid, int code, String msg, RPCServer srv) {
        ErrorMessage errMsg = new ErrorMessage(mtid, code, msg);
        errMsg.setDestination(target);
        srv.sendMessage(errMsg);
    }

    @Override
    public boolean canStartTask(Task toCheck) {
        return this.tman.getNumTasks() < 7 * this.servers.size() && toCheck.getRPC().getNumActiveRPCCalls() + 16 < 256;
    }

    @Override
    public Key getOurID() {
        if (this.running) {
            return this.node.getRootID();
        }
        return null;
    }

    private boolean hasStatsListeners() {
        return !this.statsListeners.isEmpty();
    }

    private void onStatsUpdate() {
        this.stats.setNumTasks(this.tman.getNumTasks() + this.tman.getNumQueuedTasks());
        this.stats.setNumPeers(this.node.getNumEntriesInRoutingTable());
        int numSent = 0;
        int numReceived = 0;
        int activeCalls = 0;
        for (RPCServer s : this.servers) {
            numSent += s.getNumSent();
            numReceived += s.getNumReceived();
            activeCalls += s.getNumActiveRPCCalls();
        }
        this.stats.setNumSentPackets(numSent);
        this.stats.setNumReceivedPackets(numReceived);
        this.stats.setNumRpcCalls(activeCalls);
        int i = 0;
        while (i < this.statsListeners.size()) {
            this.statsListeners.get(i).statsUpdated(this.stats);
            ++i;
        }
    }

    private void setStatus(DHTStatus status) {
        if (!this.status.equals((Object)status)) {
            DHTStatus old = this.status;
            this.status = status;
            if (!this.statusListeners.isEmpty()) {
                int i = 0;
                while (i < this.statusListeners.size()) {
                    this.statusListeners.get(i).statusChanged(status, old);
                    ++i;
                }
            }
        }
    }

    @Override
    public void addStatsListener(DHTStatsListener listener) {
        this.statsListeners.add(listener);
    }

    @Override
    public void removeStatsListener(DHTStatsListener listener) {
        this.statsListeners.remove(listener);
    }

    public void addIndexingLinstener(DHTIndexingListener listener) {
        this.indexingListeners.add(listener);
    }

    public void addStatusListener(DHTStatusListener listener) {
        this.statusListeners.add(listener);
    }

    public void removeStatusListener(DHTStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    public static void setLogger(DHTLogger logger) {
        DHT.logger = logger;
    }

    public static LogLevel getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(LogLevel logLevel) {
        DHT.logLevel = logLevel;
        logger.log("Change LogLevel to: " + (Object)((Object)logLevel));
    }

    public static ScheduledExecutorService getScheduler() {
        return scheduler;
    }

    public static void log(String message, LogLevel level) {
        if (level.compareTo(logLevel) < 1) {
            logger.log(message);
        }
    }

    public static void log(Throwable e, LogLevel level) {
        if (level.compareTo(logLevel) < 1) {
            logger.log(e);
        }
    }

    public static void logFatal(String message) {
        DHT.log(message, LogLevel.Fatal);
    }

    public static void logError(String message) {
        DHT.log(message, LogLevel.Error);
    }

    public static void logInfo(String message) {
        DHT.log(message, LogLevel.Info);
    }

    public static void logDebug(String message) {
        DHT.log(message, LogLevel.Debug);
    }

    public static void logVerbose(String message) {
        DHT.log(message, LogLevel.Verbose);
    }

    public static boolean isLogLevelEnabled(LogLevel level) {
        return level.compareTo(logLevel) < 1;
    }

    public static enum DHTtype {
        IPV4_DHT("IPv4", 26, 6, Inet4Address.class, 28),
        IPV6_DHT("IPv6", 38, 18, Inet6Address.class, 48);

        public final int HEADER_LENGTH;
        public final int NODES_ENTRY_LENGTH;
        public final int ADDRESS_ENTRY_LENGTH;
        public final Class<? extends InetAddress> PREFERRED_ADDRESS_TYPE;
        public final String shortName;

        private DHTtype(String shortName, int nodeslength, int addresslength, Class<? extends InetAddress> addresstype, int header) {
            this.shortName = shortName;
            this.NODES_ENTRY_LENGTH = nodeslength;
            this.PREFERRED_ADDRESS_TYPE = addresstype;
            this.ADDRESS_ENTRY_LENGTH = addresslength;
            this.HEADER_LENGTH = header;
        }
    }

    public static enum LogLevel {
        Fatal,
        Error,
        Info,
        Debug,
        Verbose;

    }
}

