/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Prefix;

public class AnnounceNodeCache {
    ConcurrentSkipListSet<CacheAnchorPoint> anchors = new ConcurrentSkipListSet();
    ConcurrentSkipListMap<Key, CacheBucket> cache = new ConcurrentSkipListMap();

    public AnnounceNodeCache() {
        CacheBucket rootBucket = new CacheBucket(new Prefix());
        this.cache.put(rootBucket.prefix, rootBucket);
    }

    public void register(Key target) {
        CacheAnchorPoint anchor = new CacheAnchorPoint(target);
        this.anchors.remove(anchor);
        this.anchors.add(anchor);
    }

    public void removeEntry(Key nodeId) {
        if (nodeId != null) {
            Map.Entry<Key, CacheBucket> targetEntry = this.cache.floorEntry(nodeId);
            if (targetEntry == null || !targetEntry.getValue().prefix.isPrefixOf(nodeId)) {
                return;
            }
            int oldSize = targetEntry.getValue().numEntries.get();
            int i = 0;
            Iterator<KBucketEntry> it = targetEntry.getValue().entries.iterator();
            while (it.hasNext()) {
                ++i;
                if (!it.next().getID().equals(nodeId)) continue;
                it.remove();
                --i;
            }
            targetEntry.getValue().numEntries.compareAndSet(oldSize, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(KBucketEntry entryToInsert) {
        block9: {
            CacheBucket targetBucket;
            Key target = entryToInsert.getID();
            while (true) {
                Map.Entry<Key, CacheBucket> targetEntry;
                if ((targetEntry = this.cache.floorEntry(target)) == null || !targetEntry.getValue().prefix.isPrefixOf(target)) {
                    Thread.yield();
                    continue;
                }
                targetBucket = targetEntry.getValue();
                int size = targetBucket.numEntries.get();
                if (targetBucket.entries.contains(entryToInsert)) break block9;
                if (size >= 10) {
                    Key anchor = this.anchors.ceiling(new CacheAnchorPoint(targetBucket.prefix));
                    if (anchor == null || !targetBucket.prefix.isPrefixOf(anchor)) break block9;
                    CacheBucket cacheBucket = targetBucket;
                    synchronized (cacheBucket) {
                        if (this.cache.get(targetBucket.prefix) != targetBucket) {
                        }
                        CacheBucket lowerBucket = new CacheBucket(targetBucket.prefix.splitPrefixBranch(false));
                        CacheBucket upperBucket = new CacheBucket(targetBucket.prefix.splitPrefixBranch(true));
                        if (!this.cache.remove(targetEntry.getKey(), targetBucket)) {
                        }
                        this.cache.put(upperBucket.prefix, upperBucket);
                        this.cache.put(lowerBucket.prefix, lowerBucket);
                        for (KBucketEntry e : targetBucket.entries) {
                            this.add(e);
                        }
                    }
                }
                if (targetBucket.numEntries.compareAndSet(size, size + 1)) break;
            }
            targetBucket.entries.add(entryToInsert);
        }
    }

    public List<KBucketEntry> get(Key target, int count, Set<KBucketEntry> toExclude) {
        ArrayList<KBucketEntry> closestSet = new ArrayList<KBucketEntry>(2 * count);
        Map.Entry<Key, CacheBucket> ceil = this.cache.ceilingEntry(target);
        Map.Entry<Key, CacheBucket> floor = this.cache.floorEntry(target);
        if (ceil != null) {
            closestSet.addAll(ceil.getValue().entries);
        }
        if (floor != null && (ceil == null || floor.getValue() != ceil.getValue())) {
            closestSet.addAll(floor.getValue().entries);
        }
        while (closestSet.size() / 2 < count && (floor != null || ceil != null)) {
            if (floor != null) {
                floor = this.cache.lowerEntry(floor.getKey());
            }
            if (ceil != null) {
                ceil = this.cache.higherEntry(ceil.getKey());
            }
            if (ceil != null) {
                closestSet.addAll(ceil.getValue().entries);
            }
            if (floor == null) continue;
            closestSet.addAll(floor.getValue().entries);
        }
        closestSet.removeAll(toExclude);
        Collections.sort(closestSet, new KBucketEntry.DistanceOrder(target));
        int i = closestSet.size() - 1;
        while (i >= count) {
            closestSet.remove(i);
            --i;
        }
        return closestSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(long now) {
        Iterator<Object> it = this.anchors.iterator();
        while (it.hasNext()) {
            if (now - it.next().insertationTime <= 1800000L) continue;
            it.remove();
        }
        for (CacheBucket b : this.cache.values()) {
            Iterator<KBucketEntry> it2 = b.entries.iterator();
            while (it2.hasNext()) {
                if (now - it2.next().getLastSeen() <= 1800000L) continue;
                it2.remove();
            }
            b.numEntries.set(b.entries.size());
        }
        Map.Entry<Key, CacheBucket> entry = this.cache.firstEntry();
        if (entry == null) {
            return;
        }
        CacheBucket current = null;
        CacheBucket next = entry.getValue();
        while (true) {
            Prefix parent;
            Key anchor;
            current = next;
            entry = this.cache.higherEntry(current.prefix);
            if (entry == null) {
                return;
            }
            next = entry.getValue();
            if (!current.prefix.isSiblingOf(next.prefix) || (anchor = (Key)this.anchors.ceiling(new CacheAnchorPoint(parent = current.prefix.getParentPrefix()))) != null && parent.isPrefixOf(anchor) && current.numEntries.get() + next.numEntries.get() >= 10) continue;
            CacheBucket cacheBucket = current;
            synchronized (cacheBucket) {
                CacheBucket cacheBucket2 = next;
                synchronized (cacheBucket2) {
                    if (this.cache.get(current.prefix) != current || this.cache.get(next.prefix) != next) {
                        continue;
                    }
                    this.cache.remove(current.prefix, current);
                    this.cache.remove(next.prefix, next);
                    this.cache.put(parent, new CacheBucket(parent));
                    for (KBucketEntry e : current.entries) {
                        this.add(e);
                    }
                    for (KBucketEntry e : next.entries) {
                        this.add(e);
                    }
                }
            }
            entry = this.cache.lowerEntry(current.prefix);
            if (entry == null) continue;
            next = entry.getValue();
        }
    }

    private static class CacheAnchorPoint
    extends Key {
        long insertationTime = System.currentTimeMillis();

        public CacheAnchorPoint(Key k) {
            this.hash = k.hash;
        }
    }

    private static class CacheBucket {
        Prefix prefix;
        AtomicInteger numEntries = new AtomicInteger();
        ConcurrentLinkedQueue<KBucketEntry> entries = new ConcurrentLinkedQueue();

        public CacheBucket(Prefix p) {
            this.prefix = p;
        }
    }
}

