/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.azureus;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.gudy.azureus2.plugins.download.Download;

public class TrackedTorrent
implements Delayed {
    private long timestamp;
    private long lastAnnounceStart;
    private Download download;
    private boolean announcing;
    private int announceCount;

    public TrackedTorrent(Download download) {
        this.download = download;
    }

    public TrackedTorrent(Download download, long delay) {
        this.download = download;
        this.setDelay(delay);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.timestamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(TrackedTorrent o) {
        long x = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
        if (x > 0L) {
            return 1;
        }
        if (x < 0L) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(Delayed o) {
        long x = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
        if (x > 0L) {
            return 1;
        }
        if (x < 0L) {
            return -1;
        }
        return 0;
    }

    public boolean isAnnouncing() {
        return this.announcing;
    }

    public boolean scrapeOnly() {
        return this.download.getState() == 9;
    }

    public void setAnnouncing(boolean announcing) {
        this.announcing = announcing;
        if (announcing) {
            ++this.announceCount;
        }
    }

    public int getAnnounceCount() {
        return this.announceCount;
    }

    public void setDelay(long delay) {
        this.timestamp = System.currentTimeMillis() + delay;
    }

    public void setDelay(long delay, TimeUnit unit) {
        this.timestamp = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(delay, unit);
    }

    public Download getDownload() {
        return this.download;
    }

    public long getLastAnnounceStart() {
        return this.lastAnnounceStart;
    }

    public void setLastAnnounceStart(long lastAnnounceStart) {
        this.lastAnnounceStart = lastAnnounceStart;
    }
}

