/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.plugins.rcmplugin;

import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.plugins.rcmplugin.RCMPlugin;
import com.aelitis.plugins.rcmplugin.SearchRelatedContent;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchResult;

public final class RCM_JSONServer
implements Utilities.JSONServer {
    private final RCMPlugin rcmPlugin;
    private Map<String, SearchInstance> mapSearchInstances = new HashMap<String, SearchInstance>();
    private Map<String, Map> mapSearchResults = new HashMap<String, Map>();
    private List<String> methods = new ArrayList<String>();

    RCM_JSONServer(RCMPlugin rcmPlugin) {
        this.methods.add("rcm-is-enabled");
        this.methods.add("rcm-get-list");
        this.methods.add("rcm-lookup-start");
        this.methods.add("rcm-lookup-remove");
        this.methods.add("rcm-remove");
        this.methods.add("rcm-set-read");
        this.methods.add("rcm-lookup-get-results");
        this.methods.add("rcm-set-enabled");
        this.methods.add("rcm-create-subscription");
        this.rcmPlugin = rcmPlugin;
    }

    @Override
    public String getName() {
        return "SwarmDiscoveries";
    }

    @Override
    public List<String> getSupportedMethods() {
        return this.methods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map call(String method, Map args) throws PluginException {
        if (this.rcmPlugin.isDestroyed()) {
            throw new PluginException("Plugin unloaded");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (method.equals("rcm-is-enabled")) {
            result.put("enabled", this.rcmPlugin.isRCMEnabled());
            result.put("sources", this.rcmPlugin.getSourcesList());
            result.put("is-all-sources", this.rcmPlugin.isAllSources());
            result.put("is-default-sources", this.rcmPlugin.isDefaultSourcesList());
            result.put("ui-enabled", this.rcmPlugin.isUIEnabled());
            return result;
        } else if (method.equals("rcm-get-list")) {
            if (!this.rcmPlugin.isRCMEnabled() || !this.rcmPlugin.isUIEnabled()) throw new PluginException("RCM not enabled");
            this.rpcGetList(result, args);
            return result;
        } else if (method.equals("rcm-set-enabled")) {
            boolean enable = MapUtils.getMapBoolean(args, "enable", false);
            boolean all = MapUtils.getMapBoolean(args, "all-sources", false);
            if (enable) {
                this.rcmPlugin.setRCMEnabled(enable);
            }
            this.rcmPlugin.setSearchEnabled(enable);
            this.rcmPlugin.setUIEnabled(enable);
            this.rcmPlugin.setFTUXBeenShown(true);
            if (all) {
                this.rcmPlugin.setToAllSources();
                return result;
            } else {
                this.rcmPlugin.setToDefaultSourcesList();
            }
            return result;
        } else if (method.equals("rcm-lookup-start")) {
            if (!this.rcmPlugin.isRCMEnabled() || !this.rcmPlugin.isUIEnabled()) throw new PluginException("RCM not enabled");
            this.rpcLookupStart(result, args);
            return result;
        } else if (method.equals("rcm-lookup-remove")) {
            if (!this.rcmPlugin.isRCMEnabled() || !this.rcmPlugin.isUIEnabled()) throw new PluginException("RCM not enabled");
            this.rpcLookupRemove(result, args);
            return result;
        } else if (method.equals("rcm-remove")) {
            if (!this.rcmPlugin.isRCMEnabled() || !this.rcmPlugin.isUIEnabled()) throw new PluginException("RCM not enabled");
            this.rpcRemove(result, args);
            return result;
        } else if (method.equals("rcm-set-read")) {
            if (!this.rcmPlugin.isRCMEnabled() || !this.rcmPlugin.isUIEnabled()) throw new PluginException("RCM not enabled");
            this.rpcSetRead(result, args);
            return result;
        } else if (method.equals("rcm-lookup-get-results")) {
            if (!this.rcmPlugin.isRCMEnabled() || !this.rcmPlugin.isUIEnabled()) throw new PluginException("RCM not enabled");
            this.rpcLookupGetResults(result, args);
            return result;
        } else {
            if (!method.equals("rcm-create-subscription")) throw new PluginException("Unsupported method");
            if (!this.rcmPlugin.isRCMEnabled() || !this.rcmPlugin.isUIEnabled()) throw new PluginException("RCM not enabled");
            this.rpcCreateSubscription(result, args);
        }
        return result;
    }

    public void unload() {
        if (this.mapSearchResults != null) {
            this.mapSearchResults.clear();
        }
        if (this.mapSearchInstances != null) {
            for (SearchInstance si : this.mapSearchInstances.values()) {
                try {
                    si.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.mapSearchInstances.clear();
        }
    }

    private Map<String, Object> relatedContentToMap(RelatedContent item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long changedLocallyOn = item.getChangedLocallyOn();
        map.put("changedOn", changedLocallyOn);
        map.put("contentNetwork", item.getContentNetwork());
        map.put("hash", ByteFormatter.encodeString(item.getHash()));
        map.put("lastSeenSecs", item.getLastSeenSecs());
        map.put("peers", item.getLeechers());
        map.put("level", item.getLevel());
        map.put("publishDate", item.getPublishDate());
        map.put("rank", item.getRank());
        map.put("relatedToHash", ByteFormatter.encodeString(item.getRelatedToHash()));
        map.put("seeds", item.getSeeds());
        map.put("size", item.getSize());
        map.put("tags", item.getTags());
        map.put("title", item.getTitle());
        map.put("tracker", item.getTracker());
        map.put("unread", item.isUnread());
        map.put("id", item.hashCode());
        return map;
    }

    protected void rpcGetList(Map result, Map args) throws PluginException {
        long since = MapUtils.getMapLong(args, "since", 0L);
        long until = 0L;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        result.put("related", list);
        try {
            RelatedContent[] relatedContent;
            RelatedContentManager manager = RelatedContentManager.getSingleton();
            RelatedContent[] relatedContentArray = relatedContent = manager.getRelatedContent();
            int n = relatedContent.length;
            int n2 = 0;
            while (n2 < n) {
                long changedLocallyOn;
                RelatedContent item = relatedContentArray[n2];
                if (this.rcmPlugin.isVisible(item) && (changedLocallyOn = item.getChangedLocallyOn()) >= since) {
                    if (changedLocallyOn > until) {
                        until = changedLocallyOn;
                    }
                    Map<String, Object> map = this.relatedContentToMap(item);
                    list.add(map);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
        result.put("until", until);
    }

    protected void rpcLookupGetResults(Map result, Map args) throws PluginException {
        long since = MapUtils.getMapLong(args, "since", 0L);
        Map map = this.mapSearchResults.get(MapUtils.getMapString(args, "lid", null));
        if (map == null) {
            throw new PluginException("No results for Lookup ID");
        }
        result.putAll(map);
    }

    protected void rpcSetRead(Map result, Map args) throws PluginException {
        boolean unread = !MapUtils.getMapBoolean(args, "read", true);
        String lid = MapUtils.getMapString(args, "lid", null);
        if (!args.containsKey("ids")) {
            throw new PluginException("No ids");
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Object oIDs = args.get("ids");
        if (oIDs instanceof List) {
            List list = (List)oIDs;
            for (Object item : list) {
                ids.add(((Number)item).intValue());
            }
        } else if (oIDs instanceof Number) {
            ids.add(((Number)oIDs).intValue());
        }
        ArrayList<Integer> successes = new ArrayList<Integer>();
        result.put("success", successes);
        result.put("failure", ids);
        if (lid != null) {
            SearchInstance searchInstance = this.mapSearchInstances.get(lid);
            Map map = this.mapSearchResults.get(lid);
            if (map != null) {
                List listResults = (List)map.get("results");
                if (listResults == null) {
                    return;
                }
                for (Object o : listResults) {
                    Map mapRC = (Map)o;
                    int rcID = MapUtils.getMapInt(mapRC, "id", 0);
                    Iterator iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        Integer id = (Integer)iterator.next();
                        if (rcID != id) continue;
                        successes.add(id);
                        map.put("unread", unread);
                        iterator.remove();
                        if (ids.size() != 0) continue;
                        return;
                    }
                }
            }
            return;
        }
        try {
            RelatedContent[] relatedContent;
            RelatedContentManager manager = RelatedContentManager.getSingleton();
            RelatedContent[] relatedContentArray = relatedContent = manager.getRelatedContent();
            int n = relatedContent.length;
            int n2 = 0;
            while (n2 < n) {
                RelatedContent rc = relatedContentArray[n2];
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    Integer id = (Integer)iterator.next();
                    if (rc.hashCode() != id.intValue()) continue;
                    rc.setUnread(unread);
                    successes.add(id);
                    iterator.remove();
                    if (ids.size() != 0) continue;
                    return;
                }
                ++n2;
            }
        }
        catch (ContentException e) {
            throw new PluginException(e);
        }
    }

    protected void rpcRemove(Map result, Map args) throws PluginException {
        if (!args.containsKey("ids")) {
            throw new PluginException("No ids");
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Object o = args.get("ids");
        if (o instanceof List) {
            List list = (List)o;
            for (Object item : list) {
                ids.add(((Number)item).intValue());
            }
        } else if (o instanceof Number) {
            ids.add(((Number)o).intValue());
        }
        ArrayList<Integer> successes = new ArrayList<Integer>();
        result.put("success", successes);
        result.put("failure", ids);
        try {
            RelatedContent[] relatedContent;
            RelatedContentManager manager = RelatedContentManager.getSingleton();
            RelatedContent[] relatedContentArray = relatedContent = manager.getRelatedContent();
            int n = relatedContent.length;
            int n2 = 0;
            while (n2 < n) {
                RelatedContent rc = relatedContentArray[n2];
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    Integer id = (Integer)iterator.next();
                    if (rc.hashCode() != id.intValue()) continue;
                    successes.add(id);
                    rc.delete();
                    iterator.remove();
                    if (ids.size() != 0) continue;
                    return;
                }
                ++n2;
            }
        }
        catch (ContentException e) {
            throw new PluginException(e);
        }
    }

    protected void rpcLookupRemove(Map result, Map args) throws PluginException {
        String lid = MapUtils.getMapString(args, "lid", null);
        if (lid == null) {
            throw new PluginException("No Lookup ID");
        }
        this.mapSearchInstances.remove(lid);
        this.mapSearchResults.remove(lid);
    }

    protected void rpcLookupStart(Map result, Map args) throws PluginException {
        block9: {
            String searchTerm = MapUtils.getMapString(args, "search-term", null);
            String lookupByTorrent = MapUtils.getMapString(args, "torrent-hash", null);
            long lookupBySize = MapUtils.getMapLong(args, "file-size", 0L);
            String[] networks = new String[]{"Public"};
            String net_str = RCMPlugin.getNetworkString(networks);
            try {
                RelatedContentManager manager = RelatedContentManager.getSingleton();
                if (searchTerm != null) {
                    final String lookupID = Integer.toHexString((String.valueOf(searchTerm) + net_str).hashCode());
                    result.put("lid", lookupID);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("s", searchTerm);
                    HashMap<String, Constable> map = this.mapSearchResults.get(lookupID);
                    if (map == null) {
                        map = new HashMap<String, Constable>();
                        this.mapSearchResults.put(lookupID, map);
                    }
                    int activeSearches = MapUtils.getMapInt(map, "active-searches", 0);
                    map.put("active-searches", Integer.valueOf(++activeSearches));
                    map.put("complete", Boolean.valueOf(activeSearches <= 0));
                    SearchInstance searchInstance = manager.searchRCM(parameters, new SearchObserver(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void resultReceived(SearchInstance search, SearchResult result) {
                            Map map = RCM_JSONServer.this.mapSearchResults;
                            synchronized (map) {
                                Map map2 = (Map)RCM_JSONServer.this.mapSearchResults.get(lookupID);
                                if (map2 == null) {
                                    return;
                                }
                                ArrayList<Map> list = MapUtils.getMapList(map2, "results", null);
                                if (list == null) {
                                    list = new ArrayList<Map>();
                                    map2.put("results", list);
                                }
                                SearchRelatedContent src = new SearchRelatedContent(result);
                                Map mapResult = RCM_JSONServer.this.relatedContentToMap(src);
                                list.add(mapResult);
                            }
                        }

                        @Override
                        public Object getProperty(int property) {
                            return null;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void complete() {
                            Map map = RCM_JSONServer.this.mapSearchResults;
                            synchronized (map) {
                                Map map2 = (Map)RCM_JSONServer.this.mapSearchResults.get(lookupID);
                                if (map2 == null) {
                                    return;
                                }
                                int activeSearches = MapUtils.getMapInt(map2, "active-searches", 0);
                                if (activeSearches > 0) {
                                    --activeSearches;
                                }
                                map2.put("active-searches", activeSearches);
                                map2.put("complete", activeSearches <= 0);
                            }
                        }

                        @Override
                        public void cancelled() {
                            this.complete();
                        }
                    });
                    break block9;
                }
                if (lookupByTorrent != null || lookupBySize > 0L) {
                    final String lookupID = lookupByTorrent != null ? lookupByTorrent : Integer.toHexString((String.valueOf(String.valueOf(lookupBySize)) + net_str).hashCode());
                    result.put("lid", lookupID);
                    HashMap<String, Constable> map = this.mapSearchResults.get(lookupID);
                    if (map == null) {
                        map = new HashMap<String, Constable>();
                        this.mapSearchResults.put(lookupID, map);
                    }
                    int activeSearches = MapUtils.getMapInt(map, "active-searches", 0);
                    map.put("active-searches", Integer.valueOf(++activeSearches));
                    map.put("complete", Boolean.valueOf(activeSearches <= 0));
                    RelatedContentLookupListener l = new RelatedContentLookupListener(){

                        @Override
                        public void lookupStart() {
                        }

                        @Override
                        public void lookupFailed(ContentException error) {
                            this.lookupComplete();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void lookupComplete() {
                            Map map = RCM_JSONServer.this.mapSearchResults;
                            synchronized (map) {
                                Map map2 = (Map)RCM_JSONServer.this.mapSearchResults.get(lookupID);
                                if (map2 == null) {
                                    return;
                                }
                                int activeSearches = MapUtils.getMapInt(map2, "active-searches", 0);
                                if (activeSearches > 0) {
                                    --activeSearches;
                                }
                                map2.put("active-searches", activeSearches);
                                map2.put("complete", activeSearches <= 0);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void contentFound(RelatedContent[] content2) {
                            Map map = RCM_JSONServer.this.mapSearchResults;
                            synchronized (map) {
                                Map map2 = (Map)RCM_JSONServer.this.mapSearchResults.get(lookupID);
                                if (map2 == null) {
                                    return;
                                }
                                ArrayList<Map> list = MapUtils.getMapList(map2, "results", null);
                                if (list == null) {
                                    list = new ArrayList<Map>();
                                    map2.put("results", list);
                                }
                                RelatedContent[] relatedContentArray = content2;
                                int n = content2.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    RelatedContent item = relatedContentArray[n2];
                                    Map mapResult = RCM_JSONServer.this.relatedContentToMap(item);
                                    list.add(mapResult);
                                    ++n2;
                                }
                            }
                        }
                    };
                    if (lookupByTorrent != null) {
                        byte[] hash = ByteFormatter.decodeString(lookupByTorrent);
                        manager.lookupContent(hash, networks, l);
                    } else if (lookupBySize > 0L) {
                        manager.lookupContent(lookupBySize, l);
                    }
                    break block9;
                }
                throw new PluginException("No search-term, torrent-hash or file-size");
            }
            catch (Exception e) {
                throw new PluginException(e);
            }
        }
    }

    private void rpcCreateSubscription(Map result, Map args) throws PluginException {
        String expression = MapUtils.getMapString(args, "expression", null);
        boolean is_popularity = expression == null;
        String name = is_popularity ? MessageText.getString("rcm.pop") : "'" + expression + "'";
        String subscription_name = String.valueOf(MessageText.getString("rcm.search.provider")) + ": " + name;
        SearchProvider sp = this.rcmPlugin.getSearchProvider();
        String[] networks = AENetworkClassifier.AT_NETWORKS;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("t", subscription_name);
        properties.put("s", expression);
        properties.put("n", networks);
        try {
            this.rcmPlugin.getPluginInterface().getUtilities().getSubscriptionManager().requestSubscription(sp, properties);
        }
        catch (Throwable e) {
            throw new PluginException(e);
        }
        result.put("success", true);
    }
}

