/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.ssdp;

import com.aelitis.azureus.core.util.NetUtils;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPSSDPListener;
import com.aelitis.net.upnp.impl.SSDPIGD;
import com.aelitis.net.upnp.impl.SSDPIGDListener;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.ssdp.SSDPCore;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class SSDPIGDImpl
implements SSDPIGD,
UPnPSSDPListener {
    private UPnPImpl upnp;
    private SSDPCore ssdp_core;
    private boolean first_result = true;
    private long last_explicit_search = 0L;
    private List listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("SSDP");

    public SSDPIGDImpl(UPnPImpl _upnp, String[] _selected_interfaces) throws UPnPException {
        this.upnp = _upnp;
        this.ssdp_core = SSDPCore.getSingleton(this.upnp.getAdapter(), "239.255.255.250", 1900, 0, _selected_interfaces);
        this.ssdp_core.addListener(this);
    }

    @Override
    public SSDPCore getSSDP() {
        return this.ssdp_core;
    }

    @Override
    public void start() throws UPnPException {
        try {
            this.upnp.getAdapter().createThread("SSDP:queryLoop", new AERunnable(){

                @Override
                public void runSupport() {
                    SSDPIGDImpl.this.queryLoop();
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new UPnPException("Failed to initialise SSDP", e);
        }
    }

    @Override
    public void searchNow() {
        long now = SystemTime.getCurrentTime();
        if (now - this.last_explicit_search < 10000L) {
            return;
        }
        this.last_explicit_search = now;
        this.search();
    }

    @Override
    public void searchNow(String[] STs) {
        this.ssdp_core.search(STs);
    }

    protected void queryLoop() {
        while (true) {
            try {
                while (true) {
                    this.search();
                    Thread.sleep(60000L);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    protected void search() {
        this.ssdp_core.search(new String[]{"upnp:rootdevice"});
    }

    @Override
    public void receivedResult(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String usn, URL location, String st, String al) {
        try {
            this.this_mon.enter();
            if (st.equalsIgnoreCase("upnp:rootdevice")) {
                this.gotRoot(network_interface, local_address, usn, location);
            }
        }
        finally {
            this.first_result = false;
            this.this_mon.exit();
        }
    }

    @Override
    public void receivedNotify(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String usn, URL location, String nt, String nts) {
        block13: {
            try {
                this.this_mon.enter();
                if (!nt.contains("upnp:rootdevice")) break block13;
                if (nts.contains("alive")) {
                    try {
                        InetAddress dev = InetAddress.getByName(location.getHost());
                        byte[] dev_bytes = dev.getAddress();
                        boolean[] dev_bits = this.bytesToBits(dev_bytes);
                        NetworkInterface best_ni = null;
                        InetAddress best_addr = null;
                        int best_prefix = 0;
                        List<NetworkInterface> x = NetUtils.getNetworkInterfaces();
                        for (NetworkInterface this_ni : x) {
                            Enumeration<InetAddress> ni_addresses = this_ni.getInetAddresses();
                            block6: while (ni_addresses.hasMoreElements()) {
                                InetAddress this_address = ni_addresses.nextElement();
                                byte[] this_bytes = this_address.getAddress();
                                if (dev_bytes.length != this_bytes.length) continue;
                                boolean[] this_bits = this.bytesToBits(this_bytes);
                                int i = 0;
                                while (i < this_bits.length) {
                                    if (dev_bits[i] != this_bits[i]) continue block6;
                                    if (i > best_prefix) {
                                        best_prefix = i;
                                        best_ni = this_ni;
                                        best_addr = this_address;
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (best_ni != null) {
                            if (this.first_result) {
                                this.upnp.log(location + " -> " + best_ni.getDisplayName() + "/" + best_addr + " (prefix=" + (best_prefix + 1) + ")");
                            }
                            this.gotRoot(best_ni, best_addr, usn, location);
                            break block13;
                        }
                        this.gotAlive(usn, location);
                    }
                    catch (Throwable e) {
                        this.gotAlive(usn, location);
                    }
                    break block13;
                }
                if (nts.contains("byebye")) {
                    this.lostRoot(local_address, usn);
                }
            }
            finally {
                this.first_result = false;
                this.this_mon.exit();
            }
        }
    }

    @Override
    public String[] receivedSearch(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String ST) {
        return null;
    }

    protected boolean[] bytesToBits(byte[] bytes) {
        boolean[] res = new boolean[bytes.length * 8];
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            int j = 0;
            while (j < 8) {
                res[i * 8 + j] = (b & (byte)(1 << 7 - j)) != 0;
                ++j;
            }
            ++i;
        }
        return res;
    }

    protected void gotRoot(NetworkInterface network_interface, InetAddress local_address, String usn, URL location) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((SSDPIGDListener)this.listeners.get(i)).rootDiscovered(network_interface, local_address, usn, location);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void gotAlive(String usn, URL location) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((SSDPIGDListener)this.listeners.get(i)).rootAlive(usn, location);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void lostRoot(InetAddress local_address, String usn) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((SSDPIGDListener)this.listeners.get(i)).rootLost(local_address, usn);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void interfaceChanged(NetworkInterface network_interface) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((SSDPIGDListener)this.listeners.get(i)).interfaceChanged(network_interface);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void addListener(SSDPIGDListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(SSDPIGDListener l) {
        this.listeners.remove(l);
    }
}

