/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.download.StreamManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.DataSourceUtils;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class PlayUtils {
    public static final boolean COMPLETE_PLAY_ONLY = true;
    public static final int fileSizeThreshold = 90;
    public static final String playableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac, .mts, .m2ts";
    private static volatile String actualPlayableFileExtensions = ".avi .flv .flc .mp4 .divx .h264 .mkv .mov .mp2 .m4v .mp3 .aac, .mts, .m2ts";
    private static Boolean hasQuickTime;
    private static ThreadLocal<int[]> tls_non_block_indicator;
    private static AtomicInteger dm_uid;
    private static Map<String, Object[]> ext_play_cache;

    static {
        tls_non_block_indicator = new ThreadLocal<int[]>(){

            @Override
            public int[] initialValue() {
                return new int[1];
            }
        };
        dm_uid = new AtomicInteger();
        ext_play_cache = new LinkedHashMap<String, Object[]>(100, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Object[]> eldest) {
                return this.size() > 100;
            }
        };
    }

    public static boolean prepareForPlay(DownloadManager dm) {
        EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
        if (edm != null) {
            edm.setProgressiveMode(true);
            return true;
        }
        return false;
    }

    public static boolean canProgressiveOrIsComplete(TOTorrent torrent) {
        EnhancedDownloadManager edm;
        block5: {
            if (torrent == null) {
                return false;
            }
            try {
                DownloadManagerEnhancer enhancer = DownloadManagerEnhancer.getSingleton();
                edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(torrent.getHash());
                if (edm == null) {
                    return enhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(torrent);
                }
                boolean complete = edm.getDownloadManager().isDownloadComplete(false);
                if (!complete) break block5;
                return true;
            }
            catch (TOTorrentException e) {
                return false;
            }
        }
        return edm.supportsProgressiveMode();
    }

    public static boolean canUseEMP(DiskManagerFileInfo file) {
        return PlayUtils.isExternallyPlayable(file);
    }

    public static boolean canUseEMP(TOTorrent torrent, int file_index) {
        return PlayUtils.canUseEMP(torrent, file_index, true);
    }

    public static boolean canUseEMP(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        return PlayUtils.canPlayViaExternalEMP(torrent, file_index, complete_only);
    }

    private static boolean canPlay(DownloadManager dm, int file_index) {
        if (dm == null) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent, file_index);
    }

    private static boolean canPlay(TOTorrent torrent, int file_index) {
        if (!PlatformTorrentUtils.isContent(torrent, false)) {
            return false;
        }
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager dm = gm.getDownloadManager(torrent);
        if (dm != null) {
            return dm.getAssumedComplete() || PlayUtils.canUseEMP(torrent, file_index);
        }
        return PlayUtils.canUseEMP(torrent, file_index);
    }

    public static boolean canPlayDS(Object ds, int file_index, boolean block_for_accuracy) {
        block18: {
            boolean bl;
            block19: {
                block16: {
                    boolean bl2;
                    block17: {
                        block14: {
                            boolean bl3;
                            block15: {
                                block12: {
                                    boolean bl4;
                                    block13: {
                                        block10: {
                                            boolean bl5;
                                            block11: {
                                                int[] nArray;
                                                if (ds == null) {
                                                    return false;
                                                }
                                                try {
                                                    if (!block_for_accuracy) {
                                                        int[] nArray2 = tls_non_block_indicator.get();
                                                        nArray2[0] = nArray2[0] + 1;
                                                    }
                                                    if (!(ds instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo)) break block10;
                                                    org.gudy.azureus2.core3.disk.DiskManagerFileInfo fi = (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)ds;
                                                    bl5 = PlayUtils.canPlayDS(fi.getDownloadManager(), fi.getIndex(), block_for_accuracy);
                                                    if (block_for_accuracy) break block11;
                                                    nArray = tls_non_block_indicator.get();
                                                }
                                                catch (Throwable throwable) {
                                                    if (!block_for_accuracy) {
                                                        int[] nArray3 = tls_non_block_indicator.get();
                                                        nArray3[0] = nArray3[0] - 1;
                                                    }
                                                    throw throwable;
                                                }
                                                nArray[0] = nArray[0] - 1;
                                            }
                                            return bl5;
                                        }
                                        DownloadManager dm = DataSourceUtils.getDM((Object)ds);
                                        if (dm == null) break block12;
                                        bl4 = PlayUtils.canPlay(dm, file_index);
                                        if (block_for_accuracy) break block13;
                                        int[] nArray = tls_non_block_indicator.get();
                                        nArray[0] = nArray[0] - 1;
                                    }
                                    return bl4;
                                }
                                TOTorrent torrent = DataSourceUtils.getTorrent((Object)ds);
                                if (torrent == null) break block14;
                                bl3 = PlayUtils.canPlay(torrent, file_index);
                                if (block_for_accuracy) break block15;
                                int[] nArray = tls_non_block_indicator.get();
                                nArray[0] = nArray[0] - 1;
                            }
                            return bl3;
                        }
                        if (!(ds instanceof VuzeActivitiesEntry)) break block16;
                        bl2 = ((VuzeActivitiesEntry)ds).isPlayable(block_for_accuracy);
                        if (block_for_accuracy) break block17;
                        int[] nArray = tls_non_block_indicator.get();
                        nArray[0] = nArray[0] - 1;
                    }
                    return bl2;
                }
                if (!(ds instanceof SelectedContentV3)) break block18;
                SelectedContentV3 sel = (SelectedContentV3)ds;
                bl = sel.canPlay();
                if (block_for_accuracy) break block19;
                int[] nArray = tls_non_block_indicator.get();
                nArray[0] = nArray[0] - 1;
            }
            return bl;
        }
        if (!block_for_accuracy) {
            int[] nArray = tls_non_block_indicator.get();
            nArray[0] = nArray[0] - 1;
        }
        return false;
    }

    public static boolean isStreamPermitted() {
        FeatureManager fm = PluginInitializer.getDefaultInterface().getUtilities().getFeatureManager();
        return fm.isFeatureInstalled("core");
    }

    private static boolean canStream(DownloadManager dm, int file_index) {
        org.gudy.azureus2.core3.disk.DiskManagerFileInfo file;
        if (dm == null) {
            return false;
        }
        if (file_index == -1) {
            file = dm.getDownloadState().getPrimaryFile();
            if (file == null) {
                org.gudy.azureus2.core3.disk.DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                if (files.length == 0) {
                    return false;
                }
                file = files[0];
            }
            file_index = file.getIndex();
        } else {
            file = dm.getDiskManagerFileInfoSet().getFiles()[file_index];
        }
        if (file.getDownloaded() == file.getLength()) {
            return false;
        }
        if (!StreamManager.getSingleton().isStreamingUsable()) {
            return false;
        }
        TOTorrent torrent = dm.getTorrent();
        return PlayUtils.canUseEMP(torrent, file_index, false);
    }

    public static boolean canStreamDS(Object ds, int file_index, boolean block_for_accuracy) {
        block9: {
            boolean bl;
            block10: {
                block7: {
                    boolean bl2;
                    block8: {
                        int[] nArray;
                        if (ds == null) {
                            return false;
                        }
                        try {
                            if (!block_for_accuracy) {
                                int[] nArray2 = tls_non_block_indicator.get();
                                nArray2[0] = nArray2[0] + 1;
                            }
                            if (!(ds instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo)) break block7;
                            org.gudy.azureus2.core3.disk.DiskManagerFileInfo fi = (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)ds;
                            bl2 = PlayUtils.canStreamDS(fi.getDownloadManager(), fi.getIndex(), block_for_accuracy);
                            if (block_for_accuracy) break block8;
                            nArray = tls_non_block_indicator.get();
                        }
                        catch (Throwable throwable) {
                            if (!block_for_accuracy) {
                                int[] nArray3 = tls_non_block_indicator.get();
                                nArray3[0] = nArray3[0] - 1;
                            }
                            throw throwable;
                        }
                        nArray[0] = nArray[0] - 1;
                    }
                    return bl2;
                }
                DownloadManager dm = DataSourceUtils.getDM((Object)ds);
                if (dm == null) break block9;
                bl = PlayUtils.canStream(dm, file_index);
                if (block_for_accuracy) break block10;
                int[] nArray = tls_non_block_indicator.get();
                nArray[0] = nArray[0] - 1;
            }
            return bl;
        }
        if (!block_for_accuracy) {
            int[] nArray = tls_non_block_indicator.get();
            nArray[0] = nArray[0] - 1;
        }
        return false;
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo file) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not found"));
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            Logger.log(new LogEvent(LogIDs.UI3, "Media server plugin not operational"));
            return null;
        }
        try {
            boolean use_peek;
            Object url;
            UIFunctions uif;
            if (hasQuickTime == null && (uif = UIFunctionsManager.getUIFunctions()) != null) {
                hasQuickTime = uif.isProgramInstalled(".qtl", "Quicktime");
                try {
                    pi.getIPC().invoke("setQuickTimeAvailable", new Object[]{hasQuickTime});
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
                }
            }
            if ((url = (use_peek = tls_non_block_indicator.get()[0] > 0) && pi.getIPC().canInvoke("peekContentURL", new Object[]{file}) ? pi.getIPC().invoke("peekContentURL", new Object[]{file}) : pi.getIPC().invoke("getContentURL", new Object[]{file})) instanceof String) {
                return new URL((String)url);
            }
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, 1, "IPC to media server plugin failed", e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExternallyPlayable(Download d, int file_index, boolean complete_only) {
        if (d == null) {
            return false;
        }
        boolean use_cache = d.getState() != 4;
        String cache_key = null;
        long now = 0L;
        if (use_cache) {
            Object[] cached;
            Integer uid = (Integer)d.getUserData(PlayUtils.class);
            if (uid == null) {
                uid = dm_uid.getAndIncrement();
                d.setUserData(PlayUtils.class, uid);
            }
            cache_key = uid + "/" + file_index + "/" + complete_only;
            Map<String, Object[]> map = ext_play_cache;
            synchronized (map) {
                cached = ext_play_cache.get(cache_key);
            }
            now = SystemTime.getMonotonousTime();
            if (cached != null && now - (Long)cached[0] < 60000L) {
                return (Boolean)cached[1];
            }
        }
        boolean result = PlayUtils.isExternallyPlayableSupport(d, file_index, complete_only);
        if (use_cache) {
            Map<String, Object[]> map = ext_play_cache;
            synchronized (map) {
                ext_play_cache.put(cache_key, new Object[]{now, result});
            }
        }
        return result;
    }

    private static boolean isExternallyPlayableSupport(Download d, int file_index, boolean complete_only) {
        int primary_file_index = -1;
        if (file_index == -1) {
            DownloadManager dm = PluginCoreUtils.unwrap(d);
            if (dm == null) {
                return false;
            }
            DiskManagerFileInfo file = null;
            try {
                file = PluginCoreUtils.wrap(dm.getDownloadState().getPrimaryFile());
            }
            catch (DownloadException e) {
                return false;
            }
            if (file == null) {
                return false;
            }
            if (file.getDownloaded() != file.getLength() && (complete_only || PlayUtils.getMediaServerContentURL(file) == null)) {
                return false;
            }
            primary_file_index = file.getIndex();
        } else {
            DiskManagerFileInfo file = d.getDiskManagerFileInfo(file_index);
            if (file.getDownloaded() != file.getLength() && (complete_only || PlayUtils.getMediaServerContentURL(file) == null)) {
                return false;
            }
            primary_file_index = file_index;
        }
        if (primary_file_index == -1) {
            return false;
        }
        return PlayUtils.isExternallyPlayable(d.getDiskManagerFileInfo()[primary_file_index]);
    }

    public static int[] getExternallyPlayableFileIndexes(Download d, boolean complete_only) {
        DiskManagerFileInfo[] fileInfos = d.getDiskManagerFileInfo();
        int count = d.getDiskManagerFileCount();
        int[] playableIndexes = new int[]{};
        int i = 0;
        while (i < count) {
            DiskManagerFileInfo fileInfo2 = d.getDiskManagerFileInfo(i);
            if ((!complete_only || fileInfo2.getLength() == fileInfo2.getDownloaded()) && PlayUtils.isExternallyPlayable(fileInfo2)) {
                int[] newPlayableIndexes = new int[playableIndexes.length + 1];
                System.arraycopy(playableIndexes, 0, newPlayableIndexes, 0, playableIndexes.length);
                newPlayableIndexes[playableIndexes.length] = i;
                playableIndexes = newPlayableIndexes;
            }
            ++i;
        }
        return playableIndexes;
    }

    private static boolean isExternallyPlayable(DiskManagerFileInfo file) {
        int extIndex;
        String name = file.getFile(true).getName();
        try {
            String is;
            Download dl = file.getDownload();
            if (dl != null && (is = PluginCoreUtils.unwrap(dl).getDownloadState().getAttribute("incompfilesuffix")) != null && name.endsWith(is)) {
                name = name.substring(0, name.length() - is.length());
            }
        }
        catch (Throwable dl) {
            // empty catch block
        }
        if ((extIndex = name.lastIndexOf(".")) > -1) {
            String ext = name.substring(extIndex);
            if (ext == null) {
                return false;
            }
            ext = ext.toLowerCase();
            if (PlayUtils.getPlayableFileExtensions().contains(ext)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isExternallyPlayable(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        try {
            Download download = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(torrent.getHash());
            if (download != null) {
                return PlayUtils.isExternallyPlayable(download, file_index, complete_only);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static final boolean canPlayViaExternalEMP(TOTorrent torrent, int file_index, boolean complete_only) {
        if (torrent == null) {
            return false;
        }
        return PlayUtils.isExternallyPlayable(torrent, file_index, complete_only);
    }

    public static String getPlayableFileExtensions() {
        return actualPlayableFileExtensions;
    }

    public static void setPlayableFileExtensions(String str) {
        actualPlayableFileExtensions = str;
    }

    public static int getPrimaryFileIndex(Download dl) {
        EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(PluginCoreUtils.unwrap(dl));
        if (edm == null) {
            return -1;
        }
        return edm.getPrimaryFileIndex();
    }

    public static boolean isEMPAvailable() {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
        return pi != null && !pi.getPluginState().isDisabled();
    }

    public static boolean playURL(URL url, String name) {
        Method ow;
        PluginInterface pi;
        block4: {
            try {
                pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp");
                if (pi != null && !pi.getPluginState().isDisabled()) break block4;
                return false;
            }
            catch (Throwable e) {
                Debug.out(e);
                return false;
            }
        }
        Class<?> ewp_class = pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
        if (ewp_class != null && (ow = ewp_class.getMethod("openWindow", URL.class, String.class)) != null) {
            ow.invoke(null, url, name);
            return true;
        }
        return false;
    }
}

