/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONArray;

public final class ImportExportUtils {
    public static final void exportString(Map map, String key, String value) {
        if (value != null) {
            try {
                map.put(key, value.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void exportJSONString(Map map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public static final String importString(Map map, String key, String def) {
        String res = ImportExportUtils.importString(map, key);
        if (res == null) {
            res = def;
        }
        return res;
    }

    public static final String importString(Map map, String key) {
        if (map == null) {
            return null;
        }
        Object obj = map.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new String((byte[])obj, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static final long importLong(Map map, String key) {
        return ImportExportUtils.importLong(map, key, 0L);
    }

    public static final long importLong(Map map, String key, long def) {
        if (map == null) {
            return def;
        }
        Object obj = map.get(key);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        return def;
    }

    public static final void exportLong(Map map, String key, long value) {
        map.put(key, value);
    }

    public static final void exportInt(Map map, String key, int value) {
        map.put(key, new Long(value));
    }

    public static final int importInt(Map map, String key) {
        return (int)ImportExportUtils.importLong(map, key, 0L);
    }

    public static final int importInt(Map map, String key, int def) {
        return (int)ImportExportUtils.importLong(map, key, def);
    }

    public static final void exportFloat(Map map, String key, float value) {
        ImportExportUtils.exportString(map, key, String.valueOf(value));
    }

    public static final float importFloat(Map map, String key, float def) {
        String str = ImportExportUtils.importString(map, key);
        if (str == null) {
            return def;
        }
        return Float.parseFloat(str);
    }

    public static final void exportBoolean(Map map, String key, boolean value) {
        map.put(key, new Long(value ? 1 : 0));
    }

    public static final boolean importBoolean(Map map, String key) {
        return ImportExportUtils.importBoolean(map, key, false);
    }

    public static final boolean importBoolean(Map map, String key, boolean def) {
        if (map == null) {
            return def;
        }
        Object obj = map.get(key);
        if (obj instanceof Long) {
            return (Long)obj == 1L;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return def;
    }

    public static final void exportJSONBoolean(Map map, String key, boolean value) {
        map.put(key, value);
    }

    public static final String importURL(Map map, String key) {
        String url = ImportExportUtils.importString(map, key);
        if (url != null) {
            if ((url = url.trim()).length() == 0) {
                url = null;
            } else {
                try {
                    url = URLDecoder.decode(url, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return url;
    }

    public static final void exportURL(Map map, String key, String value) {
        ImportExportUtils.exportString(map, key, value);
    }

    public static final void exportJSONURL(Map map, String key, String value) {
        ImportExportUtils.exportJSONString(map, key, UrlUtils.encode(value));
    }

    public static final String[] importStringArray(Map map, String key) {
        List list = (List)map.get(key);
        if (list == null) {
            return new String[0];
        }
        String[] res = new String[list.size()];
        int i = 0;
        while (i < res.length) {
            Object obj = list.get(i);
            if (obj instanceof String) {
                res[i] = (String)obj;
            } else if (obj instanceof byte[]) {
                try {
                    res[i] = new String((byte[])obj, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return res;
    }

    public static final void exportStringArray(Map map, String key, String[] data) {
        ArrayList<byte[]> l = new ArrayList<byte[]>(data.length);
        map.put(key, l);
        int i = 0;
        while (i < data.length) {
            try {
                l.add(data[i].getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static final void exportJSONStringArray(Map map, String key, String[] data) {
        JSONArray l = new JSONArray(data.length);
        map.put(key, l);
        Collections.addAll(l, data);
    }

    public static final void exportIntArray(Map map, String key, int[] values) {
        if (values == null) {
            return;
        }
        int num = values.length;
        byte[] bytes = new byte[num * 4];
        int pos = 0;
        int i = 0;
        while (i < num) {
            int v = values[i];
            bytes[pos++] = (byte)(v >>> 24);
            bytes[pos++] = (byte)(v >>> 16);
            bytes[pos++] = (byte)(v >>> 8);
            bytes[pos++] = (byte)v;
            ++i;
        }
        map.put(key, bytes);
    }

    public static final int[] importIntArray(Map map, String key) {
        byte[] bytes = (byte[])map.get(key);
        if (bytes == null) {
            return null;
        }
        int[] values = new int[bytes.length / 4];
        int pos = 0;
        int i = 0;
        while (i < values.length) {
            values[i] = ((bytes[pos++] & 0xFF) << 24) + ((bytes[pos++] & 0xFF) << 16) + ((bytes[pos++] & 0xFF) << 8) + (bytes[pos++] & 0xFF);
            ++i;
        }
        return values;
    }
}

