/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class FeatureUtils {
    private static FeatureManager featman;

    static {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
                featman = pi.getUtilities().getFeatureManager();
            }
        });
    }

    public static String getPlusMode() {
        boolean isTrial;
        boolean isFull = FeatureUtils.hasPlusLicence();
        boolean bl = isTrial = FeatureUtils.hasFullBurn() && !isFull;
        return isFull ? "plus" : (isTrial ? "trial" : "free");
    }

    public static String getNoAdsMode() {
        boolean isNoAds = FeatureUtils.hasNoAdLicence();
        return isNoAds ? "no_ads" : "free";
    }

    public static boolean hasPlusLicence() {
        if (featman == null) {
            Set<String> featuresInstalled = UtilitiesImpl.getFeaturesInstalled();
            return featuresInstalled.contains("dvdburn");
        }
        licenceDetails fullFeatureDetails = FeatureUtils.getPlusFeatureDetails();
        long now = SystemTime.getCurrentTime();
        return fullFeatureDetails != null && fullFeatureDetails.expiry > now && fullFeatureDetails.displayedExpiry > now;
    }

    public static boolean hasFullLicence() {
        return FeatureUtils.hasPlusLicence();
    }

    public static boolean hasTrialLicence() {
        boolean isFull = FeatureUtils.hasPlusLicence();
        boolean isTrial = FeatureUtils.hasFullBurn() && !isFull;
        return isTrial;
    }

    public static boolean hasNoAdLicence() {
        if (featman == null) {
            Set<String> featuresInstalled = UtilitiesImpl.getFeaturesInstalled();
            return featuresInstalled.contains("no_ads");
        }
        licenceDetails details = FeatureUtils.getNoAdFeatureDetails();
        long now = SystemTime.getCurrentTime();
        return details != null && details.expiry > now && details.displayedExpiry > now;
    }

    public static licenceDetails getPlusFeatureDetails() {
        return FeatureUtils.getFeatureDetails("dvdburn");
    }

    private static licenceDetails getNoAdFeatureDetails() {
        return FeatureUtils.getFeatureDetails("no_ads");
    }

    public static licenceDetails getPlusOrNoAdFeatureDetails() {
        licenceDetails plusDetails = FeatureUtils.getPlusFeatureDetails();
        long now = System.currentTimeMillis();
        if (plusDetails != null && plusDetails.licence.getState() == 2 && plusDetails.expiry >= now) {
            return plusDetails;
        }
        licenceDetails noAdDetails = FeatureUtils.getNoAdFeatureDetails();
        if (noAdDetails == null) {
            return plusDetails;
        }
        if (plusDetails == null) {
            return noAdDetails;
        }
        if (noAdDetails.licence.getState() == 2 && noAdDetails.expiry >= now) {
            return noAdDetails;
        }
        return plusDetails;
    }

    /*
     * Unable to fully structure code
     */
    private static licenceDetails getFeatureDetails(String feature) {
        if (FeatureUtils.featman == null) {
            Debug.out("featman null");
            return null;
        }
        mapOrder = new TreeMap<T, Object[]>(Collections.<T>reverseOrder());
        var6_3 = featureDetails = FeatureUtils.featman.getFeatureDetails(feature);
        var5_4 = featureDetails.length;
        var4_6 = 0;
        while (var4_6 < var5_4) {
            block7: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block6: {
                                        fd = var6_3[var4_6];
                                        licence = fd.getLicence();
                                        state = licence.getState();
                                        if (state != 6) break block6;
                                        mapOrder.put(-1L, new Object[]{licence, 0L});
                                        break block7;
                                    }
                                    if (state != 4) break block8;
                                    mapOrder.put(-2L, new Object[]{licence, 0L});
                                    break block7;
                                }
                                if (state != 3) break block9;
                                mapOrder.put(-3L, new Object[]{licence, 0L});
                                break block7;
                            }
                            if (state != 5) break block10;
                            mapOrder.put(-4L, new Object[]{licence, 0L});
                            break block7;
                        }
                        if (state != 1) break block11;
                        mapOrder.put(-6L, new Object[]{licence, 0L});
                        break block7;
                    }
                    now = SystemTime.getCurrentTime();
                    lValidUntil = (Long)fd.getProperty("ValidUntil");
                    lValidOfflineUntil = (Long)fd.getProperty("OfflineValidUntil");
                    if (lValidUntil == null && lValidOfflineUntil == null) break block7;
                    minValidUntil = -1L;
                    maxValidUntil = -1L;
                    if (lValidUntil == null || (minValidUntil = (maxValidUntil = lValidUntil.longValue())) >= now) break block12;
                    mapOrder.put(minValidUntil, new Object[]{licence, minValidUntil});
                    break block7;
                }
                if (lValidOfflineUntil == null) ** GOTO lbl56
                validOfflineUntil = lValidOfflineUntil;
                if (validOfflineUntil < now) {
                    mapOrder.put(validOfflineUntil, new Object[]{licence, maxValidUntil});
                } else {
                    if (maxValidUntil == -1L || validOfflineUntil > maxValidUntil) {
                        maxValidUntil = validOfflineUntil;
                    }
lbl56:
                    // 4 sources

                    mapOrder.put(maxValidUntil, new Object[]{licence, minValidUntil});
                }
            }
            ++var4_6;
        }
        if (mapOrder.size() == 0) {
            return null;
        }
        firstKey = (Long)mapOrder.firstKey();
        objects = (Object[])mapOrder.get(firstKey);
        licence = (FeatureManager.Licence)objects[0];
        return new licenceDetails(firstKey, (Long)objects[1], licence, feature);
    }

    public static boolean isTrialLicence(FeatureManager.Licence licence) {
        FeatureManager.FeatureDetails[] featureDetails;
        if (featman == null) {
            return false;
        }
        boolean trial = false;
        FeatureManager.FeatureDetails[] featureDetailsArray = featureDetails = licence.getFeatures();
        int n = featureDetails.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureManager.FeatureDetails fd = featureDetailsArray[n2];
            trial = FeatureUtils.isTrial(fd);
            if (trial) break;
            ++n2;
        }
        return trial;
    }

    public static boolean isTrial(FeatureManager.FeatureDetails fd) {
        Long lIsTrial = (Long)fd.getProperty("IsTrial");
        return lIsTrial == null ? false : lIsTrial != 0L;
    }

    public static long getRemaining() {
        FeatureManager.FeatureDetails[] featureDetails = featman.getFeatureDetails("dvdburn_trial");
        if (featureDetails == null) {
            return 0L;
        }
        FeatureManager.FeatureDetails[] featureDetailsArray = featureDetails;
        int n = featureDetails.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureManager.FeatureDetails fd = featureDetailsArray[n2];
            long remainingUses = FeatureUtils.getRemainingUses(fd);
            if (remainingUses >= 0L) {
                return remainingUses;
            }
            ++n2;
        }
        return 0L;
    }

    private static long getRemainingUses(FeatureManager.FeatureDetails fd) {
        if (fd == null) {
            return 0L;
        }
        Long lRemainingUses = (Long)fd.getProperty("TrialUsesRemaining");
        long remainingUses = lRemainingUses == null ? -1L : lRemainingUses;
        return remainingUses;
    }

    public static boolean hasFullBurn() {
        PluginInterface pi;
        PluginInterface pluginInterface = pi = PluginInitializer.getDefaultInterface().getPluginState().isInitialisationComplete() ? AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azburn_v") : null;
        if (pi == null) {
            Set<String> featuresInstalled = UtilitiesImpl.getFeaturesInstalled();
            return featuresInstalled.contains("dvdburn_trial") && !featuresInstalled.contains("dvdburn");
        }
        return pi.getPluginState().isOperational();
    }

    public static class licenceDetails {
        private final FeatureManager.Licence licence;
        private final long expiry;
        private final long displayedExpiry;
        private final String feature;

        public licenceDetails(long expiry, long displayedExpiry, FeatureManager.Licence licence, String feature) {
            this.expiry = expiry;
            this.displayedExpiry = displayedExpiry;
            this.licence = licence;
            this.feature = feature;
        }

        public FeatureManager.Licence getLicence() {
            return this.licence;
        }

        public String getRenewalKey() {
            FeatureManager.FeatureDetails[] features = this.licence.getFeatures();
            if (features == null) {
                return null;
            }
            FeatureManager.FeatureDetails[] featureDetailsArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureManager.FeatureDetails fd = featureDetailsArray[n2];
                Object property = fd.getProperty("RenewalKey");
                if (property instanceof String) {
                    return (String)property;
                }
                ++n2;
            }
            return null;
        }

        public boolean isPlus() {
            return this.feature.equals("dvdburn");
        }

        public boolean isNoAds() {
            return !this.isPlus();
        }

        public long getExpiryTimeStamp() {
            return this.expiry;
        }

        public long getExpiryDisplayTimeStamp() {
            if (this.expiry == 0L) {
                return 0L;
            }
            return this.displayedExpiry;
        }

        public String getRenewalCode() {
            if (this.expiry == 0L) {
                return null;
            }
            return this.getRenewalKey();
        }
    }
}

